/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;

public final class AgenticSearchQueryBuilder
extends AbstractQueryBuilder<AgenticSearchQueryBuilder>
implements WithFieldName {
    @Generated
    private static final Logger log = LogManager.getLogger(AgenticSearchQueryBuilder.class);
    public static final String NAME = "agentic";
    public static final ParseField QUERY_TEXT_FIELD = new ParseField("query_text", new String[0]);
    public static final ParseField QUERY_FIELDS = new ParseField("query_fields", new String[0]);
    public static final ParseField MEMORY_ID_FIELD = new ParseField("memory_id", new String[0]);
    private static final String SYSTEM_INSTRUCTION_PATTERN = "(?i)\\b(system|instruction|prompt)\\s*:";
    private static final String COMMAND_INJECTION_PATTERN = "(?i)\\b(execute|run|eval|script)\\s*[:\\(]";
    private static final int MAX_QUERY_LENGTH = 1000;
    public String queryText;
    public List<String> queryFields;
    public String memoryId;
    private transient String agentFailureReason;

    public AgenticSearchQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryText = in.readString();
        this.queryFields = in.readOptionalStringList();
        this.memoryId = in.readOptionalString();
        this.agentFailureReason = in.readOptionalString();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public List<String> getQueryFields() {
        return this.queryFields;
    }

    public String getMemoryId() {
        return this.memoryId;
    }

    public void setAgentFailureReason(String reason) {
        this.agentFailureReason = reason;
    }

    public String getAgentFailureReason() {
        return this.agentFailureReason;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.queryText);
        out.writeOptionalStringCollection(this.queryFields);
        out.writeOptionalString(this.memoryId);
        out.writeOptionalString(this.agentFailureReason);
    }

    protected void doXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject(NAME);
        if (Objects.nonNull(QUERY_TEXT_FIELD)) {
            xContentBuilder.field(QUERY_TEXT_FIELD.getPreferredName(), this.queryText);
        }
        if (Objects.nonNull(this.queryFields) && !this.queryFields.isEmpty()) {
            xContentBuilder.field(QUERY_FIELDS.getPreferredName(), this.queryFields);
        }
        if (Objects.nonNull(this.memoryId) && !this.memoryId.trim().isEmpty()) {
            xContentBuilder.field(MEMORY_ID_FIELD.getPreferredName(), this.memoryId);
        }
        xContentBuilder.endObject();
    }

    public static AgenticSearchQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        EventStatsManager.increment(EventStatName.AGENTIC_QUERY_REQUESTS);
        AgenticSearchQueryBuilder agenticSearchQueryBuilder = new AgenticSearchQueryBuilder();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (QUERY_TEXT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    agenticSearchQueryBuilder.queryText = parser.text();
                    continue;
                }
                if (MEMORY_ID_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    agenticSearchQueryBuilder.memoryId = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown field [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if (QUERY_FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                ArrayList<String> fieldsList = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (fieldsList.size() >= 25) {
                        throw new ParsingException(parser.getTokenLocation(), "Too many query fields. Maximum allowed is 25", new Object[0]);
                    }
                    fieldsList.add(parser.text());
                }
                agenticSearchQueryBuilder.queryFields = fieldsList;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown field [" + currentFieldName + "]", new Object[0]);
        }
        if (agenticSearchQueryBuilder.queryText == null || agenticSearchQueryBuilder.queryText.trim().isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "[" + QUERY_TEXT_FIELD.getPreferredName() + "] is required", new Object[0]);
        }
        agenticSearchQueryBuilder.queryText = AgenticSearchQueryBuilder.sanitizeQueryText(agenticSearchQueryBuilder.queryText);
        return agenticSearchQueryBuilder;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return this;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.agentFailureReason != null) {
            throw new IllegalStateException("Agentic search failed: " + this.agentFailureReason);
        }
        throw new IllegalStateException("Agentic search query must be used as top-level query, not nested inside other queries. Should be used with agentic_query_translator search processor");
    }

    protected boolean doEquals(AgenticSearchQueryBuilder obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != ((Object)((Object)obj)).getClass()) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.queryText, (Object)obj.queryText);
        equalsBuilder.append(this.queryFields, obj.queryFields);
        equalsBuilder.append((Object)this.memoryId, (Object)obj.memoryId);
        return equalsBuilder.isEquals();
    }

    protected int doHashCode() {
        return new HashCodeBuilder().append((Object)this.queryText).append(this.queryFields).append((Object)this.memoryId).toHashCode();
    }

    public String getWriteableName() {
        return NAME;
    }

    public String fieldName() {
        return NAME;
    }

    private static String sanitizeQueryText(String queryText) {
        if (queryText == null) {
            return null;
        }
        String sanitized = queryText.replaceAll(SYSTEM_INSTRUCTION_PATTERN, "").replaceAll(COMMAND_INJECTION_PATTERN, "").trim();
        if (sanitized.length() > 1000) {
            String errorMessage = String.format(Locale.ROOT, "Query text too long. Maximum allowed length is [%s] characters", 1000);
            throw new IllegalArgumentException(errorMessage);
        }
        return sanitized;
    }

    @Generated
    public AgenticSearchQueryBuilder() {
    }

    @Generated
    public AgenticSearchQueryBuilder(String queryText, List<String> queryFields, String memoryId, String agentFailureReason) {
        this.queryText = queryText;
        this.queryFields = queryFields;
        this.memoryId = memoryId;
        this.agentFailureReason = agentFailureReason;
    }

    @Generated
    public String queryText() {
        return this.queryText;
    }

    @Generated
    public List<String> queryFields() {
        return this.queryFields;
    }

    @Generated
    public String memoryId() {
        return this.memoryId;
    }

    @Generated
    public String agentFailureReason() {
        return this.agentFailureReason;
    }

    @Generated
    public AgenticSearchQueryBuilder queryText(String queryText) {
        this.queryText = queryText;
        return this;
    }

    @Generated
    public AgenticSearchQueryBuilder queryFields(List<String> queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    @Generated
    public AgenticSearchQueryBuilder memoryId(String memoryId) {
        this.memoryId = memoryId;
        return this;
    }

    @Generated
    public AgenticSearchQueryBuilder agentFailureReason(String agentFailureReason) {
        this.agentFailureReason = agentFailureReason;
        return this;
    }
}

