/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.rank_eval;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalMetricDiscountedCumulativeGain;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalMetricExpectedReciprocalRank;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalMetricMeanReciprocalRank;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalMetricPrecision;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalMetricRecall;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RankEvalMetric
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RankEvalMetric> {
    @Nullable
    private final RankEvalMetricDiscountedCumulativeGain dcg;
    @Nullable
    private final RankEvalMetricExpectedReciprocalRank expectedReciprocalRank;
    @Nullable
    private final RankEvalMetricMeanReciprocalRank meanReciprocalRank;
    @Nullable
    private final RankEvalMetricPrecision precision;
    @Nullable
    private final RankEvalMetricRecall recall;
    public static final JsonpDeserializer<RankEvalMetric> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalMetric::setupRankEvalMetricDeserializer);

    private RankEvalMetric(Builder builder) {
        this.dcg = builder.dcg;
        this.expectedReciprocalRank = builder.expectedReciprocalRank;
        this.meanReciprocalRank = builder.meanReciprocalRank;
        this.precision = builder.precision;
        this.recall = builder.recall;
    }

    public static RankEvalMetric of(Function<Builder, ObjectBuilder<RankEvalMetric>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final RankEvalMetricDiscountedCumulativeGain dcg() {
        return this.dcg;
    }

    @Nullable
    public final RankEvalMetricExpectedReciprocalRank expectedReciprocalRank() {
        return this.expectedReciprocalRank;
    }

    @Nullable
    public final RankEvalMetricMeanReciprocalRank meanReciprocalRank() {
        return this.meanReciprocalRank;
    }

    @Nullable
    public final RankEvalMetricPrecision precision() {
        return this.precision;
    }

    @Nullable
    public final RankEvalMetricRecall recall() {
        return this.recall;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dcg != null) {
            generator.writeKey("dcg");
            this.dcg.serialize(generator, mapper);
        }
        if (this.expectedReciprocalRank != null) {
            generator.writeKey("expected_reciprocal_rank");
            this.expectedReciprocalRank.serialize(generator, mapper);
        }
        if (this.meanReciprocalRank != null) {
            generator.writeKey("mean_reciprocal_rank");
            this.meanReciprocalRank.serialize(generator, mapper);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            this.precision.serialize(generator, mapper);
        }
        if (this.recall != null) {
            generator.writeKey("recall");
            this.recall.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRankEvalMetricDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dcg, RankEvalMetricDiscountedCumulativeGain._DESERIALIZER, "dcg");
        op.add(Builder::expectedReciprocalRank, RankEvalMetricExpectedReciprocalRank._DESERIALIZER, "expected_reciprocal_rank");
        op.add(Builder::meanReciprocalRank, RankEvalMetricMeanReciprocalRank._DESERIALIZER, "mean_reciprocal_rank");
        op.add(Builder::precision, RankEvalMetricPrecision._DESERIALIZER, "precision");
        op.add(Builder::recall, RankEvalMetricRecall._DESERIALIZER, "recall");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.dcg);
        result = 31 * result + Objects.hashCode(this.expectedReciprocalRank);
        result = 31 * result + Objects.hashCode(this.meanReciprocalRank);
        result = 31 * result + Objects.hashCode(this.precision);
        result = 31 * result + Objects.hashCode(this.recall);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankEvalMetric other = (RankEvalMetric)o;
        return Objects.equals(this.dcg, other.dcg) && Objects.equals(this.expectedReciprocalRank, other.expectedReciprocalRank) && Objects.equals(this.meanReciprocalRank, other.meanReciprocalRank) && Objects.equals(this.precision, other.precision) && Objects.equals(this.recall, other.recall);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RankEvalMetric> {
        @Nullable
        private RankEvalMetricDiscountedCumulativeGain dcg;
        @Nullable
        private RankEvalMetricExpectedReciprocalRank expectedReciprocalRank;
        @Nullable
        private RankEvalMetricMeanReciprocalRank meanReciprocalRank;
        @Nullable
        private RankEvalMetricPrecision precision;
        @Nullable
        private RankEvalMetricRecall recall;

        public Builder() {
        }

        private Builder(RankEvalMetric o) {
            this.dcg = o.dcg;
            this.expectedReciprocalRank = o.expectedReciprocalRank;
            this.meanReciprocalRank = o.meanReciprocalRank;
            this.precision = o.precision;
            this.recall = o.recall;
        }

        private Builder(Builder o) {
            this.dcg = o.dcg;
            this.expectedReciprocalRank = o.expectedReciprocalRank;
            this.meanReciprocalRank = o.meanReciprocalRank;
            this.precision = o.precision;
            this.recall = o.recall;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder dcg(@Nullable RankEvalMetricDiscountedCumulativeGain value) {
            this.dcg = value;
            return this;
        }

        @Nonnull
        public final Builder dcg(Function<RankEvalMetricDiscountedCumulativeGain.Builder, ObjectBuilder<RankEvalMetricDiscountedCumulativeGain>> fn) {
            return this.dcg(fn.apply(new RankEvalMetricDiscountedCumulativeGain.Builder()).build());
        }

        @Nonnull
        public final Builder expectedReciprocalRank(@Nullable RankEvalMetricExpectedReciprocalRank value) {
            this.expectedReciprocalRank = value;
            return this;
        }

        @Nonnull
        public final Builder expectedReciprocalRank(Function<RankEvalMetricExpectedReciprocalRank.Builder, ObjectBuilder<RankEvalMetricExpectedReciprocalRank>> fn) {
            return this.expectedReciprocalRank(fn.apply(new RankEvalMetricExpectedReciprocalRank.Builder()).build());
        }

        @Nonnull
        public final Builder meanReciprocalRank(@Nullable RankEvalMetricMeanReciprocalRank value) {
            this.meanReciprocalRank = value;
            return this;
        }

        @Nonnull
        public final Builder meanReciprocalRank(Function<RankEvalMetricMeanReciprocalRank.Builder, ObjectBuilder<RankEvalMetricMeanReciprocalRank>> fn) {
            return this.meanReciprocalRank(fn.apply(new RankEvalMetricMeanReciprocalRank.Builder()).build());
        }

        @Nonnull
        public final Builder precision(@Nullable RankEvalMetricPrecision value) {
            this.precision = value;
            return this;
        }

        @Nonnull
        public final Builder precision(Function<RankEvalMetricPrecision.Builder, ObjectBuilder<RankEvalMetricPrecision>> fn) {
            return this.precision(fn.apply(new RankEvalMetricPrecision.Builder()).build());
        }

        @Nonnull
        public final Builder recall(@Nullable RankEvalMetricRecall value) {
            this.recall = value;
            return this;
        }

        @Nonnull
        public final Builder recall(Function<RankEvalMetricRecall.Builder, ObjectBuilder<RankEvalMetricRecall>> fn) {
            return this.recall(fn.apply(new RankEvalMetricRecall.Builder()).build());
        }

        @Override
        @Nonnull
        public RankEvalMetric build() {
            this._checkSingleUse();
            return new RankEvalMetric(this);
        }
    }
}

