/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.frontend.TerminalOutputScrollingModel;
import com.intellij.terminal.session.TerminalOutputBlock;
import com.intellij.util.CoroutineScopeKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptions;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptionsListener;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockFinishedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockRemovedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockStartedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModelEvent;
import org.jetbrains.plugins.terminal.block.ui.BlockSeparatorRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalBlockLeftErrorRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalPromptLeftAreaRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalPromptSeparatorRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.ui.VerticalSpaceInlayRenderer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001%B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0018\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/terminal/frontend/TerminalBlocksDecorator;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "scrollingModel", "Lcom/intellij/terminal/frontend/TerminalOutputScrollingModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;Lcom/intellij/terminal/frontend/TerminalOutputScrollingModel;Lkotlinx/coroutines/CoroutineScope;)V", "decorations", "", "", "Lcom/intellij/terminal/frontend/TerminalBlocksDecorator$BlockDecoration;", "handleBlocksModelEvent", "", "event", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelEvent;", "createPromptDecoration", "block", "Lcom/intellij/terminal/session/TerminalOutputBlock;", "createFinishedBlockDecoration", "createDecorationsForAllBlocks", "disposeAllDecorations", "disposeDecoration", "decoration", "createTopInlay", "Lcom/intellij/openapi/editor/Inlay;", "createBottomInlay", "offset", "createBackgroundHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "startOffset", "endOffset", "createCornersHighlighter", "BlockDecoration", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalBlocksDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksDecorator.kt\ncom/intellij/terminal/frontend/TerminalBlocksDecorator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class TerminalBlocksDecorator {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final TerminalOutputScrollingModel scrollingModel;
    @NotNull
    private final Map<Integer, BlockDecoration> decorations;

    public TerminalBlocksDecorator(@NotNull EditorEx editor, @NotNull TerminalBlocksModel blocksModel, @NotNull TerminalOutputScrollingModel scrollingModel, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)blocksModel, (String)"blocksModel");
        Intrinsics.checkNotNullParameter((Object)scrollingModel, (String)"scrollingModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.editor = editor;
        this.blocksModel = blocksModel;
        this.scrollingModel = scrollingModel;
        this.decorations = new HashMap();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalBlocksDecorator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.blocksModel.getEvents().collect(new FlowCollector(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            public final Object emit(TerminalBlocksModelEvent event, Continuation<? super Unit> $completion) {
                                void $this$doTerminalOutputScrollChangingAction$iv;
                                Editor editor = (Editor)this$0.editor;
                                TerminalBlocksDecorator terminalBlocksDecorator = this$0;
                                boolean $i$f$doTerminalOutputScrollChangingAction = false;
                                TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress((Editor)$this$doTerminalOutputScrollChangingAction$iv, true);
                                try {
                                    boolean bl = false;
                                    terminalBlocksDecorator.handleBlocksModelEvent(event);
                                    Unit unit = Unit.INSTANCE;
                                }
                                finally {
                                    TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress((Editor)$this$doTerminalOutputScrollChangingAction$iv, false);
                                }
                                this$0.scrollingModel.scrollToCursor(false);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BlockTerminalOptions.Companion.getInstance().addListener(CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new BlockTerminalOptionsListener(){

            @Override
            public void showSeparatorsBetweenBlocksChanged(boolean shouldShow) {
                if (shouldShow) {
                    this.createDecorationsForAllBlocks();
                } else {
                    this.disposeAllDecorations();
                }
            }
        });
    }

    private final void handleBlocksModelEvent(TerminalBlocksModelEvent event) {
        if (!BlockTerminalOptions.Companion.getInstance().getShowSeparatorsBetweenBlocks()) {
            return;
        }
        TerminalOutputBlock block = event.getBlock();
        TerminalBlocksModelEvent terminalBlocksModelEvent = event;
        if (terminalBlocksModelEvent instanceof TerminalBlockStartedEvent) {
            this.decorations.put(block.getId(), this.createPromptDecoration(block));
        } else if (terminalBlocksModelEvent instanceof TerminalBlockFinishedEvent) {
            BlockDecoration blockDecoration = this.decorations.get(block.getId());
            if (blockDecoration == null) {
                throw new IllegalStateException(("Decoration not found for block " + block).toString());
            }
            BlockDecoration decoration = blockDecoration;
            this.disposeDecoration(decoration);
            this.decorations.put(block.getId(), this.createFinishedBlockDecoration(block));
        } else if (terminalBlocksModelEvent instanceof TerminalBlockRemovedEvent) {
            BlockDecoration blockDecoration = this.decorations.get(block.getId());
            if (blockDecoration == null) {
                throw new IllegalStateException(("Decoration not found for block " + block).toString());
            }
            BlockDecoration decoration = blockDecoration;
            this.disposeDecoration(decoration);
            this.decorations.remove(block.getId());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final BlockDecoration createPromptDecoration(TerminalOutputBlock block) {
        RangeHighlighter rangeHighlighter;
        int startOffset = block.getStartOffset();
        int endOffset = block.getEndOffset();
        Inlay<?> topInlay = this.createTopInlay(block);
        RangeHighlighter bgHighlighter = this.createBackgroundHighlighter(startOffset, endOffset);
        bgHighlighter.setGreedyToRight(true);
        RangeHighlighter it = rangeHighlighter = this.createCornersHighlighter(startOffset, endOffset);
        boolean bl = false;
        it.setGreedyToRight(true);
        it.setCustomRenderer((CustomHighlighterRenderer)new TerminalPromptSeparatorRenderer());
        it.setLineMarkerRenderer((LineMarkerRenderer)new TerminalPromptLeftAreaRenderer());
        RangeHighlighter cornersHighlighter = rangeHighlighter;
        return new BlockDecoration(block.getId(), bgHighlighter, cornersHighlighter, topInlay, null);
    }

    private final BlockDecoration createFinishedBlockDecoration(TerminalOutputBlock block) {
        int startOffset = block.getStartOffset();
        int endOffset = Math.max(0, block.getEndOffset() - 1);
        Inlay<?> topInlay = this.createTopInlay(block);
        Inlay<?> bottomInlay = this.createBottomInlay(endOffset);
        RangeHighlighter bgHighlighter = this.createBackgroundHighlighter(startOffset, endOffset);
        RangeHighlighter cornersHighlighter = this.createCornersHighlighter(startOffset, endOffset);
        cornersHighlighter.setCustomRenderer((CustomHighlighterRenderer)new BlockSeparatorRenderer());
        if (block.getExitCode() != null) {
            Integer n = block.getExitCode();
            if (n == null || n != 0) {
                cornersHighlighter.setLineMarkerRenderer((LineMarkerRenderer)new TerminalBlockLeftErrorRenderer());
            }
        }
        return new BlockDecoration(block.getId(), bgHighlighter, cornersHighlighter, topInlay, bottomInlay);
    }

    private final void createDecorationsForAllBlocks() {
        if (!this.decorations.isEmpty()) {
            boolean $i$a$-check-TerminalBlocksDecorator$createDecorationsForAllBlocks$22 = false;
            String $i$a$-check-TerminalBlocksDecorator$createDecorationsForAllBlocks$22 = "Decorations map should be empty";
            throw new IllegalStateException($i$a$-check-TerminalBlocksDecorator$createDecorationsForAllBlocks$22.toString());
        }
        List<TerminalOutputBlock> blocks = this.blocksModel.getBlocks();
        int n = ((Collection)blocks).size();
        for (int ind = 0; ind < n; ++ind) {
            TerminalOutputBlock block = blocks.get(ind);
            this.decorations.put(block.getId(), ind < CollectionsKt.getLastIndex(blocks) ? this.createFinishedBlockDecoration(block) : this.createPromptDecoration(block));
        }
    }

    private final void disposeAllDecorations() {
        for (BlockDecoration decoration : this.decorations.values()) {
            this.disposeDecoration(decoration);
        }
        this.decorations.clear();
    }

    private final void disposeDecoration(BlockDecoration decoration) {
        block0: {
            decoration.getBackgroundHighlighter().dispose();
            decoration.getCornersHighlighter().dispose();
            Disposer.dispose((Disposable)((Disposable)decoration.getTopInlay()));
            Inlay<?> inlay = decoration.getBottomInlay();
            if (inlay == null) break block0;
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    private final Inlay<?> createTopInlay(TerminalOutputBlock block) {
        VerticalSpaceInlayRenderer topRenderer = new VerticalSpaceInlayRenderer((Function0<Integer>)((Function0)() -> TerminalBlocksDecorator.createTopInlay$lambda$3(this, block)));
        Inlay inlay = this.editor.getInlayModel().addBlockElement(block.getStartOffset(), false, true, 300, (EditorCustomElementRenderer)topRenderer);
        Intrinsics.checkNotNull((Object)inlay);
        return inlay;
    }

    private final Inlay<?> createBottomInlay(int offset) {
        VerticalSpaceInlayRenderer bottomRenderer = new VerticalSpaceInlayRenderer(6);
        Inlay inlay = this.editor.getInlayModel().addBlockElement(offset, true, false, 100, (EditorCustomElementRenderer)bottomRenderer);
        Intrinsics.checkNotNull((Object)inlay);
        return inlay;
    }

    private final RangeHighlighter createBackgroundHighlighter(int startOffset, int endOffset) {
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        return rangeHighlighter;
    }

    private final RangeHighlighter createCornersHighlighter(int startOffset, int endOffset) {
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 900, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        return rangeHighlighter;
    }

    private static final int createTopInlay$lambda$3(TerminalBlocksDecorator this$0, TerminalOutputBlock $block) {
        TerminalOutputBlock terminalOutputBlock = (TerminalOutputBlock)CollectionsKt.firstOrNull(this$0.blocksModel.getBlocks());
        boolean isFirstBlock = terminalOutputBlock != null ? terminalOutputBlock.getId() == $block.getId() : false;
        return isFirstBlock ? 0 : 7;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\f\b\u0002\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/terminal/frontend/TerminalBlocksDecorator$BlockDecoration;", "", "blockId", "", "backgroundHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "cornersHighlighter", "topInlay", "Lcom/intellij/openapi/editor/Inlay;", "bottomInlay", "<init>", "(ILcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/openapi/editor/Inlay;)V", "getBlockId", "()I", "getBackgroundHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getCornersHighlighter", "getTopInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getBottomInlay", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.terminal.frontend"})
    private static final class BlockDecoration {
        private final int blockId;
        @NotNull
        private final RangeHighlighter backgroundHighlighter;
        @NotNull
        private final RangeHighlighter cornersHighlighter;
        @NotNull
        private final Inlay<?> topInlay;
        @Nullable
        private final Inlay<?> bottomInlay;

        public BlockDecoration(int blockId, @NotNull RangeHighlighter backgroundHighlighter, @NotNull RangeHighlighter cornersHighlighter, @NotNull Inlay<?> topInlay, @Nullable Inlay<?> bottomInlay) {
            Intrinsics.checkNotNullParameter((Object)backgroundHighlighter, (String)"backgroundHighlighter");
            Intrinsics.checkNotNullParameter((Object)cornersHighlighter, (String)"cornersHighlighter");
            Intrinsics.checkNotNullParameter(topInlay, (String)"topInlay");
            this.blockId = blockId;
            this.backgroundHighlighter = backgroundHighlighter;
            this.cornersHighlighter = cornersHighlighter;
            this.topInlay = topInlay;
            this.bottomInlay = bottomInlay;
        }

        public final int getBlockId() {
            return this.blockId;
        }

        @NotNull
        public final RangeHighlighter getBackgroundHighlighter() {
            return this.backgroundHighlighter;
        }

        @NotNull
        public final RangeHighlighter getCornersHighlighter() {
            return this.cornersHighlighter;
        }

        @NotNull
        public final Inlay<?> getTopInlay() {
            return this.topInlay;
        }

        @Nullable
        public final Inlay<?> getBottomInlay() {
            return this.bottomInlay;
        }

        public final int component1() {
            return this.blockId;
        }

        @NotNull
        public final RangeHighlighter component2() {
            return this.backgroundHighlighter;
        }

        @NotNull
        public final RangeHighlighter component3() {
            return this.cornersHighlighter;
        }

        @NotNull
        public final Inlay<?> component4() {
            return this.topInlay;
        }

        @Nullable
        public final Inlay<?> component5() {
            return this.bottomInlay;
        }

        @NotNull
        public final BlockDecoration copy(int blockId, @NotNull RangeHighlighter backgroundHighlighter, @NotNull RangeHighlighter cornersHighlighter, @NotNull Inlay<?> topInlay, @Nullable Inlay<?> bottomInlay) {
            Intrinsics.checkNotNullParameter((Object)backgroundHighlighter, (String)"backgroundHighlighter");
            Intrinsics.checkNotNullParameter((Object)cornersHighlighter, (String)"cornersHighlighter");
            Intrinsics.checkNotNullParameter(topInlay, (String)"topInlay");
            return new BlockDecoration(blockId, backgroundHighlighter, cornersHighlighter, topInlay, bottomInlay);
        }

        public static /* synthetic */ BlockDecoration copy$default(BlockDecoration blockDecoration, int n, RangeHighlighter rangeHighlighter, RangeHighlighter rangeHighlighter2, Inlay inlay, Inlay inlay2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = blockDecoration.blockId;
            }
            if ((n2 & 2) != 0) {
                rangeHighlighter = blockDecoration.backgroundHighlighter;
            }
            if ((n2 & 4) != 0) {
                rangeHighlighter2 = blockDecoration.cornersHighlighter;
            }
            if ((n2 & 8) != 0) {
                inlay = blockDecoration.topInlay;
            }
            if ((n2 & 0x10) != 0) {
                inlay2 = blockDecoration.bottomInlay;
            }
            return blockDecoration.copy(n, rangeHighlighter, rangeHighlighter2, inlay, inlay2);
        }

        @NotNull
        public String toString() {
            return "BlockDecoration(blockId=" + this.blockId + ", backgroundHighlighter=" + this.backgroundHighlighter + ", cornersHighlighter=" + this.cornersHighlighter + ", topInlay=" + this.topInlay + ", bottomInlay=" + this.bottomInlay + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.blockId);
            result2 = result2 * 31 + this.backgroundHighlighter.hashCode();
            result2 = result2 * 31 + this.cornersHighlighter.hashCode();
            result2 = result2 * 31 + this.topInlay.hashCode();
            result2 = result2 * 31 + (this.bottomInlay == null ? 0 : this.bottomInlay.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockDecoration)) {
                return false;
            }
            BlockDecoration blockDecoration = (BlockDecoration)other;
            if (this.blockId != blockDecoration.blockId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.backgroundHighlighter, (Object)blockDecoration.backgroundHighlighter)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cornersHighlighter, (Object)blockDecoration.cornersHighlighter)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.topInlay, blockDecoration.topInlay)) {
                return false;
            }
            return Intrinsics.areEqual(this.bottomInlay, blockDecoration.bottomInlay);
        }
    }
}

