local cockpit_anim_speed = 0.06

local A1_1 = --custom 255
        {
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 1, 13 frames
            1,1,1,2,1,2,1,2,3,2,3,4,5,4,5,6,7,6,7,8,7,8,9,8,9,9,9, -- hard cycle, 27 frames
            1,1,1,2,3,4,5,6,6,5,4,5,6,6,5,4,3,2, -- hungup, 18 frames
            1,1,1,2,3,3,2, -- quick fail, 7 frames
            1,1,1,2,3,2,3,2,3,2, -- quick fail, 10 frames
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 3, 13 frames
            1,1,1,2,3,4,5,6,7,7,7,6,5,6,7,6,7,6,5,4,4,4,3,2,3,3,2, -- hangup, 27 frames
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 4, 13 frames
            1,2,3,2,3,4,5,6,5,4,5,6,7,6,7,8,7,6,6,7,7,8,8,9,8,9,8,9,9,9, -- hard cycle 5, 30 frames
            1,1,1,2,3,2,3,2,3,2, -- quick fail, 10 frames
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 6, 13 frames
            1,1,1,2,2,3,2,3,4,5,5,4,3,4,3,2,2, -- hangup, 17 frames
            1,1,1,2,3,4,5,6,5,4,3,4,5,6,7,7,7,6,5,6,7,8,8,9,9,9, -- hard cycle 7, 26 frames
            1,1,1,2,3,3,2,1,2,3,4,5,6,5,5,4,5,6,7,8,9,9,9, -- hard rise cycle 8, 24 frames
            1,1,1,2,3,2,3,2, -- quick fail, 8 frames
        }
local A1_2 = --custom 255 / A1_1
        {
            1,1,1,1,1,1,1,1,1,1,1,2,2, -- full rise cycle 1, 13 frames
            2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3, -- hard cycle, 27 frames
            3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3, -- hungup, 18 frames
            3,3,3,3,3,3,3, -- quick fail, 7 frames
            3,3,3,3,3,3,3,3,3,3, -- quick fail, 10 frames
            3,3,3,3,3,3,3,3,3,3,3,4,4, -- full rise cycle 3, 13 frames
            4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4, -- hangup, 27 frames
            4,4,4,4,4,4,4,4,4,4,4,5,5, -- full rise cycle 4, 13 frames
            5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6, -- hard cycle 5, 30 frames
            6,6,6,6,6,6,6,6,6,6, -- quick fail, 10 frames
            6,6,6,6,6,6,6,6,6,6,6,7,7, -- full rise cycle 6, 13 frames
            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7, -- hangup, 17 frames
            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8, -- hard cycle 7, 26 frames
            8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9, -- hard rise cycle 8, 24 frames
            9,8,7,6,5,4,3,2, -- unload, 8 frames
        }
local A1_3 = --custom 255
        {
            1,1,1,2,3,4,5,6,6,5,4,5,6,6,5,4,3,2, -- hungup, 18 frames
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 1, 13 frames
            1,1,1,2,3,3,2, -- quick fail, 7 frames
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 6, 13 frames
            1,1,1,2,3,2,3,2,3,2, -- quick fail, 10 frames
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 3, 13 frames
            1,1,1,2,3,4,5,6,7,7,7,6,5,6,7,6,7,6,5,4,4,4,3,2,3,3,2, -- hangup, 27 frames
            1,1,1,2,3,4,5,6,7,8,9,9,9, -- full rise cycle 4, 13 frames
            1,1,1,2,1,2,1,2,3,2,3,4,5,4,5,6,7,6,7,8,7,8,9,8,9,9,9, -- hard cycle, 27 frames
            1,1,1,2,2,3,2,3,4,5,5,4,3,4,3,2,2, -- hangup, 17 frames
            1,1,1,2,3,3,2,1,2,3,4,5,6,5,5,4,5,6,7,8,9,9,9, -- hard rise cycle 8, 24 frames
            1,2,3,2,3,4,5,6,5,4,5,6,7,6,7,8,7,6,6,7,7,8,8,9,8,9,8,9,9,9, -- hard cycle 5, 30 frames
            1,1,1,2,3,4,5,6,5,4,3,4,5,6,7,7,7,6,5,6,7,8,8,9,9,9, -- hard cycle 7, 26 frames
            1,1,1,2,3,2,3,2,3,2, -- quick fail, 10 frames
            1,1,1,2,3,2,3,2, -- quick fail, 8 frames
        }
local A1_4 = --custom 255 / A1_3
        {
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, -- hungup, 18 frames
            1,1,1,1,1,1,1,1,1,1,1,2,2, -- full rise cycle 1, 13 frames
            2,2,2,2,2,2,2, -- quick fail, 7 frames
            2,2,2,2,2,2,2,2,2,2,2,3,3, -- full rise cycle 6, 13 frames
            3,3,3,3,3,3,3,3,3,3, -- quick fail, 10 frames
            3,3,3,3,3,3,3,3,3,3,3,4,4, -- full rise cycle 3, 13 frames
            4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4, -- hangup, 27 frames
            4,4,4,4,4,4,4,4,4,4,4,5,5, -- full rise cycle 4, 13 frames
            5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6, -- hard cycle, 27 frames
            6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6, -- hangup, 66 frames
            6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7, -- hard rise cycle 6, 66 frames
            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8, -- hard cycle 5, 30 frames
            8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9, -- hard cycle 7, 26 frames
            9,9,9,9,9,9,9,9,9,9, -- quick fail, 10 frames
            9,8,7,6,5,4,3,2, -- unload, 8 frames
        }
local A2 = --60*4+15
        {
            --60
            1,1,1,1,1,1,2,2,1,1,2,2,1,1,2,2,2,2,2,2,
            3,3,2,2,3,3,2,2,3,3,3,3,3,3,4,4,3,3,4,4,
            3,3,4,4,4,4,4,4,3,3,4,4,2,2,4,4,1,1,4,4,
            --10
            1,1,1,1,1,1,1,1,1,1,
            --60
            1,1,1,1,1,1,2,2,1,1,2,2,1,1,2,2,2,2,2,2,
            3,3,2,2,3,3,2,2,3,3,3,3,3,3,4,4,3,3,4,4,
            3,3,4,4,4,4,4,4,3,3,4,4,2,2,4,4,1,1,4,4,
            --60
            1,1,1,1,1,1,2,2,1,1,2,2,1,1,2,2,2,2,2,2,
            3,3,2,2,3,3,2,2,3,3,3,3,3,3,4,4,3,3,4,4,
            3,3,4,4,4,4,4,4,3,3,4,4,2,2,4,4,1,1,4,4,
            --5
            1,1,1,1,1,
            --60
            1,1,1,1,1,1,2,2,1,1,2,2,1,1,2,2,2,2,2,2,
            3,3,2,2,3,3,2,2,3,3,3,3,3,3,4,4,3,3,4,4,
            3,3,4,4,4,4,4,4,3,3,4,4,2,2,4,4,1,1,4,4,
        }

local A3 =  --100*2+55
        {
            --100
            4,4,4,4,4,4,2,2,2,2,2,2,2,2,4,4,3,3,1,1,
            4,4,3,3,2,2,4,4,3,3,4,4,4,4,3,3,3,3,2,2,
            3,3,4,4,2,2,3,3,3,3,4,4,2,2,1,1,1,4,1,1,
            4,4,4,4,4,2,2,2,1,1,2,2,2,1,1,1,1,1,3,3,
            1,2,2,1,1,1,1,3,3,3,3,3,4,4,4,4,4,4,3,3,
            --100
            4,4,4,4,4,4,2,2,2,2,2,2,2,2,4,4,3,3,1,1,
            4,4,3,3,2,2,4,4,3,3,4,4,4,4,3,3,3,3,2,2,
            3,3,4,4,2,2,3,3,3,3,4,4,2,2,1,1,1,4,1,1,
            4,4,4,4,4,2,2,2,1,1,2,2,2,1,1,1,1,1,3,3,
            1,2,2,1,1,1,1,3,3,3,3,3,4,4,4,4,4,4,3,3,
            --50
            4,4,4,4,4,4,2,2,2,2,2,2,2,2,4,4,3,3,1,1,
            4,4,3,3,2,2,4,4,3,3,4,4,4,4,3,3,3,3,2,2,
            3,3,4,4,2,2,3,3,3,3,2,3,3,3,3,
        }

local A4 =  --200+55
        {
            --200
            1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,
            1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,
            2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,
            2,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,2,
            1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,
            2,2,2,2,1,1,1,1,2,2,2,2,1,1,2,2,1,1,2,2,
            1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,
            1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,
            1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
            --50
            2,2,2,2,1,1,1,1,2,2,2,2,1,1,2,2,1,1,2,2,
            1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,
            1,1,2,2,1,1,2,2,1,1,2,2,2,1,1,
        }

local A5 =  --255
        {
            4,4,4,5,5,3,3,3,8,8,3,1,1,2,2,2,7,7,5,5,
            4,2,2,2,5,5,6,6,7,7,4,4,4,6,7,7,7,7,5,5,
            5,5,7,7,7,7,4,6,6,3,6,6,4,1,4,1,4,1,4,1,
            1,1,8,8,6,1,6,6,1,1,6,5,5,5,3,3,3,8,8,5,
            4,4,4,2,2,8,8,5,4,5,4,2,2,2,2,4,4,7,3,7,
            1,1,1,1,6,6,8,8,1,1,1,1,2,2,4,5,6,4,5,6,
            4,4,3,3,3,3,8,8,4,4,8,8,5,5,8,8,7,7,4,4,
            4,5,5,4,4,5,5,4,4,5,5,4,3,3,3,2,2,5,5,8,
            1,1,5,5,6,6,4,1,4,1,4,1,3,6,6,5,3,3,6,5,
            5,5,3,3,6,6,6,6,2,2,5,5,2,2,4,4,4,4,6,6,
            3,3,5,5,3,3,4,4,5,5,3,3,5,5,3,3,4,4,5,5,
            1,1,1,1,6,6,8,8,1,1,1,1,2,2,4,5,6,4,5,6,
            5,5,7,7,7,7,4,6,6,3,6,6,4,1,4,
        }

local A6 =  --60*4+15
        {
            --60
            2,2,2,2,4,4,4,4,1,1,3,3,1,1,4,4,2,2,1,1,
            2,2,1,1,3,3,3,3,1,1,2,2,4,4,4,4,2,2,2,2,
            3,3,1,1,1,1,2,2,3,3,2,2,4,4,4,4,4,4,2,2,
            --60
            2,2,2,2,4,4,4,4,1,1,3,3,1,1,4,4,2,2,1,1,
            2,2,1,1,3,3,3,3,1,1,2,2,4,4,4,4,2,2,2,2,
            3,3,1,1,1,1,2,2,3,3,2,2,4,4,4,4,4,4,2,2,
            --15
            1,1,1,1,1,1,2,2,2,2,4,4,3,3,3,
            --60
            2,2,2,2,4,4,4,4,1,1,3,3,1,1,4,4,2,2,1,1,
            2,2,1,1,3,3,3,3,1,1,2,2,4,4,4,4,2,2,2,2,
            3,3,1,1,1,1,2,2,3,3,2,2,4,4,4,4,4,4,2,2,
            --60
            2,2,2,2,4,4,4,4,1,1,3,3,1,1,4,4,2,2,1,1,
            2,2,1,1,3,3,3,3,1,1,2,2,4,4,4,4,2,2,2,2,
            3,3,1,1,1,1,2,2,3,3,2,2,4,4,4,4,4,4,2,2,

        }

local A7 =  --50*5+5
        {
            --50
            3,3,3,4,3,4,4,3,3,3,2,4,2,2,4,2,2,2,4,4,
            4,2,2,1,3,1,1,1,1,2,2,1,1,1,3,2,2,3,3,3,
            2,4,4,1,1,4,4,1,1,2,
            --50
            3,3,3,4,3,4,4,3,3,3,2,4,2,2,4,2,2,2,4,4,
            4,2,2,1,3,1,1,1,1,2,2,1,1,1,3,2,2,3,3,3,
            2,4,4,1,1,4,4,1,1,2,
            --50
            3,3,3,4,3,4,4,3,3,3,2,4,2,2,4,2,2,2,4,4,
            4,2,2,1,3,1,1,1,1,2,2,1,1,1,3,2,2,3,3,3,
            2,4,4,1,1,4,4,1,1,2,
            --50
            3,3,3,4,3,4,4,3,3,3,2,4,2,2,4,2,2,2,4,4,
            4,2,2,1,3,1,1,1,1,2,2,1,1,1,3,2,2,3,3,3,
            2,4,4,1,1,4,4,1,1,2,
            --50
            3,3,3,4,3,4,4,3,3,3,2,4,2,2,4,2,2,2,4,4,
            4,2,2,1,3,1,1,1,1,2,2,1,1,1,3,2,2,3,3,3,
            2,4,4,1,1,4,4,1,1,2,
            --5
            3,3,2,4,2,
        }

local A8 =  --62*4 + 7 special
        {
            -- lockon : 6
            -- all-red : 1

            --lockon sequence for 2
            1,1,1,1,1,2,2,2,2,2, --10
            1,1,1,1,2,2,2,2, -- 18
            1,1,1,2,2,2, -- 24
            1,1,1,2,2,2, -- 30
            1,1,1,2,2,2, -- 36
            1,1,2,2, -- 40
            1,1,2,2, -- 44
            1,1,2,2, -- 48
            1,2, -- 50
            1,2, -- 52
            1,2, -- 54
            6,6,6,6,6,6,6,6, --62

            1,1,

            --lockon sequence for 4
            1,1,1,1,1,4,4,4,4,4,1,1,1,1,4,4,4,4,1,1,
            1,4,4,4,1,1,1,4,4,4,1,1,1,4,4,4,1,1,4,4,
            1,1,4,4,1,1,4,4,1,4,1,4,1,4,6,6,6,6,6,6,
            6,6,

            1,1,

            --lockon sequence for 3
            1,1,1,1,1,3,3,3,3,3,1,1,1,1,3,3,3,3,1,1,
            1,3,3,3,1,1,1,3,3,3,1,1,1,3,3,3,1,1,3,3,
            1,1,3,3,1,1,3,3,1,3,1,3,1,3,6,6,6,6,6,6,
            6,6,

            1,1,

            --lockon sequence for 5
            1,1,1,1,1,5,5,5,5,5,1,1,1,1,5,5,5,5,1,1,
            1,5,5,5,1,1,1,5,5,5,1,1,1,5,5,5,1,1,5,5,
            1,1,5,5,1,1,5,5,1,5,1,5,1,5,6,6,6,6,6,6,
            6,6,

            1,
        }

local A9 =  --255
        {
            2,1,1,2,2,1,1,2,1,2,1,2,1,1,2,2,2,1,2,1,
            2,2,2,2,2,1,1,1,1,2,1,2,2,1,1,1,1,1,2,1,
            1,1,1,1,1,2,1,1,1,2,2,1,2,2,2,1,1,2,2,2,
            2,2,2,1,1,2,1,2,1,2,1,1,1,2,1,2,2,1,1,1,
            2,2,2,2,2,1,2,1,1,2,2,1,1,1,1,1,1,2,2,2,
            2,2,2,1,1,1,2,2,2,2,2,2,2,2,1,2,1,1,1,2,
            1,2,2,2,1,2,2,2,2,2,2,1,1,1,2,1,2,2,1,1,
            2,2,1,2,2,2,2,2,2,2,1,2,1,2,1,1,1,1,2,1,
            1,2,1,2,1,1,1,1,1,2,1,2,2,1,1,2,2,2,2,1,
            2,1,1,1,1,2,2,2,2,2,2,2,1,1,2,1,1,2,1,2,
            2,1,1,2,1,1,1,1,2,1,2,1,2,2,2,2,1,2,1,2,
            2,2,2,1,1,1,1,1,2,1,2,2,1,1,2,2,1,1,1,2,
            1,1,2,2,1,1,1,2,2,2,1,2,2,2,1,
        }

local B1 =  --100*2+30+25

        {
            --100
            3,3,3,2,2,2,3,3,3,3,2,2,2,3,3,3,2,2,2,2,
            1,1,1,1,1,1,3,3,3,3,2,2,2,1,1,2,1,2,1,1,
            3,3,3,3,2,2,2,3,3,2,2,1,1,1,1,1,1,1,1,1,
            3,3,3,3,2,2,2,2,2,3,3,3,2,2,2,2,1,1,1,1,
            1,1,1,2,2,2,2,3,3,3,3,3,2,2,1,1,1,2,2,2,
            --20
            1,1,1,2,2,2,3,3,3,2,2,1,2,3,3,2,3,3,3,2,
            2,1,1,1,1,1,1,1,1,1,
            --100
            3,3,3,2,2,2,3,3,3,3,2,2,2,3,3,3,2,2,2,2,
            1,1,1,1,1,1,3,3,3,3,2,2,2,1,1,2,1,2,1,1,
            3,3,3,3,2,2,2,3,3,2,2,1,1,1,1,1,1,1,1,1,
            3,3,3,3,2,2,2,2,2,3,3,3,2,2,2,2,1,1,1,1,
            1,1,1,2,2,2,2,3,3,3,3,3,2,2,1,1,1,2,2,2,
            --25
            2,2,3,3,3,3,2,2,1,2,2,1,1,1,1,2,2,3,3,3,
            2,2,1,1,1,
        }

local B2 =  --255
        {
            2,2,2,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,
            1,1,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,1,1,
            1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,
            2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,
            1,1,1,1,1,2,2,2,1,1,1,2,2,2,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,
            1,1,1,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,1,
            1,1,2,2,2,1,1,1,2,2,2,2,2,2,1,1,1,2,2,
            2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,
            2,2,2,1,1,1,2,2,2,1,1,1,2,2,2,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,
        }

local B3 =  --85*3
        {
            --85
            2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
            1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
            1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,
            --85
            2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
            1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
            1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,
            --85
            2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
            1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
            1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,
        }

local B4 =  --255

        {
            1,4,1,2,4,1,3,2,4,4,1,3,4,2,3,2,1,2,1,4,
            3,2,1,1,4,2,1,2,3,3,1,4,2,4,3,2,1,4,4,2,
            2,3,2,4,3,2,2,4,2,2,1,1,2,4,3,4,1,2,3,4,
            4,2,3,3,3,2,2,3,2,1,2,1,3,3,2,1,2,1,2,2,
            4,1,4,3,3,4,1,3,1,3,1,1,4,4,1,2,3,3,1,2,
            4,1,1,3,1,3,2,2,4,1,3,2,4,1,3,1,2,2,1,4,
            3,1,4,4,1,2,3,3,3,1,2,2,1,3,4,3,1,3,4,3,
            3,4,1,3,4,3,2,1,4,2,4,2,1,4,4,2,1,3,1,1,
            1,2,3,2,2,3,4,2,2,3,2,2,2,2,1,4,1,1,4,2,
            2,1,2,3,4,3,4,1,1,1,1,4,1,3,3,1,4,3,3,2,
            2,3,4,2,1,2,2,4,4,4,3,4,4,3,4,3,4,4,3,1,
            4,3,2,2,4,1,3,4,2,3,2,1,2,4,3,1,4,2,4,2,
            2,3,2,3,4,1,2,2,4,4,1,1,2,4,1,
        }

local B5 =  --51*5

        {
            --51
            3,3,1,1,3,3,1,1,2,2,2,2,2,2,2,2,3,3,
            3,3,1,1,3,3,1,1,4,4,4,4,4,4,4,4,3,3,
            3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,
            --51
            3,3,1,1,3,3,1,1,2,2,2,2,2,2,2,2,3,3,
            3,3,1,1,3,3,1,1,4,4,4,4,4,4,4,4,3,3,
            3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,
            --51
            3,3,1,1,3,3,1,1,2,2,2,2,2,2,2,2,3,3,
            3,3,1,1,3,3,1,1,4,4,4,4,4,4,4,4,3,3,
            3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,
            --51
            3,3,1,1,3,3,1,1,2,2,2,2,2,2,2,2,3,3,
            3,3,1,1,3,3,1,1,4,4,4,4,4,4,4,4,3,3,
            3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,
            --51
            3,3,1,1,3,3,1,1,2,2,2,2,2,2,2,2,3,3,
            3,3,1,1,3,3,1,1,4,4,4,4,4,4,4,4,3,3,
            3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,
        }

local B6 =  --255
        {
            2,2,2,2,2,1,2,1,
            1,1,1,1,1,2,1,2,
            2,2,2,2,2,3,2,3,
            3,3,3,3,3,4,3,4,
            4,4,4,4,4,3,4,3,2,3,2,3,2,1,2,1,
            1,1,1,1,1,2,1,2,
            2,2,2,2,2,1,2,1,
            1,1,1,1,1,2,1,2,3,2,3,2,3,4,3,4,
            4,4,4,4,3,4,3,4,3,2,3,2,1,2,1,2,
            1,1,1,1,2,1,2,1,2,3,2,3,4,3,4,3,
            4,4,4,4,
            4,4,4,4,3,4,3,4,3,2,3,2,1,2,1,2,
            1,1,1,1,1,2,1,2,
            2,2,2,2,2,1,2,1,
            1,1,1,1,
            1,1,1,1,1,2,1,2,
            2,2,2,2,
            2,2,2,2,2,3,2,3,
            3,3,3,3,3,2,3,2,
            2,2,2,2,
            2,2,2,2,2,3,2,3,
            3,3,3,3,
            3,3,3,3,
            3,3,3,3,2,3,2,1,2,1,2,
            1,1,1,1,2,1,2,1,2,3,2,3,
            3,3,3,3,
            3,3,3,3,2,3,2,3,
            2,2,2,2,3,2,3,2,3,4,3,4,
            3,4,3,4,3,2,3,2,
        }

local B7 =  --255
        {
            2,2,2,1,1,1,1,1,1,3,3,3,1,1,1,6,6,6,8,8,8,
            9,9,9,3,3,3,3,3,3,8,8,8,2,2,2,9,9,9,4,4,4,
            8,8,8,4,4,4,7,7,7,9,9,9,2,2,2,4,4,4,1,1,1,
            8,8,8,8,8,8,2,2,2,1,1,1,2,2,2,4,4,4,4,4,4,
            7,7,7,9,9,9,5,5,5,3,3,3,3,3,3,7,7,7,1,1,1,
            3,3,3,1,1,1,6,6,6,3,3,3,1,1,1,8,8,8,3,3,3,
            4,4,4,8,8,8,7,7,7,5,5,5,9,9,9,1,1,1,8,8,8,
            3,3,3,4,4,4,6,6,6,3,3,3,1,1,1,8,8,8,3,3,3,
            7,7,7,9,9,9,9,9,9,5,5,5,5,5,5,1,1,1,8,8,8,
            2,2,2,7,7,7,3,3,3,3,3,3,5,5,5,9,9,9,4,4,4,
            3,3,3,4,4,4,7,7,7,2,2,2,4,4,4,5,5,5,6,6,6,
            5,5,5,7,7,7,8,8,8,5,5,5,3,3,3,7,7,7,9,9,9,
            1,1,1
        }

local B8 =  --255
        {
            2,2,2,1,1,1,2,3,4,5,5,5,6,6,6,5,4,4,4,3,
            2,2,2,3,4,5,6,7,8,8,8,7,6,5,4,3,2,2,2,2,
            2,2,2,2,2,3,4,4,4,5,6,7,8,8,8,7,6,5,4,3,
            2,1,1,1,1,1,1,2,3,4,4,4,5,6,7,8,8,8,7,6,
            5,4,3,2,2,2,3,4,4,4,3,2,2,2,3,4,5,6,6,6,
            6,6,6,5,4,3,3,3,4,5,6,7,8,8,8,7,6,5,4,3,
            3,3,3,3,3,4,4,4,5,6,7,8,8,8,8,8,8,7,6,6,
            6,7,7,7,8,9,9,9,8,7,6,5,4,3,2,1,1,1,2,3,
            4,5,6,6,6,5,4,4,4,5,6,7,7,7,8,9,9,9,8,7,
            6,5,4,3,2,1,1,1,2,3,3,3,4,5,6,7,8,8,8,7,
            6,5,4,3,2,2,2,3,4,5,6,6,6,7,7,7,6,5,4,3,
            2,2,2,3,4,5,6,6,6,5,4,3,3,3,4,4,4,5,6,7,
            7,7,6,5,4,3,3,3,4,4,4,3,2,2,2,
        }

local B9 =  --255
        {
            1,1,2,2,3,3,4,4,5,5,6,6,6,6,7,7,8,8,9,9,
            8,8,7,7,6,6,5,5,4,4,3,3,2,2,3,3,4,4,5,5,
            6,6,7,7,8,8,7,7,6,6,5,5,4,4,3,3,2,2,2,2,
            3,3,4,4,5,5,6,6,6,6,5,5,6,6,7,7,8,8,9,9,
            8,8,7,7,8,8,9,9,8,8,7,7,6,6,5,5,6,6,7,7,
            7,7,6,6,5,5,4,4,3,3,2,2,3,3,4,4,5,5,6,6,
            7,7,8,8,9,9,8,8,7,7,6,6,5,5,4,4,5,5,6,6,
            7,7,6,6,7,7,8,8,9,9,8,8,7,7,6,6,5,5,4,4,
            3,3,2,2,1,1,2,2,3,3,4,4,5,5,6,6,5,5,4,4,
            3,3,2,2,3,3,4,4,3,3,2,2,1,1,2,2,1,1,2,2,
            3,3,2,2,1,1,2,2,3,3,4,4,5,5,4,4,5,5,6,6,
            5,5,4,4,3,3,4,4,5,5,6,6,7,7,6,6,5,5,4,4,
            3,3,2,2,1,1,2,2,3,3,2,2,1,1,1,
        }

local B10 =  --255
        {
            2,5,5,3,4,6,6,7,1,5,3,4,2,1,8,2,2,8,7,3,
            4,6,5,1,6,5,7,6,2,3,8,2,4,6,2,5,7,8,8,6,
            5,5,8,3,2,4,6,8,4,8,1,4,1,6,4,2,3,7,4,1,
            6,2,4,1,3,4,5,7,3,6,6,8,2,6,2,6,5,6,5,3,
            2,2,3,6,3,5,8,2,8,2,1,7,6,1,8,1,4,1,1,1,
            5,7,5,5,5,4,1,3,3,2,8,2,8,1,6,5,4,5,5,8,
            2,8,8,4,8,5,8,8,1,8,5,8,6,1,1,7,5,8,2,4,
            8,6,4,5,1,4,1,6,8,4,2,4,4,3,4,5,7,4,3,7,
            2,2,7,8,4,3,2,2,1,7,4,1,1,2,7,8,8,6,1,3,
            4,7,1,2,2,4,5,2,5,6,1,5,1,5,6,8,1,7,4,3,
            4,6,5,4,7,5,4,6,8,6,1,7,6,1,7,7,2,2,5,2,
            3,7,6,5,6,3,5,2,3,8,4,6,5,4,7,7,8,2,4,3,
            8,8,5,6,1,7,2,5,2,8,8,2,6,4,4,
        }

function load_cockpit_sprite(index,sequence,frame_count)
    return
    util.sprite_load("__space-age__/graphics/entity/cargo-hubs/hubs/cockpit/space-platform-hub-cockpit-"..index,
    {
    scale = 0.5,
    shift = {0, -1},
    animation_speed = cockpit_anim_speed,
    draw_as_glow = true,
    blend_mode = "additive",
    frame_count = 9,
    frame_sequence = sequence,
    })
end

function cockpit_animation()
    return
        {
            layers =
            {
                --UPPER COCKPIT
                load_cockpit_sprite("A-1-1",A1_1,9),
                load_cockpit_sprite("A-1-2",A1_2,9),
                load_cockpit_sprite("A-1-3",A1_3,9),
                load_cockpit_sprite("A-1-4",A1_4,9),
                load_cockpit_sprite("A-2",A2,4),
                load_cockpit_sprite("A-3",A3,4),
                load_cockpit_sprite("A-4",A4,2),
                load_cockpit_sprite("A-5",A5,8),
                load_cockpit_sprite("A-6",A6,4),
                load_cockpit_sprite("A-7",A7,4),
                load_cockpit_sprite("A-8",A8,6),
                load_cockpit_sprite("A-9",A9,2),
                -- LOWER COCKPIT
                load_cockpit_sprite("B-1",B1,3),
                load_cockpit_sprite("B-2",B2,2),
                load_cockpit_sprite("B-3",B3,2),
                load_cockpit_sprite("B-4",B4,4),
                load_cockpit_sprite("B-5",B5,4),
                load_cockpit_sprite("B-6",B6,4),
                load_cockpit_sprite("B-7",B7,9),
                load_cockpit_sprite("B-8",B8,9),
                load_cockpit_sprite("B-9",B9,9),
                load_cockpit_sprite("B-10",B10,8)
            }
        }
end