/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.dragon.EnderDragonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EnderDragonRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EnderDragonRenderer
extends EntityRenderer<EnderDragon, EnderDragonRenderState> {
    public static final ResourceLocation CRYSTAL_BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/end_crystal/end_crystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation DRAGON_EYES_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon_eyes.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull(DRAGON_LOCATION);
    private static final RenderType DECAL = RenderType.entityDecal(DRAGON_LOCATION);
    private static final RenderType EYES = RenderType.eyes(DRAGON_EYES_LOCATION);
    private static final RenderType BEAM = RenderType.entitySmoothCutout(CRYSTAL_BEAM_LOCATION);
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final EnderDragonModel model;

    public EnderDragonRenderer(EntityRendererProvider.Context p_173973_) {
        super(p_173973_);
        this.shadowRadius = 0.5f;
        this.model = new EnderDragonModel(p_173973_.bakeLayer(ModelLayers.ENDER_DRAGON));
    }

    @Override
    public void submit(EnderDragonRenderState p_430659_, PoseStack p_425524_, SubmitNodeCollector p_423449_, CameraRenderState p_424851_) {
        p_425524_.pushPose();
        float f = p_430659_.getHistoricalPos(7).yRot();
        float f1 = (float)(p_430659_.getHistoricalPos(5).y() - p_430659_.getHistoricalPos(10).y());
        p_425524_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f));
        p_425524_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f1 * 10.0f));
        p_425524_.translate(0.0f, 0.0f, 1.0f);
        p_425524_.scale(-1.0f, -1.0f, 1.0f);
        p_425524_.translate(0.0f, -1.501f, 0.0f);
        int i = OverlayTexture.pack((float)0.0f, (boolean)p_430659_.hasRedOverlay);
        if (p_430659_.deathTime > 0.0f) {
            int j = ARGB.white(p_430659_.deathTime / 200.0f);
            p_423449_.order(0).submitModel((Model)this.model, (Object)p_430659_, p_425524_, RenderType.dragonExplosionAlpha(DRAGON_EXPLODING_LOCATION), p_430659_.lightCoords, OverlayTexture.NO_OVERLAY, j, null, p_430659_.outlineColor, null);
            p_423449_.order(1).submitModel((Model)this.model, (Object)p_430659_, p_425524_, DECAL, p_430659_.lightCoords, i, -1, null, p_430659_.outlineColor, null);
        } else {
            p_423449_.order(0).submitModel((Model)this.model, (Object)p_430659_, p_425524_, RENDER_TYPE, p_430659_.lightCoords, i, -1, null, p_430659_.outlineColor, null);
        }
        p_423449_.submitModel((Model)this.model, (Object)p_430659_, p_425524_, EYES, p_430659_.lightCoords, OverlayTexture.NO_OVERLAY, p_430659_.outlineColor, null);
        if (p_430659_.deathTime > 0.0f) {
            float f2 = p_430659_.deathTime / 200.0f;
            p_425524_.pushPose();
            p_425524_.translate(0.0f, -1.0f, -2.0f);
            EnderDragonRenderer.submitRays(p_425524_, f2, p_423449_, RenderType.dragonRays());
            EnderDragonRenderer.submitRays(p_425524_, f2, p_423449_, RenderType.dragonRaysDepth());
            p_425524_.popPose();
        }
        p_425524_.popPose();
        if (p_430659_.beamOffset != null) {
            EnderDragonRenderer.submitCrystalBeams((float)p_430659_.beamOffset.x, (float)p_430659_.beamOffset.y, (float)p_430659_.beamOffset.z, p_430659_.ageInTicks, p_425524_, p_423449_, p_430659_.lightCoords);
        }
        super.submit(p_430659_, p_425524_, p_423449_, p_424851_);
    }

    private static void submitRays(PoseStack p_431183_, float p_423513_, SubmitNodeCollector p_425353_, RenderType p_427587_) {
        p_425353_.submitCustomGeometry(p_431183_, p_427587_, (p_426942_, p_423628_) -> {
            float f = Math.min(p_423513_ > 0.8f ? (p_423513_ - 0.8f) / 0.2f : 0.0f, 1.0f);
            int i = ARGB.colorFromFloat(1.0f - f, 1.0f, 1.0f, 1.0f);
            int j = 0xFF00FF;
            RandomSource randomsource = RandomSource.create(432L);
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f1 = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            Vector3f vector3f3 = new Vector3f();
            Quaternionf quaternionf = new Quaternionf();
            int k = Mth.floor((p_423513_ + p_423513_ * p_423513_) / 2.0f * 60.0f);
            for (int l = 0; l < k; ++l) {
                quaternionf.rotationXYZ(randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2) + p_423513_ * 1.5707964f);
                p_426942_.rotate((Quaternionfc)quaternionf);
                float f1 = randomsource.nextFloat() * 20.0f + 5.0f + f * 10.0f;
                float f2 = randomsource.nextFloat() * 2.0f + 1.0f + f * 2.0f;
                vector3f1.set(-HALF_SQRT_3 * f2, f1, -0.5f * f2);
                vector3f2.set(HALF_SQRT_3 * f2, f1, -0.5f * f2);
                vector3f3.set(0.0f, f1, f2);
                p_423628_.addVertex(p_426942_, vector3f).setColor(i);
                p_423628_.addVertex(p_426942_, vector3f1).setColor(0xFF00FF);
                p_423628_.addVertex(p_426942_, vector3f2).setColor(0xFF00FF);
                p_423628_.addVertex(p_426942_, vector3f).setColor(i);
                p_423628_.addVertex(p_426942_, vector3f2).setColor(0xFF00FF);
                p_423628_.addVertex(p_426942_, vector3f3).setColor(0xFF00FF);
                p_423628_.addVertex(p_426942_, vector3f).setColor(i);
                p_423628_.addVertex(p_426942_, vector3f3).setColor(0xFF00FF);
                p_423628_.addVertex(p_426942_, vector3f1).setColor(0xFF00FF);
            }
        });
    }

    public static void submitCrystalBeams(float p_427097_, float p_422335_, float p_431166_, float p_425647_, PoseStack p_425351_, SubmitNodeCollector p_429648_, int p_425816_) {
        float f = Mth.sqrt(p_427097_ * p_427097_ + p_431166_ * p_431166_);
        float f1 = Mth.sqrt(p_427097_ * p_427097_ + p_422335_ * p_422335_ + p_431166_ * p_431166_);
        p_425351_.pushPose();
        p_425351_.translate(0.0f, 2.0f, 0.0f);
        p_425351_.mulPose((Quaternionfc)Axis.YP.rotation((float)(-Math.atan2(p_431166_, p_427097_)) - 1.5707964f));
        p_425351_.mulPose((Quaternionfc)Axis.XP.rotation((float)(-Math.atan2(f, p_422335_)) - 1.5707964f));
        float f2 = 0.0f - p_425647_ * 0.01f;
        float f3 = f1 / 32.0f - p_425647_ * 0.01f;
        p_429648_.submitCustomGeometry(p_425351_, BEAM, (p_423101_, p_428371_) -> {
            int i = 8;
            float f4 = 0.0f;
            float f5 = 0.75f;
            float f6 = 0.0f;
            for (int j = 1; j <= 8; ++j) {
                float f7 = Mth.sin((float)j * ((float)Math.PI * 2) / 8.0f) * 0.75f;
                float f8 = Mth.cos((float)j * ((float)Math.PI * 2) / 8.0f) * 0.75f;
                float f9 = (float)j / 8.0f;
                p_428371_.addVertex(p_423101_, f4 * 0.2f, f5 * 0.2f, 0.0f).setColor(-16777216).setUv(f6, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_425816_).setNormal(p_423101_, 0.0f, -1.0f, 0.0f);
                p_428371_.addVertex(p_423101_, f4, f5, f1).setColor(-1).setUv(f6, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_425816_).setNormal(p_423101_, 0.0f, -1.0f, 0.0f);
                p_428371_.addVertex(p_423101_, f7, f8, f1).setColor(-1).setUv(f9, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_425816_).setNormal(p_423101_, 0.0f, -1.0f, 0.0f);
                p_428371_.addVertex(p_423101_, f7 * 0.2f, f8 * 0.2f, 0.0f).setColor(-16777216).setUv(f9, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_425816_).setNormal(p_423101_, 0.0f, -1.0f, 0.0f);
                f4 = f7;
                f5 = f8;
                f6 = f9;
            }
        });
        p_425351_.popPose();
    }

    @Override
    public EnderDragonRenderState createRenderState() {
        return new EnderDragonRenderState();
    }

    @Override
    public void extractRenderState(EnderDragon p_367718_, EnderDragonRenderState p_360720_, float p_367927_) {
        super.extractRenderState(p_367718_, p_360720_, p_367927_);
        p_360720_.flapTime = Mth.lerp(p_367927_, p_367718_.oFlapTime, p_367718_.flapTime);
        p_360720_.deathTime = p_367718_.dragonDeathTime > 0 ? (float)p_367718_.dragonDeathTime + p_367927_ : 0.0f;
        p_360720_.hasRedOverlay = p_367718_.hurtTime > 0;
        EndCrystal endcrystal = p_367718_.nearestCrystal;
        if (endcrystal != null) {
            Vec3 vec3 = endcrystal.getPosition(p_367927_).add(0.0, EndCrystalRenderer.getY((float)((float)endcrystal.time + p_367927_)), 0.0);
            p_360720_.beamOffset = vec3.subtract(p_367718_.getPosition(p_367927_));
        } else {
            p_360720_.beamOffset = null;
        }
        DragonPhaseInstance dragonphaseinstance = p_367718_.getPhaseManager().getCurrentPhase();
        p_360720_.isLandingOrTakingOff = dragonphaseinstance == EnderDragonPhase.LANDING || dragonphaseinstance == EnderDragonPhase.TAKEOFF;
        p_360720_.isSitting = dragonphaseinstance.isSitting();
        BlockPos blockpos = p_367718_.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(p_367718_.getFightOrigin()));
        p_360720_.distanceToEgg = blockpos.distToCenterSqr(p_367718_.position());
        p_360720_.partialTicks = p_367718_.isDeadOrDying() ? 0.0f : p_367927_;
        p_360720_.flightHistory.copyFrom(p_367718_.flightHistory);
    }

    @Override
    protected void extractAdditionalHitboxes(EnderDragon p_394570_, ImmutableList.Builder<HitboxRenderState> p_396096_, float p_397646_) {
        super.extractAdditionalHitboxes(p_394570_, p_396096_, p_397646_);
    }

    public static void extractAdditionalHitboxexGeneric(Entity p_394570_, ImmutableList.Builder<HitboxRenderState> p_396096_, float p_397646_) {
        if (!p_394570_.isMultipartEntity()) {
            return;
        }
        double d0 = -Mth.lerp((double)p_397646_, p_394570_.xOld, p_394570_.getX());
        double d1 = -Mth.lerp((double)p_397646_, p_394570_.yOld, p_394570_.getY());
        double d2 = -Mth.lerp((double)p_397646_, p_394570_.zOld, p_394570_.getZ());
        for (PartEntity enderdragonpart : p_394570_.getParts()) {
            AABB aabb = enderdragonpart.getBoundingBox();
            HitboxRenderState hitboxrenderstate = new HitboxRenderState(aabb.minX - enderdragonpart.getX(), aabb.minY - enderdragonpart.getY(), aabb.minZ - enderdragonpart.getZ(), aabb.maxX - enderdragonpart.getX(), aabb.maxY - enderdragonpart.getY(), aabb.maxZ - enderdragonpart.getZ(), (float)(d0 + Mth.lerp((double)p_397646_, enderdragonpart.xOld, enderdragonpart.getX())), (float)(d1 + Mth.lerp((double)p_397646_, enderdragonpart.yOld, enderdragonpart.getY())), (float)(d2 + Mth.lerp((double)p_397646_, enderdragonpart.zOld, enderdragonpart.getZ())), 0.25f, 1.0f, 0.0f);
            p_396096_.add((Object)hitboxrenderstate);
        }
    }

    @Override
    protected boolean affectedByCulling(EnderDragon p_362111_) {
        return false;
    }
}

