/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.players.NameAndId;
import net.minecraftforge.network.ServerStatusPing;

public record ServerStatus(Component description, Optional<Players> players, Optional<Version> version, Optional<Favicon> favicon, boolean enforcesSecureChat, Optional<ServerStatusPing> forgeData) {
    public static final Codec<ServerStatus> CODEC = RecordCodecBuilder.create(p_326135_ -> p_326135_.group((App)ComponentSerialization.CODEC.lenientOptionalFieldOf("description", (Object)CommonComponents.EMPTY).forGetter(ServerStatus::description), (App)Players.CODEC.lenientOptionalFieldOf("players").forGetter(ServerStatus::players), (App)Version.CODEC.lenientOptionalFieldOf("version").forGetter(ServerStatus::version), (App)Favicon.CODEC.lenientOptionalFieldOf("favicon").forGetter(ServerStatus::favicon), (App)Codec.BOOL.lenientOptionalFieldOf("enforcesSecureChat", (Object)false).forGetter(ServerStatus::enforcesSecureChat), (App)ServerStatusPing.CODEC.optionalFieldOf("forgeData").forGetter(ServerStatus::forgeData)).apply((Applicative)p_326135_, ServerStatus::new));

    public record Players(int max, int online, List<NameAndId> sample) {
        public static final Codec<Players> CODEC = RecordCodecBuilder.create(p_421256_ -> p_421256_.group((App)Codec.INT.fieldOf("max").forGetter(Players::max), (App)Codec.INT.fieldOf("online").forGetter(Players::online), (App)NameAndId.CODEC.listOf().lenientOptionalFieldOf("sample", List.of()).forGetter(Players::sample)).apply((Applicative)p_421256_, Players::new));
    }

    public record Version(String name, int protocol) {
        public static final Codec<Version> CODEC = RecordCodecBuilder.create(p_273157_ -> p_273157_.group((App)Codec.STRING.fieldOf("name").forGetter(Version::name), (App)Codec.INT.fieldOf("protocol").forGetter(Version::protocol)).apply((Applicative)p_273157_, Version::new));

        public static Version current() {
            WorldVersion worldversion = SharedConstants.getCurrentVersion();
            return new Version(worldversion.name(), worldversion.protocolVersion());
        }
    }

    public record Favicon(byte[] iconBytes) {
        private static final String PREFIX = "data:image/png;base64,";
        public static final Codec<Favicon> CODEC = Codec.STRING.comapFlatMap(p_274795_ -> {
            if (!p_274795_.startsWith(PREFIX)) {
                return DataResult.error(() -> "Unknown format");
            }
            try {
                String s = p_274795_.substring(PREFIX.length()).replaceAll("\n", "");
                byte[] abyte = Base64.getDecoder().decode(s.getBytes(StandardCharsets.UTF_8));
                return DataResult.success((Object)new Favicon(abyte));
            }
            catch (IllegalArgumentException illegalargumentexception) {
                return DataResult.error(() -> "Malformed base64 server icon");
            }
        }, p_273258_ -> PREFIX + new String(Base64.getEncoder().encode(p_273258_.iconBytes), StandardCharsets.UTF_8));
    }
}

