/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.gametest.BlockPosValueConverter;
import net.minecraftforge.server.loading.ServerModLoader;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SuppressForbidden(reason="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.tryDetectVersion();
        OptionParser optionparser = new OptionParser();
        OptionSpecBuilder optionspec = optionparser.accepts("nogui");
        OptionSpecBuilder optionspec1 = optionparser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder optionspec2 = optionparser.accepts("demo");
        OptionSpecBuilder optionspec3 = optionparser.accepts("bonusChest");
        OptionSpecBuilder optionspec4 = optionparser.accepts("forceUpgrade");
        OptionSpecBuilder optionspec5 = optionparser.accepts("eraseCache");
        OptionSpecBuilder optionspec6 = optionparser.accepts("recreateRegionFiles");
        OptionSpecBuilder optionspec7 = optionparser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec optionspec8 = optionparser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("serverId").withRequiredArg();
        OptionSpecBuilder optionspec13 = optionparser.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec optionspec14 = optionparser.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec optionspec15 = optionparser.nonOptions();
        optionparser.accepts("allowUpdates").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)Boolean.TRUE, (Object[])new Boolean[0]);
        optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        OptionSpecBuilder uniqueWorld = null;
        boolean gametestEnabled = Boolean.getBoolean("forge.gameTestServer");
        if (gametestEnabled) {
            ArgumentAcceptingOptionSpec spawnPosOpt = optionparser.accepts("spawnPos").withRequiredArg().withValuesConvertedBy((ValueConverter)new BlockPosValueConverter()).defaultsTo((Object)new BlockPos(0, 60, 0), (Object[])new BlockPos[0]);
            uniqueWorld = optionparser.accepts("uniqueWorld");
        } else {
            Object spawnPosOpt = null;
        }
        try {
            WorldStem worldstem;
            Dynamic<?> dynamic;
            OptionSet optionset = optionparser.parse(p_129699_);
            if (optionset.has((OptionSpec)optionspec8)) {
                optionparser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path path2 = Paths.get("eula.txt", new String[0]);
            Eula eula = new Eula(path2);
            if (!eula.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            Path path = (Path)optionset.valueOf((OptionSpec)optionspec14);
            if (path != null) {
                Main.writePidFile(path);
            }
            CrashReport.preload();
            if (optionset.has((OptionSpec)optionspec13)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            Bootstrap.bootStrap();
            Bootstrap.validate();
            Util.startTimerHackThread();
            Path path1 = Paths.get("server.properties", new String[0]);
            if (!optionset.has((OptionSpec)optionspec1)) {
                ServerModLoader.load();
            }
            DedicatedServerSettings dedicatedserversettings = new DedicatedServerSettings(path1);
            dedicatedserversettings.forceSave();
            RegionFileVersion.configure(dedicatedserversettings.getProperties().regionFileComression);
            if (optionset.has((OptionSpec)optionspec1)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)path1.toAbsolutePath(), (Object)path2.toAbsolutePath());
                return;
            }
            File file1 = new File((String)optionset.valueOf((OptionSpec)optionspec9));
            Services services = Services.create(new YggdrasilAuthenticationService(Proxy.NO_PROXY), file1);
            Object s = Optional.ofNullable((String)optionset.valueOf((OptionSpec)optionspec10)).orElse(dedicatedserversettings.getProperties().levelName);
            if (uniqueWorld != null && optionset.has((OptionSpec)uniqueWorld)) {
                s = "gametest_world\\" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss.SSS").format(LocalDateTime.now());
            }
            if (s == null || ((String)s).isEmpty() || new File(file1, (String)s).getAbsolutePath().equals(new File((String)s).getAbsolutePath())) {
                LOGGER.error("Invalid world directory specified, must not be null, empty or the same directory as your universe! " + (String)s);
                return;
            }
            LevelStorageSource levelstoragesource = LevelStorageSource.createDefault(file1.toPath());
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.validateAndCreateAccess((String)s);
            if (levelstoragesource$levelstorageaccess.hasWorldData()) {
                LevelSummary levelsummary;
                try {
                    dynamic = levelstoragesource$levelstorageaccess.getDataTag();
                    levelsummary = levelstoragesource$levelstorageaccess.getSummary(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception1) {
                    LevelStorageSource.LevelDirectory levelstoragesource$leveldirectory = levelstoragesource$levelstorageaccess.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)levelstoragesource$leveldirectory.dataFile(), (Object)ioexception1);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        dynamic = levelstoragesource$levelstorageaccess.getDataTagFallback();
                        levelsummary = levelstoragesource$levelstorageaccess.getSummary(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception) {
                        LOGGER.error("Failed to load world data from {}", (Object)levelstoragesource$leveldirectory.oldDataFile(), (Object)ioexception);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelstoragesource$leveldirectory.dataFile(), (Object)levelstoragesource$leveldirectory.oldDataFile());
                        return;
                    }
                    levelstoragesource$levelstorageaccess.restoreLevelDataFromOld();
                }
                if (levelsummary.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!levelsummary.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            Dynamic<?> dynamic1 = dynamic;
            boolean flag = optionset.has((OptionSpec)optionspec7);
            if (flag) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository packrepository = ServerPacksSource.createPackRepository(levelstoragesource$levelstorageaccess);
            if (dynamic != null) {
                ForgeHooks.readAdditionalLevelSaveData((LevelStorageSource.LevelStorageAccess)levelstoragesource$levelstorageaccess, (LevelStorageSource.LevelDirectory)levelstoragesource$levelstorageaccess.getLevelDirectory());
            }
            try {
                WorldLoader.InitConfig worldloader$initconfig = Main.loadOrCreateConfig(dedicatedserversettings.getProperties(), dynamic1, flag, packrepository);
                worldstem = (WorldStem)Util.blockUntilDone(arg_0 -> Main.lambda$main$1(worldloader$initconfig, dynamic1, dedicatedserversettings, optionset, (OptionSpec)optionspec2, (OptionSpec)optionspec3, arg_0)).get();
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                return;
            }
            RegistryAccess.Frozen registryaccess$frozen = worldstem.registries().compositeAccess();
            WorldData worlddata = worldstem.worldData();
            boolean flag1 = optionset.has((OptionSpec)optionspec6);
            if (optionset.has((OptionSpec)optionspec4) || flag1) {
                Main.forceUpgrade(levelstoragesource$levelstorageaccess, worlddata, DataFixers.getDataFixer(), optionset.has((OptionSpec)optionspec5), () -> true, registryaccess$frozen, flag1);
            }
            levelstoragesource$levelstorageaccess.saveDataTag(registryaccess$frozen, worlddata);
            final MinecraftServer dedicatedserver = MinecraftServer.spin(arg_0 -> Main.lambda$main$3(levelstoragesource$levelstorageaccess, packrepository, worldstem, dedicatedserversettings, services, optionset, (OptionSpec)optionspec11, (OptionSpec)optionspec2, (OptionSpec)optionspec12, (OptionSpec)optionspec, (OptionSpec)optionspec15, arg_0));
            Thread thread = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.halt(true);
                    LogManager.shutdown();
                }
            };
            thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception1) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static WorldLoader.DataLoadOutput<WorldData> createNewWorldData(DedicatedServerSettings p_430592_, WorldLoader.DataLoadContext p_423661_, Registry<LevelStem> p_422717_, boolean p_429137_, boolean p_427999_) {
        WorldDimensions worlddimensions;
        WorldOptions worldoptions;
        LevelSettings levelsettings;
        if (p_429137_) {
            levelsettings = MinecraftServer.DEMO_SETTINGS;
            worldoptions = WorldOptions.DEMO_OPTIONS;
            worlddimensions = WorldPresets.createNormalWorldDimensions(p_423661_.datapackWorldgen());
        } else {
            DedicatedServerProperties dedicatedserverproperties = p_430592_.getProperties();
            levelsettings = new LevelSettings(dedicatedserverproperties.levelName, dedicatedserverproperties.gameMode.get(), dedicatedserverproperties.hardcore, dedicatedserverproperties.difficulty.get(), false, new GameRules(p_423661_.dataConfiguration().enabledFeatures()), p_423661_.dataConfiguration());
            worldoptions = p_427999_ ? dedicatedserverproperties.worldOptions.withBonusChest(true) : dedicatedserverproperties.worldOptions;
            worlddimensions = dedicatedserverproperties.createDimensions(p_423661_.datapackWorldgen());
        }
        RegistryOps<Tag> dynamicops = RegistryOps.create(NbtOps.INSTANCE, p_423661_.datapackWorldgen());
        worlddimensions = WorldDimensions.CODEC.encoder().encodeStart(dynamicops, (Object)worlddimensions).flatMap(writtenPayloadWithModdedDimensions -> WorldDimensions.CODEC.decoder().parse((DynamicOps)dynamicops, writtenPayloadWithModdedDimensions)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(worlddimensions);
        WorldDimensions.Complete worlddimensions$complete = worlddimensions.bake(p_422717_);
        Lifecycle lifecycle = worlddimensions$complete.lifecycle().add(p_423661_.datapackWorldgen().allRegistriesLifecycle());
        return new WorldLoader.DataLoadOutput<WorldData>(new PrimaryLevelData(levelsettings, worldoptions, worlddimensions$complete.specialWorldProperty(), lifecycle), worlddimensions$complete.dimensionsRegistryAccess());
    }

    private static void writePidFile(Path p_270192_) {
        try {
            long i = ProcessHandle.current().pid();
            Files.writeString(p_270192_, (CharSequence)Long.toString(i), new OpenOption[0]);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    private static WorldLoader.InitConfig loadOrCreateConfig(DedicatedServerProperties p_248563_, @Nullable Dynamic<?> p_310940_, boolean p_249093_, PackRepository p_251069_) {
        WorldDataConfiguration worlddataconfiguration;
        boolean flag;
        if (p_310940_ != null) {
            WorldDataConfiguration worlddataconfiguration1 = LevelStorageSource.readDataConfig(p_310940_);
            flag = false;
            worlddataconfiguration = worlddataconfiguration1;
        } else {
            flag = true;
            worlddataconfiguration = new WorldDataConfiguration(p_248563_.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(p_251069_, worlddataconfiguration, p_249093_, flag);
        return new WorldLoader.InitConfig(worldloader$packconfig, Commands.CommandSelection.DEDICATED, p_248563_.functionPermissionLevel);
    }

    private static void forceUpgrade(LevelStorageSource.LevelStorageAccess p_195489_, WorldData p_394459_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, RegistryAccess p_332212_, boolean p_331291_) {
        LOGGER.info("Forcing world upgrade!");
        try (WorldUpgrader worldupgrader = new WorldUpgrader(p_195489_, p_195490_, p_394459_, p_332212_, p_195491_, p_331291_);){
            Component component = null;
            while (!worldupgrader.isFinished()) {
                int i;
                Component component1 = worldupgrader.getStatus();
                if (component != component1) {
                    component = component1;
                    LOGGER.info(worldupgrader.getStatus().getString());
                }
                if ((i = worldupgrader.getTotalChunks()) > 0) {
                    int j = worldupgrader.getConverted() + worldupgrader.getSkipped();
                    LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.floor((float)j / (float)i * 100.0f), j, i});
                }
                if (!p_195492_.getAsBoolean()) {
                    worldupgrader.cancel();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static /* synthetic */ MinecraftServer lambda$main$3(LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess, PackRepository packrepository, WorldStem worldstem, DedicatedServerSettings dedicatedserversettings, Services services, OptionSet optionset, OptionSpec optionspec11, OptionSpec optionspec2, OptionSpec optionspec12, OptionSpec optionspec, OptionSpec optionspec15, Thread p_421274_) {
        boolean flag2;
        DedicatedServer dedicatedserver1 = new DedicatedServer(p_421274_, levelstoragesource$levelstorageaccess, packrepository, worldstem, dedicatedserversettings, DataFixers.getDataFixer(), services);
        dedicatedserver1.setPort((Integer)optionset.valueOf(optionspec11));
        dedicatedserver1.setDemo(optionset.has(optionspec2));
        dedicatedserver1.setId((String)optionset.valueOf(optionspec12));
        boolean bl = flag2 = !optionset.has(optionspec) && !optionset.valuesOf(optionspec15).contains("nogui");
        if (flag2 && !GraphicsEnvironment.isHeadless() && dedicatedserver1 instanceof DedicatedServer) {
            DedicatedServer ds = dedicatedserver1;
            ds.showGui();
        }
        return dedicatedserver1;
    }

    private static /* synthetic */ CompletableFuture lambda$main$1(WorldLoader.InitConfig worldloader$initconfig, Dynamic dynamic1, DedicatedServerSettings dedicatedserversettings, OptionSet optionset, OptionSpec optionspec2, OptionSpec optionspec3, Executor p_358505_) {
        return WorldLoader.load(worldloader$initconfig, p_421262_ -> {
            HolderLookup.RegistryLookup registry = p_421262_.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM);
            if (dynamic1 != null) {
                LevelDataAndDimensions leveldataanddimensions = LevelStorageSource.getLevelDataAndDimensions(dynamic1, p_421262_.dataConfiguration(), (Registry<LevelStem>)registry, p_421262_.datapackWorldgen());
                return new WorldLoader.DataLoadOutput<WorldData>(leveldataanddimensions.worldData(), leveldataanddimensions.dimensions().dimensionsRegistryAccess());
            }
            LOGGER.info("No existing world data, creating new world");
            return Main.createNewWorldData(dedicatedserversettings, p_421262_, (Registry<LevelStem>)registry, optionset.has(optionspec2), optionset.has(optionspec3));
        }, WorldStem::new, Util.backgroundExecutor(), p_358505_);
    }
}

