/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<?>, SpawnEggItem> BY_ID = Maps.newIdentityHashMap();

    public SpawnEggItem(Item.Properties $$0) {
        super($$0);
        TypedEntityData<EntityType<?>> $$1 = this.components().get(DataComponents.ENTITY_DATA);
        if ($$1 != null) {
            BY_ID.put($$1.type(), this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InteractionResult useOn(UseOnContext $$0) {
        BlockPos $$12;
        Level $$1 = $$0.getLevel();
        if (!($$1 instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel $$2 = (ServerLevel)$$1;
        ItemStack $$4 = $$0.getItemInHand();
        BlockPos $$5 = $$0.getClickedPos();
        Direction $$6 = $$0.getClickedFace();
        BlockState $$7 = $$1.getBlockState($$5);
        BlockEntity blockEntity = $$1.getBlockEntity($$5);
        if (blockEntity instanceof Spawner) {
            void $$3;
            Spawner $$8 = (Spawner)((Object)blockEntity);
            EntityType<?> $$9 = this.getType($$4);
            if ($$9 == null) {
                return InteractionResult.FAIL;
            }
            if (!$$3.getServer().isSpawnerBlockEnabled()) {
                Player player = $$0.getPlayer();
                if (player instanceof ServerPlayer) {
                    ServerPlayer $$10 = (ServerPlayer)player;
                    $$10.sendSystemMessage(Component.translatable("advMode.notEnabled.spawner"));
                }
                return InteractionResult.FAIL;
            }
            $$8.setEntityId($$9, $$1.getRandom());
            $$1.sendBlockUpdated($$5, $$7, $$7, 3);
            $$1.gameEvent($$0.getPlayer(), GameEvent.BLOCK_CHANGE, $$5);
            $$4.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if ($$7.getCollisionShape($$1, $$5).isEmpty()) {
            BlockPos $$11 = $$5;
        } else {
            $$12 = $$5.relative($$6);
        }
        return this.spawnMob($$0.getPlayer(), $$4, $$1, $$12, true, !Objects.equals($$5, $$12) && $$6 == Direction.UP);
    }

    private InteractionResult spawnMob(@Nullable LivingEntity $$0, ItemStack $$1, Level $$2, BlockPos $$3, boolean $$4, boolean $$5) {
        EntityType<?> $$6 = this.getType($$1);
        if ($$6 == null) {
            return InteractionResult.FAIL;
        }
        if (!$$6.isAllowedInPeaceful() && $$2.getDifficulty() == Difficulty.PEACEFUL) {
            return InteractionResult.FAIL;
        }
        if ($$6.spawn((ServerLevel)$$2, $$1, $$0, $$3, EntitySpawnReason.SPAWN_ITEM_USE, $$4, $$5) != null) {
            $$1.consume(1, $$0);
            $$2.gameEvent($$0, GameEvent.ENTITY_PLACE, $$3);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level $$0, Player $$1, InteractionHand $$2) {
        ItemStack $$3 = $$1.getItemInHand($$2);
        BlockHitResult $$4 = SpawnEggItem.getPlayerPOVHitResult($$0, $$1, ClipContext.Fluid.SOURCE_ONLY);
        if ($$4.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (!($$0 instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel $$5 = (ServerLevel)$$0;
        BlockPos $$7 = $$4.getBlockPos();
        if (!($$0.getBlockState($$7).getBlock() instanceof LiquidBlock)) {
            return InteractionResult.PASS;
        }
        if (!$$0.mayInteract($$1, $$7) || !$$1.mayUseItemAt($$7, $$4.getDirection(), $$3)) {
            return InteractionResult.FAIL;
        }
        InteractionResult $$8 = this.spawnMob($$1, $$3, $$0, $$7, false, false);
        if ($$8 == InteractionResult.SUCCESS) {
            $$1.awardStat(Stats.ITEM_USED.get(this));
        }
        return $$8;
    }

    public boolean spawnsEntity(ItemStack $$0, EntityType<?> $$1) {
        return Objects.equals(this.getType($$0), $$1);
    }

    @Nullable
    public static SpawnEggItem byId(@Nullable EntityType<?> $$0) {
        return BY_ID.get($$0);
    }

    public static Iterable<SpawnEggItem> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    @Nullable
    public EntityType<?> getType(ItemStack $$0) {
        TypedEntityData $$1 = (TypedEntityData)$$0.get(DataComponents.ENTITY_DATA);
        if ($$1 != null) {
            return (EntityType)$$1.type();
        }
        return null;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return Optional.ofNullable(this.components().get(DataComponents.ENTITY_DATA)).map(TypedEntityData::type).map(EntityType::requiredFeatures).orElseGet(FeatureFlagSet::of);
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player $$0, Mob $$1, EntityType<? extends Mob> $$2, ServerLevel $$3, Vec3 $$4, ItemStack $$5) {
        Mob $$7;
        if (!this.spawnsEntity($$5, $$2)) {
            return Optional.empty();
        }
        if ($$1 instanceof AgeableMob) {
            AgeableMob $$6 = ((AgeableMob)$$1).getBreedOffspring($$3, (AgeableMob)$$1);
        } else {
            $$7 = $$2.create($$3, EntitySpawnReason.SPAWN_ITEM_USE);
        }
        if ($$7 == null) {
            return Optional.empty();
        }
        $$7.setBaby(true);
        if (!$$7.isBaby()) {
            return Optional.empty();
        }
        $$7.snapTo($$4.x(), $$4.y(), $$4.z(), 0.0f, 0.0f);
        $$7.applyComponentsFromItemStack($$5);
        $$3.addFreshEntityWithPassengers($$7);
        $$5.consume(1, $$0);
        return Optional.of($$7);
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack $$0, @Nullable Player $$1) {
        TypedEntityData $$2;
        if ($$1 != null && $$1.getPermissionLevel() >= 2 && ($$2 = (TypedEntityData)$$0.get(DataComponents.ENTITY_DATA)) != null) {
            return ((EntityType)$$2.type()).onlyOpCanSetNbt();
        }
        return false;
    }
}

