/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final int EVENT_SPAWN = 1;
    private static final int DEFAULT_SPAWN_DELAY = 20;
    private static final int DEFAULT_MIN_SPAWN_DELAY = 200;
    private static final int DEFAULT_MAX_SPAWN_DELAY = 800;
    private static final int DEFAULT_SPAWN_COUNT = 4;
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 6;
    private static final int DEFAULT_REQUIRED_PLAYER_RANGE = 16;
    private static final int DEFAULT_SPAWN_RANGE = 4;
    private int spawnDelay = 20;
    private WeightedList<SpawnData> spawnPotentials = WeightedList.of();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(EntityType<?> p_253682_, @Nullable Level p_254041_, RandomSource p_254221_, BlockPos p_254050_) {
        this.getOrCreateNextSpawnData(p_254041_, p_254221_, p_254050_).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(p_253682_).toString());
    }

    private boolean isNearPlayer(Level p_151344_, BlockPos p_151345_) {
        return p_151344_.hasNearbyAlivePlayer((double)p_151345_.getX() + 0.5, (double)p_151345_.getY() + 0.5, (double)p_151345_.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level p_151320_, BlockPos p_151321_) {
        if (!this.isNearPlayer(p_151320_, p_151321_)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource randomsource = p_151320_.getRandom();
            double d0 = (double)p_151321_.getX() + randomsource.nextDouble();
            double d1 = (double)p_151321_.getY() + randomsource.nextDouble();
            double d2 = (double)p_151321_.getZ() + randomsource.nextDouble();
            p_151320_.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            p_151320_.addParticle(ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel p_151312_, BlockPos p_151313_) {
        if (this.isNearPlayer(p_151312_, p_151313_) && p_151312_.getServer().isSpawnerBlockEnabled()) {
            if (this.spawnDelay == -1) {
                this.delay(p_151312_, p_151313_);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean flag = false;
                RandomSource randomsource = p_151312_.getRandom();
                SpawnData spawndata = this.getOrCreateNextSpawnData(p_151312_, randomsource, p_151313_);
                for (int i = 0; i < this.spawnCount; ++i) {
                    try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(this::toString, LOGGER);){
                        ValueInput valueinput = TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)p_151312_.registryAccess(), spawndata.getEntityToSpawn());
                        Optional<EntityType<?>> optional = EntityType.by(valueinput);
                        if (optional.isEmpty()) {
                            this.delay(p_151312_, p_151313_);
                            return;
                        }
                        Vec3 vec3 = valueinput.read("Pos", Vec3.CODEC).orElseGet(() -> new Vec3((double)p_151313_.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5, p_151313_.getY() + randomsource.nextInt(3) - 1, (double)p_151313_.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5));
                        if (!p_151312_.noCollision(optional.get().getSpawnAABB(vec3.x, vec3.y, vec3.z))) continue;
                        BlockPos blockpos = BlockPos.containing(vec3);
                        if (spawndata.getCustomSpawnRules().isPresent()) {
                            SpawnData.CustomSpawnRules spawndata$customspawnrules;
                            if (!optional.get().getCategory().isFriendly() && p_151312_.getDifficulty() == Difficulty.PEACEFUL || !(spawndata$customspawnrules = spawndata.getCustomSpawnRules().get()).isValidPosition(blockpos, p_151312_)) continue;
                        } else if (!SpawnPlacements.checkSpawnRules(optional.get(), p_151312_, EntitySpawnReason.SPAWNER, blockpos, p_151312_.getRandom())) continue;
                        Entity entity = EntityType.loadEntityRecursive(valueinput, (Level)p_151312_, EntitySpawnReason.SPAWNER, p_390874_ -> {
                            p_390874_.snapTo(vec3.x, vec3.y, vec3.z, p_390874_.getYRot(), p_390874_.getXRot());
                            return p_390874_;
                        });
                        if (entity == null) {
                            this.delay(p_151312_, p_151313_);
                            return;
                        }
                        int j = p_151312_.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB(p_151313_.getX(), p_151313_.getY(), p_151313_.getZ(), p_151313_.getX() + 1, p_151313_.getY() + 1, p_151313_.getZ() + 1).inflate(this.spawnRange), EntitySelector.NO_SPECTATORS).size();
                        if (j >= this.maxNearbyEntities) {
                            this.delay(p_151312_, p_151313_);
                            return;
                        }
                        entity.snapTo(entity.getX(), entity.getY(), entity.getZ(), randomsource.nextFloat() * 360.0f, 0.0f);
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            if (!ForgeEventFactory.checkSpawnPositionSpawner((Mob)mob, (ServerLevelAccessor)p_151312_, (EntitySpawnReason)EntitySpawnReason.SPAWNER, (SpawnData)spawndata, (BaseSpawner)this)) continue;
                            boolean flag1 = spawndata.getEntityToSpawn().size() == 1 && spawndata.getEntityToSpawn().getString("id").isPresent();
                            MobSpawnEvent.FinalizeSpawn event = ForgeEventFactory.onFinalizeSpawnSpawner((Mob)mob, (ServerLevelAccessor)p_151312_, (DifficultyInstance)p_151312_.getCurrentDifficultyAt(entity.blockPosition()), null, (ValueInput)valueinput, (BaseSpawner)this);
                            if (event != null && flag1) {
                                mob.finalizeSpawn(p_151312_, event.getDifficulty(), EntitySpawnReason.SPAWNER, null);
                            }
                            spawndata.getEquipment().ifPresent(mob::equip);
                        }
                        if (!p_151312_.tryAddFreshEntityWithPassengers(entity)) {
                            this.delay(p_151312_, p_151313_);
                            return;
                        }
                        p_151312_.levelEvent(2004, p_151313_, 0);
                        p_151312_.gameEvent(entity, GameEvent.ENTITY_PLACE, blockpos);
                        if (entity instanceof Mob) {
                            ((Mob)entity).spawnAnim();
                        }
                        flag = true;
                        continue;
                    }
                }
                if (flag) {
                    this.delay(p_151312_, p_151313_);
                }
                return;
            }
        }
    }

    private void delay(Level p_151351_, BlockPos p_151352_) {
        RandomSource randomsource = p_151351_.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomsource).ifPresent(p_390869_ -> this.setNextSpawnData(p_151351_, p_151352_, (SpawnData)p_390869_));
        this.broadcastEvent(p_151351_, p_151352_, 1);
    }

    public void load(@Nullable Level p_151329_, BlockPos p_151330_, ValueInput p_407329_) {
        this.spawnDelay = p_407329_.getShortOr("Delay", (short)20);
        p_407329_.read(SPAWN_DATA_TAG, SpawnData.CODEC).ifPresent(p_390872_ -> this.setNextSpawnData(p_151329_, p_151330_, (SpawnData)p_390872_));
        this.spawnPotentials = p_407329_.read("SpawnPotentials", SpawnData.LIST_CODEC).orElseGet(() -> WeightedList.of(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        this.minSpawnDelay = p_407329_.getIntOr("MinSpawnDelay", 200);
        this.maxSpawnDelay = p_407329_.getIntOr("MaxSpawnDelay", 800);
        this.spawnCount = p_407329_.getIntOr("SpawnCount", 4);
        this.maxNearbyEntities = p_407329_.getIntOr("MaxNearbyEntities", 6);
        this.requiredPlayerRange = p_407329_.getIntOr("RequiredPlayerRange", 16);
        this.spawnRange = p_407329_.getIntOr("SpawnRange", 4);
        this.displayEntity = null;
    }

    public void save(ValueOutput p_406220_) {
        p_406220_.putShort("Delay", (short)this.spawnDelay);
        p_406220_.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        p_406220_.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_406220_.putShort("SpawnCount", (short)this.spawnCount);
        p_406220_.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_406220_.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        p_406220_.putShort("SpawnRange", (short)this.spawnRange);
        p_406220_.storeNullable(SPAWN_DATA_TAG, SpawnData.CODEC, this.nextSpawnData);
        p_406220_.store("SpawnPotentials", SpawnData.LIST_CODEC, this.spawnPotentials);
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level p_254323_, BlockPos p_254313_) {
        if (this.displayEntity == null) {
            CompoundTag compoundtag = this.getOrCreateNextSpawnData(p_254323_, p_254323_.getRandom(), p_254313_).getEntityToSpawn();
            if (compoundtag.getString("id").isEmpty()) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive(compoundtag, p_254323_, EntitySpawnReason.SPAWNER, Function.identity());
            if (compoundtag.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.isClientSide()) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level p_151325_, BlockPos p_151326_, SpawnData p_151327_) {
        this.nextSpawnData = p_151327_;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level p_254503_, RandomSource p_253892_, BlockPos p_254487_) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(p_254503_, p_254487_, this.spawnPotentials.getRandom(p_253892_).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return null;
    }

    @Nullable
    public BlockEntity getSpawnerBlockEntity() {
        return null;
    }
}

