/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;

public class ModListWidget
extends ObjectSelectionList<ModEntry> {
    private static final ResourceLocation VERSION_CHECK_ICONS = ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"textures/gui/version_check_icons.png");
    private final int listWidth;
    private final ModListScreen parent;

    private static String stripControlCodes(String value) {
        return StringUtil.stripColor((String)value);
    }

    public ModListWidget(ModListScreen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraftInstance();
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, bottom, top, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    protected int scrollBarX() {
        return this.getRowRight() - 8;
    }

    protected void renderSelection(GuiGraphics gui, ModEntry entry, int color) {
        int widthOffset = this.scrollbarVisible() ? 11 : 4;
        int top = entry.getContentY();
        int left = entry.getContentX();
        int right = left + entry.getWidth() - widthOffset;
        int bottom = top + entry.getHeight();
        gui.fill(left, top - 2, right, bottom + 2, color);
        gui.fill(left + 1, top - 1, right - 1, bottom + 1, -16777216);
    }

    public void refreshList() {
        this.clearEntries();
        this.parent.buildModList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), mod -> new ModEntry((IModInfo)mod, this.parent));
    }

    public class ModEntry
    extends ObjectSelectionList.Entry<ModEntry> {
        private final IModInfo modInfo;
        private final ModListScreen parent;

        ModEntry(IModInfo info, ModListScreen parent) {
            this.modInfo = info;
            this.parent = parent;
        }

        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.modInfo.getDisplayName()});
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            int top = this.getContentY();
            int left = this.getContentX();
            int entryHeight = this.getContentBottom();
            MutableComponent name = Component.literal((String)ModListWidget.stripControlCodes(this.modInfo.getDisplayName()));
            MutableComponent version = Component.literal((String)ModListWidget.stripControlCodes(MavenVersionStringHelper.artifactVersionToString(this.modInfo.getVersion())));
            VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)this.modInfo);
            Font font = this.parent.getFontRenderer();
            int barOffset = ModListWidget.this.scrollbarVisible() ? 6 : 0;
            guiGraphics.drawString(font, Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)name, ModListWidget.this.listWidth - 6 - barOffset)})), left + 3, top + 2, -1, false);
            FormattedCharSequence formattedCharSequence = Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)version, ModListWidget.this.listWidth - 6 - barOffset)}));
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, formattedCharSequence, left + 3, top + 2 + 9, -3355444, false);
            if (vercheck.status().shouldDraw()) {
                guiGraphics.pose().pushMatrix();
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, VERSION_CHECK_ICONS, this.getX() + ModListWidget.this.width - 12 - barOffset, top + entryHeight / 4, (float)(vercheck.status().getSheetOffset() * 8), vercheck.status().isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f, 8, 8, 64, 16);
                guiGraphics.pose().popMatrix();
            }
        }

        public boolean mouseClicked(MouseButtonEvent info, boolean recent) {
            this.parent.setSelected(this);
            ModListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public IModInfo getInfo() {
            return this.modInfo;
        }
    }
}

