/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.TransformList;
import cpw.mods.modlauncher.api.ITransformer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public final class TransformTargetLabel {
    private final Type className;
    private final String elementName;
    private final Type elementDescriptor;
    private final LabelType labelType;

    TransformTargetLabel(ITransformer.Target target) {
        this(target.className(), target.elementName(), target.elementDescriptor(), LabelType.valueOf(target.targetType().name()));
    }

    private TransformTargetLabel(String className, String elementName, String elementDescriptor, LabelType labelType) {
        this.className = Type.getObjectType((String)className.replace('.', '/'));
        this.elementName = elementName;
        this.elementDescriptor = !elementDescriptor.isEmpty() ? Type.getMethodType((String)elementDescriptor) : Type.VOID_TYPE;
        this.labelType = labelType;
    }

    public TransformTargetLabel(String className, String fieldName) {
        this(className, fieldName, "", LabelType.FIELD);
    }

    TransformTargetLabel(String className, String methodName, String methodDesc) {
        this(className, methodName, methodDesc, LabelType.METHOD);
    }

    @Deprecated
    public TransformTargetLabel(String className) {
        this(className, "", "", LabelType.CLASS);
    }

    public TransformTargetLabel(String className, LabelType type) {
        this(className, "", "", type);
        if (type.nodeType != ClassNode.class) {
            throw new IllegalArgumentException("Invalid type " + type + ", must be for class!");
        }
    }

    Type getClassName() {
        return this.className;
    }

    public String getElementName() {
        return this.elementName;
    }

    public Type getElementDescriptor() {
        return this.elementDescriptor;
    }

    LabelType getLabelType() {
        return this.labelType;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.elementName, this.elementDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        Object object = obj;
        if (!(object instanceof TransformTargetLabel)) return false;
        TransformTargetLabel tl = (TransformTargetLabel)object;
        if (!Objects.equals(this.className, tl.className)) return false;
        if (!Objects.equals(this.elementName, tl.elementName)) return false;
        if (!Objects.equals(this.elementDescriptor, tl.elementDescriptor)) return false;
        return true;
    }

    public String toString() {
        return "Target : " + Objects.toString((Object)this.labelType) + " {" + Objects.toString(this.className) + "} {" + Objects.toString(this.elementName) + "} {" + Objects.toString(this.elementDescriptor) + "}";
    }

    public static enum LabelType {
        FIELD(FieldNode.class),
        METHOD(MethodNode.class),
        CLASS(ClassNode.class),
        PRE_CLASS(ClassNode.class);

        private final Class<?> nodeType;

        private LabelType(Class<?> nodeType) {
            this.nodeType = nodeType;
        }

        public Class<?> getNodeType() {
            return this.nodeType;
        }

        public <V> TransformList<V> getFromMap(EnumMap<LabelType, TransformList<?>> transformers) {
            return this.get(transformers, this.nodeType);
        }

        private <V> TransformList<V> get(EnumMap<LabelType, TransformList<?>> transformers, Class<V> type) {
            return transformers.get((Object)this);
        }

        public <T> Supplier<TransformList<T>> mapSupplier(EnumMap<LabelType, TransformList<?>> transformers) {
            return () -> (TransformList)transformers.get((Object)this);
        }

        @Deprecated(forRemoval=true, since="10.0")
        public static List<LabelType> getTypeFor(java.lang.reflect.Type type) {
            switch (type.getTypeName()) {
                case "org.objectweb.asm.tree.FieldNode": {
                    return List.of(FIELD);
                }
                case "org.objectweb.asm.tree.MethodNode": {
                    return List.of(METHOD);
                }
                case "org.objectweb.asm.tree.ClassNode": {
                    return List.of(CLASS, PRE_CLASS);
                }
            }
            return Collections.emptyList();
        }
    }
}

