/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.UniqueModListBuilder;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModValidator;
import net.minecraftforge.fml.loading.moddiscovery.ModsFolderLocator;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileLoadingException;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class ModDiscoverer {
    private static final Logger LOGGER = LogUtils.getLogger();

    private ModDiscoverer() {
    }

    public static ModValidator discoverMods(Map<String, ?> arguments) {
        List locatedFiles;
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODDIRECTORYFACTORY.get(), v -> ModsFolderLocator::new);
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.PROGRESSMESSAGE.get(), v -> StartupNotificationManager.locatorConsumer().orElseGet(() -> s -> {}));
        IModuleLayerManager moduleLayerManager = (IModuleLayerManager)Launcher.INSTANCE.environment().findModuleLayerManager().orElseThrow();
        ServiceLoader<IModLocator> modLocators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IModLocator.class);
        ServiceLoader<IDependencyLocator> dependencyLocators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IDependencyLocator.class);
        List modLocatorList = ServiceLoaderUtils.streamWithErrorHandling(modLocators, sce -> LOGGER.error("Failed to load mod locator list", (Throwable)sce)).toList();
        for (Object iModLocator : modLocatorList) {
            iModLocator.initArguments(arguments);
        }
        List dependencyLocatorList = ServiceLoaderUtils.streamWithErrorHandling(dependencyLocators, sce -> LOGGER.error("Failed to load dependency locator list", (Throwable)sce)).toList();
        for (IDependencyLocator l : dependencyLocatorList) {
            l.initArguments(arguments);
        }
        if (LOGGER.isDebugEnabled(LogMarkers.CORE)) {
            LOGGER.debug(LogMarkers.CORE, "Found Mod Locators : {}", (Object)modLocatorList.stream().map(modLocator -> "(%s:%s)".formatted(modLocator.name(), modLocator.getClass().getPackage().getImplementationVersion())).collect(Collectors.joining(",")));
            LOGGER.debug(LogMarkers.CORE, "Found Dependency Locators : {}", (Object)dependencyLocatorList.stream().map(dependencyLocator -> "(%s:%s)".formatted(dependencyLocator.name(), dependencyLocator.getClass().getPackage().getImplementationVersion())).collect(Collectors.joining(",")));
        }
        LOGGER.debug(LogMarkers.SCAN, "Scanning for mods and other resources to load. We know {} ways to find mods", (Object)modLocatorList.size());
        List<ModFile> loadedFiles = new ArrayList<ModFile>();
        ArrayList<EarlyLoadingException.ExceptionData> discoveryErrorData = new ArrayList<EarlyLoadingException.ExceptionData>();
        boolean successfullyLoadedMods = true;
        ArrayList<IModFileInfo> brokenFiles = new ArrayList<IModFileInfo>();
        ArrayList<ModFileLoadingException> modFileLoadingExceptions = new ArrayList<ModFileLoadingException>();
        boolean distIsDedicatedServer = FMLLoader.getDist().isDedicatedServer();
        ImmediateWindowHandler.updateProgress("Discovering mod files");
        for (IModLocator locator : modLocatorList) {
            try {
                List<IModFile> clientOnlyModFiles;
                List<IModFile> badModFiles;
                LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", (Object)locator);
                List candidates = locator.scanMods();
                LOGGER.debug(LogMarkers.SCAN, "Locator {} found {} candidates or errors", (Object)locator, (Object)candidates.size());
                List<ModFileLoadingException> exceptions = candidates.stream().map(IModLocator.ModFileOrException::ex).filter(Objects::nonNull).toList();
                if (!exceptions.isEmpty()) {
                    LOGGER.debug(LogMarkers.SCAN, "Locator {} found {} invalid mod files", (Object)locator, (Object)exceptions.size());
                    for (ModFileLoadingException ex : exceptions) {
                        if (ex instanceof InvalidModFileException) {
                            InvalidModFileException invalidModFileEx = (InvalidModFileException)ex;
                            IModFileInfo modInfo = invalidModFileEx.getBrokenFile();
                            brokenFiles.add(modInfo);
                            discoveryErrorData.add(new EarlyLoadingException.ExceptionData(ex.getMessage(), modInfo));
                            continue;
                        }
                        discoveryErrorData.add(new EarlyLoadingException.ExceptionData(ex.getMessage(), new Object[0]));
                    }
                }
                if (!(badModFiles = (locatedFiles = candidates.stream().map(IModLocator.ModFileOrException::file).filter(Objects::nonNull).collect(Collectors.toList())).stream().filter(file -> !(file instanceof ModFile)).toList()).isEmpty()) {
                    LOGGER.error(LogMarkers.SCAN, "Locator {} returned {} files which is are not ModFile instances! They will be skipped!", (Object)locator, (Object)badModFiles.size());
                    brokenFiles.addAll(badModFiles.stream().map(IModFile::getModFileInfo).toList());
                    locatedFiles.removeAll(badModFiles);
                }
                if (distIsDedicatedServer && !(clientOnlyModFiles = locatedFiles.stream().filter(file -> file.getModFileInfo().isClientSideOnly()).toList()).isEmpty()) {
                    LOGGER.warn(LogMarkers.SCAN, "Locator {} returned {} files which are client-side-only mods, but we're on a dedicated server. They will be skipped!", (Object)locator, (Object)clientOnlyModFiles.size());
                    locatedFiles.removeAll(clientOnlyModFiles);
                }
                LOGGER.debug(LogMarkers.SCAN, "Locator {} found {} valid mod files", (Object)locator, (Object)locatedFiles.size());
                ModDiscoverer.handleLocatedFiles(loadedFiles, locatedFiles, locator);
            }
            catch (InvalidModFileException imfe) {
                LOGGER.error(LogMarkers.SCAN, "Locator {} found an invalid mod file {}", new Object[]{locator, imfe.getBrokenFile(), imfe});
                brokenFiles.add(imfe.getBrokenFile());
            }
            catch (EarlyLoadingException exception) {
                LOGGER.error(LogMarkers.SCAN, "Failed to load mods with locator {}", (Object)locator, (Object)exception);
                discoveryErrorData.addAll(exception.getAllData());
            }
        }
        Map modFilesMap = new EnumMap(IModFile.Type.class);
        try {
            UniqueModListBuilder.UniqueModListData uniqueModsData = UniqueModListBuilder.buildUniqueList(loadedFiles);
            modFilesMap = uniqueModsData.modFiles().stream().collect(Collectors.groupingBy(IModFile::getType, () -> new EnumMap(IModFile.Type.class), Collectors.toList()));
            loadedFiles = uniqueModsData.modFiles();
        }
        catch (EarlyLoadingException exception) {
            LOGGER.error(LogMarkers.SCAN, "Failed to build unique mod list after mod discovery.", (Throwable)exception);
            discoveryErrorData.addAll(exception.getAllData());
            successfullyLoadedMods = false;
        }
        if (successfullyLoadedMods) {
            LOGGER.debug(LogMarkers.SCAN, "Successfully Loaded {} mods. Attempting to load dependencies...", (Object)loadedFiles.size());
            for (IDependencyLocator locator : dependencyLocatorList) {
                try {
                    LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", (Object)locator);
                    List<ModFile> locatedMods = List.copyOf(loadedFiles);
                    locatedFiles = locator.scanMods(locatedMods);
                    ModDiscoverer.handleLocatedFiles(loadedFiles, locatedFiles, locator);
                }
                catch (EarlyLoadingException exception) {
                    LOGGER.error(LogMarkers.SCAN, "Failed to load dependencies with locator {}", (Object)locator, (Object)exception);
                    discoveryErrorData.addAll(exception.getAllData());
                }
            }
            try {
                UniqueModListBuilder.UniqueModListData uniqueModsAndDependenciesData = UniqueModListBuilder.buildUniqueList(loadedFiles);
                modFilesMap = uniqueModsAndDependenciesData.modFiles().stream().collect(Collectors.groupingBy(IModFile::getType, () -> new EnumMap(IModFile.Type.class), Collectors.toList()));
            }
            catch (EarlyLoadingException exception) {
                LOGGER.error(LogMarkers.SCAN, "Failed to build unique mod list after dependency discovery.", (Throwable)exception);
                discoveryErrorData.addAll(exception.getAllData());
                modFilesMap = loadedFiles.stream().collect(Collectors.groupingBy(IModFile::getType, () -> new EnumMap(IModFile.Type.class), Collectors.toList()));
            }
        } else {
            LOGGER.error(LogMarkers.SCAN, "Mod Discovery failed. Skipping dependency discovery.");
        }
        ModValidator validator = new ModValidator(modFilesMap, brokenFiles, discoveryErrorData, modFileLoadingExceptions);
        validator.stage1Validation();
        return validator;
    }

    private static void handleLocatedFiles(List<ModFile> loadedFiles, List<IModFile> locatedFiles, Object locator) {
        for (IModFile mf : locatedFiles) {
            if (mf instanceof ModFile) {
                ModFile modFile = (ModFile)mf;
                LOGGER.info(LogMarkers.SCAN, "Found mod file {} of type {} with provider {}", new Object[]{mf.getFileName(), mf.getType(), mf.getProvider()});
                loadedFiles.add(modFile);
                continue;
            }
            LOGGER.error(LogMarkers.SCAN, "Skipping mod file {} found by {}, as it was not a ModFile instance!", (Object)mf.getFileName(), locator);
        }
    }
}

