/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import net.minecraftforge.roimfs.Handler;
import net.minecraftforge.roimfs.ReadOnlyByteChannel;
import net.minecraftforge.roimfs.RoimFileAttributeView;
import net.minecraftforge.roimfs.RoimFileSystem;
import net.minecraftforge.roimfs.RoimPath;

public final class RoimFileSystemProvider
extends FileSystemProvider {
    static final String SCHEMA = "roimfs";
    private final Map<String, RoimFileSystem> filesystems = new HashMap<String, RoimFileSystem>();

    @Override
    public String getScheme() {
        return SCHEMA;
    }

    private void checkUri(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
        String path = uri.getSchemeSpecificPart();
        if (path == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        int idx = path.indexOf(47);
        if (idx == -1 || idx == 0) {
            throw new IllegalArgumentException("Path must contain a key");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        this.checkUri(uri);
        Handler.register();
        String raw = uri.getSchemeSpecificPart();
        int idx = raw.indexOf(47);
        String key = raw.substring(0, idx);
        String path = raw.substring(idx + 1);
        Map<String, RoimFileSystem> map = this.filesystems;
        synchronized (map) {
            if (this.filesystems.containsKey(key)) {
                throw new FileSystemAlreadyExistsException();
            }
            RoimFileSystem fs = new RoimFileSystem(this, key, path, env);
            this.filesystems.put(key, fs);
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(URI uri) {
        this.checkUri(uri);
        String path = uri.getSchemeSpecificPart();
        int idx = path.indexOf(47);
        String key = path.substring(0, idx);
        Map<String, RoimFileSystem> map = this.filesystems;
        synchronized (map) {
            FileSystem fs = this.filesystems.get(key);
            if (fs == null) {
                throw new FileSystemNotFoundException();
            }
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(RoimFileSystem fs) {
        Map<String, RoimFileSystem> map = this.filesystems;
        synchronized (map) {
            this.filesystems.remove(fs.getKey());
        }
    }

    @Override
    public Path getPath(URI uri) {
        this.checkUri(uri);
        int idx = uri.getRawSchemeSpecificPart().indexOf(47);
        String path = uri.getRawSchemeSpecificPart().substring(idx + 1);
        return this.getFileSystem(uri).getPath(path, new String[0]);
    }

    private static RoimPath cast(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof RoimPath)) {
            throw new ProviderMismatchException();
        }
        return (RoimPath)path;
    }

    private static RoimFileSystem getFileSystem(Path path) {
        return (RoimFileSystem)RoimFileSystemProvider.cast(path).getFileSystem();
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        String string;
        for (OpenOption openOption : options) {
            if (openOption == StandardOpenOption.READ) continue;
            throw new UnsupportedOperationException("'" + openOption + "' not allowed");
        }
        RoimFileSystem fs = RoimFileSystemProvider.getFileSystem(path);
        if (fs.isDirectory(string = path.toRealPath(new LinkOption[0]).toString())) {
            throw new FileSystemException("roimfs:" + fs.getKey() + path + " is a directory");
        }
        byte[] data = RoimFileSystemProvider.getFileSystem(path).getFile(string);
        return new ReadOnlyByteChannel(data);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        String str;
        for (OpenOption option : options) {
            if (option == StandardOpenOption.READ) continue;
            throw new UnsupportedOperationException("'" + option + "' not allowed");
        }
        RoimFileSystem fs = RoimFileSystemProvider.getFileSystem(path);
        if (fs.isDirectory(str = path.toRealPath(new LinkOption[0]).toString())) {
            throw new FileSystemException("roimfs:" + fs.getKey() + path + " is a directory");
        }
        byte[] data = RoimFileSystemProvider.getFileSystem(path).getFile(str);
        return new ByteArrayInputStream(data);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return RoimFileSystemProvider.getFileSystem(dir).newDirectoryStream(dir, filter);
    }

    @Override
    public boolean isSameFile(Path path, Path other) throws IOException {
        if (path.equals(other)) {
            return true;
        }
        if (other == null || path.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        Path realA = path.toRealPath(new LinkOption[0]);
        Path realB = other.toRealPath(new LinkOption[0]);
        return realA.equals(realB);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return RoimFileSystemProvider.getFileSystem(path).getFileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        RoimPath rPath = RoimFileSystemProvider.cast(path);
        for (AccessMode mode : modes) {
            if (mode == AccessMode.READ) continue;
            throw new AccessDeniedException(rPath.toString());
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            return (V)new RoimFileAttributeView(RoimFileSystemProvider.cast(path));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type != BasicFileAttributes.class) {
            throw new UnsupportedOperationException("Attribute type " + type.getName() + " is not supported");
        }
        return (A)this.getFileAttributeView(path, BasicFileAttributeView.class, options).readAttributes();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        String attrs;
        String type;
        int idx = attributes.indexOf(58);
        if (idx == -1) {
            type = "basic";
            attrs = attributes;
        } else {
            type = attributes.substring(0, idx);
            attrs = attributes.substring(idx + 1);
        }
        if (!"basic".equals(type)) {
            throw new UnsupportedOperationException("View type `" + type + "` is not supported");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        BasicFileAttributes view = this.getFileAttributeView(path, BasicFileAttributeView.class, options).readAttributes();
        String[] stringArray = attrs.split(",");
        int n = stringArray.length;
        block24: for (int i = 0; i < n; ++i) {
            String name;
            switch (name = stringArray[i]) {
                case "*": {
                    ret.put("size", view.size());
                    ret.put("creationTime", view.creationTime());
                    ret.put("lastAccessTime", view.lastAccessTime());
                    ret.put("lastModifiedTime", view.lastModifiedTime());
                    ret.put("isDirectory", view.isDirectory());
                    ret.put("isRegularFile", view.isRegularFile());
                    ret.put("isSymbolicLink", view.isSymbolicLink());
                    ret.put("isOther", view.isOther());
                    ret.put("fileKey", view.fileKey());
                    continue block24;
                }
                case "size": {
                    ret.put("size", view.size());
                    continue block24;
                }
                case "creationTime": {
                    ret.put("creationTime", view.creationTime());
                    continue block24;
                }
                case "lastAccessTime": {
                    ret.put("lastAccessTime", view.lastAccessTime());
                    continue block24;
                }
                case "lastModifiedTime": {
                    ret.put("lastModifiedTime", view.lastModifiedTime());
                    continue block24;
                }
                case "isDirectory": {
                    ret.put("isDirectory", view.isDirectory());
                    continue block24;
                }
                case "isRegularFile": {
                    ret.put("isRegularFile", view.isRegularFile());
                    continue block24;
                }
                case "isSymbolicLink": {
                    ret.put("isSymbolicLink", view.isSymbolicLink());
                    continue block24;
                }
                case "isOther": {
                    ret.put("isOther", view.isOther());
                    continue block24;
                }
                case "fileKey": {
                    ret.put("fileKey", view.fileKey());
                }
            }
        }
        return ret;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    @Override
    public void delete(Path path) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        throw new ReadOnlyFileSystemException();
    }
}

