// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

package adapter // import "github.com/open-telemetry/opentelemetry-collector-contrib/pkg/stanza/adapter"

import (
	"time"

	"go.opentelemetry.io/collector/component"

	"github.com/open-telemetry/opentelemetry-collector-contrib/internal/coreinternal/consumerretry"
	"github.com/open-telemetry/opentelemetry-collector-contrib/pkg/stanza/operator"
)

// BaseConfig is the common configuration of a stanza-based receiver
type BaseConfig struct {
	Operators      []operator.Config    `mapstructure:"operators"`
	StorageID      *component.ID        `mapstructure:"storage"`
	RetryOnFailure consumerretry.Config `mapstructure:"retry_on_failure"`

	// currently not configurable by users, but available for benchmarking
	maxBatchSize  uint
	flushInterval time.Duration
}
