// Copyright 2018, OpenCensus Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: opencensus/proto/agent/metrics/v1/metrics_service.proto

package v1

import (
	context "context"
	v1 "github.com/census-instrumentation/opencensus-proto/gen-go/agent/common/v1"
	v11 "github.com/census-instrumentation/opencensus-proto/gen-go/metrics/v1"
	v12 "github.com/census-instrumentation/opencensus-proto/gen-go/resource/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ExportMetricsServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is required only in the first message on the stream or if the
	// previous sent ExportMetricsServiceRequest message has a different Node (e.g.
	// when the same RPC is used to send Metrics from multiple Applications).
	Node *v1.Node `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	// A list of metrics that belong to the last received Node.
	Metrics []*v11.Metric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// The resource for the metrics in this message that do not have an explicit
	// resource set.
	// If unset, the most recently set resource in the RPC stream applies. It is
	// valid to never be set within a stream, e.g. when no resource info is known
	// at all or when all sent metrics have an explicit resource set.
	Resource *v12.Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *ExportMetricsServiceRequest) Reset() {
	*x = ExportMetricsServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMetricsServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetricsServiceRequest) ProtoMessage() {}

func (x *ExportMetricsServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetricsServiceRequest.ProtoReflect.Descriptor instead.
func (*ExportMetricsServiceRequest) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescGZIP(), []int{0}
}

func (x *ExportMetricsServiceRequest) GetNode() *v1.Node {
	if x != nil {
		return x.Node
	}
	return nil
}

func (x *ExportMetricsServiceRequest) GetMetrics() []*v11.Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *ExportMetricsServiceRequest) GetResource() *v12.Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

type ExportMetricsServiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportMetricsServiceResponse) Reset() {
	*x = ExportMetricsServiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMetricsServiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetricsServiceResponse) ProtoMessage() {}

func (x *ExportMetricsServiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetricsServiceResponse.ProtoReflect.Descriptor instead.
func (*ExportMetricsServiceResponse) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescGZIP(), []int{1}
}

var File_opencensus_proto_agent_metrics_v1_metrics_service_proto protoreflect.FileDescriptor

var file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDesc = []byte{
	0x0a, 0x37, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x6f, 0x70, 0x65, 0x6e, 0x63,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x2d, 0x6f, 0x70,
	0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x6f, 0x70, 0x65,
	0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x01, 0x0a, 0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x12,
	0x3d, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x42,
	0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x1e, 0x0a, 0x1c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x32, 0xa2, 0x01, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x06, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x12, 0x3e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x42, 0xb1, 0x01, 0x0a, 0x24, 0x69, 0x6f, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31,
	0x42, 0x13, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2d, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x63,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x65, 0x6e, 0x2d,
	0x67, 0x6f, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2f, 0x76, 0x31, 0xea, 0x02, 0x25, 0x4f, 0x70, 0x65, 0x6e, 0x43, 0x65, 0x6e, 0x73, 0x75, 0x73,
	0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x3a, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x3a,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescOnce sync.Once
	file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescData = file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDesc
)

func file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescGZIP() []byte {
	file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescOnce.Do(func() {
		file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescData)
	})
	return file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDescData
}

var file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_opencensus_proto_agent_metrics_v1_metrics_service_proto_goTypes = []interface{}{
	(*ExportMetricsServiceRequest)(nil),  // 0: opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest
	(*ExportMetricsServiceResponse)(nil), // 1: opencensus.proto.agent.metrics.v1.ExportMetricsServiceResponse
	(*v1.Node)(nil),                      // 2: opencensus.proto.agent.common.v1.Node
	(*v11.Metric)(nil),                   // 3: opencensus.proto.metrics.v1.Metric
	(*v12.Resource)(nil),                 // 4: opencensus.proto.resource.v1.Resource
}
var file_opencensus_proto_agent_metrics_v1_metrics_service_proto_depIdxs = []int32{
	2, // 0: opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest.node:type_name -> opencensus.proto.agent.common.v1.Node
	3, // 1: opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest.metrics:type_name -> opencensus.proto.metrics.v1.Metric
	4, // 2: opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest.resource:type_name -> opencensus.proto.resource.v1.Resource
	0, // 3: opencensus.proto.agent.metrics.v1.MetricsService.Export:input_type -> opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest
	1, // 4: opencensus.proto.agent.metrics.v1.MetricsService.Export:output_type -> opencensus.proto.agent.metrics.v1.ExportMetricsServiceResponse
	4, // [4:5] is the sub-list for method output_type
	3, // [3:4] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_opencensus_proto_agent_metrics_v1_metrics_service_proto_init() }
func file_opencensus_proto_agent_metrics_v1_metrics_service_proto_init() {
	if File_opencensus_proto_agent_metrics_v1_metrics_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMetricsServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMetricsServiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_opencensus_proto_agent_metrics_v1_metrics_service_proto_goTypes,
		DependencyIndexes: file_opencensus_proto_agent_metrics_v1_metrics_service_proto_depIdxs,
		MessageInfos:      file_opencensus_proto_agent_metrics_v1_metrics_service_proto_msgTypes,
	}.Build()
	File_opencensus_proto_agent_metrics_v1_metrics_service_proto = out.File
	file_opencensus_proto_agent_metrics_v1_metrics_service_proto_rawDesc = nil
	file_opencensus_proto_agent_metrics_v1_metrics_service_proto_goTypes = nil
	file_opencensus_proto_agent_metrics_v1_metrics_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MetricsServiceClient is the client API for MetricsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MetricsServiceClient interface {
	// For performance reasons, it is recommended to keep this RPC
	// alive for the entire life of the application.
	Export(ctx context.Context, opts ...grpc.CallOption) (MetricsService_ExportClient, error)
}

type metricsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetricsServiceClient(cc grpc.ClientConnInterface) MetricsServiceClient {
	return &metricsServiceClient{cc}
}

func (c *metricsServiceClient) Export(ctx context.Context, opts ...grpc.CallOption) (MetricsService_ExportClient, error) {
	stream, err := c.cc.NewStream(ctx, &_MetricsService_serviceDesc.Streams[0], "/opencensus.proto.agent.metrics.v1.MetricsService/Export", opts...)
	if err != nil {
		return nil, err
	}
	x := &metricsServiceExportClient{stream}
	return x, nil
}

type MetricsService_ExportClient interface {
	Send(*ExportMetricsServiceRequest) error
	Recv() (*ExportMetricsServiceResponse, error)
	grpc.ClientStream
}

type metricsServiceExportClient struct {
	grpc.ClientStream
}

func (x *metricsServiceExportClient) Send(m *ExportMetricsServiceRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *metricsServiceExportClient) Recv() (*ExportMetricsServiceResponse, error) {
	m := new(ExportMetricsServiceResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// MetricsServiceServer is the server API for MetricsService service.
type MetricsServiceServer interface {
	// For performance reasons, it is recommended to keep this RPC
	// alive for the entire life of the application.
	Export(MetricsService_ExportServer) error
}

// UnimplementedMetricsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMetricsServiceServer struct {
}

func (*UnimplementedMetricsServiceServer) Export(MetricsService_ExportServer) error {
	return status.Errorf(codes.Unimplemented, "method Export not implemented")
}

func RegisterMetricsServiceServer(s *grpc.Server, srv MetricsServiceServer) {
	s.RegisterService(&_MetricsService_serviceDesc, srv)
}

func _MetricsService_Export_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MetricsServiceServer).Export(&metricsServiceExportServer{stream})
}

type MetricsService_ExportServer interface {
	Send(*ExportMetricsServiceResponse) error
	Recv() (*ExportMetricsServiceRequest, error)
	grpc.ServerStream
}

type metricsServiceExportServer struct {
	grpc.ServerStream
}

func (x *metricsServiceExportServer) Send(m *ExportMetricsServiceResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *metricsServiceExportServer) Recv() (*ExportMetricsServiceRequest, error) {
	m := new(ExportMetricsServiceRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _MetricsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "opencensus.proto.agent.metrics.v1.MetricsService",
	HandlerType: (*MetricsServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Export",
			Handler:       _MetricsService_Export_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "opencensus/proto/agent/metrics/v1/metrics_service.proto",
}
