/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0012\u0010\f\u001a\u00020\u00072\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\n\u0010\r\u001a\u00060\nj\u0002`\u000eJ\n\u0010\u000f\u001a\u00060\nj\u0002`\u000eJ\u001a\u0010\u0010\u001a\u00020\u00072\n\u0010\u0011\u001a\u00060\nj\u0002`\u000e2\u0006\u0010\u0012\u001a\u00020\nJ\u0018\u0010\u0013\u001a\u00020\u00072\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0015J\f\u0010\u0016\u001a\u00060\nj\u0002`\u000eH\u0002J\u001c\u0010\u0017\u001a\u00020\u00072\n\u0010\u0011\u001a\u00060\nj\u0002`\u000e2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\f\u0010\u0019\u001a\u00060\nj\u0002`\u000eH\u0002J\u001c\u0010\u001a\u001a\u00020\u00072\n\u0010\u0011\u001a\u00060\nj\u0002`\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0014\u0010\u001b\u001a\u00060\nj\u0002`\u000e2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u001c\u0010\u001d\u001a\u00020\u00072\n\u0010\u0011\u001a\u00060\nj\u0002`\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#\u00a8\u0006%"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;", "", "<init>", "()V", "Empty", "", "Clear", "", "CanAdd", "deltaSize", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/DeltaSize;", "Add", "Emit", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/Chunk;", "EncodeLast", "Decode", "chunk", "max_size", "AppendTo", "deltas", "", "EncodeRunLength", "DecodeRunLength", "max_count", "EncodeOneBit", "DecodeOneBit", "EncodeTwoBit", "size", "DecodeTwoBit", "size_", "all_same_", "has_large_delta_", "delta_sizes_", "", "[Ljava/lang/Integer;", "Companion", "rtp"})
public final class LastChunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size_;
    private boolean all_same_ = true;
    private boolean has_large_delta_;
    @NotNull
    private final Integer[] delta_sizes_;
    private static final int kMaxRunLengthCapacity = 8191;
    private static final int kMaxOneBitCapacity = 14;
    private static final int kMaxTwoBitCapacity = 7;
    private static final int kMaxVectorCapacity = 14;
    private static final int kLarge = 2;

    public LastChunk() {
        int n = 0;
        Integer[] integerArray = new Integer[14];
        LastChunk lastChunk = this;
        while (n < 14) {
            int n2 = n++;
            integerArray[n2] = 0;
        }
        lastChunk.delta_sizes_ = integerArray;
    }

    public final boolean Empty() {
        return this.size_ == 0;
    }

    public final void Clear() {
        this.size_ = 0;
        this.all_same_ = true;
        this.has_large_delta_ = false;
    }

    public final boolean CanAdd(int deltaSize) {
        if (this.size_ < 7) {
            return true;
        }
        if (this.size_ < 14 && !this.has_large_delta_ && deltaSize != 2) {
            return true;
        }
        return this.size_ < 8191 && this.all_same_ && this.delta_sizes_[0] == deltaSize;
    }

    public final void Add(int deltaSize) {
        if (this.size_ < 14) {
            this.delta_sizes_[this.size_] = deltaSize;
        }
        int n = this.size_;
        this.size_ = n + 1;
        this.all_same_ = this.all_same_ && deltaSize == this.delta_sizes_[0];
        this.has_large_delta_ = this.has_large_delta_ || deltaSize == 2;
    }

    public final int Emit() {
        if (this.all_same_) {
            int chunk = this.EncodeRunLength();
            this.Clear();
            return chunk;
        }
        if (this.size_ == 14) {
            int chunk = this.EncodeOneBit();
            this.Clear();
            return chunk;
        }
        int chunk = this.EncodeTwoBit(7);
        this.size_ -= 7;
        this.all_same_ = true;
        this.has_large_delta_ = false;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            int deltaSize = this.delta_sizes_[7 + i];
            this.delta_sizes_[i] = deltaSize;
            this.all_same_ = this.all_same_ && deltaSize == this.delta_sizes_[0];
            this.has_large_delta_ = this.has_large_delta_ || deltaSize == 2;
        }
        return chunk;
    }

    public final int EncodeLast() {
        return this.all_same_ ? this.EncodeRunLength() : (this.size_ <= 7 ? this.EncodeTwoBit(this.size_) : this.EncodeOneBit());
    }

    public final void Decode(int chunk, int max_size) {
        if ((chunk & 0x8000) == 0) {
            this.DecodeRunLength(chunk, max_size);
        } else if ((chunk & 0x4000) == 0) {
            this.DecodeOneBit(chunk, max_size);
        } else {
            this.DecodeTwoBit(chunk, max_size);
        }
    }

    public final void AppendTo(@NotNull List<Integer> deltas) {
        Intrinsics.checkNotNullParameter(deltas, (String)"deltas");
        if (this.all_same_) {
            int n = this.size_;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                deltas.add(this.delta_sizes_[0]);
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                deltas.add(this.delta_sizes_[i]);
            }
        }
    }

    private final int EncodeRunLength() {
        return this.delta_sizes_[0] << 13 | this.size_;
    }

    private final void DecodeRunLength(int chunk, int max_count) {
        this.size_ = Math.min(chunk & 0x1FFF, max_count);
        int delta_size = chunk >>> 13 & 3;
        this.has_large_delta_ = delta_size >= 2;
        this.all_same_ = true;
        int n = Math.min(this.size_, 14);
        for (int i = 0; i < n; ++i) {
            this.delta_sizes_[i] = delta_size;
        }
    }

    private final int EncodeOneBit() {
        int chunk = 32768;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            chunk |= this.delta_sizes_[i] << 13 - i;
        }
        return chunk;
    }

    private final void DecodeOneBit(int chunk, int max_size) {
        this.size_ = Math.min(14, max_size);
        this.has_large_delta_ = false;
        this.all_same_ = false;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            this.delta_sizes_[i] = chunk >>> 13 - i & 1;
        }
    }

    private final int EncodeTwoBit(int size) {
        int chunk = 49152;
        for (int i = 0; i < size; ++i) {
            chunk |= this.delta_sizes_[i] << 2 * (6 - i);
        }
        return chunk;
    }

    private final void DecodeTwoBit(int chunk, int max_size) {
        this.size_ = Math.min(7, max_size);
        this.has_large_delta_ = true;
        this.all_same_ = false;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            this.delta_sizes_[i] = chunk >>> 2 * (6 - i) & 3;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0005j\u0002`\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk$Companion;", "", "<init>", "()V", "kMaxRunLengthCapacity", "", "kMaxOneBitCapacity", "kMaxTwoBitCapacity", "kMaxVectorCapacity", "kLarge", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/DeltaSize;", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

