/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtensionKt;
import org.jitsi.rtp.rtp.header_extensions.DTI;
import org.jitsi.rtp.rtp.header_extensions.DecodeTargetLayer;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.rtp.rtp.header_extensions.Resolution;
import org.jitsi.rtp.util.BitWriter;
import org.jitsi.utils.OrderedJsonObject;
import org.json.simple.JSONAware;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003J\u000e\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000204H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0011\u00a8\u00066"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;", "Lorg/json/simple/JSONAware;", "templateIdOffset", "", "templateInfo", "", "Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;", "decodeTargetProtectedBy", "decodeTargetLayers", "Lorg/jitsi/rtp/rtp/header_extensions/DecodeTargetLayer;", "maxRenderResolutions", "Lorg/jitsi/rtp/rtp/header_extensions/Resolution;", "maxSpatialId", "maxTemporalId", "<init>", "(ILjava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;II)V", "getTemplateIdOffset", "()I", "setTemplateIdOffset", "(I)V", "getTemplateInfo", "()Ljava/util/List;", "getDecodeTargetProtectedBy", "getDecodeTargetLayers", "getMaxRenderResolutions", "getMaxSpatialId", "getMaxTemporalId", "templateCount", "getTemplateCount", "decodeTargetCount", "getDecodeTargetCount", "chainCount", "getChainCount", "unpaddedLengthBits", "getUnpaddedLengthBits", "clone", "write", "", "writer", "Lorg/jitsi/rtp/util/BitWriter;", "writeTemplateLayers", "writeTemplateDtis", "writeTemplateFdiffs", "writeTemplateChains", "writeRenderResolutions", "canSwitchWithoutKeyframe", "", "fromDt", "toDt", "getDtBitmaskForDt", "dt", "toJSONString", "", "toString", "rtp"})
@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
@SourceDebugExtension(value={"SMAP\nAv1DependencyDescriptorHeaderExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DependencyDescriptorHeaderExtension.kt\norg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,912:1\n1740#2,3:913\n1740#2,3:916\n1740#2,3:919\n1869#2,2:922\n1869#2,2:924\n1869#2:926\n1869#2,2:927\n1870#2:929\n1869#2:930\n1869#2,2:931\n1870#2:933\n1869#2,2:934\n1869#2:936\n1869#2,2:937\n1870#2:939\n1869#2,2:940\n1761#2,3:942\n1869#2:945\n1878#2,3:946\n1870#2:949\n*S KotlinDebug\n*F\n+ 1 Av1DependencyDescriptorHeaderExtension.kt\norg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure\n*L\n310#1:913,3\n313#1:916,3\n319#1:919,3\n332#1:922,2\n338#1:924,2\n405#1:926\n406#1:927,2\n405#1:929\n413#1:930\n414#1:931,2\n413#1:933\n424#1:934,2\n427#1:936\n428#1:937,2\n427#1:939\n439#1:940,2\n450#1:942,3\n460#1:945\n461#1:946,3\n460#1:949\n*E\n"})
public final class Av1TemplateDependencyStructure
implements JSONAware {
    private int templateIdOffset;
    @NotNull
    private final List<FrameInfo> templateInfo;
    @NotNull
    private final List<Integer> decodeTargetProtectedBy;
    @NotNull
    private final List<DecodeTargetLayer> decodeTargetLayers;
    @NotNull
    private final List<Resolution> maxRenderResolutions;
    private final int maxSpatialId;
    private final int maxTemporalId;
    private final int chainCount;

    public Av1TemplateDependencyStructure(int templateIdOffset, @NotNull List<? extends FrameInfo> templateInfo, @NotNull List<Integer> decodeTargetProtectedBy, @NotNull List<DecodeTargetLayer> decodeTargetLayers, @NotNull List<Resolution> maxRenderResolutions, int maxSpatialId, int maxTemporalId) {
        boolean bl;
        block15: {
            boolean bl2;
            FrameInfo it;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block14: {
                boolean bl3;
                block13: {
                    Intrinsics.checkNotNullParameter(templateInfo, (String)"templateInfo");
                    Intrinsics.checkNotNullParameter(decodeTargetProtectedBy, (String)"decodeTargetProtectedBy");
                    Intrinsics.checkNotNullParameter(decodeTargetLayers, (String)"decodeTargetLayers");
                    Intrinsics.checkNotNullParameter(maxRenderResolutions, (String)"maxRenderResolutions");
                    this.templateIdOffset = templateIdOffset;
                    this.templateInfo = templateInfo;
                    this.decodeTargetProtectedBy = decodeTargetProtectedBy;
                    this.decodeTargetLayers = decodeTargetLayers;
                    this.maxRenderResolutions = maxRenderResolutions;
                    this.maxSpatialId = maxSpatialId;
                    this.maxTemporalId = maxTemporalId;
                    this.chainCount = ((FrameInfo)CollectionsKt.first(this.templateInfo)).getChains().size();
                    $this$all$iv = this.templateInfo;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (FrameInfo)element$iv;
                            boolean bl4 = false;
                            if (it.getChains().size() == this.chainCount) continue;
                            bl3 = false;
                            break block13;
                        }
                        bl3 = true;
                    }
                }
                if (!bl3) {
                    boolean $i$a$-check-Av1TemplateDependencyStructure$32 = false;
                    String $i$a$-check-Av1TemplateDependencyStructure$32 = "Templates have inconsistent chain sizes";
                    throw new IllegalStateException($i$a$-check-Av1TemplateDependencyStructure$32.toString());
                }
                $this$all$iv = this.templateInfo;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (FrameInfo)element$iv;
                        boolean bl5 = false;
                        if (it.getTemporalId() <= this.maxTemporalId) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                boolean $i$a$-check-Av1TemplateDependencyStructure$62 = false;
                String $i$a$-check-Av1TemplateDependencyStructure$62 = "Incorrect maxTemporalId";
                throw new IllegalStateException($i$a$-check-Av1TemplateDependencyStructure$62.toString());
            }
            if (!(this.maxRenderResolutions.isEmpty() || this.maxRenderResolutions.size() == this.maxSpatialId + 1)) {
                boolean $i$a$-check-Av1TemplateDependencyStructure$82 = false;
                String $i$a$-check-Av1TemplateDependencyStructure$82 = "Non-zero number of render resolutions does not match maxSpatialId";
                throw new IllegalStateException($i$a$-check-Av1TemplateDependencyStructure$82.toString());
            }
            $this$all$iv = this.templateInfo;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (FrameInfo)element$iv;
                    boolean bl6 = false;
                    if (it.getSpatialId() <= this.maxSpatialId) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl7 = false;
            String string = "Incorrect maxSpatialId";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getTemplateIdOffset() {
        return this.templateIdOffset;
    }

    public final void setTemplateIdOffset(int n) {
        this.templateIdOffset = n;
    }

    @NotNull
    public final List<FrameInfo> getTemplateInfo() {
        return this.templateInfo;
    }

    @NotNull
    public final List<Integer> getDecodeTargetProtectedBy() {
        return this.decodeTargetProtectedBy;
    }

    @NotNull
    public final List<DecodeTargetLayer> getDecodeTargetLayers() {
        return this.decodeTargetLayers;
    }

    @NotNull
    public final List<Resolution> getMaxRenderResolutions() {
        return this.maxRenderResolutions;
    }

    public final int getMaxSpatialId() {
        return this.maxSpatialId;
    }

    public final int getMaxTemporalId() {
        return this.maxTemporalId;
    }

    public final int getTemplateCount() {
        return this.templateInfo.size();
    }

    public final int getDecodeTargetCount() {
        return this.decodeTargetLayers.size();
    }

    public final int getChainCount() {
        return this.chainCount;
    }

    public final int getUnpaddedLengthBits() {
        int length = 0;
        length = 6;
        length += 5;
        length += this.getTemplateCount() * 2;
        length += this.getTemplateCount() * this.getDecodeTargetCount() * 2;
        Iterable $this$forEach$iv = this.templateInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrameInfo it = (FrameInfo)element$iv;
            boolean bl = false;
            length += it.getFdiffCnt() * 5 + 1;
        }
        length += Av1DependencyDescriptorHeaderExtensionKt.nsBits(this.getDecodeTargetCount() + 1, this.chainCount);
        if (this.chainCount > 0) {
            $this$forEach$iv = this.decodeTargetProtectedBy;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                length += Av1DependencyDescriptorHeaderExtensionKt.nsBits(this.chainCount, it);
            }
            length += this.getTemplateCount() * this.chainCount * 4;
        }
        ++length;
        return length += this.maxRenderResolutions.size() * 32;
    }

    @NotNull
    public final Av1TemplateDependencyStructure clone() {
        return new Av1TemplateDependencyStructure(this.templateIdOffset, this.templateInfo, this.decodeTargetProtectedBy, this.decodeTargetLayers, this.maxRenderResolutions, this.maxSpatialId, this.maxTemporalId);
    }

    public final void write(@NotNull BitWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.writeBits(6, this.templateIdOffset);
        writer.writeBits(5, this.getDecodeTargetCount() - 1);
        this.writeTemplateLayers(writer);
        this.writeTemplateDtis(writer);
        this.writeTemplateFdiffs(writer);
        this.writeTemplateChains(writer);
        this.writeRenderResolutions(writer);
    }

    private final void writeTemplateLayers(BitWriter writer) {
        if (!(this.templateInfo.get(0).getSpatialId() == 0 && this.templateInfo.get(0).getTemporalId() == 0)) {
            boolean bl = false;
            String string = "First template must have spatial and temporal IDs 0/0, but found " + this.templateInfo.get(0).getSpatialId() + "/" + this.templateInfo.get(0).getTemporalId();
            throw new IllegalStateException(string.toString());
        }
        int n = this.templateInfo.size();
        for (int templateNum = 1; templateNum < n; ++templateNum) {
            int n2;
            if (this.templateInfo.get(templateNum).getSpatialId() == this.templateInfo.get(templateNum - 1).getSpatialId() && this.templateInfo.get(templateNum).getTemporalId() == this.templateInfo.get(templateNum - 1).getTemporalId()) {
                n2 = 0;
            } else if (this.templateInfo.get(templateNum).getSpatialId() == this.templateInfo.get(templateNum - 1).getSpatialId() && this.templateInfo.get(templateNum).getTemporalId() == this.templateInfo.get(templateNum - 1).getTemporalId() + 1) {
                n2 = 1;
            } else if (this.templateInfo.get(templateNum).getSpatialId() == this.templateInfo.get(templateNum - 1).getSpatialId() + 1 && this.templateInfo.get(templateNum).getTemporalId() == 0) {
                n2 = 2;
            } else {
                throw new IllegalStateException("Template " + templateNum + " with spatial and temporal IDs " + this.templateInfo.get(templateNum).getSpatialId() + "/" + this.templateInfo.get(templateNum).getTemporalId() + " cannot follow template " + (templateNum - 1) + " with spatial and temporal IDs " + this.templateInfo.get(templateNum - 1).getSpatialId() + "/" + this.templateInfo.get(templateNum - 1).getTemporalId() + ".");
            }
            int layerIdc = n2;
            writer.writeBits(2, layerIdc);
        }
        writer.writeBits(2, 3);
    }

    private final void writeTemplateDtis(BitWriter writer) {
        Iterable $this$forEach$iv = this.templateInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrameInfo t = (FrameInfo)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = t.getDti();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DTI dti = (DTI)((Object)element$iv2);
                boolean bl2 = false;
                writer.writeBits(2, dti.getDti());
            }
        }
    }

    private final void writeTemplateFdiffs(BitWriter writer) {
        Iterable $this$forEach$iv = this.templateInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrameInfo t = (FrameInfo)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = t.getFdiff();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int fdiff = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                writer.writeBit(true);
                writer.writeBits(4, fdiff - 1);
            }
            writer.writeBit(false);
        }
    }

    private final void writeTemplateChains(BitWriter writer) {
        writer.writeNs(this.getDecodeTargetCount() + 1, this.chainCount);
        Iterable $this$forEach$iv = this.decodeTargetProtectedBy;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            writer.writeNs(this.chainCount, it);
        }
        $this$forEach$iv = this.templateInfo;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrameInfo t = (FrameInfo)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = t.getChains();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int chain = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                writer.writeBits(4, chain);
            }
        }
    }

    private final void writeRenderResolutions(BitWriter writer) {
        if (this.maxRenderResolutions.isEmpty()) {
            writer.writeBit(false);
        } else {
            writer.writeBit(true);
            Iterable $this$forEach$iv = this.maxRenderResolutions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Resolution r = (Resolution)element$iv;
                boolean bl = false;
                writer.writeBits(16, r.getWidth() - 1);
                writer.writeBits(16, r.getHeight() - 1);
            }
        }
    }

    public final boolean canSwitchWithoutKeyframe(int fromDt, int toDt) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.templateInfo;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FrameInfo it = (FrameInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.hasInterPictureDependency() && it.getDti().size() > fromDt && it.getDti().size() > toDt && it.getDti().get(fromDt) != DTI.NOT_PRESENT && it.getDti().get(toDt) == DTI.SWITCH)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int getDtBitmaskForDt(int dt) {
        int mask = 0;
        mask = (1 << this.getDecodeTargetCount()) - 1;
        Iterable $this$forEach$iv = this.templateInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrameInfo frameInfo = (FrameInfo)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = frameInfo.getDti();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void dti;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DTI dTI = (DTI)((Object)item$iv);
                int i = n;
                boolean bl2 = false;
                if (frameInfo.getDti().get(dt) != DTI.NOT_PRESENT || dti == DTI.NOT_PRESENT) continue;
                mask &= ~(1 << i);
            }
        }
        return mask;
    }

    @NotNull
    public String toJSONString() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$toJSONString_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$toJSONString_u24lambda_u240.put((Object)"templateIdOffset", (Object)this.templateIdOffset);
        $this$toJSONString_u24lambda_u240.put((Object)"templateInfo", Av1DependencyDescriptorHeaderExtensionKt.toIndexedMap(this.templateInfo));
        $this$toJSONString_u24lambda_u240.put((Object)"decodeTargetProtectedBy", Av1DependencyDescriptorHeaderExtensionKt.toIndexedMap(this.decodeTargetProtectedBy));
        $this$toJSONString_u24lambda_u240.put((Object)"decodeTargetLayers", Av1DependencyDescriptorHeaderExtensionKt.toIndexedMap(this.decodeTargetLayers));
        if (!((Collection)this.maxRenderResolutions).isEmpty()) {
            $this$toJSONString_u24lambda_u240.put((Object)"maxRenderResolutions", Av1DependencyDescriptorHeaderExtensionKt.toIndexedMap(this.maxRenderResolutions));
        }
        $this$toJSONString_u24lambda_u240.put((Object)"maxSpatialId", (Object)this.maxSpatialId);
        $this$toJSONString_u24lambda_u240.put((Object)"maxTemporalId", (Object)this.maxTemporalId);
        return orderedJsonObject.toJSONString();
    }

    @NotNull
    public String toString() {
        return this.toJSONString();
    }
}

