/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.util;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.TimeUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/rtp/util/RtpUtils;", "", "<init>", "()V", "Companion", "rtp"})
public final class RtpUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final int getSequenceNumberDelta(int a, int b) {
        return Companion.getSequenceNumberDelta(a, b);
    }

    @JvmStatic
    public static final int applySequenceNumberDelta(int start, int delta) {
        return Companion.applySequenceNumberDelta(start, delta);
    }

    @JvmStatic
    public static final long applyTimestampDelta(long start, long delta) {
        return Companion.applyTimestampDelta(start, delta);
    }

    @JvmStatic
    public static final boolean isNewerSequenceNumberThan(int a, int b) {
        return Companion.isNewerSequenceNumberThan(a, b);
    }

    @JvmStatic
    public static final boolean isOlderSequenceNumberThan(int a, int b) {
        return Companion.isOlderSequenceNumberThan(a, b);
    }

    @JvmStatic
    public static final boolean isNewerTimestampThan(long a, long b) {
        return Companion.isNewerTimestampThan(a, b);
    }

    @JvmStatic
    public static final boolean isOlderTimestampThan(long a, long b) {
        return Companion.isOlderTimestampThan(a, b);
    }

    @JvmStatic
    public static final long getTimestampDiff(long a, long b) {
        return Companion.getTimestampDiff(a, b);
    }

    @JvmStatic
    public static final long millisToNtpTimestamp(long timestampMs) {
        return Companion.millisToNtpTimestamp(timestampMs);
    }

    @JvmStatic
    public static final long convertRtpTimestampToMs(int rtpTimestamp, int ticksPerSecond) {
        return Companion.convertRtpTimestampToMs(rtpTimestamp, ticksPerSecond);
    }

    @JvmStatic
    @NotNull
    public static final Instant convertRtpTimestampToInstant(int rtpTimestamp, int ticksPerSecond) {
        return Companion.convertRtpTimestampToInstant(rtpTimestamp, ticksPerSecond);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0082\bJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012H\u0007J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012H\u0007J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012H\u0007J\u0019\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012H\u0086\bJ\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0007J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0007J\u0018\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0007\u00a8\u0006%"}, d2={"Lorg/jitsi/rtp/util/RtpUtils$Companion;", "", "<init>", "()V", "calculateRtcpLengthFieldValue", "", "sizeBytes", "getNumPaddingBytes", "dataSizeBytes", "getSequenceNumberDelta", "a", "b", "getSequenceNumberDeltaAsShort", "", "applySequenceNumberDelta", "start", "delta", "applyTimestampDelta", "", "isNewerSequenceNumberThan", "", "isOlderSequenceNumberThan", "isNewerTimestampThan", "isOlderTimestampThan", "getTimestampDiff", "getTimestampDiffAsInt", "sequenceNumbersBetween", "Lkotlin/sequences/Sequence;", "olderSeqNum", "newerSeqNum", "millisToNtpTimestamp", "timestampMs", "convertRtpTimestampToMs", "rtpTimestamp", "ticksPerSecond", "convertRtpTimestampToInstant", "Ljava/time/Instant;", "rtp"})
    @SourceDebugExtension(value={"SMAP\nRtpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpUtils.kt\norg/jitsi/rtp/util/RtpUtils$Companion\n*L\n1#1,185:1\n65#1:186\n65#1:187\n65#1:188\n112#1:189\n112#1:190\n112#1:191\n*S KotlinDebug\n*F\n+ 1 RtpUtils.kt\norg/jitsi/rtp/util/RtpUtils$Companion\n*L\n54#1:186\n88#1:187\n91#1:188\n94#1:189\n97#1:190\n104#1:191\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int calculateRtcpLengthFieldValue(int sizeBytes) {
            if (sizeBytes % 4 != 0) {
                throw new Exception("Invalid RTCP size value");
            }
            return sizeBytes / 4 - 1;
        }

        public final int getNumPaddingBytes(int dataSizeBytes) {
            int n;
            switch (dataSizeBytes % 4) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 3;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final int getSequenceNumberDelta(int a, int b) {
            void a$iv;
            Companion companion = this;
            int n = a;
            int b$iv = b;
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a$iv - b$iv);
        }

        private final short getSequenceNumberDeltaAsShort(int a, int b) {
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a - b);
        }

        @JvmStatic
        public final int applySequenceNumberDelta(int start, int delta) {
            return start + delta & 0xFFFF;
        }

        @JvmStatic
        public final long applyTimestampDelta(long start, long delta) {
            return start + delta & 0xFFFFFFFFL;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean isNewerSequenceNumberThan(int a, int b) {
            void a$iv;
            Companion companion = this;
            int n = a;
            int b$iv = b;
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a$iv - b$iv) > 0;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean isOlderSequenceNumberThan(int a, int b) {
            void a$iv;
            Companion companion = this;
            int n = a;
            int b$iv = b;
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a$iv - b$iv) < 0;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean isNewerTimestampThan(long a, long b) {
            void a$iv;
            Companion companion = this;
            long l = a;
            long b$iv = b;
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a$iv - b$iv) > 0;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean isOlderTimestampThan(long a, long b) {
            void a$iv;
            Companion companion = this;
            long l = a;
            long b$iv = b;
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a$iv - b$iv) < 0;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final long getTimestampDiff(long a, long b) {
            void a$iv;
            Companion companion = this;
            long l = a;
            long b$iv = b;
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a$iv - b$iv);
        }

        public final int getTimestampDiffAsInt(long a, long b) {
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a - b);
        }

        @NotNull
        public final Sequence<Integer> sequenceNumbersBetween(int olderSeqNum, int newerSeqNum) {
            Ref.IntRef currSeqNum = new Ref.IntRef();
            currSeqNum.element = olderSeqNum;
            return SequencesKt.generateSequence(() -> Companion.sequenceNumbersBetween$lambda$0(currSeqNum, newerSeqNum));
        }

        @JvmStatic
        public final long millisToNtpTimestamp(long timestampMs) {
            return TimeUtils.toNtpTime((long)timestampMs);
        }

        @JvmStatic
        public final long convertRtpTimestampToMs(int rtpTimestamp, int ticksPerSecond) {
            return (long)((double)rtpTimestamp / (double)ticksPerSecond * (double)1000);
        }

        @JvmStatic
        @NotNull
        public final Instant convertRtpTimestampToInstant(int rtpTimestamp, int ticksPerSecond) {
            Instant instant = Instant.EPOCH.plus(Duration.ofSeconds(rtpTimestamp).dividedBy(ticksPerSecond));
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
            return instant;
        }

        private static final Integer sequenceNumbersBetween$lambda$0(Ref.IntRef $currSeqNum, int $newerSeqNum) {
            $currSeqNum.element = ($currSeqNum.element + 1) % 65536;
            return $currSeqNum.element == $newerSeqNum ? null : Integer.valueOf($currSeqNum.element);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

