/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.Deprecation;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpSender;
import org.jitsi.nlj.RtpSenderImpl;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.rtcp.KeyframeRequester;
import org.jitsi.nlj.rtcp.NackHandler;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpSrUpdater;
import org.jitsi.nlj.rtp.ClassicTransportCcEngine;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimatorConfig;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimatorEngine;
import org.jitsi.nlj.rtp.bandwidthestimation.GoogleCcEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation2.GoogCcTransportCcEngine;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.transform.NodeDebugStateVisitor;
import org.jitsi.nlj.transform.NodeEventVisitor;
import org.jitsi.nlj.transform.NodeTeardownVisitor;
import org.jitsi.nlj.transform.PipelineBuilder;
import org.jitsi.nlj.transform.PipelineDslKt;
import org.jitsi.nlj.transform.node.AudioRedHandler;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.PacketCacher;
import org.jitsi.nlj.transform.node.PacketLossConfig;
import org.jitsi.nlj.transform.node.PacketLossNode;
import org.jitsi.nlj.transform.node.PacketStreamStatsNode;
import org.jitsi.nlj.transform.node.PluggableTransformerNode;
import org.jitsi.nlj.transform.node.SrtcpEncryptNode;
import org.jitsi.nlj.transform.node.SrtpEncryptNode;
import org.jitsi.nlj.transform.node.ToggleablePcapWriter;
import org.jitsi.nlj.transform.node.outgoing.AbsSendTime;
import org.jitsi.nlj.transform.node.outgoing.HeaderExtEncoder;
import org.jitsi.nlj.transform.node.outgoing.HeaderExtStripper;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsSnapshot;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsTracker;
import org.jitsi.nlj.transform.node.outgoing.ProbingDataSender;
import org.jitsi.nlj.transform.node.outgoing.RetransmissionSender;
import org.jitsi.nlj.transform.node.outgoing.SentRtcpStats;
import org.jitsi.nlj.transform.node.outgoing.TccSeqNumTagger;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.StreamInformationStore;
import org.jitsi.nlj.util.UtilKt;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.utils.queue.ErrorHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a1\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001F\u0018\u0000 {2\u00020\u0001:\u0001{BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020I2\u0006\u0010M\u001a\u00020NH\u0014J\u001e\u0010O\u001a\u00020P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020&0R2\u0006\u0010S\u001a\u00020PH\u0016J\u0010\u0010T\u001a\u00020I2\u0006\u0010U\u001a\u00020*H\u0016J\u0010\u0010V\u001a\u00020I2\u0006\u0010W\u001a\u00020XH\u0016J\u0017\u0010Y\u001a\u00020I2\b\u0010Z\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010[J\u0010\u0010\\\u001a\u00020I2\u0006\u0010]\u001a\u00020^H\u0016J\u0018\u0010_\u001a\u00020I2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020 H\u0016J\u0010\u0010c\u001a\u00020 2\u0006\u0010`\u001a\u00020aH\u0016J\u0010\u0010d\u001a\u00020 2\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010e\u001a\u00020fH\u0016J\b\u0010g\u001a\u00020hH\u0016J\b\u0010i\u001a\u00020jH\u0016J\u0010\u0010k\u001a\u00020I2\u0006\u0010l\u001a\u00020mH\u0016J\u0010\u0010n\u001a\u00020I2\u0006\u0010l\u001a\u00020mH\u0016J\u0010\u0010o\u001a\u00020I2\u0006\u0010p\u001a\u00020qH\u0016J\u0010\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uH\u0016J\b\u0010v\u001a\u00020IH\u0016J\b\u0010w\u001a\u00020IH\u0016J\u0010\u0010x\u001a\u00020I2\u0006\u0010y\u001a\u00020zH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0012\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0012\u0010(\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010G\u00a8\u0006|"}, d2={"Lorg/jitsi/nlj/RtpSenderImpl;", "Lorg/jitsi/nlj/RtpSender;", "id", "", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "executor", "Ljava/util/concurrent/ExecutorService;", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Ljava/lang/String;Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/nlj/util/StreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "getId", "()Ljava/lang/String;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "getBackgroundExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "logger", "outgoingRtpRoot", "Lorg/jitsi/nlj/transform/node/Node;", "outgoingRtxRoot", "outgoingRtcpRoot", "incomingPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "localVideoSsrc", "", "Ljava/lang/Long;", "localAudioSsrc", "outgoingPacketHandler", "Lorg/jitsi/nlj/PacketHandler;", "transportCcEngine", "Lorg/jitsi/nlj/rtp/TransportCcEngine;", "srtpEncryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtpEncryptNode;", "srtcpEncryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtcpEncryptNode;", "toggleablePcapWriter", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter;", "outgoingPacketCache", "Lorg/jitsi/nlj/transform/node/PacketCacher;", "headerExtensionStripper", "Lorg/jitsi/nlj/transform/node/outgoing/HeaderExtStripper;", "absSendTime", "Lorg/jitsi/nlj/transform/node/outgoing/AbsSendTime;", "statsTracker", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "packetStreamStats", "Lorg/jitsi/nlj/transform/node/PacketStreamStatsNode;", "rtcpSrUpdater", "Lorg/jitsi/nlj/rtcp/RtcpSrUpdater;", "keyframeRequester", "Lorg/jitsi/nlj/rtcp/KeyframeRequester;", "probingDataSender", "Lorg/jitsi/nlj/transform/node/outgoing/ProbingDataSender;", "nackHandler", "Lorg/jitsi/nlj/rtcp/NackHandler;", "outputPipelineTerminationNode", "org/jitsi/nlj/RtpSenderImpl$outputPipelineTerminationNode$1", "Lorg/jitsi/nlj/RtpSenderImpl$outputPipelineTerminationNode$1;", "onRttUpdate", "", "newRttMs", "", "doProcessPacket", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "sendProbing", "", "mediaSsrcs", "", "numBytes", "onOutgoingPacket", "handler", "setSrtpTransformers", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "requestKeyframe", "mediaSsrc", "(Ljava/lang/Long;)V", "addLossListener", "lossListener", "Lorg/jitsi/nlj/rtp/LossListener;", "setFeature", "feature", "Lorg/jitsi/nlj/Features;", "enabled", "isFeatureEnabled", "handlePacket", "getStreamStats", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsSnapshot;", "getPacketStreamStats", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "getTransportCcEngineStats", "Lorg/jitsi/nlj/rtp/TransportCcEngine$StatisticsSnapshot;", "addBandwidthListener", "listener", "Lorg/jitsi/nlj/rtp/TransportCcEngine$BandwidthListener;", "removeBandwidthListener", "handleEvent", "event", "Lorg/jitsi/nlj/Event;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "mode", "Lorg/jitsi/nlj/DebugStateMode;", "stop", "tearDown", "addRtpExtensionToRetain", "extensionType", "Lorg/jitsi/nlj/rtp/RtpExtensionType;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRtpSenderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpSenderImpl.kt\norg/jitsi/nlj/RtpSenderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 4 SupplierBuilder.kt\norg/jitsi/metaconfig/SupplierBuilderKt\n+ 5 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,379:1\n1#2:380\n63#3,4:381\n127#4:385\n59#5:386\n*S KotlinDebug\n*F\n+ 1 RtpSenderImpl.kt\norg/jitsi/nlj/RtpSenderImpl\n*L\n155#1:381,4\n371#1:385\n371#1:386\n*E\n"})
public final class RtpSenderImpl
extends RtpSender {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final ScheduledExecutorService backgroundExecutor;
    @NotNull
    private final StreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Node outgoingRtpRoot;
    @NotNull
    private final Node outgoingRtxRoot;
    @NotNull
    private final Node outgoingRtcpRoot;
    @NotNull
    private final PacketInfoQueue incomingPacketQueue;
    private boolean running;
    @Nullable
    private Long localVideoSsrc;
    @Nullable
    private Long localAudioSsrc;
    @Nullable
    private PacketHandler outgoingPacketHandler;
    @NotNull
    private final TransportCcEngine transportCcEngine;
    @NotNull
    private final SrtpEncryptNode srtpEncryptWrapper;
    @NotNull
    private final SrtcpEncryptNode srtcpEncryptWrapper;
    @NotNull
    private final ToggleablePcapWriter toggleablePcapWriter;
    @NotNull
    private final PacketCacher outgoingPacketCache;
    @NotNull
    private final HeaderExtStripper headerExtensionStripper;
    @NotNull
    private final AbsSendTime absSendTime;
    @NotNull
    private final OutgoingStatisticsTracker statsTracker;
    @NotNull
    private final PacketStreamStatsNode packetStreamStats;
    @NotNull
    private final RtcpSrUpdater rtcpSrUpdater;
    @NotNull
    private final KeyframeRequester keyframeRequester;
    @NotNull
    private final ProbingDataSender probingDataSender;
    @NotNull
    private final NackHandler nackHandler;
    @NotNull
    private final outputPipelineTerminationNode.1 outputPipelineTerminationNode;
    @NotNull
    private static CountingErrorHandler queueErrorCounter;
    @NotNull
    private static final String PACKET_QUEUE_ENTRY_EVENT = "Entered RTP sender incoming queue";
    @NotNull
    private static final String PACKET_QUEUE_EXIT_EVENT = "Exited RTP sender incoming queue";
    @NotNull
    private static final ConfigDelegate<Integer> queueSize$delegate;
    @NotNull
    private static final PacketLossConfig packetLossConfig;

    /*
     * WARNING - void declaration
     */
    public RtpSenderImpl(@NotNull String id, @NotNull RtcpEventNotifier rtcpEventNotifier, @NotNull ExecutorService executor, @NotNull ScheduledExecutorService backgroundExecutor, @NotNull StreamInformationStore streamInformationStore, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        void it;
        TransportCcEngine transportCcEngine;
        TransportCcEngine transportCcEngine2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)rtcpEventNotifier, (String)"rtcpEventNotifier");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        Intrinsics.checkNotNullParameter((Object)streamInformationStore, (String)"streamInformationStore");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        this.id = id;
        this.rtcpEventNotifier = rtcpEventNotifier;
        this.executor = executor;
        this.backgroundExecutor = backgroundExecutor;
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.incomingPacketQueue = new PacketInfoQueue("rtp-sender-incoming-packet-queue", this.executor, (Function1<? super PacketInfo, Boolean>)((Function1)new Function1<PacketInfo, Boolean>((Object)this){

            public final Boolean invoke(PacketInfo p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RtpSenderImpl.access$handlePacket((RtpSenderImpl)this.receiver, p0);
            }
        }), RtpSenderImpl.Companion.getQueueSize());
        this.running = true;
        switch (WhenMappings.$EnumSwitchMapping$0[BandwidthEstimatorConfig.Companion.getEngine().ordinal()]) {
            case 1: {
                transportCcEngine2 = new ClassicTransportCcEngine(new GoogleCcEstimator(diagnosticContext, this.logger), this.logger, null, 4, null);
                break;
            }
            case 2: {
                transportCcEngine2 = new GoogCcTransportCcEngine(diagnosticContext, this.logger, this.backgroundExecutor, (arg_0, arg_1) -> RtpSenderImpl.transportCcEngine$lambda$0(this, arg_0, arg_1), null, 16, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TransportCcEngine transportCcEngine3 = transportCcEngine = transportCcEngine2;
        RtpSenderImpl rtpSenderImpl = this;
        boolean bl = false;
        it.start();
        rtpSenderImpl.transportCcEngine = transportCcEngine;
        this.srtpEncryptWrapper = new SrtpEncryptNode();
        this.srtcpEncryptWrapper = new SrtcpEncryptNode();
        this.toggleablePcapWriter = new ToggleablePcapWriter(this.logger, this.id + "-tx");
        this.outgoingPacketCache = new PacketCacher();
        this.headerExtensionStripper = new HeaderExtStripper(this.streamInformationStore);
        this.absSendTime = new AbsSendTime(this.streamInformationStore);
        this.statsTracker = new OutgoingStatisticsTracker(diagnosticContext);
        this.packetStreamStats = new PacketStreamStatsNode(diagnosticContext, "send", null, 4, null);
        this.rtcpSrUpdater = new RtcpSrUpdater(this.statsTracker);
        this.keyframeRequester = new KeyframeRequester(this.streamInformationStore, this.logger, null, 4, null);
        this.outputPipelineTerminationNode = new ConsumerNode(this){
            private final String aggregationKey;
            final /* synthetic */ RtpSenderImpl this$0;
            {
                this.this$0 = $receiver;
                super("Output pipeline termination node");
                this.aggregationKey = this.getName();
            }

            protected void consume(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
                PacketHandler packetHandler = RtpSenderImpl.access$getOutgoingPacketHandler$p(this.this$0);
                if (packetHandler != null) {
                    packetHandler.processPacket(packetInfo);
                } else {
                    this.packetDiscarded(packetInfo);
                }
            }

            protected String getAggregationKey() {
                return this.aggregationKey;
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                f.invoke();
            }
        };
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            rtpSenderImpl = $this$cdebug$iv;
            boolean bl2 = false;
            rtpSenderImpl.debug("Sender " + this.id + " using executor " + this.executor.hashCode());
        }
        if (packetLossConfig.getEnabled()) {
            this.logger.warn((Object)("Will simulate packet loss: " + packetLossConfig));
        }
        this.incomingPacketQueue.setErrorHandler((ErrorHandler)queueErrorCounter);
        this.outgoingRtpRoot = PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)((Function1)arg_0 -> RtpSenderImpl._init_$lambda$1(this, arg_0)));
        this.outgoingRtxRoot = PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)((Function1)arg_0 -> RtpSenderImpl._init_$lambda$2(this, arg_0)));
        this.nackHandler = new NackHandler(this.outgoingPacketCache.getPacketCache(), this.outgoingRtxRoot, this.logger);
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.nackHandler, false, 2, null);
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.transportCcEngine, false, 2, null);
        this.outgoingRtcpRoot = PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)((Function1)arg_0 -> RtpSenderImpl._init_$lambda$3(this, arg_0)));
        this.probingDataSender = new ProbingDataSender(this.outgoingPacketCache.getPacketCache(), this.outgoingRtxRoot, this.absSendTime, diagnosticContext, this.streamInformationStore, this.logger);
    }

    public /* synthetic */ RtpSenderImpl(String string, RtcpEventNotifier rtcpEventNotifier, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, StreamInformationStore streamInformationStore, Logger logger, DiagnosticContext diagnosticContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            diagnosticContext = new DiagnosticContext();
        }
        this(string, rtcpEventNotifier, executorService, scheduledExecutorService, streamInformationStore, logger, diagnosticContext);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ExecutorService getExecutor() {
        return this.executor;
    }

    @NotNull
    public final ScheduledExecutorService getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    public void onRttUpdate(double newRttMs) {
        this.nackHandler.onRttUpdate(newRttMs);
        this.keyframeRequester.onRttUpdate(newRttMs);
        Duration duration = Duration.ofNanos((long)(newRttMs * 1000000.0));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        this.transportCcEngine.onRttUpdate(duration);
    }

    @Override
    protected void doProcessPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        if (this.running) {
            packetInfo.addEvent(PACKET_QUEUE_ENTRY_EVENT);
            this.incomingPacketQueue.add(packetInfo);
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
            function1.invoke((Object)packetInfo.getPacket().buffer);
        }
    }

    @Override
    public int sendProbing(@NotNull Collection<Long> mediaSsrcs, int numBytes) {
        Intrinsics.checkNotNullParameter(mediaSsrcs, (String)"mediaSsrcs");
        return this.probingDataSender.sendProbing(mediaSsrcs, numBytes, null);
    }

    @Override
    public void onOutgoingPacket(@NotNull PacketHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.outgoingPacketHandler = handler;
    }

    @Override
    public void setSrtpTransformers(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter((Object)srtpTransformers, (String)"srtpTransformers");
        this.srtpEncryptWrapper.setTransformer(srtpTransformers.getSrtpEncryptTransformer());
        this.srtcpEncryptWrapper.setTransformer(srtpTransformers.getSrtcpEncryptTransformer());
    }

    @Override
    public void requestKeyframe(@Nullable Long mediaSsrc) {
        this.keyframeRequester.requestKeyframe(mediaSsrc);
    }

    @Override
    public void addLossListener(@NotNull LossListener lossListener) {
        Intrinsics.checkNotNullParameter((Object)lossListener, (String)"lossListener");
        this.transportCcEngine.addLossListener(lossListener);
    }

    @Override
    public void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        if (WhenMappings.$EnumSwitchMapping$1[feature.ordinal()] == 1) {
            if (enabled2) {
                this.toggleablePcapWriter.enable();
            } else {
                this.toggleablePcapWriter.disable();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Features feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        if (WhenMappings.$EnumSwitchMapping$1[feature.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return this.toggleablePcapWriter.isEnabled();
    }

    private final boolean handlePacket(PacketInfo packetInfo) {
        boolean bl;
        if (this.running) {
            packetInfo.addEvent(PACKET_QUEUE_EXIT_EVENT);
            Node root = packetInfo.getPacket() instanceof RtcpPacket ? this.outgoingRtcpRoot : this.outgoingRtpRoot;
            root.processPacket(packetInfo);
            bl = true;
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
            function1.invoke((Object)packetInfo.getPacket().buffer);
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public OutgoingStatisticsSnapshot getStreamStats() {
        return this.statsTracker.getSnapshot();
    }

    @Override
    @NotNull
    public PacketStreamStats.Snapshot getPacketStreamStats() {
        return this.packetStreamStats.snapshot();
    }

    @Override
    @NotNull
    public TransportCcEngine.StatisticsSnapshot getTransportCcEngineStats() {
        return this.transportCcEngine.getStatistics();
    }

    @Override
    public void addBandwidthListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.transportCcEngine.addBandwidthListener(listener);
    }

    @Override
    public void removeBandwidthListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.transportCcEngine.removeBandwidthListener(listener);
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof SetLocalSsrcEvent) {
            switch (WhenMappings.$EnumSwitchMapping$2[((SetLocalSsrcEvent)event).getMediaType().ordinal()]) {
                case 1: {
                    this.localVideoSsrc = ((SetLocalSsrcEvent)event).getSsrc();
                    break;
                }
                case 2: {
                    this.localAudioSsrc = ((SetLocalSsrcEvent)event).getSsrc();
                }
            }
        }
        new NodeEventVisitor(event).reverseVisit(this.outputPipelineTerminationNode);
        this.probingDataSender.handleEvent(event);
    }

    @Override
    @NotNull
    public OrderedJsonObject debugState(@NotNull DebugStateMode mode) {
        OrderedJsonObject orderedJsonObject;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        OrderedJsonObject $this$debugState_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        if (mode == DebugStateMode.FULL) {
            UtilKt.appendAll($this$debugState_u24lambda_u240, super.getNodeStats().toJson());
            ((Map)$this$debugState_u24lambda_u240).put("packet_queue", this.incomingPacketQueue.getDebugState());
            ((Map)$this$debugState_u24lambda_u240).put("running", this.running);
        }
        UtilKt.appendAll($this$debugState_u24lambda_u240, this.nackHandler.getNodeStats().toJson());
        ((Map)$this$debugState_u24lambda_u240).put("probing_data_sender", this.probingDataSender.debugState(mode));
        Map map = (Map)$this$debugState_u24lambda_u240;
        String string = "local_video_ssrc";
        Object object = this.localVideoSsrc;
        if (object == null || (object = String.valueOf((Long)object)) == null) {
            object = "null";
        }
        Object object2 = object;
        map.put(string, object2);
        map = (Map)$this$debugState_u24lambda_u240;
        string = "local_audio_ssrc";
        Object object3 = this.localAudioSsrc;
        if (object3 == null || (object3 = String.valueOf((Long)object3)) == null) {
            object3 = "null";
        }
        object2 = object3;
        map.put(string, object2);
        ((Map)$this$debugState_u24lambda_u240).put("transport_cc_engine", this.transportCcEngine.getStatistics().toJson());
        new NodeDebugStateVisitor($this$debugState_u24lambda_u240, mode).reverseVisit(this.outputPipelineTerminationNode);
        return orderedJsonObject;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void tearDown() {
        this.logger.debug((Object)"Tearing down");
        new NodeTeardownVisitor().reverseVisit(this.outputPipelineTerminationNode);
        this.incomingPacketQueue.close();
        this.toggleablePcapWriter.disable();
    }

    @Override
    public void addRtpExtensionToRetain(@NotNull RtpExtensionType extensionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionType), (String)"extensionType");
        this.headerExtensionStripper.addRtpExtensionToRetain(extensionType);
    }

    private static final int transportCcEngine$lambda$0(RtpSenderImpl this$0, DataSize dataSize, Object probingData) {
        Intrinsics.checkNotNullParameter((Object)dataSize, (String)"dataSize");
        return this$0.probingDataSender.sendProbing(null, (int)dataSize.getBytes(), probingData);
    }

    private static final Unit _init_$lambda$1(RtpSenderImpl this$0, PipelineBuilder $this$pipeline) {
        Intrinsics.checkNotNullParameter((Object)$this$pipeline, (String)"$this$pipeline");
        PipelineBuilder.node$default($this$pipeline, new PluggableTransformerNode("RTP pre-processor", (Function0<? extends Function1<? super PacketInfo, ? extends PacketInfo>>)((Function0)() -> RtpSenderImpl.lambda$1$0(this$0))), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new AudioRedHandler(this$0.streamInformationStore, this$0.logger), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.headerExtensionStripper, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.outgoingPacketCache, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.absSendTime, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.statsTracker, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new TccSeqNumTagger(this$0.transportCcEngine, this$0.streamInformationStore), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new HeaderExtEncoder(this$0.streamInformationStore, this$0.logger), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.toggleablePcapWriter.newObserverNode(true, "tx_rtp"), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.srtpEncryptWrapper, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.packetStreamStats.createNewNode(), null, 2, null);
        $this$pipeline.node(new PacketLossNode(packetLossConfig), (Function0<Boolean>)((Function0)RtpSenderImpl::lambda$1$1));
        PipelineBuilder.node$default($this$pipeline, this$0.outputPipelineTerminationNode, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Function1 lambda$1$0(RtpSenderImpl this$0) {
        return this$0.getPreProcesor();
    }

    private static final boolean lambda$1$1() {
        return packetLossConfig.getEnabled();
    }

    private static final Unit _init_$lambda$2(RtpSenderImpl this$0, PipelineBuilder $this$pipeline) {
        Intrinsics.checkNotNullParameter((Object)$this$pipeline, (String)"$this$pipeline");
        PipelineBuilder.node$default($this$pipeline, new RetransmissionSender(this$0.streamInformationStore, this$0.logger), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.absSendTime, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(RtpSenderImpl this$0, PipelineBuilder $this$pipeline) {
        Intrinsics.checkNotNullParameter((Object)$this$pipeline, (String)"$this$pipeline");
        PipelineBuilder.node$default($this$pipeline, new PluggableTransformerNode("RTCP pre-processor", (Function0<? extends Function1<? super PacketInfo, ? extends PacketInfo>>)((Function0)() -> RtpSenderImpl.lambda$3$0(this$0))), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.keyframeRequester, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new SentRtcpStats(), null, 2, null);
        $this$pipeline.simpleNode("RTCP sender ssrc setter", (Function1<? super PacketInfo, ? extends PacketInfo>)((Function1)arg_0 -> RtpSenderImpl.lambda$3$1(this$0, arg_0)));
        PipelineBuilder.node$default($this$pipeline, this$0.rtcpSrUpdater, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.toggleablePcapWriter.newObserverNode(true, "tx_rtcp"), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new ObserverNode(this$0){
            final /* synthetic */ RtpSenderImpl this$0;
            {
                this.this$0 = $receiver;
                super("RTCP sent notifier");
            }

            protected void observe(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
                Packet packet = packetInfo.getPacket();
                if (packet instanceof RtcpPacket) {
                    RtcpEventNotifier.notifyRtcpSent$default(RtpSenderImpl.access$getRtcpEventNotifier$p(this.this$0), (RtcpPacket)packet, false, 2, null);
                }
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
            }
        }, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.srtcpEncryptWrapper, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.packetStreamStats.createNewNode(), null, 2, null);
        $this$pipeline.node(new PacketLossNode(packetLossConfig), (Function0<Boolean>)((Function0)RtpSenderImpl::lambda$3$2));
        PipelineBuilder.node$default($this$pipeline, this$0.outputPipelineTerminationNode, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Function1 lambda$3$0(RtpSenderImpl this$0) {
        return this$0.getPreProcesor();
    }

    private static final PacketInfo lambda$3$1(RtpSenderImpl this$0, PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Long l = this$0.localVideoSsrc;
        if (l == null) {
            return packetInfo;
        }
        long senderSsrc = l;
        RtcpPacket rtcpPacket = (RtcpPacket)packetInfo.packetAs();
        if (rtcpPacket.getSenderSsrc() == 0L) {
            rtcpPacket.setSenderSsrc(senderSsrc);
        }
        return packetInfo;
    }

    private static final boolean lambda$3$2() {
        return packetLossConfig.getEnabled();
    }

    public static final /* synthetic */ RtcpEventNotifier access$getRtcpEventNotifier$p(RtpSenderImpl $this) {
        return $this.rtcpEventNotifier;
    }

    public static final /* synthetic */ boolean access$handlePacket(RtpSenderImpl $this, PacketInfo packetInfo) {
        return $this.handlePacket(packetInfo);
    }

    public static final /* synthetic */ PacketHandler access$getOutgoingPacketHandler$p(RtpSenderImpl $this) {
        return $this.outgoingPacketHandler;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$from$iv;
        Companion = new Companion(null);
        queueErrorCounter = new CountingErrorHandler();
        String string = "jmt.transceiver.send.queue-size";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), (Deprecation)DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        queueSize$delegate = new ConfigDelegate((ConfigValueSupplier)supplier$iv);
        packetLossConfig = new PacketLossConfig("jmt.debug.packet-loss.outgoing");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/RtpSenderImpl$Companion;", "", "<init>", "()V", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "getQueueErrorCounter", "()Lorg/jitsi/utils/queue/CountingErrorHandler;", "setQueueErrorCounter", "(Lorg/jitsi/utils/queue/CountingErrorHandler;)V", "PACKET_QUEUE_ENTRY_EVENT", "", "PACKET_QUEUE_EXIT_EVENT", "queueSize", "", "getQueueSize", "()I", "queueSize$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "packetLossConfig", "Lorg/jitsi/nlj/transform/node/PacketLossConfig;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final CountingErrorHandler getQueueErrorCounter() {
            return queueErrorCounter;
        }

        public final void setQueueErrorCounter(@NotNull CountingErrorHandler countingErrorHandler) {
            Intrinsics.checkNotNullParameter((Object)countingErrorHandler, (String)"<set-?>");
            queueErrorCounter = countingErrorHandler;
        }

        private final int getQueueSize() {
            return ((Number)queueSize$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "queueSize", "getQueueSize()I", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[BandwidthEstimatorEngine.values().length];
            try {
                nArray[BandwidthEstimatorEngine.GoogleCc.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BandwidthEstimatorEngine.GoogleCc2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Features.values().length];
            try {
                nArray[Features.TRANSCEIVER_PCAP_DUMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[MediaType.values().length];
            try {
                nArray[MediaType.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

