/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

public abstract class FsFile extends FsObject {

    protected long length;
    private int useCount = 0;

    public abstract int readBytes(long offset, byte[] b, int off, int len);

    public abstract int writeBytes(long offset, byte[] b, int off, int len);

    protected abstract void lastReferenceClosed();

    @Override
    public int getBooleanAttributes() {
        return BA_EXISTS | BA_REGULAR;
    }

    public long getLength() {
        callPopulateAttributes();
        return length;
    }

    public void setLength(long alength) {
        callPopulateAttributes();
        length = alength;
    }

    public synchronized void incrementUseCount() {
        useCount++;
    }

    public synchronized void decrementUseCount() {
        useCount--;
        if (useCount == 0) {
            lastReferenceClosed();
        }
    }

}
