/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.net;

import java.net.MalformedURLException;

import blues.Log;

public class URLPeer {

    public static URLAccess access = null;

    public static synchronized void setURLAccess(URLAccess a) {
        if (access == null) {
            access = a;
        }
    }

    public static java.net.URL fromJail(jail.java.net.URL url) {

        if (null == url)
            return null;

        return UrlStreamHandlerPeer.createPeerURL(url.getProtocol(), url.getHost(), url.getPort(), url.getAuthority(),
                url.getUserInfo(), url.getPath(), url.getQuery(), url.getRef());
    }

    public static jail.java.net.URL toJail(java.net.URL url) {
        if (null == url)
            return null;

        jail.java.net.URL u;

        try {
            u = new jail.java.net.URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
        } catch (MalformedURLException e) {
            Log.unimplemented();
            return null;
        }

        access.set(u, url.getProtocol(), url.getHost(), url.getPort(), url.getAuthority(), url.getUserInfo(),
                url.getPath(), url.getQuery(), url.getRef());

        return u;
    }

}
