/*
 * This file is part of libbluray
 * Copyright (C) 2010  William Hahne
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */

package jail.org.dvb.media;

import jail.java.awt.Dimension;
import jail.java.awt.Rectangle;
import jail.javax.media.Control;
import jail.org.havi.ui.HScreenRectangle;

public interface VideoPresentationControl extends Control {
    public abstract Dimension getInputVideoSize();

    public abstract Dimension getVideoSize();

    public abstract HScreenRectangle getActiveVideoArea();

    public abstract HScreenRectangle getActiveVideoAreaOnScreen();

    public abstract HScreenRectangle getTotalVideoArea();

    public abstract HScreenRectangle getTotalVideoAreaOnScreen();

    public abstract boolean supportsClipping();

    public abstract Rectangle setClipRegion(Rectangle clipRect);

    public abstract Rectangle getClipRegion();

    public abstract float[] supportsArbitraryHorizontalScaling();

    public abstract float[] supportsArbitraryVerticalScaling();

    public abstract float[] getHorizontalScalingFactors();

    public abstract float[] getVerticalScalingFactors();

    public byte getPositioningCapability();

    public static final byte POS_CAP_FULL = 0;
    public static final byte POS_CAP_FULL_IF_ENTIRE_VIDEO_ON_SCREEN = 1;
    public static final byte POS_CAP_FULL_EVEN_LINES = 3;
    public static final byte POS_CAP_FULL_EVEN_LINES_IF_ENTIRE_VIDEO_ON_SCREEN = 4;
    public static final byte POS_CAP_OTHER = -1;
}
