/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.webvtt.sampleboxes;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.Box;
import org.mp4parser.IsoFile;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.Utf8;

public abstract class AbstractCueBox
implements Box {
    String content = "";
    String type;

    public AbstractCueBox(String type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public long getSize() {
        return 8 + Utf8.utf8StringLengthInBytes((String)this.content);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(CastUtils.l2i((long)this.getSize()));
        IsoTypeWriter.writeUInt32((ByteBuffer)header, (long)this.getSize());
        header.put(IsoFile.fourCCtoBytes((String)this.getType()));
        header.put(Utf8.convert((String)this.content));
        writableByteChannel.write((ByteBuffer)((Buffer)header).rewind());
    }

    public String getType() {
        return this.type;
    }
}

