/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldCL;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldNM;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldPL;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldPN;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldPX;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldRE;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldRR;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldSF;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldSL;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldTF;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldCE;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldER;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldPD;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldSP;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldST;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.InvalidSuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.SuspFieldEnds;
import java.util.ArrayList;
import java.util.List;

public final class Iso9660FileEntry
implements FileEntry {
    public static final String ID_SEPARATOR1 = ".;1";
    public static final String ID_SEPARATOR2 = ";1";
    private Iso9660FileSystem fileSystem;
    private String parentPath;
    private final int entryLength;
    private final long startSector;
    private final long dataLength;
    private final long lastModifiedTime;
    private final int flags;
    private final int fidLength;
    private final String identifier;
    private final boolean suParsed;
    private final List<SuspField> suspFields = new ArrayList<SuspField>();
    private final List<RripFieldNM> rrnmFields = new ArrayList<RripFieldNM>();
    private final List<RripFieldSL> rrslFields = new ArrayList<RripFieldSL>();
    private RripFieldPX rrpxField = null;

    public Iso9660FileEntry(Iso9660FileSystem iso9660FileSystem, byte[] byArray, int n) {
        this(iso9660FileSystem, null, byArray, n, true);
    }

    public Iso9660FileEntry(Iso9660FileSystem iso9660FileSystem, String string, byte[] byArray, int n) {
        this(iso9660FileSystem, string, byArray, n, true);
    }

    public Iso9660FileEntry(Iso9660FileSystem iso9660FileSystem, String string, byte[] byArray, int n, boolean bl) {
        this.fileSystem = iso9660FileSystem;
        this.parentPath = string;
        int n2 = n - 1;
        this.entryLength = Util.getUInt8(byArray, n2 + 1);
        this.startSector = Util.getUInt32LE(byArray, n2 + 3);
        this.dataLength = Util.getUInt32LE(byArray, n2 + 11);
        this.lastModifiedTime = Util.getDateTime(byArray, n2 + 19);
        this.flags = Util.getUInt8(byArray, n2 + 26);
        this.fidLength = Util.getUInt8(byArray, n2 + 33);
        this.identifier = this.getFileIdentifier(byArray, n2, this.isDirectory());
        this.suParsed = bl;
        if (this.suParsed) {
            int n3 = n2 + 33 + this.fidLength;
            if (this.fidLength % 2 == 0) {
                ++n3;
            }
            byte[] byArray2 = Util.getBytes(byArray, n3, this.entryLength - (33 + this.fidLength));
            try {
                this.deserializeSuBlock(byArray2);
            }
            catch (InvalidSuspField invalidSuspField) {
                throw new RuntimeException(invalidSuspField);
            }
            catch (SuspFieldEnds suspFieldEnds) {
                // empty catch block
            }
        }
    }

    private void deserializeSuBlock(byte[] byArray) throws InvalidSuspField, SuspFieldEnds {
        int n;
        for (int i = 1; i < byArray.length; i += n) {
            SuspField suspField;
            int n2 = SuspField.extractFieldId(byArray, i);
            switch (n2) {
                case 17221: {
                    suspField = new SuspFieldCE(byArray, i);
                    break;
                }
                case 20548: {
                    suspField = new SuspFieldPD(byArray, i);
                    break;
                }
                case 21328: {
                    suspField = new SuspFieldSP(byArray, i);
                    break;
                }
                case 21332: {
                    suspField = new SuspFieldST(byArray, i);
                    this.suspFields.add(suspField);
                    throw new SuspFieldEnds("SU field sequence ends with the ST field");
                }
                case 17746: {
                    suspField = new SuspFieldER(byArray, i);
                    break;
                }
                case 20568: {
                    suspField = new RripFieldPX(byArray, i);
                    this.rrpxField = (RripFieldPX)suspField;
                    break;
                }
                case 20558: {
                    suspField = new RripFieldPN(byArray, i);
                    break;
                }
                case 21324: {
                    suspField = new RripFieldSL(byArray, i);
                    this.rrslFields.add((RripFieldSL)suspField);
                    break;
                }
                case 20045: {
                    suspField = new RripFieldNM(byArray, i);
                    this.rrnmFields.add((RripFieldNM)suspField);
                    break;
                }
                case 17228: {
                    suspField = new RripFieldCL(byArray, i);
                    break;
                }
                case 20556: {
                    suspField = new RripFieldPL(byArray, i);
                    break;
                }
                case 21061: {
                    suspField = new RripFieldRE(byArray, i);
                    break;
                }
                case 21574: {
                    suspField = new RripFieldTF(byArray, i);
                    break;
                }
                case 21318: {
                    suspField = new RripFieldSF(byArray, i);
                    break;
                }
                case 21074: {
                    suspField = new RripFieldRR(byArray, i);
                    break;
                }
                default: {
                    String string = Integer.toHexString(n2).toUpperCase();
                    throw new SuspFieldEnds("SU field sequence ends with unknown field id: 0x" + string);
                }
            }
            this.suspFields.add(suspField);
            n = suspField.getLength();
        }
    }

    private String getFileIdentifier(byte[] byArray, int n, boolean bl) {
        if (bl) {
            int n2 = Util.getUInt8(byArray, n + 34);
            if (this.fidLength == 1 && n2 == 0) {
                return ".";
            }
            if (this.fidLength == 1 && n2 == 1) {
                return "..";
            }
        }
        String string = this.suParsed ? Util.getString(byArray, n + 34, this.fidLength) : Util.getDChars(byArray, n + 34, this.fidLength, this.fileSystem.getEncoding());
        int n3 = string.indexOf(ID_SEPARATOR1);
        int n4 = string.indexOf(ID_SEPARATOR2);
        if (n3 >= 0) {
            return string.substring(0, n3);
        }
        if (n4 >= 0) {
            return string.substring(0, n4);
        }
        return string;
    }

    public String getName() {
        if (this.fileSystem.suspUsed().booleanValue()) {
            if (this.rrnmFields.toArray().length == 0) {
                return this.identifier;
            }
            String string = "";
            for (RripFieldNM rripFieldNM : this.rrnmFields) {
                string = string + rripFieldNM.getNameContent();
                if (rripFieldNM.getFlagContinue()) continue;
                break;
            }
            return string;
        }
        return this.identifier;
    }

    public String getPath() {
        if (".".equals(this.getName())) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.parentPath) {
            stringBuffer.append(this.parentPath);
        }
        stringBuffer.append(this.getName());
        if (this.isDirectory()) {
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean isDirectory() {
        return (this.flags & 2) != 0;
    }

    public boolean isSymlink() {
        return this.rrpxField.isSymlink();
    }

    public String getSymlinkPath() {
        if (!this.isSymlink()) {
            throw new RuntimeException("This is not a symbolic link");
        }
        String string = "";
        boolean bl = true;
        for (RripFieldSL rripFieldSL : this.rrslFields) {
            if (!bl) {
                string = string + "/";
            }
            string = string + rripFieldSL.getPathname();
            if (!rripFieldSL.isContinuous()) break;
            bl = false;
        }
        return string;
    }

    public long getSize() {
        return this.dataLength;
    }

    public long getStartBlock() {
        return this.startSector;
    }

    public int getEntryLength() {
        return this.entryLength;
    }

    public final boolean isLastEntry() {
        return (this.flags & 0x40) == 0;
    }

    public List<SuspField> getSuspFields() {
        return this.suspFields;
    }

    public List<RripFieldNM> getRRNMFields() {
        return this.rrnmFields;
    }

    public boolean hasNMFields() {
        return this.rrnmFields.toArray().length > 0;
    }
}

