/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.StreamAttribute;
import org.tinymediamanager.library.bluray.playlist.StreamEntry;

public class SecondaryAudioStreamEntry {
    private int id;
    private StreamEntry streamEntry;
    private StreamAttribute streamAttribute;
    private int[] primaryAudioReferences;

    public SecondaryAudioStreamEntry() {
    }

    public SecondaryAudioStreamEntry(int n) {
        this.id = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        StreamEntry streamEntry = new StreamEntry();
        StreamAttribute streamAttribute = new StreamAttribute();
        streamEntry.readObject(dataInputStream);
        streamAttribute.readObject(dataInputStream);
        this.setStreamEntry(streamEntry);
        this.setStreamAttribute(streamAttribute);
        int n = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dataInputStream.readUnsignedByte();
            }
            if (n % 2 != 0) {
                dataInputStream.skipBytes(1);
            }
            this.setPrimaryAudioReferences(nArray);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        this.getStreamEntry().writeObject(dataOutputStream);
        this.getStreamAttribute().writeObject(dataOutputStream);
        int[] nArray = this.getPrimaryAudioReferences();
        if (nArray == null || nArray.length == 0) {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            return;
        }
        dataOutputStream.writeByte(nArray.length);
        dataOutputStream.writeByte(0);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeByte(nArray[i]);
            if (nArray.length % 2 == 0) continue;
            dataOutputStream.writeByte(0);
        }
    }

    @XmlAttribute
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public StreamEntry getStreamEntry() {
        return this.streamEntry;
    }

    public void setStreamEntry(StreamEntry streamEntry) {
        this.streamEntry = streamEntry;
    }

    public StreamAttribute getStreamAttribute() {
        return this.streamAttribute;
    }

    public void setStreamAttribute(StreamAttribute streamAttribute) {
        this.streamAttribute = streamAttribute;
    }

    public int[] getPrimaryAudioReferences() {
        return this.primaryAudioReferences;
    }

    public void setPrimaryAudioReferences(int[] nArray) {
        this.primaryAudioReferences = nArray;
    }
}

