/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client;

import com.amazonaws.services.iot.client.AWSIotDeviceErrorCode;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.core.AwsIotMessageCallback;
import com.amazonaws.services.iot.client.core.AwsIotRuntimeException;
import java.io.UnsupportedEncodingException;

public class AWSIotMessage
implements AwsIotMessageCallback {
    protected String topic;
    protected AWSIotQos qos;
    protected byte[] payload;
    protected AWSIotDeviceErrorCode errorCode;
    protected String errorMessage;

    public AWSIotMessage(String topic, AWSIotQos qos) {
        this.topic = topic;
        this.qos = qos;
    }

    public AWSIotMessage(String topic, AWSIotQos qos, byte[] payload) {
        this.topic = topic;
        this.qos = qos;
        this.setPayload(payload);
    }

    public AWSIotMessage(String topic, AWSIotQos qos, String payload) {
        this.topic = topic;
        this.qos = qos;
        this.setStringPayload(payload);
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            return null;
        }
        return (byte[])this.payload.clone();
    }

    public void setPayload(byte[] payload) {
        if (payload == null) {
            this.payload = null;
            return;
        }
        this.payload = (byte[])payload.clone();
    }

    public String getStringPayload() {
        String str;
        if (this.payload == null) {
            return null;
        }
        try {
            str = new String(this.payload, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AwsIotRuntimeException(e);
        }
        return str;
    }

    public void setStringPayload(String payload) {
        if (payload == null) {
            this.payload = null;
            return;
        }
        try {
            this.payload = payload.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AwsIotRuntimeException(e);
        }
    }

    @Override
    public void onSuccess() {
    }

    @Override
    public void onFailure() {
    }

    @Override
    public void onTimeout() {
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public AWSIotQos getQos() {
        return this.qos;
    }

    public void setQos(AWSIotQos qos) {
        this.qos = qos;
    }

    public AWSIotDeviceErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(AWSIotDeviceErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

