/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.wlan.Hotspot2ConfigDto;
import com.ubnt.model.api.wlan.Hotspot2VenueNameDto;
import com.ubnt.model.api.wlan.hotspot2.CellularNetworkDto;
import com.ubnt.model.api.wlan.hotspot2.ConnectionCapabilityDto;
import com.ubnt.model.api.wlan.hotspot2.FriendlyNameDto;
import com.ubnt.model.api.wlan.hotspot2.Hotspot2NetworkType;
import com.ubnt.model.api.wlan.hotspot2.Hotspot2VenueGroup;
import com.ubnt.model.api.wlan.hotspot2.IPv4AvailabilityAddressType;
import com.ubnt.model.api.wlan.hotspot2.IPv6AvailabilityAddressType;
import com.ubnt.model.api.wlan.hotspot2.MetricsInfo;
import com.ubnt.model.api.wlan.hotspot2.NaiRealmDto;
import com.ubnt.model.api.wlan.hotspot2.RoamingConsortiumDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Wlan Hotspot2 Config", description="Hotspot2 configuration details for WLAN network")
@Generated(from="Hotspot2ConfigDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableHotspot2ConfigDto
implements Hotspot2ConfigDto {
    private final List<Hotspot2VenueNameDto> venueNames;
    private final Hotspot2VenueGroup venueGroup;
    private final int venueType;
    private final Hotspot2NetworkType networkType;
    private final IPv4AvailabilityAddressType ipV4AddressTypeAvailability;
    private final IPv6AvailabilityAddressType ipV6AddressTypeAvailability;
    private final List<NaiRealmDto> naiRealmList;
    private final List<RoamingConsortiumDto> roamingConsortiumList;
    private final List<String> domainNameList;
    private final List<CellularNetworkDto> cellularNetworkList;
    private final List<FriendlyNameDto> friendlyName;
    private final boolean metricsStatus;
    @Nullable
    private final MetricsInfo metricsInfo;
    private final boolean metricsSymmetric;
    private final boolean metricsInfoAtCapacity;
    private final boolean metricsDownlinkSpeedEnabled;
    private final int metricsDownlinkSpeed;
    private final boolean metricsUplinkSpeedEnabled;
    private final int metricsUplinkSpeed;
    private final boolean metricsDownlinkLoadEnabled;
    private final int metricsDownlinkLoad;
    private final boolean metricsUplinkLoadEnabled;
    private final int metricsUplinkLoad;
    private final boolean metricsMeasurementEnabled;
    private final int metricsMeasurement;
    private final List<ConnectionCapabilityDto> connectionCapability;

    private ImmutableHotspot2ConfigDto(Builder builder) {
        this.venueNames = ImmutableHotspot2ConfigDto.o00000(true, builder.venueNames);
        this.venueGroup = builder.venueGroup;
        this.venueType = builder.venueType;
        this.networkType = builder.networkType;
        this.ipV4AddressTypeAvailability = builder.ipV4AddressTypeAvailability;
        this.ipV6AddressTypeAvailability = builder.ipV6AddressTypeAvailability;
        this.naiRealmList = ImmutableHotspot2ConfigDto.o00000(true, builder.naiRealmList);
        this.roamingConsortiumList = ImmutableHotspot2ConfigDto.o00000(true, builder.roamingConsortiumList);
        this.domainNameList = ImmutableHotspot2ConfigDto.o00000(true, builder.domainNameList);
        this.cellularNetworkList = ImmutableHotspot2ConfigDto.o00000(true, builder.cellularNetworkList);
        this.friendlyName = ImmutableHotspot2ConfigDto.o00000(true, builder.friendlyName);
        this.metricsStatus = builder.metricsStatus;
        this.metricsInfo = builder.metricsInfo;
        this.metricsSymmetric = builder.metricsSymmetric;
        this.metricsInfoAtCapacity = builder.metricsInfoAtCapacity;
        this.metricsDownlinkSpeedEnabled = builder.metricsDownlinkSpeedEnabled;
        this.metricsDownlinkSpeed = builder.metricsDownlinkSpeed;
        this.metricsUplinkSpeedEnabled = builder.metricsUplinkSpeedEnabled;
        this.metricsUplinkSpeed = builder.metricsUplinkSpeed;
        this.metricsDownlinkLoadEnabled = builder.metricsDownlinkLoadEnabled;
        this.metricsDownlinkLoad = builder.metricsDownlinkLoad;
        this.metricsUplinkLoadEnabled = builder.metricsUplinkLoadEnabled;
        this.metricsUplinkLoad = builder.metricsUplinkLoad;
        this.metricsMeasurementEnabled = builder.metricsMeasurementEnabled;
        this.metricsMeasurement = builder.metricsMeasurement;
        this.connectionCapability = ImmutableHotspot2ConfigDto.o00000(true, builder.connectionCapability);
    }

    @Override
    @Schema(name="Venue Name List")
    public List<Hotspot2VenueNameDto> venueNames() {
        return this.venueNames;
    }

    @Override
    @Schema(name="Venue Group")
    public Hotspot2VenueGroup venueGroup() {
        return this.venueGroup;
    }

    @Override
    @Schema(name="Venue Type based on venue group")
    public int venueType() {
        return this.venueType;
    }

    @Override
    @Schema(name="Network Type")
    public Hotspot2NetworkType networkType() {
        return this.networkType;
    }

    @Override
    @Schema(name="IPv4 Address Type Availability")
    public IPv4AvailabilityAddressType ipV4AddressTypeAvailability() {
        return this.ipV4AddressTypeAvailability;
    }

    @Override
    @Schema(name="IPv6 Address Type Availability")
    public IPv6AvailabilityAddressType ipV6AddressTypeAvailability() {
        return this.ipV6AddressTypeAvailability;
    }

    @Override
    @Schema(name="NAI Realm List")
    public List<NaiRealmDto> naiRealmList() {
        return this.naiRealmList;
    }

    @Override
    @Schema(name="Roaming Consortium List")
    public List<RoamingConsortiumDto> roamingConsortiumList() {
        return this.roamingConsortiumList;
    }

    @Override
    @Schema(name="Domain Name List")
    public List<String> domainNameList() {
        return this.domainNameList;
    }

    @Override
    @Schema(name="Cellular Network List")
    public List<CellularNetworkDto> cellularNetworkList() {
        return this.cellularNetworkList;
    }

    @Override
    @Schema(name="Friendly Name")
    public List<FriendlyNameDto> friendlyName() {
        return this.friendlyName;
    }

    @Override
    @Schema(name="Metrics Status")
    public boolean metricsStatus() {
        return this.metricsStatus;
    }

    @Override
    @Schema(name="Metrics Info")
    public Optional<MetricsInfo> metricsInfo() {
        return Optional.ofNullable(this.metricsInfo);
    }

    @Override
    @Schema(name="Metrics Symmetric")
    public boolean metricsSymmetric() {
        return this.metricsSymmetric;
    }

    @Override
    @Schema(name="Metrics Info At Capacity")
    public boolean metricsInfoAtCapacity() {
        return this.metricsInfoAtCapacity;
    }

    @Override
    @Schema(name="Metrics Downlink Speed Enabled")
    public boolean metricsDownlinkSpeedEnabled() {
        return this.metricsDownlinkSpeedEnabled;
    }

    @Override
    @Schema(name="Metrics Downlink Speed")
    public int metricsDownlinkSpeed() {
        return this.metricsDownlinkSpeed;
    }

    @Override
    @Schema(name="Metrics Uplink Speed Enabled")
    public boolean metricsUplinkSpeedEnabled() {
        return this.metricsUplinkSpeedEnabled;
    }

    @Override
    @Schema(name="Metrics Uplink Speed")
    public int metricsUplinkSpeed() {
        return this.metricsUplinkSpeed;
    }

    @Override
    @Schema(name="Metrics Downlink Load Enabled")
    public boolean metricsDownlinkLoadEnabled() {
        return this.metricsDownlinkLoadEnabled;
    }

    @Override
    @Schema(name="Metrics Downlink Load")
    public int metricsDownlinkLoad() {
        return this.metricsDownlinkLoad;
    }

    @Override
    @Schema(name="Metrics Uplink Load Enabled")
    public boolean metricsUplinkLoadEnabled() {
        return this.metricsUplinkLoadEnabled;
    }

    @Override
    @Schema(name="Metrics Uplink Load")
    public int metricsUplinkLoad() {
        return this.metricsUplinkLoad;
    }

    @Override
    @Schema(name="Metrics Measurement Enabled")
    public boolean metricsMeasurementEnabled() {
        return this.metricsMeasurementEnabled;
    }

    @Override
    @Schema(name="Metrics Measurement")
    public int metricsMeasurement() {
        return this.metricsMeasurement;
    }

    @Override
    @Schema(name="Connection Capability")
    public List<ConnectionCapabilityDto> connectionCapability() {
        return this.connectionCapability;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableHotspot2ConfigDto && this.\u00d200000(0, (ImmutableHotspot2ConfigDto)object);
    }

    private boolean \u00d200000(int n2, ImmutableHotspot2ConfigDto immutableHotspot2ConfigDto) {
        return this.venueNames.equals(immutableHotspot2ConfigDto.venueNames) && Objects.equals((Object)this.venueGroup, (Object)immutableHotspot2ConfigDto.venueGroup) && this.venueType == immutableHotspot2ConfigDto.venueType && Objects.equals((Object)this.networkType, (Object)immutableHotspot2ConfigDto.networkType) && Objects.equals((Object)this.ipV4AddressTypeAvailability, (Object)immutableHotspot2ConfigDto.ipV4AddressTypeAvailability) && Objects.equals((Object)this.ipV6AddressTypeAvailability, (Object)immutableHotspot2ConfigDto.ipV6AddressTypeAvailability) && this.naiRealmList.equals(immutableHotspot2ConfigDto.naiRealmList) && this.roamingConsortiumList.equals(immutableHotspot2ConfigDto.roamingConsortiumList) && this.domainNameList.equals(immutableHotspot2ConfigDto.domainNameList) && this.cellularNetworkList.equals(immutableHotspot2ConfigDto.cellularNetworkList) && this.friendlyName.equals(immutableHotspot2ConfigDto.friendlyName) && this.metricsStatus == immutableHotspot2ConfigDto.metricsStatus && Objects.equals((Object)this.metricsInfo, (Object)immutableHotspot2ConfigDto.metricsInfo) && this.metricsSymmetric == immutableHotspot2ConfigDto.metricsSymmetric && this.metricsInfoAtCapacity == immutableHotspot2ConfigDto.metricsInfoAtCapacity && this.metricsDownlinkSpeedEnabled == immutableHotspot2ConfigDto.metricsDownlinkSpeedEnabled && this.metricsDownlinkSpeed == immutableHotspot2ConfigDto.metricsDownlinkSpeed && this.metricsUplinkSpeedEnabled == immutableHotspot2ConfigDto.metricsUplinkSpeedEnabled && this.metricsUplinkSpeed == immutableHotspot2ConfigDto.metricsUplinkSpeed && this.metricsDownlinkLoadEnabled == immutableHotspot2ConfigDto.metricsDownlinkLoadEnabled && this.metricsDownlinkLoad == immutableHotspot2ConfigDto.metricsDownlinkLoad && this.metricsUplinkLoadEnabled == immutableHotspot2ConfigDto.metricsUplinkLoadEnabled && this.metricsUplinkLoad == immutableHotspot2ConfigDto.metricsUplinkLoad && this.metricsMeasurementEnabled == immutableHotspot2ConfigDto.metricsMeasurementEnabled && this.metricsMeasurement == immutableHotspot2ConfigDto.metricsMeasurement && this.connectionCapability.equals(immutableHotspot2ConfigDto.connectionCapability);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.venueNames.hashCode();
        n2 += (n2 << 5) + Objects.hashCode((Object)this.venueGroup);
        n2 += (n2 << 5) + this.venueType;
        n2 += (n2 << 5) + Objects.hashCode((Object)this.networkType);
        n2 += (n2 << 5) + Objects.hashCode((Object)this.ipV4AddressTypeAvailability);
        n2 += (n2 << 5) + Objects.hashCode((Object)this.ipV6AddressTypeAvailability);
        n2 += (n2 << 5) + this.naiRealmList.hashCode();
        n2 += (n2 << 5) + this.roamingConsortiumList.hashCode();
        n2 += (n2 << 5) + this.domainNameList.hashCode();
        n2 += (n2 << 5) + this.cellularNetworkList.hashCode();
        n2 += (n2 << 5) + this.friendlyName.hashCode();
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsStatus);
        n2 += (n2 << 5) + Objects.hashCode((Object)this.metricsInfo);
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsSymmetric);
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsInfoAtCapacity);
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsDownlinkSpeedEnabled);
        n2 += (n2 << 5) + this.metricsDownlinkSpeed;
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsUplinkSpeedEnabled);
        n2 += (n2 << 5) + this.metricsUplinkSpeed;
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsDownlinkLoadEnabled);
        n2 += (n2 << 5) + this.metricsDownlinkLoad;
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsUplinkLoadEnabled);
        n2 += (n2 << 5) + this.metricsUplinkLoad;
        n2 += (n2 << 5) + Boolean.hashCode(this.metricsMeasurementEnabled);
        n2 += (n2 << 5) + this.metricsMeasurement;
        n2 += (n2 << 5) + this.connectionCapability.hashCode();
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Hotspot2ConfigDto{");
        stringBuilder.append("venueNames=").append(this.venueNames);
        if (this.venueGroup != null) {
            stringBuilder.append(", ");
            stringBuilder.append("venueGroup=").append((Object)this.venueGroup);
        }
        stringBuilder.append(", ");
        stringBuilder.append("venueType=").append(this.venueType);
        if (this.networkType != null) {
            stringBuilder.append(", ");
            stringBuilder.append("networkType=").append((Object)this.networkType);
        }
        if (this.ipV4AddressTypeAvailability != null) {
            stringBuilder.append(", ");
            stringBuilder.append("ipV4AddressTypeAvailability=").append((Object)this.ipV4AddressTypeAvailability);
        }
        if (this.ipV6AddressTypeAvailability != null) {
            stringBuilder.append(", ");
            stringBuilder.append("ipV6AddressTypeAvailability=").append((Object)this.ipV6AddressTypeAvailability);
        }
        stringBuilder.append(", ");
        stringBuilder.append("naiRealmList=").append(this.naiRealmList);
        stringBuilder.append(", ");
        stringBuilder.append("roamingConsortiumList=").append(this.roamingConsortiumList);
        stringBuilder.append(", ");
        stringBuilder.append("domainNameList=").append(this.domainNameList);
        stringBuilder.append(", ");
        stringBuilder.append("cellularNetworkList=").append(this.cellularNetworkList);
        stringBuilder.append(", ");
        stringBuilder.append("friendlyName=").append(this.friendlyName);
        stringBuilder.append(", ");
        stringBuilder.append("metricsStatus=").append(this.metricsStatus);
        if (this.metricsInfo != null) {
            stringBuilder.append(", ");
            stringBuilder.append("metricsInfo=").append((Object)this.metricsInfo);
        }
        stringBuilder.append(", ");
        stringBuilder.append("metricsSymmetric=").append(this.metricsSymmetric);
        stringBuilder.append(", ");
        stringBuilder.append("metricsInfoAtCapacity=").append(this.metricsInfoAtCapacity);
        stringBuilder.append(", ");
        stringBuilder.append("metricsDownlinkSpeedEnabled=").append(this.metricsDownlinkSpeedEnabled);
        stringBuilder.append(", ");
        stringBuilder.append("metricsDownlinkSpeed=").append(this.metricsDownlinkSpeed);
        stringBuilder.append(", ");
        stringBuilder.append("metricsUplinkSpeedEnabled=").append(this.metricsUplinkSpeedEnabled);
        stringBuilder.append(", ");
        stringBuilder.append("metricsUplinkSpeed=").append(this.metricsUplinkSpeed);
        stringBuilder.append(", ");
        stringBuilder.append("metricsDownlinkLoadEnabled=").append(this.metricsDownlinkLoadEnabled);
        stringBuilder.append(", ");
        stringBuilder.append("metricsDownlinkLoad=").append(this.metricsDownlinkLoad);
        stringBuilder.append(", ");
        stringBuilder.append("metricsUplinkLoadEnabled=").append(this.metricsUplinkLoadEnabled);
        stringBuilder.append(", ");
        stringBuilder.append("metricsUplinkLoad=").append(this.metricsUplinkLoad);
        stringBuilder.append(", ");
        stringBuilder.append("metricsMeasurementEnabled=").append(this.metricsMeasurementEnabled);
        stringBuilder.append(", ");
        stringBuilder.append("metricsMeasurement=").append(this.metricsMeasurement);
        stringBuilder.append(", ");
        stringBuilder.append("connectionCapability=").append(this.connectionCapability);
        return stringBuilder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00d300000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> o00000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Hotspot2ConfigDto", generator="Immutables")
    public static final class Builder {
        private List<Hotspot2VenueNameDto> venueNames = new ArrayList<Hotspot2VenueNameDto>();
        @Nullable
        private Hotspot2VenueGroup venueGroup;
        private int venueType;
        @Nullable
        private Hotspot2NetworkType networkType;
        @Nullable
        private IPv4AvailabilityAddressType ipV4AddressTypeAvailability;
        @Nullable
        private IPv6AvailabilityAddressType ipV6AddressTypeAvailability;
        private List<NaiRealmDto> naiRealmList = new ArrayList<NaiRealmDto>();
        private List<RoamingConsortiumDto> roamingConsortiumList = new ArrayList<RoamingConsortiumDto>();
        private List<String> domainNameList = new ArrayList<String>();
        private List<CellularNetworkDto> cellularNetworkList = new ArrayList<CellularNetworkDto>();
        private List<FriendlyNameDto> friendlyName = new ArrayList<FriendlyNameDto>();
        private boolean metricsStatus;
        @Nullable
        private MetricsInfo metricsInfo;
        private boolean metricsSymmetric;
        private boolean metricsInfoAtCapacity;
        private boolean metricsDownlinkSpeedEnabled;
        private int metricsDownlinkSpeed;
        private boolean metricsUplinkSpeedEnabled;
        private int metricsUplinkSpeed;
        private boolean metricsDownlinkLoadEnabled;
        private int metricsDownlinkLoad;
        private boolean metricsUplinkLoadEnabled;
        private int metricsUplinkLoad;
        private boolean metricsMeasurementEnabled;
        private int metricsMeasurement;
        private List<ConnectionCapabilityDto> connectionCapability = new ArrayList<ConnectionCapabilityDto>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Hotspot2ConfigDto hotspot2ConfigDto) {
            IPv6AvailabilityAddressType iPv6AvailabilityAddressType;
            IPv4AvailabilityAddressType iPv4AvailabilityAddressType;
            Objects.requireNonNull(hotspot2ConfigDto, "instance");
            this.addAllVenueNames(hotspot2ConfigDto.venueNames());
            Hotspot2VenueGroup hotspot2VenueGroup = hotspot2ConfigDto.venueGroup();
            if (hotspot2VenueGroup != null) {
                this.venueGroup(hotspot2VenueGroup);
            }
            this.venueType(hotspot2ConfigDto.venueType());
            Hotspot2NetworkType hotspot2NetworkType = hotspot2ConfigDto.networkType();
            if (hotspot2NetworkType != null) {
                this.networkType(hotspot2NetworkType);
            }
            if ((iPv4AvailabilityAddressType = hotspot2ConfigDto.ipV4AddressTypeAvailability()) != null) {
                this.ipV4AddressTypeAvailability(iPv4AvailabilityAddressType);
            }
            if ((iPv6AvailabilityAddressType = hotspot2ConfigDto.ipV6AddressTypeAvailability()) != null) {
                this.ipV6AddressTypeAvailability(iPv6AvailabilityAddressType);
            }
            this.addAllNaiRealmList(hotspot2ConfigDto.naiRealmList());
            this.addAllRoamingConsortiumList(hotspot2ConfigDto.roamingConsortiumList());
            this.addAllDomainNameList(hotspot2ConfigDto.domainNameList());
            this.addAllCellularNetworkList(hotspot2ConfigDto.cellularNetworkList());
            this.addAllFriendlyName(hotspot2ConfigDto.friendlyName());
            this.metricsStatus(hotspot2ConfigDto.metricsStatus());
            Optional<MetricsInfo> optional = hotspot2ConfigDto.metricsInfo();
            if (optional.isPresent()) {
                this.metricsInfo(optional);
            }
            this.metricsSymmetric(hotspot2ConfigDto.metricsSymmetric());
            this.metricsInfoAtCapacity(hotspot2ConfigDto.metricsInfoAtCapacity());
            this.metricsDownlinkSpeedEnabled(hotspot2ConfigDto.metricsDownlinkSpeedEnabled());
            this.metricsDownlinkSpeed(hotspot2ConfigDto.metricsDownlinkSpeed());
            this.metricsUplinkSpeedEnabled(hotspot2ConfigDto.metricsUplinkSpeedEnabled());
            this.metricsUplinkSpeed(hotspot2ConfigDto.metricsUplinkSpeed());
            this.metricsDownlinkLoadEnabled(hotspot2ConfigDto.metricsDownlinkLoadEnabled());
            this.metricsDownlinkLoad(hotspot2ConfigDto.metricsDownlinkLoad());
            this.metricsUplinkLoadEnabled(hotspot2ConfigDto.metricsUplinkLoadEnabled());
            this.metricsUplinkLoad(hotspot2ConfigDto.metricsUplinkLoad());
            this.metricsMeasurementEnabled(hotspot2ConfigDto.metricsMeasurementEnabled());
            this.metricsMeasurement(hotspot2ConfigDto.metricsMeasurement());
            this.addAllConnectionCapability(hotspot2ConfigDto.connectionCapability());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVenueNames(@Nullable Hotspot2VenueNameDto hotspot2VenueNameDto) {
            this.venueNames.add(hotspot2VenueNameDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVenueNames(Hotspot2VenueNameDto ... hotspot2VenueNameDtoArray) {
            for (Hotspot2VenueNameDto hotspot2VenueNameDto : hotspot2VenueNameDtoArray) {
                this.venueNames.add(hotspot2VenueNameDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder venueNames(Iterable<? extends Hotspot2VenueNameDto> iterable) {
            this.venueNames.clear();
            return this.addAllVenueNames(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllVenueNames(Iterable<? extends Hotspot2VenueNameDto> iterable) {
            for (Hotspot2VenueNameDto hotspot2VenueNameDto : iterable) {
                this.venueNames.add(hotspot2VenueNameDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder venueGroup(Hotspot2VenueGroup hotspot2VenueGroup) {
            this.venueGroup = hotspot2VenueGroup;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder venueType(int n2) {
            this.venueType = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder networkType(Hotspot2NetworkType hotspot2NetworkType) {
            this.networkType = hotspot2NetworkType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipV4AddressTypeAvailability(IPv4AvailabilityAddressType iPv4AvailabilityAddressType) {
            this.ipV4AddressTypeAvailability = iPv4AvailabilityAddressType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipV6AddressTypeAvailability(IPv6AvailabilityAddressType iPv6AvailabilityAddressType) {
            this.ipV6AddressTypeAvailability = iPv6AvailabilityAddressType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNaiRealmList(@Nullable NaiRealmDto naiRealmDto) {
            this.naiRealmList.add(naiRealmDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNaiRealmList(NaiRealmDto ... naiRealmDtoArray) {
            for (NaiRealmDto naiRealmDto : naiRealmDtoArray) {
                this.naiRealmList.add(naiRealmDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder naiRealmList(Iterable<? extends NaiRealmDto> iterable) {
            this.naiRealmList.clear();
            return this.addAllNaiRealmList(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNaiRealmList(Iterable<? extends NaiRealmDto> iterable) {
            for (NaiRealmDto naiRealmDto : iterable) {
                this.naiRealmList.add(naiRealmDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoamingConsortiumList(@Nullable RoamingConsortiumDto roamingConsortiumDto) {
            this.roamingConsortiumList.add(roamingConsortiumDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoamingConsortiumList(RoamingConsortiumDto ... roamingConsortiumDtoArray) {
            for (RoamingConsortiumDto roamingConsortiumDto : roamingConsortiumDtoArray) {
                this.roamingConsortiumList.add(roamingConsortiumDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roamingConsortiumList(Iterable<? extends RoamingConsortiumDto> iterable) {
            this.roamingConsortiumList.clear();
            return this.addAllRoamingConsortiumList(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoamingConsortiumList(Iterable<? extends RoamingConsortiumDto> iterable) {
            for (RoamingConsortiumDto roamingConsortiumDto : iterable) {
                this.roamingConsortiumList.add(roamingConsortiumDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDomainNameList(@Nullable String string) {
            this.domainNameList.add(string);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDomainNameList(String ... stringArray) {
            for (String string : stringArray) {
                this.domainNameList.add(string);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder domainNameList(Iterable<String> iterable) {
            this.domainNameList.clear();
            return this.addAllDomainNameList(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDomainNameList(Iterable<String> iterable) {
            for (String string : iterable) {
                this.domainNameList.add(string);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCellularNetworkList(@Nullable CellularNetworkDto cellularNetworkDto) {
            this.cellularNetworkList.add(cellularNetworkDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCellularNetworkList(CellularNetworkDto ... cellularNetworkDtoArray) {
            for (CellularNetworkDto cellularNetworkDto : cellularNetworkDtoArray) {
                this.cellularNetworkList.add(cellularNetworkDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cellularNetworkList(Iterable<? extends CellularNetworkDto> iterable) {
            this.cellularNetworkList.clear();
            return this.addAllCellularNetworkList(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCellularNetworkList(Iterable<? extends CellularNetworkDto> iterable) {
            for (CellularNetworkDto cellularNetworkDto : iterable) {
                this.cellularNetworkList.add(cellularNetworkDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFriendlyName(@Nullable FriendlyNameDto friendlyNameDto) {
            this.friendlyName.add(friendlyNameDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFriendlyName(FriendlyNameDto ... friendlyNameDtoArray) {
            for (FriendlyNameDto friendlyNameDto : friendlyNameDtoArray) {
                this.friendlyName.add(friendlyNameDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder friendlyName(Iterable<? extends FriendlyNameDto> iterable) {
            this.friendlyName.clear();
            return this.addAllFriendlyName(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFriendlyName(Iterable<? extends FriendlyNameDto> iterable) {
            for (FriendlyNameDto friendlyNameDto : iterable) {
                this.friendlyName.add(friendlyNameDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsStatus(boolean bl) {
            this.metricsStatus = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsInfo(@Nullable MetricsInfo metricsInfo) {
            this.metricsInfo = metricsInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsInfo(Optional<? extends MetricsInfo> optional) {
            this.metricsInfo = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsSymmetric(boolean bl) {
            this.metricsSymmetric = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsInfoAtCapacity(boolean bl) {
            this.metricsInfoAtCapacity = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsDownlinkSpeedEnabled(boolean bl) {
            this.metricsDownlinkSpeedEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsDownlinkSpeed(int n2) {
            this.metricsDownlinkSpeed = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsUplinkSpeedEnabled(boolean bl) {
            this.metricsUplinkSpeedEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsUplinkSpeed(int n2) {
            this.metricsUplinkSpeed = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsDownlinkLoadEnabled(boolean bl) {
            this.metricsDownlinkLoadEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsDownlinkLoad(int n2) {
            this.metricsDownlinkLoad = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsUplinkLoadEnabled(boolean bl) {
            this.metricsUplinkLoadEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsUplinkLoad(int n2) {
            this.metricsUplinkLoad = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsMeasurementEnabled(boolean bl) {
            this.metricsMeasurementEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsMeasurement(int n2) {
            this.metricsMeasurement = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConnectionCapability(@Nullable ConnectionCapabilityDto connectionCapabilityDto) {
            this.connectionCapability.add(connectionCapabilityDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConnectionCapability(ConnectionCapabilityDto ... connectionCapabilityDtoArray) {
            for (ConnectionCapabilityDto connectionCapabilityDto : connectionCapabilityDtoArray) {
                this.connectionCapability.add(connectionCapabilityDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionCapability(Iterable<? extends ConnectionCapabilityDto> iterable) {
            this.connectionCapability.clear();
            return this.addAllConnectionCapability(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConnectionCapability(Iterable<? extends ConnectionCapabilityDto> iterable) {
            for (ConnectionCapabilityDto connectionCapabilityDto : iterable) {
                this.connectionCapability.add(connectionCapabilityDto);
            }
            return this;
        }

        public ImmutableHotspot2ConfigDto build() {
            return new ImmutableHotspot2ConfigDto(this);
        }
    }
}

