/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.port;

import com.ubnt.data.Site;
import com.ubnt.model.api.alert.AlertListDto;
import com.ubnt.model.api.alert.PortAlertListParameterDto;
import com.ubnt.model.api.port.DeviceMacTablesDto;
import com.ubnt.model.api.port.DeviceMacTablesParameterDto;
import com.ubnt.net.security.role.D;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.alert.T;
import com.ubnt.service.alert.p;
import com.ubnt.service.alert.superObject;
import com.ubnt.service.port.insight.super;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Ports Insight")
public class PortsInsightController {
    private final superObject new;
    private final p o00000;
    private final super \u00d400000;
    private final com.ubnt.net.security.role.super \u00d300000;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/ports/mac-tables"})
    @Operation(summary="Retrieve MAC tables of specific devices and ports", description="Since 9.4.4")
    public List<DeviceMacTablesDto> retrieveMacTables(@PathVariable(value="siteName") Site site, @RequestBody @Valid List<DeviceMacTablesParameterDto> list) {
        Map<String, List<Integer>> map = list.stream().collect(Collectors.toMap(DeviceMacTablesParameterDto::getMac, DeviceMacTablesParameterDto::getPortIndexes));
        return this.\u00d400000.\u00d400000(site.getId(), map);
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/ports/system-logs"})
    @Operation(summary="Retrieve system-logs of specific device port", description="Since 10.0.65")
    public AlertListDto listAllSystemLogsOfPort(@PathVariable(value="siteName") Site site, @RequestBody @Valid PortAlertListParameterDto portAlertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        D d2 = this.super(site, httpServletRequest, httpServletResponse);
        T t2 = this.o00000.oO0000(site.getId(), portAlertListParameterDto, d2);
        return AlertListDto.builder().totalElementCount(t2.\u00d300000()).totalPageCount(t2.String()).pageNumber(t2.o00000()).data(this.new.String(t2.\u00d200000(), false)).build();
    }

    private D super(Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d300000.Object(httpServletRequest, httpServletResponse, site.getId());
    }

    @ConstructorProperties(value={"alertDocumentMapper", "alertSearchService", "portsInsightService", "roleManager"})
    @Generated
    public PortsInsightController(superObject superObject2, p p2, super super_, com.ubnt.net.security.role.super super_2) {
        this.new = superObject2;
        this.o00000 = p2;
        this.\u00d400000 = super_;
        this.\u00d300000 = super_2;
    }
}

