/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.switchacl;

import com.ubnt.data.Device;
import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.switchacl.AclEntryCount;
import com.ubnt.model.api.switchacl.AclRuleDto;
import com.ubnt.model.api.switchacl.BatchAclRuleUpdatePartDto;
import com.ubnt.model.api.switchacl.CombinedAclRuleOriginType;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.config.do;
import com.ubnt.service.devmgr.supervoid;
import com.ubnt.service.object.oriented.network.O0OO;
import com.ubnt.service.setting.while.B;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.D;
import com.ubnt.service.switchacl.Stringsuper;
import com.ubnt.service.switchacl.public;
import com.ubnt.service.system.setting.null;
import com.ubnt.service.system.setting.oO0O;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="Switch ACL Rules")
public class AclRuleController {
    private final public o00000;
    private final Stringsuper \u00d300000;
    private final supervoid \u00d800000;
    private final B \u00d500000;
    private final oO0O \u00d600000;
    private final O0OO String;
    private final do \u00d200000;

    public AclRuleController(public public_, Stringsuper stringsuper, supervoid supervoid2, B b2, oO0O oO0O2, O0OO o0OO2, do do_) {
        this.o00000 = public_;
        this.\u00d300000 = stringsuper;
        this.\u00d800000 = supervoid2;
        this.\u00d500000 = b2;
        this.\u00d600000 = oO0O2;
        this.String = o0OO2;
        this.\u00d200000 = do_;
    }

    @GetMapping(value={"/api/site/{siteName}/{mac}/acl-entry-count"})
    @Operation(summary="ACL Entry Count")
    public AclEntryCount getAclEntryCount(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        String string2 = site.getId();
        if (!this.\u00d800000.O\u00f8OO00(string2, string, Device::supportsSwitchAccessControlList)) {
            return AclEntryCount.empty();
        }
        Setting setting = this.\u00d600000.\u00d300000(null.\u00f8O0000, string2);
        int n2 = this.\u00d500000.\u00d300000(string2, setting);
        int n3 = this.\u00d300000.\u00d500000(string2, string);
        return AclEntryCount.builder().globalAclEntryCount(n2).customIpAclEntryCount(n3).customMacAclEntryCount(0).build();
    }

    @GetMapping(value={"/api/site/{siteName}/acl-rules"})
    @Operation(summary="List ACL Rules")
    public List<AclRuleDto> listAclRules(@PathVariable(value="siteName") Site site) {
        Stream<AclRuleDto> stream = this.Object(site);
        Stream<AclRuleDto> stream2 = this.o00000(site);
        return Stream.concat(stream, stream2).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Create a new ACL Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public AclRuleDto createAclRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDocument aclRuleDocument = this.o00000.\u00d800000(aclRuleDto.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"}, consumes={"application/json"})
    @Operation(summary="Update ACL Rule")
    public AclRuleDto updateAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDto aclRuleDto2 = AclRuleDto.withId(aclRuleDto, string);
        AclRuleDocument aclRuleDocument = this.o00000.super(aclRuleDto2.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Update Selected Properties of ACL Rules in Batch")
    public List<AclRuleDto> batchUpdateAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<BatchAclRuleUpdatePartDto> list) {
        List<D> list2 = list.stream().map(BatchAclRuleUpdatePartDto::toBatchUpdatePart).toList();
        return this.o00000.\u00d600000(site.getId(), list2).stream().map(AclRuleDto::fromDocument).toList();
    }

    @DeleteMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"})
    @Operation(summary="Delete ACL Rule")
    public void deleteAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        this.o00000.\u00d400000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules/batch-delete"}, consumes={"application/json"})
    @Operation(summary="Delete ACL Rules in Batch")
    public void deleteAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<String> list) {
        this.o00000.\u00d300000(site.getId(), list);
    }

    private Stream<AclRuleDto> o00000(Site site) {
        Device device = this.\u00d800000.\u00f4\u00f4OO00(site.getId());
        if (device == null) {
            return Stream.empty();
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return this.String.\u00d300000(this.\u00d200000.\u00d600000(device)).stream().map(aclRuleDocument -> AclRuleDto.builderFromDocument(aclRuleDocument).predefined(true).originType(CombinedAclRuleOriginType.OBJECT_ACL_RULE).originId(aclRuleDocument.getId()).id("obj_" + aclRuleDocument.getId() + "_" + atomicInteger.incrementAndGet()).build());
    }

    private Stream<AclRuleDto> Object(Site site) {
        return this.o00000.class(site.getId()).stream().map(AclRuleDto::fromDocument);
    }
}

