/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.lang.annotation.ElementType;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@ApiStatus.Internal
class ModClassVisitor
extends ClassVisitor {
    private Type asmType;
    private Type asmSuperType;
    private Set<Type> interfaces;
    private final LinkedList<ModAnnotation> annotations = new LinkedList();

    ModClassVisitor() {
        super(589824);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.asmType = Type.getObjectType((String)name);
        this.asmSuperType = superName != null && !superName.isEmpty() ? Type.getObjectType((String)superName) : null;
        this.interfaces = Stream.of(interfaces).map(Type::getObjectType).collect(Collectors.toSet());
    }

    public AnnotationVisitor visitAnnotation(String annotationName, boolean runtimeVisible) {
        ModAnnotation ann = new ModAnnotation(ElementType.TYPE, Type.getType((String)annotationName), this.asmType.getClassName());
        this.annotations.addFirst(ann);
        return new ModAnnotationVisitor(ann);
    }

    public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
        return new FieldVisitor(589824){

            public AnnotationVisitor visitAnnotation(String annotationName, boolean runtimeVisible) {
                ModAnnotation ann = new ModAnnotation(ElementType.FIELD, Type.getType((String)annotationName), name);
                ModClassVisitor.this.annotations.addFirst(ann);
                return new ModAnnotationVisitor(ann);
            }
        };
    }

    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        return new MethodVisitor(589824){

            public AnnotationVisitor visitAnnotation(String annotationName, boolean runtimeVisible) {
                ModAnnotation ann = new ModAnnotation(ElementType.METHOD, Type.getType((String)annotationName), name + desc);
                ModClassVisitor.this.annotations.addFirst(ann);
                return new ModAnnotationVisitor(ann);
            }
        };
    }

    public void buildData(Set<ModFileScanData.ClassData> classes, Set<ModFileScanData.AnnotationData> baked) {
        classes.add(new ModFileScanData.ClassData(this.asmType, this.asmSuperType, this.interfaces));
        for (ModAnnotation a : this.annotations) {
            baked.add(ModAnnotation.fromModAnnotation(this.asmType, a));
        }
    }

    private class ModAnnotationVisitor
    extends AnnotationVisitor {
        private final ModAnnotation annotation;
        private boolean array;
        private boolean isSubAnnotation;

        public ModAnnotationVisitor(ModAnnotation annotation) {
            super(589824);
            this.annotation = annotation;
        }

        public ModAnnotationVisitor(ModAnnotation annotation, String name) {
            this(annotation);
            this.array = true;
            annotation.addArray(name);
        }

        public ModAnnotationVisitor(ModAnnotation annotation, boolean isSubAnnotation) {
            this(annotation);
            this.isSubAnnotation = true;
        }

        public void visit(String key, Object value) {
            this.annotation.addProperty(key, value);
        }

        public void visitEnum(String name, String desc, String value) {
            this.annotation.addEnumProperty(name, desc, value);
        }

        public AnnotationVisitor visitArray(String name) {
            return new ModAnnotationVisitor(this.annotation, name);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            ModAnnotation ma = ModClassVisitor.this.annotations.getFirst();
            ModAnnotation childAnnotation = ma.addChildAnnotation(name, desc);
            ModClassVisitor.this.annotations.addFirst(childAnnotation);
            return new ModAnnotationVisitor(childAnnotation, true);
        }

        public void visitEnd() {
            if (this.array) {
                this.annotation.endArray();
            }
            if (this.isSubAnnotation) {
                ModClassVisitor.this.annotations.addLast(ModClassVisitor.this.annotations.removeFirst());
            }
        }
    }
}

