/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.List;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.IModLoadingState;
import net.minecraftforge.fml.IModStateProvider;
import net.minecraftforge.fml.ModLoadingPhase;
import net.minecraftforge.fml.ModLoadingState;
import net.minecraftforge.fml.core.ModStateProvider;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryManager;

public class ForgeStatesProvider
implements IModStateProvider {
    public static final ModLoadingState CREATE_REGISTRIES = ForgeStatesProvider.gather("CREATE_REGISTRIES", ModStateProvider.CONSTRUCT, RegistryManager::postNewRegistryEvent);
    public static final ModLoadingState OBJECT_HOLDERS = ForgeStatesProvider.gather("OBJECT_HOLDERS", CREATE_REGISTRIES, ObjectHolderRegistry::findObjectHolders);
    public static final ModLoadingState INJECT_CAPABILITIES = ForgeStatesProvider.gather("INJECT_CAPABILITIES", OBJECT_HOLDERS).withInline(CapabilityManager::injectCapabilities);
    public static final ModLoadingState UNFREEZE_DATA = ForgeStatesProvider.gather("UNFREEZE_DATA", INJECT_CAPABILITIES, GameData::unfreezeData);
    public static final ModLoadingState LOAD_REGISTRIES = ForgeStatesProvider.gather("LOAD_REGISTRIES", UNFREEZE_DATA, GameData::postRegisterEvents);
    public static final ModLoadingState FREEZE_DATA = ForgeStatesProvider.complete("FREEZE_DATA", ModStateProvider.COMPLETE, GameData::freezeData);
    public static final ModLoadingState NETWORK_LOCK = ForgeStatesProvider.complete("NETWORK_LOCK", FREEZE_DATA, NetworkRegistry::lock);

    private static ModLoadingState.Builder gather(String name, ModLoadingState after) {
        return ModLoadingState.of((String)name, (ModLoadingPhase)ModLoadingPhase.GATHER).after(after);
    }

    private static ModLoadingState gather(String name, ModLoadingState after, Runnable inline) {
        return ForgeStatesProvider.gather(name, after).withInline(ml -> inline.run());
    }

    private static ModLoadingState.Builder complete(String name, ModLoadingState after) {
        return ModLoadingState.of((String)name, (ModLoadingPhase)ModLoadingPhase.COMPLETE).after(after);
    }

    private static ModLoadingState complete(String name, ModLoadingState after, Runnable inline) {
        return ForgeStatesProvider.complete(name, after).withInline(ml -> inline.run());
    }

    public List<IModLoadingState> getAllStates() {
        return List.of(CREATE_REGISTRIES, OBJECT_HOLDERS, INJECT_CAPABILITIES, UNFREEZE_DATA, LOAD_REGISTRIES, FREEZE_DATA, NETWORK_LOCK);
    }
}

