/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.EventBusMigrationHelper;
import net.minecraftforge.common.TagConventionMigrationHelper;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.DualStackUtils;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class MinecraftForge {
    public static final EventBusMigrationHelper EVENT_BUS = EventBusMigrationHelper.INSTANCE;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGE = MarkerManager.getMarker((String)"FORGE");

    public static void initialize() {
        LOGGER.info(FORGE, "MinecraftForge v{} Initialized", (Object)ForgeVersion.getVersion());
        UsernameCache.load();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientCommandHandler.init();
        }
        DualStackUtils.initialise();
        TagConventionMigrationHelper.init();
    }

    public static void registerConfigScreen(Function<Screen, Screen> screenFunction) {
        MinecraftForge.registerConfigScreen((Minecraft mcClient, Screen modsScreen) -> (Screen)screenFunction.apply((Screen)modsScreen));
    }

    public static void registerConfigScreen(BiFunction<Minecraft, Screen, Screen> screenFunction) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(screenFunction));
    }
}

