/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ForgeBiomeTagsProvider
extends BiomeTagsProvider {
    public ForgeBiomeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider lookupProvider) {
        this.tag(Tags.Biomes.NO_DEFAULT_MONSTERS).add((Object)Biomes.MUSHROOM_FIELDS).add((Object)Biomes.DEEP_DARK);
        this.tag(Tags.Biomes.HIDDEN_FROM_LOCATOR_SELECTION);
        this.tag(Tags.Biomes.IS_VOID).add((Object)Biomes.THE_VOID);
        this.tag(Tags.Biomes.IS_END).addTag(BiomeTags.IS_END);
        this.tag(Tags.Biomes.IS_NETHER).addTag(BiomeTags.IS_NETHER);
        this.tag(Tags.Biomes.IS_OVERWORLD).addTag(BiomeTags.IS_OVERWORLD);
        this.tag(Tags.Biomes.IS_HOT_OVERWORLD).add((Object)Biomes.SWAMP).add((Object)Biomes.MANGROVE_SWAMP).add((Object)Biomes.JUNGLE).add((Object)Biomes.BAMBOO_JUNGLE).add((Object)Biomes.SPARSE_JUNGLE).add((Object)Biomes.DESERT).add((Object)Biomes.BADLANDS).add((Object)Biomes.WOODED_BADLANDS).add((Object)Biomes.ERODED_BADLANDS).add((Object)Biomes.SAVANNA).add((Object)Biomes.SAVANNA_PLATEAU).add((Object)Biomes.WINDSWEPT_SAVANNA).add((Object)Biomes.STONY_PEAKS).add((Object)Biomes.WARM_OCEAN).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"));
        this.tag(Tags.Biomes.IS_HOT_NETHER).add((Object)Biomes.NETHER_WASTES).add((Object)Biomes.CRIMSON_FOREST).add((Object)Biomes.WARPED_FOREST).add((Object)Biomes.SOUL_SAND_VALLEY).add((Object)Biomes.BASALT_DELTAS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"));
        this.tag(Tags.Biomes.IS_HOT_END);
        this.tag(Tags.Biomes.IS_HOT).addTag(Tags.Biomes.IS_HOT_OVERWORLD).addTag(Tags.Biomes.IS_HOT_NETHER).addOptionalTag(Tags.Biomes.IS_HOT_END);
        this.tag(Tags.Biomes.IS_COLD_OVERWORLD).add((Object)Biomes.TAIGA).add((Object)Biomes.OLD_GROWTH_PINE_TAIGA).add((Object)Biomes.OLD_GROWTH_SPRUCE_TAIGA).add((Object)Biomes.WINDSWEPT_HILLS).add((Object)Biomes.WINDSWEPT_GRAVELLY_HILLS).add((Object)Biomes.WINDSWEPT_FOREST).add((Object)Biomes.SNOWY_PLAINS).add((Object)Biomes.ICE_SPIKES).add((Object)Biomes.GROVE).add((Object)Biomes.SNOWY_SLOPES).add((Object)Biomes.JAGGED_PEAKS).add((Object)Biomes.FROZEN_PEAKS).add((Object)Biomes.STONY_SHORE).add((Object)Biomes.SNOWY_BEACH).add((Object)Biomes.SNOWY_TAIGA).add((Object)Biomes.FROZEN_RIVER).add((Object)Biomes.COLD_OCEAN).add((Object)Biomes.FROZEN_OCEAN).add((Object)Biomes.DEEP_COLD_OCEAN).add((Object)Biomes.DEEP_FROZEN_OCEAN).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag(Tags.Biomes.IS_COLD_NETHER);
        this.tag(Tags.Biomes.IS_COLD_END).add((Object)Biomes.THE_END).add((Object)Biomes.SMALL_END_ISLANDS).add((Object)Biomes.END_MIDLANDS).add((Object)Biomes.END_HIGHLANDS).add((Object)Biomes.END_BARRENS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"));
        this.tag(Tags.Biomes.IS_COLD).addTag(Tags.Biomes.IS_COLD_OVERWORLD).addOptionalTag(Tags.Biomes.IS_COLD_NETHER).addTag(Tags.Biomes.IS_COLD_END);
        this.tag(Tags.Biomes.IS_DEAD).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dead"));
        this.tag(Tags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD).add((Object)Biomes.WOODED_BADLANDS).add((Object)Biomes.SAVANNA).add((Object)Biomes.SAVANNA_PLATEAU).add((Object)Biomes.SPARSE_JUNGLE).add((Object)Biomes.WINDSWEPT_SAVANNA).add((Object)Biomes.WINDSWEPT_FOREST).add((Object)Biomes.WINDSWEPT_HILLS).add((Object)Biomes.WINDSWEPT_GRAVELLY_HILLS).add((Object)Biomes.SNOWY_SLOPES).add((Object)Biomes.JAGGED_PEAKS).add((Object)Biomes.FROZEN_PEAKS);
        this.tag(Tags.Biomes.IS_SPARSE_NETHER);
        this.tag(Tags.Biomes.IS_SPARSE_END);
        this.tag(Tags.Biomes.IS_SPARSE_VEGETATION).addTag(Tags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD).addOptionalTag(Tags.Biomes.IS_SPARSE_NETHER).addOptionalTag(Tags.Biomes.IS_SPARSE_END);
        this.tag(Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD).add((Object)Biomes.DARK_FOREST).add((Object)Biomes.OLD_GROWTH_BIRCH_FOREST).add((Object)Biomes.OLD_GROWTH_SPRUCE_TAIGA).add((Object)Biomes.JUNGLE).add((Object)Biomes.BAMBOO_JUNGLE).add((Object)Biomes.MANGROVE_SWAMP).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"));
        this.tag(Tags.Biomes.IS_DENSE_NETHER);
        this.tag(Tags.Biomes.IS_DENSE_END);
        this.tag(Tags.Biomes.IS_DENSE_VEGETATION).addTag(Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD).addOptionalTag(Tags.Biomes.IS_DENSE_NETHER).addOptionalTag(Tags.Biomes.IS_DENSE_END);
        this.tag(Tags.Biomes.IS_WET_OVERWORLD).add((Object)Biomes.SWAMP).add((Object)Biomes.MANGROVE_SWAMP).add((Object)Biomes.JUNGLE).add((Object)Biomes.BAMBOO_JUNGLE).add((Object)Biomes.SPARSE_JUNGLE).add((Object)Biomes.BEACH).add((Object)Biomes.LUSH_CAVES).add((Object)Biomes.DRIPSTONE_CAVES).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"));
        this.tag(Tags.Biomes.IS_WET_NETHER);
        this.tag(Tags.Biomes.IS_WET_END);
        this.tag(Tags.Biomes.IS_WET).addTag(Tags.Biomes.IS_WET_OVERWORLD).addOptionalTag(Tags.Biomes.IS_WET_NETHER).addOptionalTag(Tags.Biomes.IS_WET_END);
        this.tag(Tags.Biomes.IS_DRY_OVERWORLD).add((Object)Biomes.DESERT).add((Object)Biomes.BADLANDS).add((Object)Biomes.WOODED_BADLANDS).add((Object)Biomes.ERODED_BADLANDS).add((Object)Biomes.SAVANNA).add((Object)Biomes.SAVANNA_PLATEAU).add((Object)Biomes.WINDSWEPT_SAVANNA).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"));
        this.tag(Tags.Biomes.IS_DRY_NETHER).add((Object)Biomes.NETHER_WASTES).add((Object)Biomes.CRIMSON_FOREST).add((Object)Biomes.WARPED_FOREST).add((Object)Biomes.SOUL_SAND_VALLEY).add((Object)Biomes.BASALT_DELTAS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag(Tags.Biomes.IS_DRY_END).add((Object)Biomes.THE_END).add((Object)Biomes.SMALL_END_ISLANDS).add((Object)Biomes.END_MIDLANDS).add((Object)Biomes.END_HIGHLANDS).add((Object)Biomes.END_BARRENS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag(Tags.Biomes.IS_DRY).addTag(Tags.Biomes.IS_DRY_OVERWORLD).addTag(Tags.Biomes.IS_DRY_NETHER).addTag(Tags.Biomes.IS_DRY_END).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry"));
        this.tag(Tags.Biomes.IS_CONIFEROUS_TREE).addTag(Tags.Biomes.IS_TAIGA).add((Object)Biomes.GROVE).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"));
        this.tag(Tags.Biomes.IS_SAVANNA_TREE).addTag(Tags.Biomes.IS_SAVANNA);
        this.tag(Tags.Biomes.IS_JUNGLE_TREE).addTag(Tags.Biomes.IS_JUNGLE);
        this.tag(Tags.Biomes.IS_DECIDUOUS_TREE).add((Object)Biomes.FOREST).add((Object)Biomes.FLOWER_FOREST).add((Object)Biomes.BIRCH_FOREST).add((Object)Biomes.DARK_FOREST).add((Object)Biomes.OLD_GROWTH_BIRCH_FOREST).add((Object)Biomes.WINDSWEPT_FOREST);
        this.tag(Tags.Biomes.IS_MOUNTAIN_SLOPE).add((Object)Biomes.SNOWY_SLOPES).add((Object)Biomes.MEADOW).add((Object)Biomes.GROVE).add((Object)Biomes.CHERRY_GROVE);
        this.tag(Tags.Biomes.IS_MOUNTAIN_PEAK).add((Object)Biomes.JAGGED_PEAKS).add((Object)Biomes.FROZEN_PEAKS).add((Object)Biomes.STONY_PEAKS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag(Tags.Biomes.IS_MOUNTAIN).addTag(BiomeTags.IS_MOUNTAIN).addTag(Tags.Biomes.IS_MOUNTAIN_PEAK).addTag(Tags.Biomes.IS_MOUNTAIN_SLOPE);
        this.tag(Tags.Biomes.IS_FOREST).addTag(BiomeTags.IS_FOREST);
        this.tag(Tags.Biomes.IS_BIRCH_FOREST).add((Object)Biomes.BIRCH_FOREST).add((Object)Biomes.OLD_GROWTH_BIRCH_FOREST);
        this.tag(Tags.Biomes.IS_FLOWER_FOREST).add((Object)Biomes.FLOWER_FOREST);
        this.tag(Tags.Biomes.IS_FLORAL).addTag(Tags.Biomes.IS_FLOWER_FOREST).add((Object)Biomes.SUNFLOWER_PLAINS).add((Object)Biomes.CHERRY_GROVE).add((Object)Biomes.MEADOW);
        this.tag(Tags.Biomes.IS_BEACH).addTag(BiomeTags.IS_BEACH);
        this.tag(Tags.Biomes.IS_STONY_SHORES).add((Object)Biomes.STONY_SHORE);
        this.tag(Tags.Biomes.IS_DESERT).add((Object)Biomes.DESERT);
        this.tag(Tags.Biomes.IS_BADLANDS).addTag(BiomeTags.IS_BADLANDS);
        this.tag(Tags.Biomes.IS_PLAINS).add((Object)Biomes.PLAINS).add((Object)Biomes.SUNFLOWER_PLAINS);
        this.tag(Tags.Biomes.IS_SNOWY_PLAINS).add((Object)Biomes.SNOWY_PLAINS);
        this.tag(Tags.Biomes.IS_TAIGA).addTag(BiomeTags.IS_TAIGA);
        this.tag(Tags.Biomes.IS_HILL).addTag(BiomeTags.IS_HILL);
        this.tag(Tags.Biomes.IS_WINDSWEPT).add((Object)Biomes.WINDSWEPT_HILLS).add((Object)Biomes.WINDSWEPT_GRAVELLY_HILLS).add((Object)Biomes.WINDSWEPT_FOREST).add((Object)Biomes.WINDSWEPT_SAVANNA);
        this.tag(Tags.Biomes.IS_SAVANNA).addTag(BiomeTags.IS_SAVANNA);
        this.tag(Tags.Biomes.IS_JUNGLE).addTag(BiomeTags.IS_JUNGLE);
        this.tag(Tags.Biomes.IS_SNOWY).add((Object)Biomes.SNOWY_BEACH).add((Object)Biomes.SNOWY_PLAINS).add((Object)Biomes.ICE_SPIKES).add((Object)Biomes.SNOWY_TAIGA).add((Object)Biomes.GROVE).add((Object)Biomes.SNOWY_SLOPES).add((Object)Biomes.JAGGED_PEAKS).add((Object)Biomes.FROZEN_PEAKS);
        this.tag(Tags.Biomes.IS_ICY).add((Object)Biomes.ICE_SPIKES).add((Object)Biomes.FROZEN_PEAKS);
        this.tag(Tags.Biomes.IS_SWAMP).add((Object)Biomes.SWAMP).add((Object)Biomes.MANGROVE_SWAMP);
        this.tag(Tags.Biomes.IS_OLD_GROWTH).add((Object)Biomes.OLD_GROWTH_BIRCH_FOREST).add((Object)Biomes.OLD_GROWTH_PINE_TAIGA).add((Object)Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        this.tag(Tags.Biomes.IS_LUSH).add((Object)Biomes.LUSH_CAVES);
        this.tag(Tags.Biomes.IS_MAGICAL);
        this.tag(Tags.Biomes.IS_MODIFIED);
        this.tag(Tags.Biomes.IS_SANDY).add((Object)Biomes.DESERT).add((Object)Biomes.BADLANDS).add((Object)Biomes.WOODED_BADLANDS).add((Object)Biomes.ERODED_BADLANDS).add((Object)Biomes.BEACH);
        this.tag(Tags.Biomes.IS_MUSHROOM).add((Object)Biomes.MUSHROOM_FIELDS);
        this.tag(Tags.Biomes.IS_PLATEAU).add((Object)Biomes.WOODED_BADLANDS).add((Object)Biomes.SAVANNA_PLATEAU).add((Object)Biomes.CHERRY_GROVE).add((Object)Biomes.MEADOW);
        this.tag(Tags.Biomes.IS_SPOOKY).add((Object)Biomes.DARK_FOREST).add((Object)Biomes.DEEP_DARK);
        this.tag(Tags.Biomes.IS_WASTELAND);
        this.tag(Tags.Biomes.IS_RARE).add((Object)Biomes.SUNFLOWER_PLAINS).add((Object)Biomes.FLOWER_FOREST).add((Object)Biomes.OLD_GROWTH_BIRCH_FOREST).add((Object)Biomes.OLD_GROWTH_SPRUCE_TAIGA).add((Object)Biomes.BAMBOO_JUNGLE).add((Object)Biomes.SPARSE_JUNGLE).add((Object)Biomes.ERODED_BADLANDS).add((Object)Biomes.SAVANNA_PLATEAU).add((Object)Biomes.WINDSWEPT_SAVANNA).add((Object)Biomes.ICE_SPIKES).add((Object)Biomes.WINDSWEPT_GRAVELLY_HILLS).add((Object)Biomes.MUSHROOM_FIELDS).add((Object)Biomes.DEEP_DARK);
        this.tag(Tags.Biomes.IS_RIVER).addTag(BiomeTags.IS_RIVER);
        this.tag(Tags.Biomes.IS_SHALLOW_OCEAN).add((Object)Biomes.OCEAN).add((Object)Biomes.LUKEWARM_OCEAN).add((Object)Biomes.WARM_OCEAN).add((Object)Biomes.COLD_OCEAN).add((Object)Biomes.FROZEN_OCEAN);
        this.tag(Tags.Biomes.IS_DEEP_OCEAN).addTag(BiomeTags.IS_DEEP_OCEAN);
        this.tag(Tags.Biomes.IS_OCEAN).addTag(BiomeTags.IS_OCEAN).addTag(Tags.Biomes.IS_SHALLOW_OCEAN).addTag(Tags.Biomes.IS_DEEP_OCEAN);
        this.tag(Tags.Biomes.IS_AQUATIC_ICY).add((Object)Biomes.FROZEN_RIVER).add((Object)Biomes.DEEP_FROZEN_OCEAN).add((Object)Biomes.FROZEN_OCEAN);
        this.tag(Tags.Biomes.IS_AQUATIC).addTag(Tags.Biomes.IS_OCEAN).addTag(Tags.Biomes.IS_RIVER);
        this.tag(Tags.Biomes.IS_CAVE).add((Object)Biomes.LUSH_CAVES).add((Object)Biomes.DRIPSTONE_CAVES).add((Object)Biomes.DEEP_DARK).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_cave"));
        this.tag(Tags.Biomes.IS_UNDERGROUND).addTag(Tags.Biomes.IS_CAVE);
        this.tag(Tags.Biomes.IS_NETHER_FOREST).add((Object)Biomes.CRIMSON_FOREST).add((Object)Biomes.WARPED_FOREST);
        this.tag(Tags.Biomes.IS_OUTER_END_ISLAND).add((Object)Biomes.END_HIGHLANDS).add((Object)Biomes.END_MIDLANDS).add((Object)Biomes.END_BARRENS);
        this.tag((ResourceKey<Biome>)Biomes.PLAINS, ForgeBiomeTagsProvider.forgeTagKey("is_plains"));
        this.tag((ResourceKey<Biome>)Biomes.DESERT, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sandy"), ForgeBiomeTagsProvider.forgeTagKey("is_desert"));
        this.tag((ResourceKey<Biome>)Biomes.TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"));
        this.tag((ResourceKey<Biome>)Biomes.SWAMP, ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_swamp"));
        this.tag((ResourceKey<Biome>)Biomes.NETHER_WASTES, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.THE_END, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.FROZEN_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.FROZEN_RIVER, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_PLAINS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_wasteland"), ForgeBiomeTagsProvider.forgeTagKey("is_plains"));
        this.tag((ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS, ForgeBiomeTagsProvider.forgeTagKey("is_mushroom"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.JUNGLE, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SPARSE_JUNGLE, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.BEACH, ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sandy"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_BEACH, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.DARK_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_spooky"), ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.OLD_GROWTH_PINE_TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"));
        this.tag((ResourceKey<Biome>)Biomes.WINDSWEPT_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SAVANNA, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SAVANNA_PLATEAU, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"), Tags.Biomes.IS_PLATEAU);
        this.tag((ResourceKey<Biome>)Biomes.BADLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_sandy"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.WOODED_BADLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_sandy"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"), Tags.Biomes.IS_PLATEAU);
        this.tag((ResourceKey<Biome>)Biomes.MEADOW, ForgeBiomeTagsProvider.forgeTagKey("is_plains"), Tags.Biomes.IS_PLATEAU, ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag((ResourceKey<Biome>)Biomes.GROVE, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_SLOPES, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag((ResourceKey<Biome>)Biomes.JAGGED_PEAKS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag((ResourceKey<Biome>)Biomes.FROZEN_PEAKS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag((ResourceKey<Biome>)Biomes.STONY_PEAKS, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag((ResourceKey<Biome>)Biomes.SMALL_END_ISLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.END_MIDLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.END_HIGHLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.END_BARRENS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.WARM_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.COLD_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.DEEP_COLD_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.DEEP_FROZEN_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.THE_VOID, ForgeBiomeTagsProvider.forgeTagKey("is_void"));
        this.tag((ResourceKey<Biome>)Biomes.SUNFLOWER_PLAINS, ForgeBiomeTagsProvider.forgeTagKey("is_plains"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.WINDSWEPT_GRAVELLY_HILLS, ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.FLOWER_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.ICE_SPIKES, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.OLD_GROWTH_BIRCH_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.OLD_GROWTH_SPRUCE_TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.WINDSWEPT_SAVANNA, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.ERODED_BADLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.BAMBOO_JUNGLE, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.LUSH_CAVES, ForgeBiomeTagsProvider.forgeTagKey("is_cave"), ForgeBiomeTagsProvider.forgeTagKey("is_lush"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.DRIPSTONE_CAVES, ForgeBiomeTagsProvider.forgeTagKey("is_cave"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SOUL_SAND_VALLEY, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.CRIMSON_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.WARPED_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.BASALT_DELTAS, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.MANGROVE_SWAMP, ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_swamp"));
        this.tag((ResourceKey<Biome>)Biomes.DEEP_DARK, ForgeBiomeTagsProvider.forgeTagKey("is_cave"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"), ForgeBiomeTagsProvider.forgeTagKey("is_spooky"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_hot")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether")).addOptionalTag(Tags.Biomes.IS_HOT_END);
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_cold")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld")).addOptionalTag(Tags.Biomes.IS_COLD_NETHER).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_sparse")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld")).addOptionalTag(Tags.Biomes.IS_SPARSE_NETHER).addOptionalTag(Tags.Biomes.IS_SPARSE_END);
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_dense")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld")).addOptionalTag(Tags.Biomes.IS_DENSE_NETHER).addOptionalTag(Tags.Biomes.IS_DENSE_END);
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_wet")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld")).addOptionalTag(Tags.Biomes.IS_WET_NETHER).addOptionalTag(Tags.Biomes.IS_WET_END);
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_dry")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_dead"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_water")).addTag(BiomeTags.IS_OCEAN).addTag(BiomeTags.IS_RIVER);
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_mountain")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_peak")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_underground")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_cave"));
    }

    @SafeVarargs
    private void tag(ResourceKey<Biome> biome, TagKey<Biome> ... tags) {
        for (TagKey<Biome> key : tags) {
            this.tag(key).add(biome);
        }
    }

    private static TagKey<Biome> forgeTagKey(String path) {
        return BiomeTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public String getName() {
        return "Forge Biome Tags";
    }
}

