/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.resource;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.DelegatingPackResources;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ResourcePackLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void loadResourcePacks(PackRepository resourcePacks, boolean client) {
        resourcePacks.addPackFinder(repo -> ResourcePackLoader.findPacks(repo, client));
    }

    public static List<String> getPackNames() {
        return ModList.get().applyForEachModFile(mf -> "mod:" + ((IModInfo)mf.getModInfos().get(0)).getModId()).filter(n -> !n.equals("mod:minecraft")).collect(Collectors.toList());
    }

    public static <V> Comparator<Map.Entry<String, V>> getSorter() {
        ArrayList<String> order = new ArrayList<String>();
        order.add("vanilla");
        order.add("mod_resources");
        ModList.get().getModFiles().stream().filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(e -> ((IModInfo)e.getMods().get(0)).getModId()).map(e -> "mod:" + e).forEach(order::add);
        Object2IntOpenHashMap order_f = new Object2IntOpenHashMap(order.size());
        for (int x = 0; x < order.size(); ++x) {
            order_f.put((Object)((String)order.get(x)), x);
        }
        return (arg_0, arg_1) -> ResourcePackLoader.lambda$getSorter$7((Object2IntMap)order_f, arg_0, arg_1);
    }

    private static void findPacks(Consumer<Pack> packAcceptor, boolean client) {
        PackType type = client ? PackType.CLIENT_RESOURCES : PackType.SERVER_DATA;
        int version = SharedConstants.getCurrentVersion().packVersion(type);
        ArrayList<PackResources> hiddenPacks = new ArrayList<PackResources>();
        for (IModFileInfo mod : ModList.get().getModFiles()) {
            if (mod.requiredLanguageLoaders().stream().anyMatch(ls -> ls.languageName().equals("minecraft"))) continue;
            IModFile file = mod.getFile();
            Path root = file.findResource(new String[]{""});
            PathPackResources.PathResourcesSupplier supplier = new PathPackResources.PathResourcesSupplier(root);
            IModInfo modinfo = (IModInfo)file.getModInfos().get(0);
            String name = "mod:" + modinfo.getModId();
            PackLocationInfo info = new PackLocationInfo(name, (Component)Component.literal((String)file.getFileName()), PackSource.DEFAULT, Optional.empty());
            Pack.Metadata meta = Pack.readPackMetadata((PackLocationInfo)info, (Pack.ResourcesSupplier)supplier, (int)version);
            Pack pack = null;
            if (meta != null) {
                pack = new Pack(info, (Pack.ResourcesSupplier)supplier, meta, new PackSelectionConfig(false, Pack.Position.BOTTOM, false));
            }
            if (pack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(modinfo, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{file}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)file.getFilePath());
            if (!client || mod.showAsResourcePack()) {
                packAcceptor.accept(pack);
                continue;
            }
            hiddenPacks.add(pack.open());
        }
        if (!hiddenPacks.isEmpty()) {
            PackLocationInfo info = new PackLocationInfo("mod_resources", (Component)Component.translatable((String)"fml.resources.modresources", (Object[])new Object[]{hiddenPacks.size()}), PackSource.DEFAULT, Optional.empty());
            DelegatingPackResources delegating = new DelegatingPackResources(info, new PackMetadataSection((Component)Component.translatable((String)"fml.resources.modresources", (Object[])new Object[]{hiddenPacks.size()}), version, Optional.empty()), hiddenPacks);
            Pack.ResourcesSupplier supplier = delegating.supplier();
            PackLocationInfo wrapper = new PackLocationInfo("mod_resources", (Component)Component.literal((String)"Mod Resources"), PackSource.DEFAULT, Optional.empty());
            PackSelectionConfig wrapperCfg = new PackSelectionConfig(true, Pack.Position.BOTTOM, false);
            Pack modResourcesPack = Pack.readMetaAndCreate((PackLocationInfo)wrapper, (Pack.ResourcesSupplier)supplier, (PackType)type, (PackSelectionConfig)wrapperCfg);
            packAcceptor.accept(modResourcesPack);
        }
    }

    private static /* synthetic */ int lambda$getSorter$7(Object2IntMap order_f, Map.Entry e1, Map.Entry e2) {
        int i2;
        String s1 = (String)e1.getKey();
        String s2 = (String)e2.getKey();
        int i1 = order_f.getOrDefault((Object)s1, -1);
        if (i1 == (i2 = order_f.getOrDefault((Object)s2, -1)) && i1 == -1) {
            return s1.compareTo(s2);
        }
        if (i1 == -1) {
            return 1;
        }
        if (i2 == -1) {
            return -1;
        }
        return i2 - i1;
    }
}

