/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraftforge.installertools.Task;
import net.minecraftforge.srgutils.IMappingFile;

public class MappingsCsv
extends Task {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final long ZIPTIME = 628041600000L;

    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec mapO = parser.accepts("srg").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec clientO = parser.accepts("client").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec serverO = parser.accepts("server").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        try {
            String sname;
            String cname;
            File parent;
            OptionSet options = parser.parse(args);
            File map = (File)options.valueOf((OptionSpec)mapO);
            File client = (File)options.valueOf((OptionSpec)clientO);
            File server = (File)options.valueOf((OptionSpec)serverO);
            File output = (File)options.valueOf((OptionSpec)outputO);
            this.log("SRG:    " + map);
            this.log("Client: " + client);
            this.log("Server: " + server);
            this.log("Output: " + output);
            if (output.exists() && !this.delete(output)) {
                this.error("Could not delete output file: " + output);
            }
            if ((parent = output.getAbsoluteFile().getParentFile()) != null && !parent.exists() && !parent.mkdirs()) {
                this.error("Could not make output folders: " + parent);
            }
            if (!map.exists()) {
                this.error("SRG does not exist: " + map);
            }
            if (!client.exists()) {
                this.error("Client does not exist: " + client);
            }
            if (!server.exists()) {
                this.error("Server does not exist: " + server);
            }
            IMappingFile pg_client = IMappingFile.load((File)client);
            IMappingFile pg_server = IMappingFile.load((File)server);
            IMappingFile srg = IMappingFile.load((File)map);
            TreeMap<String, String> cfields = new TreeMap<String, String>();
            TreeMap<String, String> sfields = new TreeMap<String, String>();
            TreeMap<String, String> cmethods = new TreeMap<String, String>();
            TreeMap<String, String> smethods = new TreeMap<String, String>();
            this.gatherNames(srg, pg_client, cfields, cmethods);
            this.gatherNames(srg, pg_server, sfields, smethods);
            String[] header = new String[]{"searge", "name", "side", "desc"};
            ArrayList<String[]> fields = new ArrayList<String[]>();
            ArrayList<String[]> methods = new ArrayList<String[]>();
            fields.add(header);
            methods.add(header);
            for (String name : cfields.keySet()) {
                cname = (String)cfields.get(name);
                if (cname.equals(sname = (String)sfields.get(name))) {
                    fields.add(new String[]{name, cname, "2", ""});
                    sfields.remove(name);
                    continue;
                }
                fields.add(new String[]{name, cname, "0", ""});
            }
            for (String name : cmethods.keySet()) {
                cname = (String)cmethods.get(name);
                if (cname.equals(sname = (String)smethods.get(name))) {
                    methods.add(new String[]{name, cname, "2", ""});
                    smethods.remove(name);
                    continue;
                }
                methods.add(new String[]{name, cname, "0", ""});
            }
            sfields.forEach((k, v) -> fields.add(new String[]{k, v, "1", ""}));
            smethods.forEach((k, v) -> methods.add(new String[]{k, v, "1", ""}));
            try (FileOutputStream fos = new FileOutputStream(output);
                 ZipOutputStream out = new ZipOutputStream(fos);){
                MappingsCsv.writeCsv("fields.csv", fields, out);
                MappingsCsv.writeCsv("methods.csv", methods, out);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private boolean delete(File path) throws IOException {
        if (path.isDirectory()) {
            return Files.walk(path.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).map(File::delete).anyMatch(v -> v == false);
        }
        return path.delete();
    }

    private void gatherNames(IMappingFile srg, IMappingFile official, Map<String, String> fields, Map<String, String> methods) {
        for (IMappingFile.IClass cls : official.getClasses()) {
            String name;
            IMappingFile.IClass obf = srg.getClass(cls.getMapped());
            if (obf == null) continue;
            for (IMappingFile.IField fld : cls.getFields()) {
                name = obf.remapField(fld.getMapped());
                if (!name.startsWith("field_") && !name.startsWith("f_")) continue;
                fields.put(name, fld.getOriginal());
            }
            for (IMappingFile.IMethod mtd : cls.getMethods()) {
                name = obf.remapMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                if (!name.startsWith("func_") && !name.startsWith("m_")) continue;
                methods.put(name, mtd.getOriginal());
            }
        }
    }

    public static ZipEntry getStableEntry(String name) {
        return MappingsCsv.getStableEntry(name, 628041600000L);
    }

    public static ZipEntry getStableEntry(String name, long time) {
        TimeZone _default = TimeZone.getDefault();
        TimeZone.setDefault(GMT);
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(time);
        TimeZone.setDefault(_default);
        return ret;
    }

    protected static void writeCsv(String name, List<String[]> mappings, ZipOutputStream out) throws IOException {
        if (mappings.size() <= 1) {
            return;
        }
        out.putNextEntry(MappingsCsv.getStableEntry(name));
        byte[] comma = ",".getBytes(StandardCharsets.UTF_8);
        byte[] lf = "\n".getBytes(StandardCharsets.UTF_8);
        for (String[] row : mappings) {
            for (int x = 0; x < row.length; ++x) {
                out.write(row[x].getBytes(StandardCharsets.UTF_8));
                if (x == row.length - 1) continue;
                out.write(comma);
            }
            out.write(lf);
        }
        out.closeEntry();
    }
}

