// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// ProberSpecApplyConfiguration represents a declarative configuration of the ProberSpec type for use
// with apply.
type ProberSpecApplyConfiguration struct {
	URL      *string `json:"url,omitempty"`
	Scheme   *string `json:"scheme,omitempty"`
	Path     *string `json:"path,omitempty"`
	ProxyURL *string `json:"proxyUrl,omitempty"`
}

// ProberSpecApplyConfiguration constructs a declarative configuration of the ProberSpec type for use with
// apply.
func ProberSpec() *ProberSpecApplyConfiguration {
	return &ProberSpecApplyConfiguration{}
}

// WithURL sets the URL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URL field is set to the value of the last call.
func (b *ProberSpecApplyConfiguration) WithURL(value string) *ProberSpecApplyConfiguration {
	b.URL = &value
	return b
}

// WithScheme sets the Scheme field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Scheme field is set to the value of the last call.
func (b *ProberSpecApplyConfiguration) WithScheme(value string) *ProberSpecApplyConfiguration {
	b.Scheme = &value
	return b
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *ProberSpecApplyConfiguration) WithPath(value string) *ProberSpecApplyConfiguration {
	b.Path = &value
	return b
}

// WithProxyURL sets the ProxyURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProxyURL field is set to the value of the last call.
func (b *ProberSpecApplyConfiguration) WithProxyURL(value string) *ProberSpecApplyConfiguration {
	b.ProxyURL = &value
	return b
}
