// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityCvss Vulnerability severities.
type VulnerabilityCvss struct {
	// Vulnerability severity.
	Base CVSS `json:"base"`
	// Vulnerability severity.
	Datadog CVSS `json:"datadog"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewVulnerabilityCvss instantiates a new VulnerabilityCvss object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewVulnerabilityCvss(base CVSS, datadog CVSS) *VulnerabilityCvss {
	this := VulnerabilityCvss{}
	this.Base = base
	this.Datadog = datadog
	return &this
}

// NewVulnerabilityCvssWithDefaults instantiates a new VulnerabilityCvss object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewVulnerabilityCvssWithDefaults() *VulnerabilityCvss {
	this := VulnerabilityCvss{}
	return &this
}

// GetBase returns the Base field value.
func (o *VulnerabilityCvss) GetBase() CVSS {
	if o == nil {
		var ret CVSS
		return ret
	}
	return o.Base
}

// GetBaseOk returns a tuple with the Base field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityCvss) GetBaseOk() (*CVSS, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Base, true
}

// SetBase sets field value.
func (o *VulnerabilityCvss) SetBase(v CVSS) {
	o.Base = v
}

// GetDatadog returns the Datadog field value.
func (o *VulnerabilityCvss) GetDatadog() CVSS {
	if o == nil {
		var ret CVSS
		return ret
	}
	return o.Datadog
}

// GetDatadogOk returns a tuple with the Datadog field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityCvss) GetDatadogOk() (*CVSS, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Datadog, true
}

// SetDatadog sets field value.
func (o *VulnerabilityCvss) SetDatadog(v CVSS) {
	o.Datadog = v
}

// MarshalJSON serializes the struct using spec logic.
func (o VulnerabilityCvss) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	toSerialize["base"] = o.Base
	toSerialize["datadog"] = o.Datadog

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *VulnerabilityCvss) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Base    *CVSS `json:"base"`
		Datadog *CVSS `json:"datadog"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.Base == nil {
		return fmt.Errorf("required field base missing")
	}
	if all.Datadog == nil {
		return fmt.Errorf("required field datadog missing")
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"base", "datadog"})
	} else {
		return err
	}

	hasInvalidField := false
	if all.Base.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Base = *all.Base
	if all.Datadog.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Datadog = *all.Datadog

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	if hasInvalidField {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}

	return nil
}
