/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jibri;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriSession;
import org.jitsi.jicofo.util.ErrorResponse;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0018H$J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H$J\u0018\u0010\u001e\u001a\u00020\u001f2\u0010\u0010 \u001a\f\u0012\u0004\u0012\u00020\u00180!j\u0002`\"J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H$J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lorg/jitsi/jicofo/jibri/BaseJibri;", "Lorg/jitsi/jicofo/jibri/JibriSession$StateListener;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "jibriDetector", "Lorg/jitsi/jicofo/jibri/JibriDetector;", "(Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/jicofo/jibri/JibriDetector;)V", "getConference", "()Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "getJibriDetector", "()Lorg/jitsi/jicofo/jibri/JibriDetector;", "jibriSessions", "", "Lorg/jitsi/jicofo/jibri/JibriSession;", "getJibriSessions", "()Ljava/util/List;", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "accept", "", "iq", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq;", "acceptType", "packet", "doHandleIQRequest", "Lorg/jivesoftware/smack/packet/IQ;", "getJibriSessionForMeetIq", "handleJibriRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/IqRequest;", "Lorg/jitsi/jicofo/jibri/JibriRequest;", "handleStartRequest", "verifyModeratorRole", "Lorg/jivesoftware/smack/packet/StanzaError;", "jicofo"})
public abstract class BaseJibri
implements JibriSession.StateListener {
    @NotNull
    private final JitsiMeetConferenceImpl conference;
    @NotNull
    private final JibriDetector jibriDetector;
    @NotNull
    private final Logger logger;

    public BaseJibri(@NotNull JitsiMeetConferenceImpl conference, @NotNull Logger parentLogger, @NotNull JibriDetector jibriDetector) {
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)((Object)jibriDetector), (String)"jibriDetector");
        this.conference = conference;
        this.jibriDetector = jibriDetector;
        Logger logger = parentLogger.createChildLogger(Reflection.getOrCreateKotlinClass(BaseJibri.class).getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"createChildLogger(...)");
        this.logger = logger;
    }

    @NotNull
    protected final JitsiMeetConferenceImpl getConference() {
        return this.conference;
    }

    @NotNull
    public final JibriDetector getJibriDetector() {
        return this.jibriDetector;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final IqProcessingResult handleJibriRequest(@NotNull IqRequest<JibriIq> request) {
        IqProcessingResult iqProcessingResult;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        if (this.accept((JibriIq)request.getIq())) {
            this.logger.info((Object)("Accepted jibri request: " + ((JibriIq)request.getIq()).toXML()));
            ChatRoom chatRoom = this.conference.getChatRoom();
            if (chatRoom == null) {
                BaseJibri $this$handleJibriRequest_u24lambda_u240 = this;
                boolean bl = false;
                $this$handleJibriRequest_u24lambda_u240.logger.warn((Object)("No chat room found for conference " + $this$handleJibriRequest_u24lambda_u240.conference.getRoomName()));
                return (IqProcessingResult)new IqProcessingResult.RejectedWithError(request.getIq(), StanzaError.Condition.internal_server_error);
            }
            ChatRoom chatRoom2 = chatRoom;
            chatRoom2.queueXmppTask((Function0)new Function0<Unit>(this, request){
                final /* synthetic */ BaseJibri this$0;
                final /* synthetic */ IqRequest<JibriIq> $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(0);
                }

                public final void invoke() {
                    block2: {
                        IQ response;
                        IQ iQ;
                        try {
                            iQ = BaseJibri.access$doHandleIQRequest(this.this$0, (JibriIq)this.$request.getIq());
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().warn((Object)("Failed to handle request: " + this.$request.getIq()), (Throwable)e);
                            XMPPConnection xMPPConnection = (XMPPConnection)this.$request.getConnection();
                            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)this.$request.getIq(), (StanzaError.Condition)StanzaError.Condition.internal_server_error);
                            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                            UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
                            iQ = null;
                        }
                        IQ iQ2 = response = iQ;
                        if (iQ2 == null) break block2;
                        iQ = iQ2;
                        IqRequest<JibriIq> iqRequest = this.$request;
                        IQ it = iQ;
                        boolean bl = false;
                        UtilKt.tryToSendStanza((XMPPConnection)((XMPPConnection)iqRequest.getConnection()), (Stanza)((Stanza)it));
                    }
                }
            });
            iqProcessingResult = (IqProcessingResult)new IqProcessingResult.AcceptedWithNoResponse();
        } else {
            iqProcessingResult = (IqProcessingResult)new IqProcessingResult.NotProcessed();
        }
        return iqProcessingResult;
    }

    @Nullable
    protected abstract JibriSession getJibriSessionForMeetIq(@NotNull JibriIq var1);

    @NotNull
    public abstract List<JibriSession> getJibriSessions();

    @NotNull
    protected abstract IQ handleStartRequest(@NotNull JibriIq var1);

    protected final boolean accept(@NotNull JibriIq iq) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        JibriSession session = this.getJibriSessionForMeetIq(iq);
        if (session != null && session.accept(iq)) {
            return true;
        }
        if (!this.acceptType(iq)) {
            return false;
        }
        return this.conference.getRoomName().equals((CharSequence)iq.getFrom().asBareJid());
    }

    protected abstract boolean acceptType(@NotNull JibriIq var1);

    private final IQ doHandleIQRequest(JibriIq iq) {
        IQ iQ;
        StanzaError stanzaError;
        this.logger.debug(() -> BaseJibri.doHandleIQRequest$lambda$1(iq));
        JibriSession session = this.getJibriSessionForMeetIq(iq);
        if (session != null && session.accept(iq)) {
            IQ iQ2 = session.processJibriIqRequestFromJibri(iq);
            Intrinsics.checkNotNullExpressionValue((Object)iQ2, (String)"processJibriIqRequestFromJibri(...)");
            return iQ2;
        }
        if (ConferenceConfig.config.getEnableModeratorChecks() && (stanzaError = this.verifyModeratorRole(iq)) != null) {
            StanzaError it = stanzaError;
            boolean bl = false;
            this.logger.warn((Object)"Ignored Jibri request from non-moderator.");
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)((IQ)iq), (StanzaError)it);
            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
            return (IQ)errorIQ;
        }
        JibriIq.Action action = iq.getAction();
        switch (action == null ? -1 : WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                IQ iQ3;
                if (session == null) {
                    iQ3 = this.handleStartRequest(iq);
                } else {
                    this.logger.info((Object)"Will not start a Jibri session, a session is already active");
                    iQ3 = (IQ)ErrorResponse.create((IQ)iq, StanzaError.Condition.unexpected_request, "Recording or live streaming is already enabled");
                }
                IQ iQ4 = iQ3;
                Intrinsics.checkNotNull((Object)iQ4);
                iQ = iQ4;
                break;
            }
            case 2: {
                IQ iQ5;
                if (session == null) {
                    this.logger.warn((Object)("Rejecting STOP request for an unknown session.: " + iq.toXML()));
                    iQ5 = (IQ)ErrorResponse.create((IQ)iq, StanzaError.Condition.item_not_found, "Unknown session");
                } else {
                    session.stop(iq.getFrom());
                    iQ5 = IQ.createResultIQ((IQ)((IQ)iq));
                }
                IQ iQ6 = iQ5;
                Intrinsics.checkNotNull((Object)iQ6);
                iQ = iQ6;
                break;
            }
            case -1: 
            case 3: {
                ErrorIQ errorIQ = ErrorResponse.create((IQ)iq, StanzaError.Condition.bad_request, "undefined action " + iq.toXML());
                Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"create(...)");
                return (IQ)errorIQ;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return iQ;
    }

    private final StanzaError verifyModeratorRole(JibriIq iq) {
        MemberRole role = this.conference.getRoleForMucJid(iq.getFrom());
        return role == null ? StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.forbidden).build() : (MemberRoleKt.hasModeratorRights((MemberRole)role) ? null : StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.not_allowed).build());
    }

    private static final String doHandleIQRequest$lambda$1(JibriIq $iq) {
        Intrinsics.checkNotNullParameter((Object)$iq, (String)"$iq");
        return "Jibri request. IQ: " + $iq.toXML();
    }

    public static final /* synthetic */ IQ access$doHandleIQRequest(BaseJibri $this, JibriIq iq) {
        return $this.doHandleIQRequest(iq);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JibriIq.Action.values().length];
            try {
                nArray[JibriIq.Action.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JibriIq.Action.STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JibriIq.Action.UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

