/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.SetupClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class SetupManager
implements Runnable {
    private SetupClient[] settingUp;
    int first;
    int lastPlusOne;
    private static Object monitor = new Object();
    private static SetupManager worker = null;
    private ArrayList managers;
    private static byte[] profileSetup;

    public SetupManager(int n) {
        this.managers = null;
        this.settingUp = new SetupClient[n + 1];
        this.first = 0;
        this.lastPlusOne = 0;
    }

    private SetupManager() {
        this.managers = new ArrayList(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = monitor;
        synchronized (object) {
            if (worker == null) {
                worker = new SetupManager();
                Thread thread = new Thread((Runnable)worker, "SetupManager");
                thread.setDaemon(true);
                thread.setPriority(3);
                thread.start();
            }
            if (SetupManager.worker.managers.indexOf(this) != -1) {
                Debug.assertFail();
            }
            SetupManager.worker.managers.add(this);
            monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = monitor;
        synchronized (object) {
            int n = SetupManager.worker.managers.indexOf(this);
            if (n < 0) {
                Debug.assertFail();
            }
            if (n >= 0) {
                SetupManager.worker.managers.remove(n);
            }
            if (SetupManager.worker.managers.size() == 0) {
                monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSetup(SetupClient setupClient) {
        Object object = monitor;
        synchronized (object) {
            int n = this.next(this.lastPlusOne);
            if (this.first == n) {
                HashSet<SetupClient> hashSet = new HashSet<SetupClient>();
                int n2 = this.first;
                while (n2 != this.lastPlusOne) {
                    hashSet.add(this.settingUp[n2]);
                    n2 = this.next(n2);
                }
                hashSet.add(setupClient);
                if (hashSet.size() >= this.settingUp.length) {
                    Debug.assertFail();
                }
                this.first = 0;
                this.lastPlusOne = 0;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    this.settingUp[this.lastPlusOne] = (SetupClient)iterator.next();
                    ++this.lastPlusOne;
                }
                for (int i = this.lastPlusOne; i < this.settingUp.length; ++i) {
                    this.settingUp[i] = null;
                }
            } else {
                this.settingUp[this.lastPlusOne] = setupClient;
                this.lastPlusOne = n;
            }
            monitor.notifyAll();
        }
    }

    private int next(int n) {
        if (++n >= this.settingUp.length) {
            return 0;
        }
        return n;
    }

    private boolean hasWork() {
        return this.first != this.lastPlusOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        SetupClient setupClient;
        Object object = monitor;
        synchronized (object) {
            if (!this.hasWork()) {
                return;
            }
            setupClient = this.settingUp[this.first];
        }
        if (setupClient.needsMoreSetup()) {
            setupClient.doSomeSetup();
        }
        object = monitor;
        synchronized (object) {
            if (this.hasWork() && !this.settingUp[this.first].needsMoreSetup()) {
                this.settingUp[this.first] = null;
                this.first = this.next(this.first);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Debug.println("Setup thread starts.");
        SetupManager setupManager = null;
        while (true) {
            Object object = monitor;
            synchronized (object) {
                if (this.managers.size() == 0) {
                    if (worker != this) {
                        Debug.assertFail();
                    }
                    worker = null;
                    break;
                }
                if (setupManager != null && !setupManager.hasWork()) {
                    setupManager = null;
                }
                for (int i = 0; setupManager == null && i < this.managers.size(); ++i) {
                    SetupManager setupManager2 = (SetupManager)this.managers.get(i);
                    if (!setupManager2.hasWork()) continue;
                    setupManager = setupManager2;
                }
                if (setupManager == null) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            if (setupManager == null) continue;
            setupManager.doWork();
        }
        Debug.println("Setup thread exits.");
    }
}

