/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.awt.GraphicsEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.panels.StatusBarPanel;

class Log4jBackstop
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Log4jBackstop.class);

    Log4jBackstop() {
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        if (ex instanceof AssertionError && ex.getStackTrace().length > 0 && "BeanProperty.java".equals(ex.getStackTrace()[0].getFileName())) {
            return;
        }
        if ("Null child not allowed".equals(ex.getMessage())) {
            return;
        }
        if (ex instanceof OutOfMemoryError) {
            LOGGER.debug("hit memory cap: {}", (Object)ex.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"tmm.oom.title", "tmm.oom", new String[0]));
            if (!GraphicsEnvironment.isHeadless()) {
                StatusBarPanel.setOomDetected();
            }
            return;
        }
        LOGGER.error("Uncaught exception in thread: " + t.getName(), ex);
        if (!GraphicsEnvironment.isHeadless()) {
            MessageDialog.showExceptionWindow(ex);
        }
    }
}

