/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.mediainfo.MediaInfo3D;
import org.tinymediamanager.core.mediainfo.MediaInfoFile;
import org.tinymediamanager.core.mediainfo.MediaInfoUtils;
import org.tinymediamanager.core.mediainfo.MediaInfoXMLParser;
import org.tinymediamanager.core.mediainfo.MediaInfoXmlCreator;
import org.tinymediamanager.core.tasks.MediaFileARDetectorTask;
import org.tinymediamanager.library.bluray.playlist.MPLSObject;
import org.tinymediamanager.library.bluray.playlist.MPLSReader;
import org.tinymediamanager.library.bluray.playlist.PlayItem;
import org.tinymediamanager.library.dvd.DvdTitle;
import org.tinymediamanager.library.dvd.IfoReader;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaFileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFileHelper.class);
    public static final List<String> TRAILER_FOLDERS = List.of("trailer", "trailers");
    public static final List<String> EXTRA_FOLDERS = List.of("extra", "extras", "behind the scenes", "behindthescenes", "deleted scenes", "deletedscenes", "deleted", "featurette", "featurettes", "interview", "interviews", "scene", "scenes", "short", "shorts", "other", "others", "bloopers", "trickplay");
    public static final List<String> BLURAY_FOLDERS = List.of("BDMV", "PLAYLIST", "CLIPINF", "STREAM");
    public static final List<String> SUPPORTED_ARTWORK_FILETYPES = List.of("jpg", "jpeg", "png", "tbn", "gif", "bmp", "webp");
    public static final List<String> DEFAULT_VIDEO_FILETYPES = List.of(".3gp", ".asf", ".asx", ".avc", ".avi", ".bdmv", ".bin", ".bivx", ".braw", ".dat", ".divx", ".dv", ".dvr-ms", ".disc", ".evo", ".fli", ".flv", ".h264", ".ifo", ".img", ".iso", ".mts", ".mt2s", ".m2ts", ".m2v", ".m4v", ".mkv", ".mk3d", ".mov", ".mp4", ".mpeg", ".mpg", ".nrg", ".nsv", ".nuv", ".ogm", ".pva", ".qt", ".rm", ".rmvb", ".strm", ".svq3", ".ts", ".ty", ".viv", ".vob", ".vp3", ".wmv", ".webm", ".xvid");
    public static final List<String> DEFAULT_AUDIO_FILETYPES = List.of(".a52", ".aa3", ".aac", ".ac3", ".adt", ".adts", ".aif", ".aiff", ".alac", ".ape", ".at3", ".atrac", ".au", ".dts", ".dtshd", ".flac", ".m4a", ".m4b", ".m4p", ".mid", ".midi", ".mka", ".mp3", ".mpa", ".mlp", ".oga", ".ogg", ".pcm", ".ra", ".ram", ".tta", ".thd", ".wav", ".wave", ".wma");
    public static final List<String> DEFAULT_SUBTITLE_FILETYPES = List.of(".aqt", ".cvd", ".dks", ".jss", ".sub", ".sup", ".ttxt", ".mpl", ".pjs", ".psb", ".rt", ".srt", ".smi", ".ssf", ".ssa", ".svcd", ".usf", ".ass", ".pgs", ".vobsub", ".vtt");
    public static final List<String> BINARY_FILETYPES = List.of("bin", "dat", "img", "nrg", "disc");
    public static final Pattern MOVIESET_ARTWORK_PATTERN;
    public static final Pattern POSTER_PATTERN;
    public static final Pattern FANART_PATTERN;
    public static final Pattern EXTRAFANART_PATTERN;
    public static final Pattern BANNER_PATTERN;
    public static final Pattern THUMB_PATTERN;
    public static final Pattern SEASON_POSTER_PATTERN;
    public static final Pattern SEASON_FANART_PATTERN;
    public static final Pattern SEASON_BANNER_PATTERN;
    public static final Pattern SEASON_THUMB_PATTERN;
    public static final Pattern LOGO_PATTERN;
    public static final Pattern CLEARLOGO_PATTERN;
    public static final Pattern CHARACTERART_PATTERN;
    public static final Pattern DISCART_PATTERN;
    public static final Pattern CLEARART_PATTERN;
    public static final Pattern KEYART_PATTERN;
    public static final String VIDEO_FORMAT_96P = "96p";
    public static final String VIDEO_FORMAT_120P = "120p";
    public static final String VIDEO_FORMAT_144P = "144p";
    public static final String VIDEO_FORMAT_240P = "240p";
    public static final String VIDEO_FORMAT_288P = "288p";
    public static final String VIDEO_FORMAT_360P = "360p";
    public static final String VIDEO_FORMAT_480P = "480p";
    public static final String VIDEO_FORMAT_540P = "540p";
    public static final String VIDEO_FORMAT_576P = "576p";
    public static final String VIDEO_FORMAT_720P = "720p";
    public static final String VIDEO_FORMAT_1080P = "1080p";
    public static final String VIDEO_FORMAT_1440P = "1440p";
    public static final String VIDEO_FORMAT_2160P = "2160p";
    public static final String VIDEO_FORMAT_4320P = "4320p";
    public static final String VIDEO_FORMAT_LD = "LD";
    public static final String VIDEO_FORMAT_SD = "SD";
    public static final String VIDEO_FORMAT_HD = "HD";
    public static final String VIDEO_FORMAT_UHD = "UHD";
    public static final String VIDEO_3D = "3D";
    public static final String VIDEO_3D_SBS = "3D SBS";
    public static final String VIDEO_3D_TAB = "3D TAB";
    public static final String VIDEO_3D_HSBS = "3D HSBS";
    public static final String VIDEO_3D_HTAB = "3D HTAB";
    public static final String VIDEO_3D_MVC = "3D MVC";
    public static final String VIDEO_TS = "VIDEO_TS";
    public static final String BDMV = "BDMV";
    public static final String HVDVD_TS = "HVDVD_TS";

    private MediaFileHelper() {
        throw new IllegalAccessError();
    }

    public static List<String> getVideoFormats() {
        Field[] declaredFields;
        ArrayList<String> videoFormats = new ArrayList<String>();
        for (Field field : declaredFields = MediaFileHelper.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("VIDEO_FORMAT_") || field.isAnnotationPresent(Deprecated.class)) continue;
            try {
                videoFormats.add((String)field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return videoFormats;
    }

    public static String audioChannelInDotNotation(int channels) {
        if (channels < 6) {
            return channels + ".0";
        }
        return channels - 1 + ".1";
    }

    private static Path detectDatasource(Path file) {
        for (String ds : Utils.getAllDatasources()) {
            if (!file.toAbsolutePath().startsWith(ds)) continue;
            return Paths.get(ds, new String[0]);
        }
        return null;
    }

    public static MediaFileType parseMediaFileType(Path pathToFile) {
        return MediaFileHelper.parseMediaFileType(pathToFile, MediaFileHelper.detectDatasource(pathToFile));
    }

    public static MediaFileType parseMediaFileType(Path pathToFile, Path datasource) {
        String foldername;
        String basename;
        String ext;
        String filename;
        block18: {
            block17: {
                filename = pathToFile.getFileName().toString();
                ext = FilenameUtils.getExtension((String)filename).toLowerCase(Locale.ROOT);
                basename = FilenameUtils.getBaseName((String)filename);
                foldername = FilenameUtils.getBaseName((String)(pathToFile.getParent() == null ? "" : pathToFile.getParent().toString().toLowerCase(Locale.ROOT)));
                Path relative = datasource != null ? datasource.relativize(pathToFile) : pathToFile;
                ArrayList<String> relativePathJunks = new ArrayList<String>();
                if (relative.getNameCount() > 2) {
                    relative = relative.subpath(1, relative.getNameCount() - 1);
                    for (int i = 1; i <= relative.getNameCount(); ++i) {
                        relativePathJunks.add(relative.subpath(i - 1, i).toString().toLowerCase(Locale.ROOT));
                    }
                }
                if (filename.contains(".EXTRAS.") || basename.matches("(?i).*[_.-]+extra[s]?\\d?$") || basename.matches("(?i).*[-]+extra[s]?[-].*") || foldername.equalsIgnoreCase("extras") || foldername.equalsIgnoreCase("extra") || basename.matches("(?i).*[-](behindthescenes|deleted|featurette|interview|scene|short|other|bloopers)\\d?$")) break block17;
                if (!EXTRA_FOLDERS.stream().anyMatch(relativePathJunks::contains)) break block18;
            }
            return MediaFileType.EXTRA;
        }
        if (ext.equals("nfo")) {
            return MediaFileType.NFO;
        }
        if (ext.equals("vsmeta")) {
            return MediaFileType.VSMETA;
        }
        if ((basename.endsWith("-mediainfo") || basename.endsWith(".mediainfo")) && "xml".equalsIgnoreCase(ext)) {
            return MediaFileType.MEDIAINFO;
        }
        if (SUPPORTED_ARTWORK_FILETYPES.contains(ext)) {
            return MediaFileHelper.parseImageType(pathToFile);
        }
        if (basename.matches("(?i).*[_.-]+(theme|soundtrack)\\d*$") || basename.matches("(?i)(theme|soundtrack)\\d*")) {
            return MediaFileType.THEME;
        }
        if (Settings.getInstance().getAudioFileType().contains("." + ext)) {
            return MediaFileType.AUDIO;
        }
        if (Settings.getInstance().getSubtitleFileType().contains("." + ext)) {
            return MediaFileType.SUBTITLE;
        }
        if (Settings.getInstance().getVideoFileType().contains("." + ext)) {
            if (basename.matches("(?i).*[\\[\\]\\(\\)_.-]+trailer[\\[\\]\\(\\)_.-]?(\\d)*$") || basename.equalsIgnoreCase("movie-trailer") || basename.equalsIgnoreCase("trailer") || TRAILER_FOLDERS.contains(foldername)) {
                return MediaFileType.TRAILER;
            }
            if (basename.matches("(?i).*[\\[\\]\\(\\)_.-]+sample[\\[\\]\\(\\)]?$") || basename.equalsIgnoreCase("sample") || foldername.equalsIgnoreCase("sample")) {
                return MediaFileType.SAMPLE;
            }
            return MediaFileType.VIDEO;
        }
        if (MediaFileHelper.isDiscFolder(filename)) {
            return MediaFileType.VIDEO;
        }
        if (ext.equals("txt")) {
            return MediaFileType.TEXT;
        }
        return MediaFileType.UNKNOWN;
    }

    public static MediaFileType parseImageType(Path pathToFile) {
        String filename = pathToFile.getFileName().toString();
        String foldername = pathToFile.getParent() == null ? "" : pathToFile.getParent().toString().toLowerCase(Locale.ROOT);
        String parentName = FilenameUtils.getBaseName((String)(pathToFile.getParent() == null ? "" : pathToFile.getParent().toString()));
        Matcher matcher = MOVIESET_ARTWORK_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.GRAPHIC;
        }
        matcher = SEASON_POSTER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_POSTER;
        }
        matcher = SEASON_FANART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_FANART;
        }
        matcher = SEASON_BANNER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_BANNER;
        }
        matcher = SEASON_THUMB_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_THUMB;
        }
        matcher = POSTER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.POSTER;
        }
        matcher = EXTRAFANART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.EXTRAFANART;
        }
        matcher = FANART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            if (foldername.endsWith("extrafanart")) {
                return MediaFileType.EXTRAFANART;
            }
            return MediaFileType.FANART;
        }
        matcher = BANNER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.BANNER;
        }
        matcher = THUMB_PATTERN.matcher(filename);
        if (matcher.matches()) {
            if (foldername.endsWith("extrathumbs")) {
                return MediaFileType.EXTRATHUMB;
            }
            return MediaFileType.THUMB;
        }
        matcher = CLEARART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.CLEARART;
        }
        matcher = LOGO_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.CLEARLOGO;
        }
        matcher = CLEARLOGO_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.CLEARLOGO;
        }
        matcher = DISCART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.DISC;
        }
        matcher = CHARACTERART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.CHARACTERART;
        }
        if (foldername.endsWith("characterart")) {
            return MediaFileType.CHARACTERART;
        }
        matcher = KEYART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.KEYART;
        }
        if (foldername.equalsIgnoreCase("extrafanarts") || foldername.equalsIgnoreCase("extrafanart")) {
            return MediaFileType.EXTRAFANART;
        }
        if (foldername.equalsIgnoreCase("extrathumbs") || foldername.equalsIgnoreCase("extrathumb")) {
            return MediaFileType.EXTRATHUMB;
        }
        if (parentName.equals(FileNameUtils.getBaseName((String)filename))) {
            return MediaFileType.POSTER;
        }
        return MediaFileType.GRAPHIC;
    }

    public static boolean isExtraInDedicatedFolder(MediaFile mf, MediaEntity entity) {
        if (mf.getType() != MediaFileType.EXTRA) {
            return false;
        }
        Path rel = entity.getPathNIO().relativize(mf.getFileAsPath());
        if ((rel = rel.getParent()) == null) {
            return false;
        }
        for (Path p : rel) {
            if (!EXTRA_FOLDERS.contains(p.getFileName().toString().toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    public static String getVideoFormat(MediaFile mediaFile) {
        int w = mediaFile.getVideoWidth();
        int h = mediaFile.getVideoHeight();
        if (w == 0 || h == 0) {
            return "";
        }
        if (w <= MediaFileHelper.blur(128) && h <= MediaFileHelper.blur(96)) {
            return VIDEO_FORMAT_96P;
        }
        if (w <= MediaFileHelper.blur(160) && h <= MediaFileHelper.blur(120)) {
            return VIDEO_FORMAT_120P;
        }
        if (w <= MediaFileHelper.blur(176) && h <= MediaFileHelper.blur(144)) {
            return VIDEO_FORMAT_144P;
        }
        if (w <= MediaFileHelper.blur(256) && h <= MediaFileHelper.blur(144)) {
            return VIDEO_FORMAT_144P;
        }
        if (w <= MediaFileHelper.blur(320) && h <= MediaFileHelper.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= MediaFileHelper.blur(352) && h <= MediaFileHelper.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= MediaFileHelper.blur(426) && h <= MediaFileHelper.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= MediaFileHelper.blur(480) && h <= MediaFileHelper.blur(272)) {
            return VIDEO_FORMAT_288P;
        }
        if (w <= MediaFileHelper.blur(480) && h <= MediaFileHelper.blur(360)) {
            return VIDEO_FORMAT_360P;
        }
        if (w <= MediaFileHelper.blur(640) && h <= MediaFileHelper.blur(360)) {
            return VIDEO_FORMAT_360P;
        }
        if (w <= MediaFileHelper.blur(640) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(720) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(800) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(853) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(776) && h <= MediaFileHelper.blur(592)) {
            return VIDEO_FORMAT_576P;
        }
        if (w <= MediaFileHelper.blur(960) && h <= MediaFileHelper.blur(544)) {
            return VIDEO_FORMAT_540P;
        }
        if (w <= MediaFileHelper.blur(912) && h <= MediaFileHelper.blur(384)) {
            return VIDEO_FORMAT_540P;
        }
        if (w <= MediaFileHelper.blur(1024) && h <= MediaFileHelper.blur(576)) {
            return VIDEO_FORMAT_576P;
        }
        if (w <= MediaFileHelper.blur(1332) && h <= MediaFileHelper.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= MediaFileHelper.blur(1998) && h <= MediaFileHelper.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= MediaFileHelper.blur(2664) && h <= MediaFileHelper.blur(1440)) {
            return VIDEO_FORMAT_1440P;
        }
        if (w <= MediaFileHelper.blur(3840) && h <= MediaFileHelper.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(3840) && h <= MediaFileHelper.blur(1600)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(4096) && h <= MediaFileHelper.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(4096) && h <= MediaFileHelper.blur(1716)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(3996) && h <= MediaFileHelper.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        return VIDEO_FORMAT_4320P;
    }

    public static String getVideoDefinitionCategory(MediaFile mediaFile) {
        String vf = MediaFileHelper.getVideoFormat(mediaFile);
        if (vf.isEmpty()) {
            return "";
        }
        switch (vf) {
            case "96p": 
            case "120p": 
            case "144p": 
            case "240p": 
            case "288p": 
            case "360p": {
                return VIDEO_FORMAT_LD;
            }
            case "480p": 
            case "576p": 
            case "540p": {
                return VIDEO_FORMAT_SD;
            }
            case "720p": 
            case "1080p": 
            case "1440p": {
                return VIDEO_FORMAT_HD;
            }
            case "2160p": 
            case "4320p": {
                return VIDEO_FORMAT_UHD;
            }
        }
        return "";
    }

    public static boolean isVideoDefinitionLD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_LD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    public static boolean isVideoDefinitionSD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_SD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    public static boolean isVideoDefinitionHD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_HD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    public static boolean isVideoDefinitionUHD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_UHD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    private static int blur(int value) {
        return value + value / 100;
    }

    public static boolean gatherFileInformation(MediaFile mediaFile) {
        return MediaFileHelper.gatherFileInformation(mediaFile, null);
    }

    public static boolean gatherFileInformation(MediaFile mediaFile, BasicFileAttributes basicFileAttributes) {
        boolean dirty = false;
        try {
            BasicFileAttributes view = basicFileAttributes != null ? basicFileAttributes : Files.readAttributes(mediaFile.getFileAsPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (view.creationTime().toMillis() > 100000L) {
                creDat = new Date(view.creationTime().toMillis());
                mediaFile.setDateCreated(creDat);
            } else {
                creDat = new Date(view.lastModifiedTime().toMillis());
                mediaFile.setDateCreated(creDat);
            }
            if (view.lastModifiedTime().toMillis() > 100000L) {
                Date modDat = new Date(view.lastModifiedTime().toMillis());
                mediaFile.setDateLastModified(modDat);
                mediaFile.setFiledate(view.lastModifiedTime().toMillis());
            }
            long size = view.size();
            if (view.isDirectory()) {
                size = Utils.getDirectorySizeOfDiscFiles(mediaFile.getFile());
            }
            if (size > 0L && mediaFile.getFilesize() > 0L && size != mediaFile.getFilesize()) {
                dirty = true;
            }
            mediaFile.setFilesize(size);
        }
        catch (Exception e) {
            LOGGER.debug("could not get file information (size/date): {}", (Object)e.getMessage());
        }
        return dirty;
    }

    public static void gatherMediaInformation(MediaFile mediaFile, boolean force) {
        String extension = mediaFile.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            extension = extension.toLowerCase(Locale.ROOT);
        }
        boolean fileSizeChanged = MediaFileHelper.gatherFileInformation(mediaFile);
        if (!mediaFile.isValidMediainfoFormat()) {
            if (StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
                mediaFile.setContainerFormat(extension);
            }
            return;
        }
        if (!(fileSizeChanged || force || mediaFile.getContainerFormat().isEmpty())) {
            return;
        }
        if (mediaFile.getFilesize() == 0L && StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
            LOGGER.debug("0 Byte file detected: {}", (Object)mediaFile.getFilename());
            mediaFile.setContainerFormat(extension);
        }
        switch (mediaFile.getType()) {
            case NFO: 
            case TEXT: 
            case MEDIAINFO: 
            case VSMETA: 
            case UNKNOWN: 
            case DOUBLE_EXT: {
                mediaFile.setContainerFormat(mediaFile.getExtension());
                return;
            }
        }
        LOGGER.debug("start MediaInfo for {}", (Object)mediaFile.getFileAsPath());
        List<Object> mediaInfoFiles = new ArrayList();
        if (!fileSizeChanged && mediaFile.getType() == MediaFileType.VIDEO) {
            try {
                Path xmlFile = Paths.get(mediaFile.getPath(), mediaFile.getMediaInfoXmlFilename());
                mediaInfoFiles.addAll(MediaFileHelper.detectRelevantFiles(MediaFileHelper.parseMediaInfoXml(xmlFile)));
                if (!mediaInfoFiles.isEmpty()) {
                    LOGGER.trace("mediainfo.xml found - '{}'", (Object)xmlFile.getFileName());
                    MediaFileHelper.parseMediainfoSnapshot(mediaFile, mediaInfoFiles);
                    if (((MediaInfoFile)mediaInfoFiles.get(0)).getSnapshot() == null || ((MediaInfoFile)mediaInfoFiles.get(0)).getSnapshot().isEmpty()) {
                        LOGGER.debug("Reading MediaInfoXML did not return something useful...");
                        mediaInfoFiles.clear();
                    }
                }
            }
            catch (Exception e) {
                mediaInfoFiles.clear();
                LOGGER.debug("could not read -mediainfo.xml data - maybe a broken XML? {}", (Object)e.getMessage());
            }
        }
        if (mediaInfoFiles.isEmpty() && !(mediaInfoFiles = mediaFile.isISO() ? MediaFileHelper.getMediaInfoSnapshotFromISO(mediaFile) : MediaFileHelper.getMediaInfoFromSingleFile(mediaFile)).isEmpty()) {
            MediaFileHelper.parseMediainfoSnapshot(mediaFile, mediaInfoFiles);
        }
        LOGGER.debug("end MediaInfo for {}", (Object)mediaFile.getFileAsPath());
    }

    private static void parseMediainfoSnapshot(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        if (mediaInfoFiles.isEmpty()) {
            LOGGER.debug("no mediainfo data provided");
            return;
        }
        if (mediaInfoFiles.size() > 1 && (mediaFile.isISO() || mediaFile.isDiscFile())) {
            if (MediaFileHelper.isHDDVDStructure(mediaInfoFiles)) {
                MediaFileHelper.gatherMediaInformationFromHdDvdFile(mediaFile, mediaInfoFiles);
            } else if (MediaFileHelper.isDVDStructure(mediaInfoFiles)) {
                MediaFileHelper.gatherMediaInformationFromDvdFile(mediaFile, mediaInfoFiles);
            } else if (MediaFileHelper.isBlurayStructure(mediaInfoFiles)) {
                MediaFileHelper.gatherMediaInformationFromBluRayFile(mediaFile, mediaInfoFiles);
            } else {
                MediaFileHelper.gatherMediaInformationFromFile(mediaFile, mediaInfoFiles);
            }
        } else {
            MediaFileHelper.gatherMediaInformationFromFile(mediaFile, mediaInfoFiles);
        }
    }

    public static boolean isDiscFile(String filename, String path) {
        return MediaFileHelper.isDVDFile(filename) || MediaFileHelper.isBlurayFile(filename) || MediaFileHelper.isHDDVDFile(filename);
    }

    public static boolean isDiscFolder(String folder) {
        return folder.endsWith(BDMV) || folder.endsWith(VIDEO_TS) || folder.endsWith(HVDVD_TS);
    }

    public static boolean isDVDFile(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        if (VIDEO_TS.equalsIgnoreCase(filename)) {
            return true;
        }
        return filename.toLowerCase(Locale.ROOT).matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)");
    }

    private static boolean isDVDStructure(List<MediaInfoFile> files) {
        for (MediaInfoFile mif : files) {
            if (!mif.getPath().endsWith(VIDEO_TS)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHDDVDFile(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        if (HVDVD_TS.equalsIgnoreCase(filename)) {
            return true;
        }
        return filename.toLowerCase(Locale.ROOT).matches("(hv\\d{3}[imt]\\d{2}|hv[as]\\d{5}|title\\d{3})\\.(evo|bup|ifo|vti|map)");
    }

    private static boolean isHDDVDStructure(List<MediaInfoFile> files) {
        for (MediaInfoFile mif : files) {
            if (!mif.getPath().endsWith(HVDVD_TS)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlurayFile(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        if (BDMV.equalsIgnoreCase(filename)) {
            return true;
        }
        return filename.toLowerCase(Locale.ROOT).matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts|\\d{5}\\.clpi|\\d{5}\\.mpls)");
    }

    public static boolean isMainDiscIdentifierFile(String filename) {
        return filename.equalsIgnoreCase("video_ts.ifo") || filename.equalsIgnoreCase("index.bdmv") || filename.equalsIgnoreCase("hv000i01.ifo");
    }

    private static boolean isBlurayStructure(List<MediaInfoFile> files) {
        for (MediaInfoFile mif : files) {
            Path p = mif.getFileAsPath();
            if (p.getParent() == null || p.getParent().equals(p.getRoot())) continue;
            String filename = mif.getFileAsPath().getFileName().toString();
            String foldername = mif.getFileAsPath().getParent().getFileName().toString().toUpperCase(Locale.ROOT);
            if (!BLURAY_FOLDERS.contains(foldername) || !MediaFileHelper.isBlurayFile(filename)) continue;
            return true;
        }
        return false;
    }

    private static synchronized List<MediaInfoFile> getMediaInfoFromSingleFile(MediaFile mediaFile) {
        if (!MediaInfoUtils.useMediaInfo()) {
            return Collections.emptyList();
        }
        List<MediaInfoFile> mediaInfoFiles = new ArrayList<MediaInfoFile>();
        if (Files.isDirectory(mediaFile.getFileAsPath(), new LinkOption[0])) {
            for (Path path : Utils.listFilesRecursive(mediaFile.getFileAsPath())) {
                try {
                    mediaInfoFiles.add(new MediaInfoFile(path, Files.size(path)));
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse filesize of {} - {}", (Object)path, (Object)e.getMessage());
                }
            }
            mediaInfoFiles = MediaFileHelper.detectRelevantFiles(mediaInfoFiles);
        } else {
            mediaInfoFiles.add(new MediaInfoFile(mediaFile.getFile()));
        }
        for (MediaInfoFile mif : mediaInfoFiles) {
            mif.gatherMediaInformation();
        }
        if (Settings.getInstance().isWriteMediaInfoXml() && mediaFile.getType() == MediaFileType.VIDEO) {
            try {
                MediaInfoXmlCreator mediaInfoXmlCreator = new MediaInfoXmlCreator(mediaFile, mediaInfoFiles);
                mediaInfoXmlCreator.write();
            }
            catch (Exception e) {
                LOGGER.debug("could not write mediainfo xml - {}", (Object)e.getMessage());
            }
        }
        return mediaInfoFiles;
    }

    private static List<MediaInfoFile> parseMediaInfoXml(Path xmlFile) {
        List<MediaInfoFile> miFiles = null;
        if (Files.exists(xmlFile, new LinkOption[0])) {
            try {
                LOGGER.trace("try to parse mediainfo xml - {}", (Object)xmlFile);
                miFiles = new MediaInfoXMLParser(xmlFile).parseXML();
            }
            catch (Exception e) {
                LOGGER.debug("unable to parse mediainfo xml - {} - {}", (Object)xmlFile, (Object)e.getMessage());
            }
        }
        if (miFiles == null) {
            return Collections.emptyList();
        }
        return miFiles;
    }

    private static synchronized List<MediaInfoFile> getMediaInfoSnapshotFromISO(MediaFile mediaFile) {
        if (!MediaInfoUtils.useMediaInfo()) {
            return Collections.emptyList();
        }
        List<MediaInfoFile> miFiles = MediaFileHelper.parseIso9660(mediaFile);
        if (miFiles.isEmpty()) {
            miFiles = MediaFileHelper.parseIsoUdf(mediaFile);
        }
        if (Settings.getInstance().isWriteMediaInfoXml()) {
            try {
                MediaInfoXmlCreator mediaInfoXmlCreator = new MediaInfoXmlCreator(mediaFile, miFiles);
                mediaInfoXmlCreator.write();
            }
            catch (Exception e) {
                LOGGER.debug("could not write mediainfo xml - {}", (Object)e.getMessage());
            }
        }
        return MediaFileHelper.detectRelevantFiles(miFiles);
    }

    static List<MediaInfoFile> parseIso9660(MediaFile mediaFile) {
        ArrayList<MediaInfoFile> miFiles = new ArrayList<MediaInfoFile>();
        int bufferSize = 65536;
        try (Iso9660FileSystem image = new Iso9660FileSystem(mediaFile.getFileAsPath().toFile(), true);){
            LOGGER.trace("ISO: Open");
            ArrayList<MediaInfoFile> allFiles = new ArrayList<MediaInfoFile>();
            ArrayList<Iso9660FileEntry> fileEntries = new ArrayList<Iso9660FileEntry>();
            Iterator iterator = image.iterator();
            while (iterator.hasNext()) {
                Iso9660FileEntry entry = (Iso9660FileEntry)iterator.next();
                if (entry.isDirectory()) continue;
                fileEntries.add(entry);
                MediaInfoFile mif = new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize());
                if (entry.getName().toUpperCase(Locale.ROOT).endsWith(".IFO")) {
                    byte[] contents = new byte[(int)entry.getSize()];
                    image.readBytes(entry, 0L, contents, 0, (int)entry.getSize());
                    mif.setContents(contents);
                }
                allFiles.add(mif);
            }
            List<MediaInfoFile> relevantFiles = MediaFileHelper.detectRelevantFiles(allFiles);
            for (Iso9660FileEntry entry : fileEntries) {
                MediaInfoFile mif = new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize());
                if (!relevantFiles.contains(mif)) continue;
                MediaInfoFile rel = relevantFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFilename().equals(mif.getFilename()) && mediaInfoFile.getPath().equals(mif.getPath())).findAny().orElse(null);
                mif.setContents(rel.getContents());
                LOGGER.trace("ISO: got entry {}, size : {}", (Object)entry.getName(), (Object)entry.getSize());
                MediaFile mf = new MediaFile(Paths.get(mediaFile.getFileAsPath().toString(), entry.getPath()));
                if (!mf.isDiscFile()) continue;
                try (MediaInfo fileMI = new MediaInfo();){
                    int fromBufferSize;
                    byte[] fromBuffer = new byte[bufferSize];
                    long fileSize = entry.getSize();
                    fileMI.openBufferInit(fileSize, 0L);
                    long pos = 0L;
                    do {
                        long toread;
                        if ((fromBufferSize = image.readBytes(entry, pos, fromBuffer, 0, (int)(toread = pos + (long)bufferSize > fileSize ? fileSize - pos : (long)bufferSize))) <= 0) continue;
                        pos += (long)fromBufferSize;
                        int result = fileMI.openBufferContinue(fromBuffer, fromBufferSize);
                        if ((result & 8) == 8) break;
                        if (fileMI.openBufferContinueGoToGet() == -1L) continue;
                        pos = fileMI.openBufferContinueGoToGet();
                        LOGGER.trace("ISO: Seek to {}", (Object)pos);
                        fileMI.openBufferInit(fileSize, pos);
                    } while (fromBufferSize > 0);
                    LOGGER.trace("ISO: finalize entry");
                    fileMI.openBufferFinalize();
                    mif.setSnapshot(fileMI.snapshot());
                    miFiles.add(mif);
                }
                catch (Error | Exception e) {
                    LOGGER.debug("Mediainfo could not open file STREAM for file {}", (Object)entry.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Mediainfo could not open as ISO9660 - {}", (Object)e.getMessage());
        }
        return miFiles;
    }

    static List<MediaInfoFile> parseIsoUdf(MediaFile mediaFile) {
        ArrayList<MediaInfoFile> miFiles = new ArrayList<MediaInfoFile>();
        try (UDFFileSystem image = new UDFFileSystem(mediaFile.getFileAsPath().toFile(), true);){
            MediaInfoFile mif;
            int bufferSize = 65536;
            ArrayList<MediaInfoFile> allFiles = new ArrayList<MediaInfoFile>();
            ArrayList<UDFFileEntry> fileEntries = new ArrayList<UDFFileEntry>();
            Iterator iterator = image.iterator();
            while (iterator.hasNext()) {
                Path folder;
                UDFFileEntry entry = (UDFFileEntry)iterator.next();
                if (entry.isDirectory() || (folder = Paths.get(entry.getPath(), new String[0]).getParent()) != null && folder.getFileName() != null && folder.getFileName().toString().equalsIgnoreCase("BACKUP") || folder.getParent() != null && folder.getParent().getFileName() != null && folder.getParent().getFileName().toString().equalsIgnoreCase("BACKUP")) continue;
                fileEntries.add(entry);
                mif = new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize());
                if (entry.getName().toUpperCase(Locale.ROOT).endsWith(".MPLS")) {
                    byte[] contents = new byte[(int)entry.getSize()];
                    image.readFileContent(entry, 0L, contents, 0, (int)entry.getSize());
                    mif.setContents(contents);
                }
                allFiles.add(mif);
            }
            List<MediaInfoFile> relevantFiles = MediaFileHelper.detectRelevantFiles(allFiles);
            for (UDFFileEntry entry : fileEntries) {
                mif = new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize());
                if (!relevantFiles.contains(mif)) continue;
                LOGGER.trace("ISO: got entry {}, size : {}", (Object)entry.getPath(), (Object)entry.getSize());
                try (MediaInfo fileMI = new MediaInfo();){
                    int fromBufferSize;
                    byte[] fromBuffer = new byte[bufferSize];
                    long fileSize = entry.getSize();
                    fileMI.openBufferInit(fileSize, 0L);
                    long pos = 0L;
                    do {
                        long toread;
                        if ((fromBufferSize = image.readFileContent(entry, pos, fromBuffer, 0, (int)(toread = pos + (long)bufferSize > fileSize ? fileSize - pos : (long)bufferSize))) <= 0) continue;
                        pos += (long)fromBufferSize;
                        int result = fileMI.openBufferContinue(fromBuffer, fromBufferSize);
                        if ((result & 8) == 8) break;
                        if (fileMI.openBufferContinueGoToGet() == -1L) continue;
                        pos = fileMI.openBufferContinueGoToGet();
                        LOGGER.trace("ISO: Seek to {}", (Object)pos);
                        fileMI.openBufferInit(fileSize, pos);
                    } while (fromBufferSize > 0);
                    LOGGER.trace("ISO: finalize entry");
                    fileMI.openBufferFinalize();
                    mif.setSnapshot(fileMI.snapshot());
                    miFiles.add(mif);
                }
                catch (Error | Exception e) {
                    LOGGER.debug("Mediainfo could not open file UDF for file {} - {}", (Object)entry.getPath(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Mediainfo could not open as UDF - {}", (Object)e.getMessage());
        }
        return miFiles;
    }

    static List<MediaInfoFile> detectRelevantFiles(List<MediaInfoFile> mediaInfoFiles) {
        if (mediaInfoFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (MediaFileHelper.isHDDVDStructure(mediaInfoFiles)) {
            return MediaFileHelper.detectRelevantHdDvdFiles(mediaInfoFiles);
        }
        if (MediaFileHelper.isDVDStructure(mediaInfoFiles)) {
            return MediaFileHelper.detectRelevantDvdFiles(mediaInfoFiles);
        }
        if (MediaFileHelper.isBlurayStructure(mediaInfoFiles)) {
            return MediaFileHelper.detectRelevantBlurayFiles(mediaInfoFiles);
        }
        return mediaInfoFiles;
    }

    public static List<MediaInfoFile> detectRelevantFiles(MediaFile mediaFile) {
        List<MediaInfoFile> mediaInfoFiles = new ArrayList<MediaInfoFile>();
        if (Files.isDirectory(mediaFile.getFileAsPath(), new LinkOption[0])) {
            Path folder = mediaFile.getFileAsPath();
            for (Path path : Utils.listFilesRecursive(folder)) {
                try {
                    mediaInfoFiles.add(new MediaInfoFile(path, Files.size(path)));
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse filesize of {} - {}", (Object)path, (Object)e.getMessage());
                }
            }
            mediaInfoFiles = MediaFileHelper.detectRelevantFiles(mediaInfoFiles);
        } else {
            if (mediaFile.getFilesize() == 0L) {
                try {
                    mediaFile.setFilesize(Files.size(mediaFile.getFileAsPath()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            mediaInfoFiles.add(new MediaInfoFile(mediaFile));
        }
        return mediaInfoFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MediaInfoFile> detectRelevantDvdFiles(List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile vob;
        ArrayList<MediaInfoFile> relevantFiles = new ArrayList<MediaInfoFile>();
        MediaInfoFile ifomif = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFilename().equalsIgnoreCase("VIDEO_TS.IFO")).findAny().orElse(null);
        if (ifomif == null) {
            LOGGER.debug("Could not find a valid VIDEO_TS.IFO file");
            return relevantFiles;
        }
        Object prefix = "XXXXXXXX";
        try {
            DataInputStream din = null;
            if (ifomif.getContents() == null) {
                InputStream is = Files.newInputStream(ifomif.getFileAsPath(), new OpenOption[0]);
                din = new DataInputStream(new BufferedInputStream(is));
            } else {
                din = new DataInputStream(new ByteArrayInputStream(ifomif.getContents()));
            }
            IfoReader dvd = new IfoReader();
            dvd.readVideoTsIfo(din);
            din.close();
            List<Integer> sets = dvd.getTitles().stream().map(DvdTitle::getVtsn).distinct().toList();
            for (Integer vtsn : sets) {
                String file = String.format("VTS_%02d_0.IFO", vtsn);
                LOGGER.debug("Reading file {}", (Object)file);
                MediaInfoFile vts = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFilename().equalsIgnoreCase(file)).findAny().orElse(null);
                if (vts == null) continue;
                FilterInputStream ifo = null;
                try {
                    if (vts.getContents() == null) {
                        FileInputStream fin = new FileInputStream(vts.getFileAsPath().toString());
                        ifo = new DataInputStream(new BufferedInputStream(fin));
                    } else {
                        ifo = new DataInputStream(new ByteArrayInputStream(vts.getContents()));
                    }
                    dvd.readVtsIfo((DataInputStream)ifo, vtsn);
                    ifo.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error parsing {}: {}", (Object)file, (Object)e.getMessage());
                }
                finally {
                    if (ifo == null) continue;
                    ifo.close();
                }
            }
            DvdTitle main = dvd.getTitles().stream().filter(t -> t.getTotalTimeMs() / 1000L < 9800L).max(Comparator.comparingLong(DvdTitle::getTotalTimeMs)).orElse(null);
            if (main == null) {
                main = dvd.getTitles().stream().max(Comparator.comparingLong(DvdTitle::getTotalTimeMs)).orElse(null);
            }
            if (main == null) {
                throw new IOException("Could not identify main DVD files - using fallback.");
            }
            prefix = "VTS_" + String.format("%02d", main.getVtsn());
        }
        catch (IOException e) {
            LOGGER.warn("Error parsing DVD: '{}' - Maybe it is just a MediaInfo XML?", (Object)ifomif.getFileAsPath(), (Object)e.getMessage());
            vob = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("VOB")).filter(mediaInfoFile -> mediaInfoFile.getDuration() < 9800).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null);
            if (vob == null) {
                LOGGER.debug("Could not find a valid VOB file");
                return relevantFiles;
            }
            prefix = StrgUtils.substr(vob.getFilename(), "(?i)^(VTS_\\d+).*");
        }
        for (MediaInfoFile mif2 : mediaInfoFiles) {
            if (!mif2.getFilename().toUpperCase(Locale.ROOT).startsWith((String)prefix) || mif2.getFilename().toUpperCase(Locale.ROOT).endsWith("_0.VOB") || !mif2.getFileExtension().equalsIgnoreCase("VOB") && !mif2.getFileExtension().equalsIgnoreCase("IFO")) continue;
            relevantFiles.add(mif2);
        }
        MediaInfoFile relvob = relevantFiles.stream().filter(mif -> mif.getFilename().toUpperCase().endsWith("_1.VOB")).findAny().orElse(null);
        if (relvob == null && (vob = (MediaInfoFile)mediaInfoFiles.stream().filter(mif -> mif.getFilename().toUpperCase().endsWith("_1.VOB")).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null)) != null) {
            relevantFiles.add(vob);
        }
        if (!relevantFiles.isEmpty()) {
            relevantFiles.add(ifomif);
        }
        return relevantFiles;
    }

    private static List<MediaInfoFile> detectRelevantBlurayFiles(List<MediaInfoFile> mediaInfoFiles) {
        ArrayList<MediaInfoFile> relevantFiles = new ArrayList<MediaInfoFile>();
        MPLSObject longestPlaylist = new MPLSObject();
        for (MediaInfoFile mif : mediaInfoFiles) {
            PlayItem[] folder = mif.getFileAsPath().getParent();
            if (folder != null && folder.getFileName() != null && folder.getFileName().toString().equalsIgnoreCase("BACKUP") || folder.getParent() != null && folder.getParent().getFileName() != null && folder.getParent().getFileName().toString().equalsIgnoreCase("BACKUP") || !"mpls".equalsIgnoreCase(mif.getFileExtension())) continue;
            try {
                DataInputStream din = null;
                if (mif.getContents() == null) {
                    FileInputStream fin = new FileInputStream(mif.getFileAsPath().toString());
                    din = new DataInputStream(new BufferedInputStream(fin));
                } else {
                    din = new DataInputStream(new ByteArrayInputStream(mif.getContents()));
                }
                MPLSObject mplsFile = new MPLSReader().readBinary(din);
                din.close();
                if (mplsFile.getDuration() < 120L) {
                    LOGGER.trace("Playlist {} is too short - ignoring", (Object)mif.getFilename());
                    continue;
                }
                if (!MediaFileHelper.hasDupeTracks(mplsFile)) {
                    if (mplsFile.getDuration() <= longestPlaylist.getDuration()) continue;
                    longestPlaylist = mplsFile;
                    relevantFiles.clear();
                    relevantFiles.add(mif);
                    LOGGER.trace("Considering {} as longest playlist (for now)", (Object)mif.getFilename());
                    continue;
                }
                LOGGER.trace("Playlist {} has duplicate streams - ignoring", (Object)mif.getFilename());
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse Bluray playlist file: '{}' - Maybe it is just a MediaInfo XML?", (Object)mif.getFileAsPath(), (Object)e.getMessage());
            }
        }
        if (longestPlaylist.getDuration() > 0L) {
            ArrayList<String> items = new ArrayList<String>();
            ArrayList<Long> durations = new ArrayList<Long>();
            for (PlayItem item : longestPlaylist.getPlayList().getPlayItems()) {
                items.add(item.getAngles()[0].getClipName());
                durations.add((item.getOutTime() - item.getInTime()) / 45000L);
            }
            for (int i = 0; i < items.size(); ++i) {
                String item = (String)items.get(i);
                for (MediaInfoFile mif : mediaInfoFiles) {
                    Path folder = mif.getFileAsPath().getParent();
                    if (folder != null && folder.getFileName() != null && folder.getFileName().toString().equalsIgnoreCase("BACKUP") || folder != null && folder.getParent() != null && folder.getParent().getFileName() != null && folder.getParent().getFileName().toString().equalsIgnoreCase("BACKUP") || mif.getFileExtension().equalsIgnoreCase("mpls") || !mif.getFilename().startsWith(item)) continue;
                    mif.setDuration(((Long)durations.get(i)).intValue());
                    relevantFiles.add(mif);
                }
            }
        } else {
            if (mediaInfoFiles.size() == 1 && mediaInfoFiles.get(0).getSnapshot() != null) {
                relevantFiles.add(mediaInfoFiles.get(0));
                return relevantFiles;
            }
            MediaInfoFile mainVideo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("m2ts")).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null);
            if (mainVideo == null || !mainVideo.getFilename().matches("^\\d{5}.*")) {
                return Collections.emptyList();
            }
            String prefix = mainVideo.getFilename().substring(0, 5);
            for (MediaInfoFile mif : mediaInfoFiles) {
                if (!mif.getFilename().startsWith(prefix)) continue;
                relevantFiles.add(mif);
            }
        }
        return relevantFiles;
    }

    private static boolean hasDupeTracks(MPLSObject mplsObject) {
        ArrayList<String> streams = new ArrayList<String>();
        for (PlayItem item : mplsObject.getPlayList().getPlayItems()) {
            String itemKey = item.getAngles()[0].getClipName();
            if (streams.contains(itemKey)) {
                return true;
            }
            streams.add(itemKey);
        }
        return false;
    }

    private static List<MediaInfoFile> detectRelevantHdDvdFiles(List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile evo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("evo")).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null);
        if (evo == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaInfoFile> relevantFiles = new ArrayList<MediaInfoFile>();
        relevantFiles.add(evo);
        return relevantFiles;
    }

    public static List<String> getMediaInfoValues(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        if (miSnapshot == null) {
            return Collections.emptyList();
        }
        List<Map<String, String>> stream = miSnapshot.get((Object)streamKind);
        if (stream == null || stream.size() <= streamNumber) {
            return Collections.emptyList();
        }
        Map<String, String> info = stream.get(streamNumber);
        if (info == null) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        Map<String, String> normalizedMap = MediaFileHelper.normalizeKeys(info);
        List<String> normalizedKeys = MediaFileHelper.normalizeKeys(keys);
        for (String key : normalizedKeys) {
            String value = normalizedMap.get(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            values.add(value);
        }
        return values;
    }

    public static String getMediaInfoValue(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        return MediaFileHelper.getMediaInfoValues(miSnapshot, streamKind, streamNumber, keys).stream().findFirst().orElse("");
    }

    public static String getMediaInfoContains(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, MediaInfo.StreamKind streamKind, int streamNumber, String search, String ... keys) {
        if (miSnapshot == null) {
            return "";
        }
        List<Map<String, String>> stream = miSnapshot.get((Object)streamKind);
        if (stream == null) {
            return "";
        }
        Map<String, String> info = stream.get(streamNumber);
        if (info == null) {
            return "";
        }
        Map<String, String> normalizedMap = MediaFileHelper.normalizeKeys(info);
        List<String> normalizedKeys = MediaFileHelper.normalizeKeys(keys);
        for (String key : normalizedKeys) {
            String value = normalizedMap.get(key);
            if (!StringUtils.isNotBlank((CharSequence)value) || !value.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
            return search;
        }
        return "";
    }

    private static Map<String, String> normalizeKeys(Map<String, String> originalMap) {
        HashMap<String, String> normalizedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : originalMap.entrySet()) {
            normalizedMap.put(MediaFileHelper.normalizeKey(entry.getKey()), entry.getValue());
        }
        return normalizedMap;
    }

    private static List<String> normalizeKeys(String ... keys) {
        ArrayList<String> normalizedKeys = new ArrayList<String>();
        for (String key : keys) {
            normalizedKeys.add(MediaFileHelper.normalizeKey(key));
        }
        return normalizedKeys;
    }

    public static String normalizeKey(String key) {
        String normalizedKey = key.replace("(", "");
        normalizedKey = normalizedKey.replace(")", "");
        normalizedKey = normalizedKey.replace('/', '_');
        normalizedKey = normalizedKey.replace('*', '_');
        normalizedKey = normalizedKey.replace(':', '_');
        normalizedKey = normalizedKey.replace('.', '_');
        normalizedKey = normalizedKey.toLowerCase(Locale.ROOT);
        return normalizedKey;
    }

    public static String getMediaInfoDirect(MediaFile mediaFile, MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        List<MediaInfoFile> mediaInfoFiles = MediaFileHelper.getMediaInfoFromSingleFile(mediaFile);
        if (!mediaInfoFiles.isEmpty()) {
            return MediaFileHelper.getMediaInfoValue(mediaInfoFiles.get(0).getSnapshot(), streamKind, streamNumber, keys);
        }
        return "";
    }

    public static MediaFileSubtitle gatherSubtitleLanguageFromFile(MediaFile mediaFile) {
        String filename = mediaFile.getFilename();
        String path = mediaFile.getPath();
        MediaFileSubtitle sub = new MediaFileSubtitle();
        if (filename.endsWith(".sub")) {
            Path idx = Paths.get(path, filename.replaceFirst("sub$", "idx"));
            try (FileReader fr = new FileReader(idx.toFile());
                 BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    String lang = "";
                    if (line.startsWith("id:")) {
                        lang = StrgUtils.substr(line, "id: (.*?),");
                    }
                    if (lang.isEmpty()) continue;
                    sub.setLanguage(LanguageUtils.findLanguageInString(lang));
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.debug("could not read idx file: {}", (Object)e.getMessage());
            }
        }
        sub.setCodec(mediaFile.getExtension());
        return sub;
    }

    private static MediaFileSubtitle gatherSubtitleInformationFromMediainfo(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, int i) {
        String def;
        MediaFileSubtitle stream = new MediaFileSubtitle();
        stream.id = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Text, i, "StreamKindPos");
        String codec = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Text, i, "CodecID/Hint", "Format");
        stream.setCodec(codec.replaceAll("\\p{Punct}", ""));
        String lang = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Text, i, "Language", "Language/String");
        stream.setLanguage(LanguageUtils.parseLanguageFromString(lang));
        String forced = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Text, i, "Forced");
        boolean b = forced.equalsIgnoreCase("true") || forced.equalsIgnoreCase("yes");
        stream.setForced(b);
        String title = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Text, i, "Title");
        if (StringUtils.isNotBlank((CharSequence)title)) {
            stream.setTitle(title);
        }
        if ((def = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Text, i, "Default")).equalsIgnoreCase("true") || def.equalsIgnoreCase("yes")) {
            stream.setDefaultStream(true);
        }
        return stream;
    }

    private static void gatherSubtitleInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        mediaFile.clearSubtitleInformation();
        int streams = MediaFileHelper.getSubtitleStreamCount(miSnapshot);
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            MediaFileSubtitle sub = new MediaFileSubtitle();
            if (streams > 0) {
                MediaFileSubtitle stream;
                sub = stream = MediaFileHelper.gatherSubtitleInformationFromMediainfo(miSnapshot, 0);
            }
            if (sub.getLanguage().isEmpty()) {
                MediaFileSubtitle file = MediaFileHelper.gatherSubtitleLanguageFromFile(mediaFile);
                sub.setLanguage(file.getLanguage());
            }
            mediaFile.setSubtitles(Collections.singletonList(sub));
        } else {
            ArrayList<MediaFileSubtitle> subtitles = new ArrayList<MediaFileSubtitle>();
            for (int i = 0; i < streams; ++i) {
                MediaFileSubtitle stream = MediaFileHelper.gatherSubtitleInformationFromMediainfo(miSnapshot, i);
                subtitles.add(stream);
            }
            mediaFile.setSubtitles(subtitles);
        }
    }

    private static void gatherAudioInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        mediaFile.clearAudioInformation();
        ArrayList<MediaFileAudioStream> audioStreams = new ArrayList<MediaFileAudioStream>();
        for (int i = 0; i < MediaFileHelper.getAudioStreamCount(miSnapshot); ++i) {
            String forced;
            String def;
            String commName;
            String audioProfile;
            String addFeature;
            String formatString;
            String[] acSearch = new String[]{"Format", "Format_Profile", "Format_Commercial", "Format_Commercial_IfAny", "CodecID", "Codec"};
            String audioCodec = MediaFileHelper.getMediaInfoContains(miSnapshot, MediaInfo.StreamKind.Audio, i, "TrueHD", acSearch);
            if (StringUtils.isBlank((CharSequence)audioCodec)) {
                audioCodec = MediaFileHelper.getMediaInfoContains(miSnapshot, MediaInfo.StreamKind.Audio, i, "DTS", acSearch);
            }
            if (StringUtils.isBlank((CharSequence)audioCodec)) {
                audioCodec = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format");
                audioCodec = audioCodec.replaceAll("\\p{Punct}", "");
            }
            if ("ac3".equalsIgnoreCase(audioCodec) && "e-ac-3".equalsIgnoreCase(formatString = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_String"))) {
                audioCodec = "EAC3";
            }
            if (!(addFeature = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_AdditionalFeatures")).isEmpty()) {
                if ("dts".equalsIgnoreCase(audioCodec)) {
                    if (addFeature.startsWith("XLL")) {
                        audioCodec = addFeature.endsWith("X") ? "DTS-X" : (addFeature.endsWith("IMAX") ? "DTS-X-IMAX" : "DTSHD-MA");
                    }
                    if (addFeature.equals("ES")) {
                        audioCodec = "DTS-ES";
                    }
                    if (addFeature.equals("XBR")) {
                        audioCodec = "DTSHD-HRA";
                    }
                    if (addFeature.equals("X96")) {
                        audioCodec = "DTS-96/24";
                    }
                }
                if ("TrueHD".equalsIgnoreCase(audioCodec) && addFeature.equalsIgnoreCase("16-ch")) {
                    audioCodec = "TrueHD/Atmos";
                }
            }
            if (!(audioProfile = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_Profile")).isEmpty()) {
                if ("dts".equalsIgnoreCase(audioCodec)) {
                    if (audioProfile.contains("ES")) {
                        audioCodec = "DTS-ES";
                    }
                    if (audioProfile.contains("HRA")) {
                        audioCodec = "DTSHD-HRA";
                    }
                    if (audioProfile.contains("MA")) {
                        audioCodec = "DTSHD-MA";
                    }
                    if (audioProfile.contains("X")) {
                        audioCodec = "DTS-X";
                    }
                }
                if ("TrueHD".equalsIgnoreCase(audioCodec) && audioProfile.contains("Atmos")) {
                    audioCodec = "TrueHD/Atmos";
                }
                if ("MPEG Audio".equalsIgnoreCase(audioCodec)) {
                    String codecId = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "CodecID");
                    if ("55".equals(codecId) || "A_MPEG/L3".equalsIgnoreCase(codecId) || "Layer 3".equalsIgnoreCase(audioProfile)) {
                        audioCodec = "MP3";
                    } else if ("A_MPEG/L2".equalsIgnoreCase(codecId) || "Layer 2".equalsIgnoreCase(audioProfile)) {
                        audioCodec = "MP2";
                    }
                }
            }
            if (("ac3".equalsIgnoreCase(audioCodec) || "eac3".equalsIgnoreCase(audioCodec) || "dts".equalsIgnoreCase(audioCodec) || "TrueHD".equalsIgnoreCase(audioCodec)) && !(commName = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_Commercial", "Format_Commercial_IfAny").toLowerCase(Locale.ROOT)).isEmpty()) {
                if (commName.contains("master audio")) {
                    audioCodec = "DTSHD-MA";
                }
                if (commName.contains("high resolution audio")) {
                    audioCodec = "DTSHD-HRA";
                }
                if (commName.contains("extended") || commName.contains("es matrix") || commName.contains("es discrete")) {
                    audioCodec = "DTS-ES";
                }
                if (commName.contains("truehd") && commName.contains("atmos")) {
                    audioCodec = "TrueHD/Atmos";
                }
                if (commName.contains("dolby digital plus") && commName.contains("atmos")) {
                    audioCodec = "EAC3/Atmos";
                }
                if (commName.contains("ex audio")) {
                    audioCodec = "AC3EX";
                }
            }
            MediaFileAudioStream stream = new MediaFileAudioStream();
            stream.id = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "StreamKindPos");
            stream.setCodec(audioCodec);
            int ch = MediaFileHelper.parseChannelsAsInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Channel(s)"));
            int ch2 = MediaFileHelper.parseChannelsAsInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Channel(s)_Original"));
            if (ch2 > ch) {
                ch = ch2;
            }
            stream.setAudioChannels(ch);
            String br = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "BitRate", "BitRate_Maximum", "BitRate_Minimum", "BitRate_Nominal");
            if (StringUtils.isNotBlank((CharSequence)br)) {
                try {
                    String[] brMode = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "BitRate_Mode").split("/");
                    if (brMode.length > 1) {
                        String[] brChunks = br.split("/");
                        int brMult = 0;
                        for (String brChunk : brChunks) {
                            brMult += MetadataUtil.parseInt(brChunk.strip(), 0);
                        }
                        stream.setBitrate(brMult / 1000);
                    } else {
                        br = br.replace("kb/s", "");
                        stream.setBitrate(Integer.parseInt(br.strip()) / 1000);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse bitrate: {}", (Object)e.getMessage());
                }
            }
            String bd = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "BitDepth");
            stream.setBitDepth(MetadataUtil.parseInt(bd, 0));
            String language = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Language", "Language/String");
            if (language.isEmpty()) {
                if (!mediaFile.isDiscFile()) {
                    String shortname = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                    stream.setLanguage(LanguageUtils.parseLanguageFromString(shortname));
                }
            } else {
                stream.setLanguage(LanguageUtils.parseLanguageFromString(language));
            }
            if ((def = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Default")).equalsIgnoreCase("true") || def.equalsIgnoreCase("yes")) {
                stream.setDefaultStream(true);
            }
            if ((forced = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Forced")).equalsIgnoreCase("true") || forced.equalsIgnoreCase("yes")) {
                stream.setForced(true);
            }
            String title = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Audio, i, "Title");
            stream.setTitle(title);
            audioStreams.add(stream);
        }
        mediaFile.setAudioStreams(audioStreams);
    }

    private static int getStreamCount(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, MediaInfo.StreamKind kind) {
        List<Map<String, String>> map = miSnapshot.get((Object)kind);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    private static int getAudioStreamCount(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int streamCount = 0;
        try {
            streamCount = MetadataUtil.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "AudioCount"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (streamCount == 0) {
            streamCount = MediaFileHelper.getStreamCount(miSnapshot, MediaInfo.StreamKind.Audio);
        }
        return streamCount;
    }

    private static int getSubtitleStreamCount(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int streamsTextCount = MetadataUtil.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "TextCount"), 0);
        int streamsStreamCount = MetadataUtil.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Text, 0, "StreamCount"), 0);
        return streamsTextCount > 0 ? streamsTextCount : streamsStreamCount;
    }

    public static int parseChannelsAsInt(String channels) {
        int highest = 0;
        if (!channels.isEmpty()) {
            try {
                String[] parts;
                for (String p : parts = channels.split("/")) {
                    String[] c;
                    if (p.toLowerCase(Locale.ROOT).contains("object")) continue;
                    p = p.replaceAll("[a-zA-Z]", "");
                    int ch = 0;
                    for (String s : c = p.split("[^0-9]")) {
                        if (!s.matches("[0-9]+")) continue;
                        ch += Integer.parseInt(s);
                    }
                    if (ch <= highest) continue;
                    highest = ch;
                }
            }
            catch (NumberFormatException e) {
                highest = 0;
            }
        }
        return highest;
    }

    private static void gatherExtraData(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        String episode;
        String season;
        String dateAsString;
        String genre;
        String plot;
        String originalTitle;
        String title;
        String imdbId = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "id");
        if (MediaIdUtil.isValidImdbId(imdbId)) {
            mediaFile.addExtraData("imdbId", imdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)(title = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Title", "Movie")))) {
            mediaFile.addExtraData("title", title);
        }
        if (StringUtils.isNotBlank((CharSequence)(originalTitle = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Original")))) {
            mediaFile.addExtraData("originalTitle", originalTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(plot = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "extra/LongDescription", "Summary", "Description", "Comment")))) {
            mediaFile.addExtraData("plot", plot);
        }
        if (StringUtils.isNotBlank((CharSequence)(genre = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Genre")))) {
            mediaFile.addExtraData("genre", genre);
        }
        if (StringUtils.isNotBlank((CharSequence)(dateAsString = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Released_Date", "Recorded_Date", "Date")))) {
            try {
                Date date = DateUtils.parseDate(dateAsString);
                if (date != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    mediaFile.addExtraData("year", String.valueOf(calendar.get(1)));
                    mediaFile.addExtraData("releaseDate", dateAsString);
                }
            }
            catch (Exception date) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(season = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Season")))) {
            mediaFile.addExtraData("season", season);
        }
        if (StringUtils.isNotBlank((CharSequence)(episode = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Recorded_Date", "Date")))) {
            mediaFile.addExtraData("episode", episode);
        }
    }

    private static void gatherVideoInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        String trans;
        String col;
        mediaFile.clearVideoInformation();
        int height = 0;
        int width = 0;
        try {
            height = MetadataUtil.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "Height"));
            width = MetadataUtil.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "Width"));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse width/height: {}", (Object)e.getMessage());
        }
        String mvc = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "MultiView_Count");
        if ("2".equals(mvc) && width > 0 && height > 0) {
            float calculatedAspect = (float)width / (float)height;
            if (calculatedAspect > 3.0f) {
                width /= 2;
            } else if ((double)calculatedAspect < 1.5) {
                height /= 2;
            }
        }
        mediaFile.setVideoWidth(width);
        mediaFile.setVideoHeight(height);
        String br = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "BitRate");
        if (StringUtils.isNotBlank((CharSequence)br)) {
            try {
                mediaFile.setVideoBitRate(Integer.parseInt(br) / 1000);
            }
            catch (NumberFormatException e) {
                mediaFile.setVideoBitRate(0);
            }
        }
        String scanType = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "ScanType");
        String codecId = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "CodecID");
        Object videoCodec = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "CodecID/Hint", "Format");
        if (StringUtils.containsIgnoreCase((CharSequence)videoCodec, (CharSequence)"Microsoft")) {
            videoCodec = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "Format");
        }
        if (codecId.equalsIgnoreCase("XVID")) {
            videoCodec = "XVID";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)videoCodec, (CharSequence)"MPEG")) {
            try {
                int version = Integer.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "Format_Version").replaceAll("\\D*", ""));
                videoCodec = "MPEG-" + version;
            }
            catch (Exception e) {
                LOGGER.trace("could not parse MPEG version: {}", (Object)e.getMessage());
            }
        }
        mediaFile.setVideoCodec(MediaFileHelper.getFirstEntryViaScanner((String)videoCodec));
        String bd = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "BitDepth");
        mediaFile.setBitDepth(MetadataUtil.parseInt(bd, 0));
        try {
            String fr = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "FrameRate", "FrameRate_Original");
            mediaFile.setFrameRate(Double.parseDouble(fr));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse frame rate: {}", (Object)e.getMessage());
        }
        if (height == 0 || scanType.isEmpty()) {
            mediaFile.setExactVideoFormat("");
        } else {
            mediaFile.setExactVideoFormat("" + height + Character.toLowerCase(scanType.charAt(0)));
        }
        String containerFormat = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Menu_Format_List", "Format");
        if (StringUtils.isBlank((CharSequence)containerFormat)) {
            containerFormat = MediaFileHelper.getFirstEntryViaScanner(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Format/Extensions"));
        }
        if (StringUtils.isNotBlank((CharSequence)containerFormat)) {
            if ("BDAV".equalsIgnoreCase(containerFormat)) {
                containerFormat = "Blu-Ray Video";
            } else if ("DVD-Video".equalsIgnoreCase(containerFormat)) {
                containerFormat = "DVD Video";
            }
            mediaFile.setContainerFormat(containerFormat);
        } else {
            mediaFile.setContainerFormat(mediaFile.getExtension());
        }
        String parString = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "PixelAspectRatio", "Pixel_aspect_ratio");
        if (parString.isEmpty()) {
            parString = "1.0";
        }
        try {
            float par = Float.parseFloat(parString);
            mediaFile.setPixelAspectRatio(Float.valueOf(par));
            mediaFile.setAspectRatio(Float.valueOf((float)mediaFile.getVideoWidth() * par / (float)mediaFile.getVideoHeight()));
        }
        catch (Exception e) {
            LOGGER.info("Could not parse AspectRatio from '{}' - '{}'", (Object)parString, (Object)e.getMessage());
        }
        mediaFile.setVideo3DFormat(MediaFileHelper.parse3DFormat(mediaFile, miSnapshot));
        String hdrFormat = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "HDR_Format_String", "HDR_Format");
        String hdrCompat = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "HDR_Format_Compatibility");
        hdrFormat = MediaFileHelper.detectHdrFormat(hdrFormat + " / " + hdrCompat);
        if (StringUtils.isBlank((CharSequence)hdrFormat)) {
            hdrFormat = MediaFileHelper.detectHdrFormat(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "transfer_characteristics"));
        }
        if (StringUtils.isBlank((CharSequence)hdrFormat) && (col = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "colour_primaries")).contains("2100")) {
            hdrFormat = "HDR";
        }
        if (StringUtils.isBlank((CharSequence)hdrFormat) && ((trans = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "transfer_characteristics")).contains("2100") || trans.equals("PQ") || trans.equals("HLG"))) {
            hdrFormat = "HDR";
        }
        mediaFile.setHdrFormat(hdrFormat);
        if (Settings.getInstance().isArdEnabled()) {
            MediaFileARDetectorTask task = new MediaFileARDetectorTask(mediaFile);
            task.run();
        }
    }

    private static String detectHdrFormat(String source) {
        source = source.toLowerCase(Locale.ROOT);
        ArrayList<String> ret = new ArrayList<String>();
        if (source.contains("dolby vision")) {
            ret.add("Dolby Vision");
        }
        if (source.contains("hlg")) {
            ret.add("HLG");
        }
        if (source.contains("2094") || source.contains("hdr10+")) {
            ret.add("HDR10+");
        } else if (source.contains("2086") || source.contains("hdr10")) {
            ret.add("HDR10");
        }
        return String.join((CharSequence)", ", ret);
    }

    public static void gatherImageInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int height = MetadataUtil.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Image, 0, "Height"), 0);
        int width = MetadataUtil.parseInt(MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Image, 0, "Width"), 0);
        String videoCodec = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Image, 0, "CodecID/Hint", "Format");
        mediaFile.clearVideoInformation();
        mediaFile.checkForAnimation();
        mediaFile.setVideoHeight(height);
        mediaFile.setVideoWidth(width);
        mediaFile.setVideoCodec(MediaFileHelper.getFirstEntryViaScanner(videoCodec));
        String extensions = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
        mediaFile.setContainerFormat(MediaFileHelper.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
        String bd = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Image, 0, "BitDepth");
        mediaFile.setBitDepth(MetadataUtil.parseInt(bd, 0));
        if (StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
            mediaFile.setContainerFormat(mediaFile.getExtension());
        }
    }

    public static String getFirstEntryViaScanner(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        Scanner scanner = new Scanner(string);
        try {
            String string2 = scanner.next();
            scanner.close();
            return string2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.debug("could not parse string {} with a Scanner: {}", (Object)string, (Object)e.getMessage());
                return "";
            }
        }
    }

    private static void gatherMediaInformationFromFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot = mediaInfoFiles.get(0).getSnapshot();
        if (miSnapshot == null) {
            LOGGER.error("Error getting MediaInfo for '{}'", (Object)mediaFile.getFilename());
            mediaFile.setContainerFormat(mediaFile.getExtension());
            return;
        }
        LOGGER.trace("got mediainfo for '{}'", (Object)mediaFile.getFileAsPath());
        switch (mediaFile.getType()) {
            case VIDEO: {
                MediaFileHelper.gatherExtraData(mediaFile, miSnapshot);
            }
            case EXTRA: 
            case SAMPLE: 
            case TRAILER: {
                MediaFileHelper.gatherVideoInformation(mediaFile, miSnapshot);
                MediaFileHelper.gatherAudioInformation(mediaFile, miSnapshot);
                MediaFileHelper.gatherSubtitleInformation(mediaFile, miSnapshot);
                break;
            }
            case AUDIO: {
                MediaFileHelper.gatherAudioInformation(mediaFile, miSnapshot);
                MediaFileHelper.gatherSubtitleInformation(mediaFile, miSnapshot);
                break;
            }
            case POSTER: 
            case BANNER: 
            case FANART: 
            case THUMB: 
            case EXTRAFANART: 
            case GRAPHIC: 
            case SEASON_POSTER: 
            case SEASON_FANART: 
            case SEASON_BANNER: 
            case SEASON_THUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case CHARACTERART: 
            case DISC: 
            case EXTRATHUMB: 
            case KEYART: {
                MediaFileHelper.gatherImageInformation(mediaFile, miSnapshot);
                break;
            }
            case NFO: {
                break;
            }
            case SUBTITLE: {
                MediaFileHelper.gatherSubtitleInformation(mediaFile, miSnapshot);
                break;
            }
            default: {
                LOGGER.debug("no mediainformation handling for MediaFile type {} yet.", (Object)mediaFile.getType());
            }
        }
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            mediaFile.setContainerFormat(mediaFile.getExtension());
        } else {
            String extensions = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
            mediaFile.setContainerFormat(MediaFileHelper.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
            if (StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
                mediaFile.setContainerFormat(mediaFile.getExtension());
            }
        }
        switch (mediaFile.getType()) {
            case VIDEO: 
            case EXTRA: 
            case SAMPLE: 
            case TRAILER: 
            case AUDIO: {
                String miTitle;
                String br = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "OverallBitRate");
                if (StringUtils.isBlank((CharSequence)br)) {
                    br = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "OverallBitRate_Maximum");
                }
                if (StringUtils.isNotBlank((CharSequence)br)) {
                    try {
                        mediaFile.setOverallBitRate(Integer.parseInt(br) / 1000);
                    }
                    catch (NumberFormatException e) {
                        mediaFile.setOverallBitRate(0);
                    }
                }
                if (!(miTitle = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Title")).isEmpty()) {
                    mediaFile.setTitle(miTitle);
                }
                mediaFile.setDuration(MediaFileHelper.parseDuration(miSnapshot));
                break;
            }
        }
    }

    public static int parseDuration(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        String dur = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Duration/String3");
        if (StringUtils.isNotBlank((CharSequence)dur)) {
            try {
                String[] split = dur.split("[:.]");
                if (split.length >= 3) {
                    int hours = MetadataUtil.parseInt(split[0]);
                    int minutes = MetadataUtil.parseInt(split[1]);
                    int seconds = MetadataUtil.parseInt(split[2]);
                    return hours * 3600 + minutes * 60 + seconds;
                }
            }
            catch (Exception ignored) {
                LOGGER.trace("Could not parse duration as h:m:s: {}", (Object)dur);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(dur = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.General, 0, "Duration")))) {
            try {
                double ddur = Double.parseDouble(dur);
                if (ddur > 25000.0) {
                    return (int)(ddur / 1000.0);
                }
                return (int)ddur;
            }
            catch (NumberFormatException ignored) {
                LOGGER.trace("Could not parse duration as double {}", (Object)dur);
            }
        }
        return 0;
    }

    private static String parse3DFormat(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int height = mediaFile.getVideoHeight();
        int width = mediaFile.getVideoWidth();
        String mvc = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "MultiView_Count");
        String video3DFormat = "";
        if (!StringUtils.isEmpty((CharSequence)mvc) && mvc.equals("2")) {
            video3DFormat = VIDEO_3D;
            String mvl = MediaFileHelper.getMediaInfoValue(miSnapshot, MediaInfo.StreamKind.Video, 0, "MultiView_Layout").toLowerCase(Locale.ROOT);
            if (!mvl.isEmpty()) {
                LOGGER.trace("3D detected :) - {}", (Object)mvl);
                MediaInfo3D ddd = MediaInfo3D.get3DFrom(mvl);
                if (ddd != MediaInfo3D.MONO) {
                    video3DFormat = ddd.getId();
                }
            } else {
                LOGGER.debug("3D detected for '{}', but correct implementation could not be detected!", (Object)mediaFile.getFile());
                video3DFormat = VIDEO_3D;
            }
        } else if (width == 3840 && height <= 1080) {
            video3DFormat = VIDEO_3D_SBS;
        } else if (width == 1920 && height == 2160) {
            video3DFormat = VIDEO_3D_TAB;
        }
        return video3DFormat;
    }

    private static void gatherMediaInformationFromDvdFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile ifo = null;
        int videoDur = 0;
        for (MediaInfoFile mif : mediaInfoFiles) {
            mif.gatherMediaInformation();
            if (mif.getFileExtension().equalsIgnoreCase("vob")) {
                String br;
                if (mediaFile.getVideoCodec().isEmpty()) {
                    MediaFileHelper.gatherVideoInformation(mediaFile, mif.getSnapshot());
                }
                if (mediaFile.getAudioStreams() == null || mediaFile.getAudioStreams().size() == 0) {
                    MediaFileHelper.gatherAudioInformation(mediaFile, mif.getSnapshot());
                }
                if (mediaFile.getOverallBitRate() == 0 && !(br = MediaFileHelper.getMediaInfoValue(mif.getSnapshot(), MediaInfo.StreamKind.General, 0, "OverallBitRate")).isEmpty()) {
                    try {
                        mediaFile.setOverallBitRate(Integer.parseInt(br) / 1000);
                    }
                    catch (NumberFormatException e) {
                        mediaFile.setOverallBitRate(0);
                    }
                }
                videoDur += mif.getDuration();
                continue;
            }
            if (ifo != null || !mif.getFileExtension().equalsIgnoreCase("ifo")) continue;
            ifo = mif;
        }
        mediaFile.setDuration(videoDur);
        if (ifo == null) {
            return;
        }
        MediaFileHelper.gatherSubtitleInformation(mediaFile, ifo.getSnapshot());
        for (int i = 0; i < MediaFileHelper.getAudioStreamCount(ifo.getSnapshot()); ++i) {
            String id = MediaFileHelper.getMediaInfoValue(ifo.getSnapshot(), MediaInfo.StreamKind.Audio, i, "StreamKindPos");
            MediaFileAudioStream audioStream = null;
            for (MediaFileAudioStream stream : mediaFile.getAudioStreams()) {
                if (!id.equals(stream.id)) continue;
                audioStream = stream;
                break;
            }
            if (audioStream == null) continue;
            String language = MediaFileHelper.getMediaInfoValue(ifo.getSnapshot(), MediaInfo.StreamKind.Audio, i, "Language", "Language/String");
            if (language.isEmpty()) {
                if (mediaFile.isDiscFile()) continue;
                String shortname = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                audioStream.setLanguage(LanguageUtils.parseLanguageFromString(shortname));
                continue;
            }
            audioStream.setLanguage(LanguageUtils.parseLanguageFromString(language));
        }
        mediaFile.setDuration(ifo.getDuration());
    }

    private static void gatherMediaInformationFromBluRayFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile ssif;
        MediaInfoFile m2ts = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("m2ts") || mediaInfoFile.getFileExtension().equals("mpls")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null);
        if (m2ts == null) {
            LOGGER.debug("Could not find a valid M2TS file");
            return;
        }
        LOGGER.trace("Considering M2TS file: {}", (Object)m2ts.getFilename());
        MediaFileHelper.gatherMediaInformationFromFile(mediaFile, Collections.singletonList(m2ts));
        MediaInfoFile clpi = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("clpi")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null);
        if (clpi != null) {
            Object language;
            String id;
            int i;
            if (mediaFile.getDuration() == 0) {
                mediaFile.setDuration(MediaFileHelper.parseDuration(clpi.getSnapshot()));
            }
            for (i = 0; i < MediaFileHelper.getAudioStreamCount(clpi.getSnapshot()); ++i) {
                id = MediaFileHelper.getMediaInfoValue(clpi.getSnapshot(), MediaInfo.StreamKind.Audio, i, "StreamKindPos");
                MediaFileAudioStream audioStream = null;
                for (MediaFileAudioStream mediaFileAudioStream : mediaFile.getAudioStreams()) {
                    if (!id.equals(mediaFileAudioStream.id)) continue;
                    audioStream = mediaFileAudioStream;
                    break;
                }
                if (audioStream == null) continue;
                language = MediaFileHelper.getMediaInfoValue(clpi.getSnapshot(), MediaInfo.StreamKind.Audio, i, "Language", "Language/String");
                if (((String)language).isEmpty()) {
                    if (mediaFile.isDiscFile()) continue;
                    String string = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                    audioStream.setLanguage(LanguageUtils.parseLanguageFromString(string));
                    continue;
                }
                audioStream.setLanguage(LanguageUtils.parseLanguageFromString((String)language));
            }
            for (i = 0; i < MediaFileHelper.getSubtitleStreamCount(clpi.getSnapshot()); ++i) {
                id = MediaFileHelper.getMediaInfoValue(clpi.getSnapshot(), MediaInfo.StreamKind.Text, i, "StreamKindPos");
                MediaFileSubtitle subtitle = null;
                for (MediaFileSubtitle mediaFileSubtitle : mediaFile.getSubtitles()) {
                    if (!id.equals(mediaFileSubtitle.id)) continue;
                    subtitle = mediaFileSubtitle;
                    break;
                }
                if (subtitle == null) continue;
                language = MediaFileHelper.getMediaInfoValue(clpi.getSnapshot(), MediaInfo.StreamKind.Text, i, "Language", "Language/String");
                if (((String)language).isEmpty()) {
                    if (mediaFile.isDiscFile()) continue;
                    String string = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                    subtitle.setLanguage(LanguageUtils.parseLanguageFromString(string));
                    continue;
                }
                subtitle.setLanguage(LanguageUtils.parseLanguageFromString((String)language));
            }
        }
        if ((ssif = (MediaInfoFile)mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("ssif")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null)) != null) {
            if (mediaFile.getDuration() == 0) {
                mediaFile.setDuration(MediaFileHelper.parseDuration(ssif.getSnapshot()));
            }
            mediaFile.setVideo3DFormat(MediaFileHelper.parse3DFormat(mediaFile, ssif.getSnapshot()));
        }
    }

    private static void gatherMediaInformationFromHdDvdFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile evo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("evo")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null);
        if (evo == null) {
            LOGGER.debug("Could not find a valid EVO file");
            return;
        }
        LOGGER.trace("Considering EVO file: {}", (Object)evo.getFilename());
        MediaFileHelper.gatherMediaInformationFromFile(mediaFile, Collections.singletonList(evo));
    }

    public static Path getMainVideoFile(MediaFile mediaFile) {
        if (Files.isDirectory(mediaFile.getFileAsPath(), new LinkOption[0])) {
            List<MediaInfoFile> mediaInfoFiles = new ArrayList<MediaInfoFile>();
            for (Path path : Utils.listFilesRecursive(mediaFile.getFileAsPath())) {
                try {
                    mediaInfoFiles.add(new MediaInfoFile(path, Files.size(path)));
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse filesize of {} - {}", (Object)path, (Object)e.getMessage());
                }
            }
            if (!(mediaInfoFiles = MediaFileHelper.detectRelevantFiles(mediaInfoFiles)).isEmpty()) {
                Path path;
                MediaInfoFile mediaInfoFile = mediaInfoFiles.stream().filter(file -> file.getFilesize() > 200000000L).findFirst().orElse(null);
                if (mediaInfoFile == null) {
                    mediaInfoFile = mediaInfoFiles.get(0);
                }
                if (Files.exists(path = Paths.get(mediaInfoFile.getPath(), mediaInfoFile.getFilename()), new LinkOption[0])) {
                    return path;
                }
            }
        }
        return mediaFile.getFileAsPath();
    }

    public static MediaStreamInfo gatherLanguageInformation(String basename, String commonPart) {
        String[] splitted;
        String shortname = basename.replace(commonPart, "");
        String language = "";
        String title = "";
        ArrayList<MediaStreamInfo.Flags> flags = new ArrayList<MediaStreamInfo.Flags>();
        boolean hicc = false;
        if (shortname.contains("forced")) {
            flags.add(MediaStreamInfo.Flags.FLAG_FORCED);
            shortname = shortname.replaceAll("[\\p{Punct} ]+forced", "");
        }
        if (shortname.contains("sdh")) {
            flags.add(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED);
            shortname = shortname.replaceAll("[\\p{Punct} ]+sdh", "");
        }
        if (shortname.contains("cc") || shortname.contains("hi")) {
            hicc = true;
        }
        for (String token : splitted = shortname.split("[\\p{Punct} &&[^_-]]")) {
            if (!token.matches("[a-zA-Z][a-zA-Z][_-].*")) {
                token = token.replaceFirst("[^_-]+[_-]", "");
            }
            if (!token.matches("[a-zA-Z][a-zA-Z][_-].*")) continue;
            if (LanguageUtils.KEY_TO_LOCALE_MAP.containsKey(token.toLowerCase())) {
                language = token;
                break;
            }
            if (!LanguageUtils.KEY_TO_LOCALE_MAP.containsKey(token.toLowerCase().replace("_", "-"))) continue;
            language = token;
            break;
        }
        if (language.isEmpty()) {
            String languWoHiCC = "";
            if (hicc) {
                languWoHiCC = shortname;
                languWoHiCC = languWoHiCC.replaceAll("\\p{Punct}+hi", "");
                languWoHiCC = languWoHiCC.replaceAll("\\p{Punct}+cc", "");
                languWoHiCC = LanguageUtils.findLanguageInString(languWoHiCC);
            }
            if (StringUtils.isNotBlank((CharSequence)languWoHiCC)) {
                language = languWoHiCC;
            } else {
                List<String> chunks = ParserUtils.splitByPunctuation(shortname);
                int languageIndex = -1;
                for (int i = 0; i < chunks.size(); ++i) {
                    if (chunks.get(i).equalsIgnoreCase("und") || !StringUtils.isNotBlank((CharSequence)(language = LanguageUtils.findLanguageInString(chunks.get(i))))) continue;
                    languageIndex = i;
                    break;
                }
                if (hicc) {
                    if (!language.equalsIgnoreCase("hi")) {
                        int poscc = chunks.indexOf("cc");
                        languageIndex = poscc > 0 && poscc < languageIndex ? --languageIndex : poscc;
                        chunks.remove("cc");
                        int poshi = chunks.indexOf("hi");
                        if (poshi > 0 && poshi < languageIndex) {
                            --languageIndex;
                        }
                        chunks.remove("hi");
                        flags.add(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED);
                    } else {
                        chunks.remove("hi");
                        if (chunks.indexOf("cc") >= languageIndex) {
                            languageIndex = chunks.indexOf("cc");
                            chunks.remove("cc");
                            flags.add(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED);
                        }
                    }
                } else if (languageIndex >= 0) {
                    ++languageIndex;
                }
                if (languageIndex < 0 && !hicc) {
                    title = "";
                } else if (languageIndex >= 0 && languageIndex < chunks.size()) {
                    title = String.join((CharSequence)" ", chunks.subList(languageIndex, chunks.size()));
                }
            }
        } else {
            int pos = shortname.indexOf(language) + language.length();
            if (pos + 1 <= shortname.length()) {
                title = shortname.substring(pos + 1);
            }
        }
        title = title.strip();
        MediaStreamInfo info = new MediaStreamInfo();
        info.setLanguage(language);
        info.setTitle(title);
        info.set(flags);
        return info;
    }

    public static Dimension getArtworkDimension(MediaFile mediaFile) {
        if (mediaFile == null || !mediaFile.isGraphic()) {
            return new Dimension(0, 0);
        }
        return new Dimension(mediaFile.getVideoWidth(), mediaFile.getVideoHeight());
    }

    static {
        String extensions = String.join((CharSequence)"|", SUPPORTED_ARTWORK_FILETYPES);
        MOVIESET_ARTWORK_PATTERN = Pattern.compile("(?i)movieset-(poster|fanart|backdrop|banner|disc|discart|logo|clearlogo|clearart|thumb)\\.(" + extensions + ")$");
        POSTER_PATTERN = Pattern.compile("(?i)(.*-poster|poster|folder|movie|.*-cover|cover)\\.(" + extensions + ")$");
        FANART_PATTERN = Pattern.compile("(?i)(.*-fanart|.*-backdrop|.*\\.fanart|.*\\.backdrop|fanart|backdrop)\\.(" + extensions + ")$");
        EXTRAFANART_PATTERN = Pattern.compile("(?i)(.*-fanart|.*-backdrop|.*\\.fanart|.*\\.backdrop|fanart|backdrop)[0-9]+\\.(" + extensions + ")$");
        BANNER_PATTERN = Pattern.compile("(?i)(.*-banner|banner)\\.(" + extensions + ")$");
        THUMB_PATTERN = Pattern.compile("(?i)(.*-thumb|thumb|.*-landscape|landscape)[0-9]{0,2}\\.(" + extensions + ")$");
        SEASON_POSTER_PATTERN = Pattern.compile("(?i)season([0-9]{1,6}|-specials|-all)(-poster)?\\.(" + extensions + ")$");
        SEASON_FANART_PATTERN = Pattern.compile("(?i)season([0-9]{1,6}|-specials|-all)-fanart\\.(" + extensions + ")$");
        SEASON_BANNER_PATTERN = Pattern.compile("(?i)season([0-9]{1,6}|-specials|-all)-banner\\.(" + extensions + ")$");
        SEASON_THUMB_PATTERN = Pattern.compile("(?i)season([0-9]{1,6}|-specials|-all)-(thumb|landscape)\\.(" + extensions + ")$");
        LOGO_PATTERN = Pattern.compile("(?i)(.*-logo|logo)\\.(" + extensions + ")$");
        CLEARLOGO_PATTERN = Pattern.compile("(?i)(.*-clearlogo|clearlogo)\\.(" + extensions + ")$");
        CHARACTERART_PATTERN = Pattern.compile("(?i)(.*-characterart|characterart)[0-9]{0,2}\\.(" + extensions + ")$");
        DISCART_PATTERN = Pattern.compile("(?i)(.*-discart|discart|.*-disc|disc)\\.(" + extensions + ")$");
        CLEARART_PATTERN = Pattern.compile("(?i)(.*-clearart|clearart)\\.(" + extensions + ")$");
        KEYART_PATTERN = Pattern.compile("(?i)(.*-keyart|keyart)\\.(" + extensions + ")$");
    }
}

