/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.http.CommandHandler;
import org.tinymediamanager.core.http.ITmmCommandHandler;
import org.tinymediamanager.core.http.TmmCommandResponse;

public class TmmHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmHttpServer.class);
    private static final String CONTEXT_PREFIX = "/api/";
    private static TmmHttpServer instance;
    private final ObjectWriter objectWriter;
    private final Map<String, HttpHandler> contextMap;
    private HttpServer httpServer;
    private boolean running = false;
    private String apiKey = "";

    private TmmHttpServer() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setTimeZone(TimeZone.getDefault());
        this.objectWriter = objectMapper.writerFor(Response.class);
        this.contextMap = new LinkedHashMap<String, HttpHandler>();
        this.httpServer = HttpServer.create();
        this.createContext("command", new CommandHandler());
        this.updateConfiguration(Settings.getInstance().isEnableHttpServer(), Settings.getInstance().getHttpServerPort(), Settings.getInstance().getHttpApiKey());
    }

    public void start() {
        this.httpServer.start();
        this.running = true;
    }

    private void stop() {
        this.httpServer.stop(1);
        this.running = false;
    }

    private void bindPort(int port) throws IOException {
        this.httpServer.bind(new InetSocketAddress(port), 0);
    }

    public static synchronized TmmHttpServer getInstance() throws Exception {
        if (instance == null) {
            instance = new TmmHttpServer();
        }
        return instance;
    }

    public void createContext(String contextPath, ITmmCommandHandler commandHandler) {
        HttpHandler httpHandler = httpExchange -> {
            String responseMessage;
            int responseCode;
            Object apiKeyFromRequest;
            if (StringUtils.isNotBlank((CharSequence)this.apiKey) && ((apiKeyFromRequest = httpExchange.getRequestHeaders().get("api-key")) == null || !apiKeyFromRequest.contains(this.apiKey))) {
                int responseCode2 = 403;
                String responseMessage2 = "Invalid API key";
                this.sendResponse(responseCode2, responseMessage2, httpExchange);
                return;
            }
            try {
                TmmCommandResponse commandResponse = commandHandler.post(httpExchange);
                responseCode = commandResponse.getResponseCode();
                responseMessage = commandResponse.getResponseMessage();
            }
            catch (Exception e) {
                LOGGER.error("Could not process command '{}' - '{}'", (Object)commandHandler.getClass().getName(), (Object)e.getMessage());
                responseCode = 500;
                responseMessage = e.getMessage();
            }
            this.sendResponse(responseCode, responseMessage, httpExchange);
        };
        this.httpServer.createContext(CONTEXT_PREFIX + contextPath, httpHandler);
        this.contextMap.put(CONTEXT_PREFIX + contextPath, httpHandler);
    }

    private void sendResponse(int responseCode, String responseMessage, HttpExchange httpExchange) {
        Response response = new Response();
        response.message = responseMessage;
        try (OutputStream out = httpExchange.getResponseBody();){
            String body = this.objectWriter.writeValueAsString((Object)response);
            httpExchange.getResponseHeaders().add("Content-Type", "application/json");
            httpExchange.sendResponseHeaders(responseCode, body.length());
            out.write(body.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            LOGGER.error("Could not send response - '{}'", (Object)ex.getMessage());
        }
    }

    public void updateConfiguration(boolean enabled, int port, String apiKey) throws IOException {
        if (!enabled && !this.running) {
            return;
        }
        if (!enabled && this.running) {
            this.stop();
            this.createNewServer();
            return;
        }
        if (this.httpServer.getAddress() == null || port != this.httpServer.getAddress().getPort()) {
            this.stop();
            this.createNewServer();
            this.bindPort(port);
            this.start();
        }
        this.apiKey = apiKey;
    }

    private void createNewServer() throws IOException {
        this.httpServer = HttpServer.create();
        for (Map.Entry<String, HttpHandler> entry : this.contextMap.entrySet()) {
            this.httpServer.createContext(entry.getKey(), entry.getValue());
        }
    }

    public static class Response {
        public String message;
    }
}

