/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.mediainfo;

import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaInfoFile
implements Comparable<MediaInfoFile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoFile.class);
    private Map<MediaInfo.StreamKind, List<Map<String, String>>> snapshot;
    private int duration = 0;
    private long filesize = 0L;
    private String path = "";
    private String filename = "";
    private byte[] contents = null;

    public MediaInfoFile(Path file) {
        this.path = file.toAbsolutePath().getParent().toString();
        this.filename = file.getFileName().toString();
    }

    public MediaInfoFile(MediaFile mf) {
        this.path = mf.getFileAsPath().getParent().toString();
        this.filename = mf.getFileAsPath().getFileName().toString();
        this.duration = mf.getDuration();
        this.filesize = mf.getFilesize();
    }

    public MediaInfoFile(Path file, long filesize) {
        this(file);
        this.filesize = filesize;
    }

    public void setFilename(String filename) {
        this.filename = FilenameUtils.getName((String)filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPath() {
        return this.path;
    }

    public Path getFileAsPath() {
        return Paths.get(this.getPath(), this.getFilename());
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFileExtension() {
        return FilenameUtils.getExtension((String)this.filename).toLowerCase(Locale.ROOT);
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public Map<MediaInfo.StreamKind, List<Map<String, String>>> getSnapshot() {
        if (this.snapshot == null) {
            this.snapshot = Collections.emptyMap();
        }
        return this.snapshot;
    }

    public void setSnapshot(Map<MediaInfo.StreamKind, List<Map<String, String>>> snapshot) {
        String siz;
        this.snapshot = snapshot;
        this.setDuration(MediaFileHelper.parseDuration(snapshot));
        if (this.filesize == 0L && !(siz = MediaFileHelper.getMediaInfoValue(snapshot, MediaInfo.StreamKind.General, 0, "FileSize")).isEmpty()) {
            try {
                this.filesize = Long.parseLong(siz);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Could not parse filezize: {}", (Object)siz);
            }
        }
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Path dereferenceStreamFile(Path file) {
        try (FileReader fr = new FileReader(file.toFile());){
            String readLine;
            BufferedReader br;
            block21: {
                block20: {
                    block19: {
                        Path path;
                        br = new BufferedReader(fr);
                        try {
                            while ((readLine = br.readLine()) != null && ((readLine = readLine.strip()).startsWith("#") || readLine.isEmpty())) {
                            }
                            if (readLine != null && !readLine.isBlank()) break block19;
                            path = file;
                        }
                        catch (Throwable throwable) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        br.close();
                        return path;
                    }
                    if (!readLine.contains("://")) break block20;
                    Path path = file;
                    br.close();
                    return path;
                }
                if (!readLine.startsWith("/") && !readLine.startsWith("\\")) break block21;
                LOGGER.trace("Chasing absolute stream reference: {} = {}", (Object)file, (Object)readLine);
                Path path = Paths.get(readLine, new String[0]);
                br.close();
                return path;
            }
            LOGGER.trace("Chasing relative stream reference: {} = {}/{}", new Object[]{file, this.path, readLine});
            Path path = Paths.get(this.path, readLine);
            br.close();
            return path;
        }
        catch (Error | Exception e) {
            LOGGER.debug("Mediainfo could not read stream file: {} - {}", (Object)file, (Object)e.getMessage());
            return file;
        }
    }

    public void gatherMediaInformation() {
        if (this.snapshot != null) {
            return;
        }
        Path file = Paths.get(this.path, this.filename);
        if (this.filename.endsWith(".strm")) {
            file = this.dereferenceStreamFile(file);
        }
        try (MediaInfo mediaInfo = new MediaInfo();){
            if (!mediaInfo.open(file)) {
                LOGGER.error("MediaInfo could not open file  '{}'", (Object)file);
            } else {
                this.setSnapshot(mediaInfo.snapshot());
            }
        }
        catch (Error | Exception e) {
            LOGGER.error("MediaInfo could not open file '{}' - '{}'", (Object)file, (Object)e.getMessage());
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaInfoFile that = (MediaInfoFile)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.filename, that.filename);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.filename);
    }

    @Override
    public int compareTo(@NotNull MediaInfoFile o) {
        return this.getFilename().compareTo(o.getFilename());
    }
}

