/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class MovieFindMissingTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieFindMissingTask.class);
    private final List<String> dataSources;
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieFindMissingTask() {
        super(TmmResourceBundle.getString("movie.findmissing"));
        this.dataSources = new ArrayList<String>(MovieModuleManager.getInstance().getSettings().getMovieDataSource());
    }

    public MovieFindMissingTask(String datasource) {
        super(TmmResourceBundle.getString("movie.findmissing") + " (" + datasource + ")");
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
    }

    @Override
    public void doInBackground() {
        try {
            LOGGER.info("Finding missing movies...");
            ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
            for (Movie movie : this.movieList.getMovies()) {
                mfs.addAll(movie.getMediaFiles());
            }
            for (String ds : this.dataSources) {
                if (this.cancel) break;
                HashSet<Path> bigFiles = this.getBigFilesRecursive(Paths.get(ds, new String[0]));
                if (this.cancel) break;
                for (Path file : bigFiles) {
                    MediaFile mf = new MediaFile(file);
                    if (mfs.contains(mf)) continue;
                    LOGGER.debug("found possible movie file {}", (Object)file);
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"possible movie", "found possible movie " + file, new String[]{ds}));
                }
            }
            LOGGER.debug("Finished finding missing movies :) - took {} ms", (Object)this.getRuntime());
        }
        catch (Exception e) {
            LOGGER.error("Could not find missing movies - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    public HashSet<Path> getBigFilesRecursive(Path folder) {
        BigFilesRecursive visitor = new BigFilesRecursive();
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visitor.fFound;
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class BigFilesRecursive
    extends SimpleFileVisitor<Path> {
        private HashSet<Path> fFound = new HashSet();

        private BigFilesRecursive() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (Utils.isRegularFile(attr) && attr.size() > 0x6400000L) {
                this.fFound.add(file.toAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (dir.getFileName() != null && dir.getFileName().toString().equals(".deletedByTMM")) {
                LOGGER.debug("Skipping backup folder: {}", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (MovieFindMissingTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOGGER.error("Could not read file '{}' - '{}'", (Object)file, (Object)exc.getMessage());
            return FileVisitResult.CONTINUE;
        }
    }
}

