/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;

public final class AudioModel {

    public static interface SongFields {
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String ALBUM = "album";
        public static final String TRACK = "track";
        public static final String DURATION = "duration";
        public static final String COMMENT = "comment";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String ALBUMID = "albumid";
        public static final String LASTPLAYED = "lastplayed";
        public static final String DISC = "disc";
        public static final String GENREID = "genreid";
        public static final String ARTISTID = "artistid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final String DATEADDED = "dateadded";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "artist", "albumartist", "genre", "year", "rating", "album", "track", "duration", "comment", "lyrics", "musicbrainztrackid", "musicbrainzartistid", "musicbrainzalbumid", "musicbrainzalbumartistid", "playcount", "fanart", "thumbnail", "file", "albumid", "lastplayed", "disc", "genreid", "artistid", "displayartist", "albumartistid", "albumreleasetype", "dateadded"));
    }

    public static interface ArtistFields {
        public static final String INSTRUMENT = "instrument";
        public static final String STYLE = "style";
        public static final String MOOD = "mood";
        public static final String BORN = "born";
        public static final String FORMED = "formed";
        public static final String DESCRIPTION = "description";
        public static final String GENRE = "genre";
        public static final String DIED = "died";
        public static final String DISBANDED = "disbanded";
        public static final String YEARSACTIVE = "yearsactive";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String COMPILATIONARTIST = "compilationartist";
        public static final String DATEADDED = "dateadded";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("instrument", "style", "mood", "born", "formed", "description", "genre", "died", "disbanded", "yearsactive", "musicbrainzartistid", "fanart", "thumbnail", "compilationartist", "dateadded"));
    }

    public static interface AlbumFields {
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String THEME = "theme";
        public static final String MOOD = "mood";
        public static final String STYLE = "style";
        public static final String TYPE = "type";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String RATING = "rating";
        public static final String YEAR = "year";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String PLAYCOUNT = "playcount";
        public static final String GENREID = "genreid";
        public static final String ARTISTID = "artistid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String COMPILATION = "compilation";
        public static final String RELEASETYPE = "releasetype";
        public static final String DATEADDED = "dateadded";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "description", "artist", "genre", "theme", "mood", "style", "type", "albumlabel", "rating", "year", "musicbrainzalbumid", "musicbrainzalbumartistid", "fanart", "thumbnail", "playcount", "genreid", "artistid", "displayartist", "compilation", "releasetype", "dateadded"));
    }

    public static class SongDetail
    extends MediaDetail {
        public static final String API_TYPE = "Audio.Details.Song";
        public static final String ALBUM = "album";
        public static final String ALBUMARTIST = "albumartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String ALBUMID = "albumid";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final String COMMENT = "comment";
        public static final String DISC = "disc";
        public static final String DURATION = "duration";
        public static final String FILE = "file";
        public static final String LASTPLAYED = "lastplayed";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String PLAYCOUNT = "playcount";
        public static final String SONGID = "songid";
        public static final String TRACK = "track";
        public final String album;
        public final List<String> albumartist;
        public final List<Integer> albumartistid;
        public final Integer albumid;
        public final String albumreleasetype;
        public final String comment;
        public final Integer disc;
        public final Integer duration;
        public final String file;
        public final String lastplayed;
        public final String lyrics;
        public final String musicbrainzartistid;
        public final String musicbrainztrackid;
        public final Integer playcount;
        public final Integer songid;
        public final Integer track;

        public SongDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.album = SongDetail.parseString(jsonNode, ALBUM);
            this.albumartist = SongDetail.getStringArray(jsonNode, ALBUMARTIST);
            this.albumartistid = SongDetail.getIntegerArray(jsonNode, ALBUMARTISTID);
            this.albumid = SongDetail.parseInt(jsonNode, ALBUMID);
            this.albumreleasetype = SongDetail.parseString(jsonNode, ALBUMRELEASETYPE);
            this.comment = SongDetail.parseString(jsonNode, COMMENT);
            this.disc = SongDetail.parseInt(jsonNode, DISC);
            this.duration = SongDetail.parseInt(jsonNode, DURATION);
            this.file = SongDetail.parseString(jsonNode, FILE);
            this.lastplayed = SongDetail.parseString(jsonNode, LASTPLAYED);
            this.lyrics = SongDetail.parseString(jsonNode, LYRICS);
            this.musicbrainzartistid = SongDetail.parseString(jsonNode, MUSICBRAINZARTISTID);
            this.musicbrainztrackid = SongDetail.parseString(jsonNode, MUSICBRAINZTRACKID);
            this.playcount = SongDetail.parseInt(jsonNode, PLAYCOUNT);
            this.songid = SongDetail.parseInt(jsonNode, SONGID);
            this.track = SongDetail.parseInt(jsonNode, TRACK);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ALBUM, this.album);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String object : this.albumartist) {
                arrayNode.add(object);
            }
            objectNode.put(ALBUMARTIST, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Integer n : this.albumartistid) {
                arrayNode2.add(n);
            }
            objectNode.put(ALBUMARTISTID, (JsonNode)arrayNode2);
            objectNode.put(ALBUMID, this.albumid);
            objectNode.put(ALBUMRELEASETYPE, this.albumreleasetype);
            objectNode.put(COMMENT, this.comment);
            objectNode.put(DISC, this.disc);
            objectNode.put(DURATION, this.duration);
            objectNode.put(FILE, this.file);
            objectNode.put(LASTPLAYED, this.lastplayed);
            objectNode.put(LYRICS, this.lyrics);
            objectNode.put(MUSICBRAINZARTISTID, this.musicbrainzartistid);
            objectNode.put(MUSICBRAINZTRACKID, this.musicbrainztrackid);
            objectNode.put(PLAYCOUNT, this.playcount);
            objectNode.put(SONGID, this.songid);
            objectNode.put(TRACK, this.track);
            return objectNode;
        }

        static List<SongDetail> getAudioModelSongDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SongDetail> arrayList = new ArrayList<SongDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SongDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SongDetail>(0);
        }
    }

    public static class MediaDetail
    extends BaseDetail {
        public static final String API_TYPE = "Audio.Details.Media";
        public static final String ARTIST = "artist";
        public static final String ARTISTID = "artistid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String GENREID = "genreid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String RATING = "rating";
        public static final String TITLE = "title";
        public static final String YEAR = "year";
        public final List<String> artist;
        public final List<Integer> artistid;
        public final String displayartist;
        public final List<Integer> genreid;
        public final String musicbrainzalbumartistid;
        public final String musicbrainzalbumid;
        public final Integer rating;
        public final String title;
        public final Integer year;

        public MediaDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.artist = MediaDetail.getStringArray(jsonNode, ARTIST);
            this.artistid = MediaDetail.getIntegerArray(jsonNode, ARTISTID);
            this.displayartist = MediaDetail.parseString(jsonNode, DISPLAYARTIST);
            this.genreid = MediaDetail.getIntegerArray(jsonNode, GENREID);
            this.musicbrainzalbumartistid = MediaDetail.parseString(jsonNode, MUSICBRAINZALBUMARTISTID);
            this.musicbrainzalbumid = MediaDetail.parseString(jsonNode, MUSICBRAINZALBUMID);
            this.rating = MediaDetail.parseInt(jsonNode, RATING);
            this.title = MediaDetail.parseString(jsonNode, TITLE);
            this.year = MediaDetail.parseInt(jsonNode, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (String object2 : this.artist) {
                arrayNode.add(object2);
            }
            objectNode.put(ARTIST, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Integer n : this.artistid) {
                arrayNode2.add(n);
            }
            objectNode.put(ARTISTID, (JsonNode)arrayNode2);
            objectNode.put(DISPLAYARTIST, this.displayartist);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (Integer n : this.genreid) {
                arrayNode3.add(n);
            }
            objectNode.put(GENREID, (JsonNode)arrayNode3);
            objectNode.put(MUSICBRAINZALBUMARTISTID, this.musicbrainzalbumartistid);
            objectNode.put(MUSICBRAINZALBUMID, this.musicbrainzalbumid);
            objectNode.put(RATING, this.rating);
            objectNode.put(TITLE, this.title);
            objectNode.put(YEAR, this.year);
            return objectNode;
        }

        static List<MediaDetail> getAudioModelMediaDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<MediaDetail> arrayList = new ArrayList<MediaDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new MediaDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<MediaDetail>(0);
        }
    }

    public static class BaseDetail
    extends MediaModel.BaseDetail {
        public static final String API_TYPE = "Audio.Details.Base";
        public static final String DATEADDED = "dateadded";
        public static final String GENRE = "genre";
        public final String dateadded;
        public final List<String> genre;

        public BaseDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.dateadded = BaseDetail.parseString(jsonNode, DATEADDED);
            this.genre = BaseDetail.getStringArray(jsonNode, GENRE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(DATEADDED, this.dateadded);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String string : this.genre) {
                arrayNode.add(string);
            }
            objectNode.put(GENRE, (JsonNode)arrayNode);
            return objectNode;
        }

        static List<BaseDetail> getAudioModelBaseDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<BaseDetail> arrayList = new ArrayList<BaseDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new BaseDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<BaseDetail>(0);
        }
    }

    public static class ArtistDetail
    extends BaseDetail {
        public static final String API_TYPE = "Audio.Details.Artist";
        public static final String ARTIST = "artist";
        public static final String ARTISTID = "artistid";
        public static final String BORN = "born";
        public static final String COMPILATIONARTIST = "compilationartist";
        public static final String DESCRIPTION = "description";
        public static final String DIED = "died";
        public static final String DISBANDED = "disbanded";
        public static final String FORMED = "formed";
        public static final String INSTRUMENT = "instrument";
        public static final String MOOD = "mood";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String STYLE = "style";
        public static final String YEARSACTIVE = "yearsactive";
        public final String artist;
        public final Integer artistid;
        public final String born;
        public final Boolean compilationartist;
        public final String description;
        public final String died;
        public final String disbanded;
        public final String formed;
        public final List<String> instrument;
        public final List<String> mood;
        public final String musicbrainzartistid;
        public final List<String> style;
        public final List<String> yearsactive;

        public ArtistDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.artist = jsonNode.get(ARTIST).asText();
            this.artistid = ArtistDetail.parseInt(jsonNode, ARTISTID);
            this.born = ArtistDetail.parseString(jsonNode, BORN);
            this.compilationartist = ArtistDetail.parseBoolean(jsonNode, COMPILATIONARTIST);
            this.description = ArtistDetail.parseString(jsonNode, DESCRIPTION);
            this.died = ArtistDetail.parseString(jsonNode, DIED);
            this.disbanded = ArtistDetail.parseString(jsonNode, DISBANDED);
            this.formed = ArtistDetail.parseString(jsonNode, FORMED);
            this.instrument = ArtistDetail.getStringArray(jsonNode, INSTRUMENT);
            this.mood = ArtistDetail.getStringArray(jsonNode, MOOD);
            this.musicbrainzartistid = ArtistDetail.parseString(jsonNode, MUSICBRAINZARTISTID);
            this.style = ArtistDetail.getStringArray(jsonNode, STYLE);
            this.yearsactive = ArtistDetail.getStringArray(jsonNode, YEARSACTIVE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ARTIST, this.artist);
            objectNode.put(ARTISTID, this.artistid);
            objectNode.put(BORN, this.born);
            objectNode.put(COMPILATIONARTIST, this.compilationartist);
            objectNode.put(DESCRIPTION, this.description);
            objectNode.put(DIED, this.died);
            objectNode.put(DISBANDED, this.disbanded);
            objectNode.put(FORMED, this.formed);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String object22 : this.instrument) {
                arrayNode.add(object22);
            }
            objectNode.put(INSTRUMENT, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String string : this.mood) {
                arrayNode2.add(string);
            }
            objectNode.put(MOOD, (JsonNode)arrayNode2);
            objectNode.put(MUSICBRAINZARTISTID, this.musicbrainzartistid);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (String string : this.style) {
                arrayNode3.add(string);
            }
            objectNode.put(STYLE, (JsonNode)arrayNode3);
            ArrayNode arrayNode4 = OM.createArrayNode();
            for (String string : this.yearsactive) {
                arrayNode4.add(string);
            }
            objectNode.put(YEARSACTIVE, (JsonNode)arrayNode4);
            return objectNode;
        }

        static List<ArtistDetail> getAudioModelArtistDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ArtistDetail> arrayList = new ArrayList<ArtistDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ArtistDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ArtistDetail>(0);
        }
    }

    public static class AlbumDetail
    extends MediaDetail {
        public static final String API_TYPE = "Audio.Details.Album";
        public static final String ALBUMID = "albumid";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String COMPILATION = "compilation";
        public static final String DESCRIPTION = "description";
        public static final String MOOD = "mood";
        public static final String PLAYCOUNT = "playcount";
        public static final String RELEASETYPE = "releasetype";
        public static final String STYLE = "style";
        public static final String THEME = "theme";
        public static final String TYPE = "type";
        public final Integer albumid;
        public final String albumlabel;
        public final Boolean compilation;
        public final String description;
        public final List<String> mood;
        public final Integer playcount;
        public final String releasetype;
        public final List<String> style;
        public final List<String> theme;
        public final String type;

        public AlbumDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.albumid = AlbumDetail.parseInt(jsonNode, ALBUMID);
            this.albumlabel = AlbumDetail.parseString(jsonNode, ALBUMLABEL);
            this.compilation = AlbumDetail.parseBoolean(jsonNode, COMPILATION);
            this.description = AlbumDetail.parseString(jsonNode, DESCRIPTION);
            this.mood = AlbumDetail.getStringArray(jsonNode, MOOD);
            this.playcount = AlbumDetail.parseInt(jsonNode, PLAYCOUNT);
            this.releasetype = AlbumDetail.parseString(jsonNode, RELEASETYPE);
            this.style = AlbumDetail.getStringArray(jsonNode, STYLE);
            this.theme = AlbumDetail.getStringArray(jsonNode, THEME);
            this.type = AlbumDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ALBUMID, this.albumid);
            objectNode.put(ALBUMLABEL, this.albumlabel);
            objectNode.put(COMPILATION, this.compilation);
            objectNode.put(DESCRIPTION, this.description);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String object2 : this.mood) {
                arrayNode.add(object2);
            }
            objectNode.put(MOOD, (JsonNode)arrayNode);
            objectNode.put(PLAYCOUNT, this.playcount);
            objectNode.put(RELEASETYPE, this.releasetype);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String string : this.style) {
                arrayNode2.add(string);
            }
            objectNode.put(STYLE, (JsonNode)arrayNode2);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (String string : this.theme) {
                arrayNode3.add(string);
            }
            objectNode.put(THEME, (JsonNode)arrayNode3);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<AlbumDetail> getAudioModelAlbumDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<AlbumDetail> arrayList = new ArrayList<AlbumDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new AlbumDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<AlbumDetail>(0);
        }
    }
}

