/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.Mark;

public class PlayListMark {
    private Mark[] marks = null;

    public void readObject(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(4);
        int n = dataInputStream.readUnsignedShort();
        Mark[] markArray = new Mark[n];
        for (int i = 0; i < n; ++i) {
            markArray[i] = new Mark(i);
            markArray[i].readObject(dataInputStream);
        }
        this.setMarks(markArray);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        Mark[] markArray = this.getMarks();
        if (markArray == null) {
            throw new IOException("There is a playlist without any mark.  There should be an entry mark at the beginning of the PlayList.");
        }
        dataOutputStream.writeInt(14 * markArray.length + 2);
        dataOutputStream.writeShort(markArray.length);
        for (int i = 0; i < markArray.length; ++i) {
            markArray[i].writeObject(dataOutputStream);
        }
    }

    @XmlElement(name="Mark")
    public Mark[] getMarks() {
        return this.marks;
    }

    public void setMarks(Mark[] markArray) {
        for (int i = 0; i < markArray.length; ++i) {
            if (i == markArray[i].getId()) continue;
            throw new IllegalArgumentException("id does not match the array order");
        }
        this.marks = markArray;
    }
}

