/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListUtils {
    private ListUtils() {
        throw new IllegalAccessError();
    }

    public static <T> Iterable<T> nullSafe(Iterable<T> it) {
        return it != null ? it : Collections.emptySet();
    }

    public static <T> void mergeLists(List<T> baseList, List<T> newItems) {
        if (baseList == null || newItems == null) {
            return;
        }
        for (int i = 0; i < newItems.size(); ++i) {
            T entry = newItems.get(i);
            if (!baseList.contains(entry)) {
                try {
                    baseList.add(i, entry);
                }
                catch (IndexOutOfBoundsException e) {
                    baseList.add(entry);
                }
                continue;
            }
            int indexOldList = baseList.indexOf(entry);
            if (i == indexOldList) continue;
            T oldEntry = baseList.remove(indexOldList);
            try {
                baseList.add(i, oldEntry);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                baseList.add(oldEntry);
            }
        }
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean isNotEmpty(List<T> list) {
        return list != null && !list.isEmpty();
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> asSortedList(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <E> boolean addToCopyOnWriteArrayListIfAbsent(CopyOnWriteArrayList<E> list, Collection<E> values) {
        if (list.isEmpty()) {
            return list.addAll(values);
        }
        return list.addAllAbsent(values) > 0;
    }

    public static <E> boolean containsAny(List<E> list, E ... values) {
        for (E value : values) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static <E> E getFirst(List<E> list) {
        if (ListUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static <E> E getMiddle(List<E> list) {
        if (ListUtils.isEmpty(list)) {
            return null;
        }
        int middleIndex = list.size() / 2;
        return list.get(middleIndex);
    }

    public static <E> E getLast(List<E> list) {
        if (ListUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }
}

