/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.UrlUtil;
import org.tinymediamanager.updater.UpdateCheck;

public class ExternalTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalTools.class);
    private final String urlAsString;
    private List<ExternalTool> externalTools = null;

    public ExternalTools(String url) {
        this.urlAsString = url;
    }

    public static boolean isToolInstalled(String toolName) {
        Path versionFile = ExternalTools.getVersionFile(toolName);
        return Files.exists(versionFile, new LinkOption[0]);
    }

    private static Path getVersionFile(String toolName) {
        return Paths.get(Globals.ADDON_FOLDER, toolName + ".ver");
    }

    public boolean isUpdateAvailable(String toolName) throws Exception {
        this.init();
        ExternalTool externalTool = this.findExternalTool(toolName);
        if (externalTool == null) {
            throw new IllegalArgumentException();
        }
        if (ExternalTools.isToolInstalled(toolName)) {
            String installedVersion = Utils.readFileToString(ExternalTools.getVersionFile(toolName));
            return !installedVersion.equalsIgnoreCase(externalTool.version);
        }
        return false;
    }

    private void init() throws Exception {
        if (this.externalTools == null) {
            this.externalTools = this.parseJson();
        }
    }

    private ExternalTool findExternalTool(String toolName) {
        for (ExternalTool entry : this.externalTools) {
            if (!toolName.equalsIgnoreCase(entry.name)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadTool(String toolName) throws Exception {
        block18: {
            this.init();
            ExternalTool externalTool = this.findExternalTool(toolName);
            if (externalTool == null) {
                throw new IllegalArgumentException();
            }
            String osArch = this.getOsArchString();
            ExternalToolUrl toolUrl = null;
            for (ExternalToolUrl entry : externalTool.urls) {
                if (!osArch.equalsIgnoreCase(entry.arch)) continue;
                toolUrl = entry;
                break;
            }
            if (toolUrl == null) {
                throw new Exception("no download for the given os/arch found");
            }
            Path addonFolder = Paths.get(Globals.ADDON_FOLDER, new String[0]);
            Path tempFile = Paths.get(Utils.getTempFolder(), UrlUtil.getFilename(toolUrl.url));
            try {
                Url url = new Url(toolUrl.url);
                url.download(tempFile);
                if (FilenameUtils.getExtension((String)tempFile.getFileName().toString()).equals("zip")) {
                    Path destinationFolder = tempFile.resolveSibling(UrlUtil.getBasename(toolUrl.url));
                    try {
                        Utils.unzip(tempFile, destinationFolder);
                        Path source = Paths.get(destinationFolder.toString(), toolUrl.filenameInArchive);
                        Path destinationFilename = addonFolder.resolve(this.getOsSpecificFilename(externalTool));
                        if (Files.exists(destinationFilename, new LinkOption[0])) {
                            Utils.deleteFileSafely(destinationFilename);
                        }
                        if (!Files.exists(addonFolder, new LinkOption[0])) {
                            Files.createDirectory(addonFolder, new FileAttribute[0]);
                        }
                        if (Utils.moveFileSafe(source, destinationFilename)) {
                            if (!destinationFilename.toFile().setExecutable(true)) {
                                LOGGER.debug("Could not make '{}' executable", (Object)destinationFilename);
                            }
                            Utils.writeStringToFile(addonFolder.resolve(toolName + ".ver"), externalTool.version);
                        }
                        break block18;
                    }
                    finally {
                        Utils.deleteDirectorySafely(destinationFolder);
                    }
                }
                Path destinationFilename = Paths.get(Globals.ADDON_FOLDER, this.getOsSpecificFilename(externalTool));
                if (Files.exists(destinationFilename, new LinkOption[0])) {
                    Utils.deleteFileSafely(destinationFilename);
                }
                if (!Files.exists(addonFolder, new LinkOption[0])) {
                    Files.createDirectory(addonFolder, new FileAttribute[0]);
                }
                if (Utils.moveFileSafe(tempFile, destinationFilename)) {
                    if (!destinationFilename.toFile().setExecutable(true)) {
                        LOGGER.debug("Could not make '{}' executable", (Object)destinationFilename);
                    }
                    Utils.writeStringToFile(Paths.get(Globals.ADDON_FOLDER, toolName + ".ver"), externalTool.version);
                }
            }
            finally {
                Utils.deleteFileSafely(tempFile);
            }
        }
    }

    private String getOsArchString() {
        Object osArch = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            osArch = (String)osArch + "windows-amd64";
        } else if (SystemUtils.IS_OS_LINUX) {
            osArch = (String)osArch + "linux-";
            osArch = System.getProperty("os.arch").contains("arm") || System.getProperty("os.arch").contains("aarch") ? (String)osArch + "arm64" : (String)osArch + "amd64";
        } else if (SystemUtils.IS_OS_MAC) {
            osArch = (String)osArch + "macos-";
            osArch = System.getProperty("os.arch").contains("arm") || System.getProperty("os.arch").contains("aarch") ? (String)osArch + "arm64" : (String)osArch + "amd64";
        }
        return osArch;
    }

    private String getOsSpecificFilename(ExternalTool externalTool) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return externalTool.filename + ".exe";
        }
        return externalTool.filename;
    }

    List<ExternalTool> parseJson() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectReader reader = objectMapper.readerForListOf(ExternalTool.class);
        OnDiskCachedUrl url = new OnDiskCachedUrl(this.urlAsString, 10, TimeUnit.MINUTES);
        return (List)reader.readValue(url.getInputStream());
    }

    public static class ExternalTool {
        @JsonProperty
        private String name = "";
        @JsonProperty
        private String version = "";
        @JsonProperty
        private String filename = "";
        @JsonProperty
        private List<ExternalToolUrl> urls = new ArrayList<ExternalToolUrl>();
    }

    public static class ExternalToolUrl {
        @JsonProperty
        private String arch = "";
        @JsonProperty
        private String url = "";
        @JsonProperty
        private String filenameInArchive = "";
    }

    public static class ExternalToolsUpgradeTask
    extends TmmTask {
        private static final Logger LOGGER = LoggerFactory.getLogger(ExternalToolsUpgradeTask.class);
        private final String toolName;
        private String updateUrl = "";

        public ExternalToolsUpgradeTask(String toolName) {
            super(TmmResourceBundle.getString("task.externaltoolupgrade") + " - " + toolName, 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.toolName = toolName;
            if (ReleaseInfo.isGitBuild()) {
                this.updateUrl = Paths.get("external-tools.json", new String[0]).toUri().toString();
            } else {
                List<String> updateUrls = UpdateCheck.parseUpdateUrls();
                if (!updateUrls.isEmpty()) {
                    this.updateUrl = updateUrls.get(0) + "external-tools.json";
                }
            }
        }

        @Override
        protected void doInBackground() {
            ExternalTools externalTools = new ExternalTools(this.updateUrl);
            try {
                if (!ExternalTools.isToolInstalled(this.toolName) || externalTools.isUpdateAvailable(this.toolName)) {
                    externalTools.downloadTool(this.toolName);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not update the external tool '{}' - '{}", (Object)this.toolName, (Object)e.getMessage());
            }
        }
    }
}

