/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.fourthline.cling.DefaultUpnpServiceConfiguration;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceConfiguration;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.binding.LocalServiceBindingException;
import org.fourthline.cling.binding.annotations.AnnotationLocalServiceBinder;
import org.fourthline.cling.binding.xml.DescriptorBindingException;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.model.DefaultServiceManager;
import org.fourthline.cling.model.DiscoveryOptions;
import org.fourthline.cling.model.ServiceManager;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.UDADeviceTypeHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.DeviceDetails;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.Icon;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.meta.ManufacturerDetails;
import org.fourthline.cling.model.meta.ModelDetails;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.profile.RemoteClientInfo;
import org.fourthline.cling.model.types.DLNACaps;
import org.fourthline.cling.model.types.DLNADoc;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceId;
import org.fourthline.cling.model.types.UDADeviceType;
import org.fourthline.cling.model.types.UDAServiceId;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.registry.RegistrationException;
import org.fourthline.cling.registry.RegistryListener;
import org.fourthline.cling.support.avtransport.callback.Play;
import org.fourthline.cling.support.avtransport.callback.SetAVTransportURI;
import org.fourthline.cling.support.avtransport.callback.Stop;
import org.fourthline.cling.support.connectionmanager.ConnectionManagerService;
import org.fourthline.cling.support.contentdirectory.DIDLParser;
import org.fourthline.cling.support.model.DIDLContent;
import org.fourthline.cling.support.model.ProtocolInfo;
import org.fourthline.cling.support.model.ProtocolInfos;
import org.fourthline.cling.support.model.Res;
import org.fourthline.cling.support.model.dlna.DLNAProfiles;
import org.fourthline.cling.support.model.dlna.DLNAProtocolInfo;
import org.fourthline.cling.support.model.item.Item;
import org.fourthline.cling.transport.RouterException;
import org.fourthline.cling.transport.impl.StreamClientConfigurationImpl;
import org.fourthline.cling.transport.spi.StreamClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.thirdparty.NetworkUtil;
import org.tinymediamanager.thirdparty.upnp.ContentDirectoryService;
import org.tinymediamanager.thirdparty.upnp.MSMediaReceiverRegistrarService;
import org.tinymediamanager.thirdparty.upnp.Metadata;
import org.tinymediamanager.thirdparty.upnp.TmmStreamClientImpl;
import org.tinymediamanager.thirdparty.upnp.UpnpListener;
import org.tinymediamanager.thirdparty.upnp.WebServer;

public class Upnp {
    private static final Logger LOGGER = LoggerFactory.getLogger(Upnp.class);
    public static final int UPNP_PORT = 8008;
    public static final int WEBSERVER_PORT = 8009;
    public static final String ID_ROOT = "0";
    public static final String ID_MOVIES = "1";
    public static final String ID_TVSHOWS = "2";
    private static Upnp instance;
    private final String ipAddress = NetworkUtil.getMachineIPAddress();
    private UpnpService upnpService = null;
    private WebServer webServer = null;
    private Service playerService = null;
    private LocalDevice localDevice = null;

    private Upnp() {
    }

    public static synchronized Upnp getInstance() {
        if (instance == null) {
            instance = new Upnp();
        }
        return instance;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    public LocalDevice getLocalDevice() {
        return this.localDevice;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void createUpnpService() {
        if (this.upnpService == null) {
            this.upnpService = new UpnpServiceImpl((UpnpServiceConfiguration)new DefaultUpnpServiceConfiguration(8008){

                public StreamClient createStreamClient() {
                    return new TmmStreamClientImpl(new StreamClientConfigurationImpl(this.getSyncProtocolExecutorService()));
                }
            }, new RegistryListener[]{UpnpListener.getListener()});
        }
    }

    private LocalDevice getDevice() throws ValidationException, LocalServiceBindingException, IOException, IllegalArgumentException, URISyntaxException {
        if (this.localDevice == null) {
            DeviceIdentity identity = new DeviceIdentity(UDN.uniqueSystemIdentifier((String)"tinyMediaManager"), Integer.valueOf(600));
            UDADeviceType type = new UDADeviceType("MediaServer", 1);
            DeviceDetails details = new DeviceDetails("tinyMediaManager", new ManufacturerDetails("tinyMediaManager", "https://www.tinymediamanager.org/"), new ModelDetails("tinyMediaManager", "tinyMediaManager - Media Server", ReleaseInfo.getVersion()), new URI("http://" + this.ipAddress + ":8008/dev/" + identity.getUdn().getIdentifierString() + "/desc"), new DLNADoc[]{new DLNADoc("DMS", DLNADoc.Version.V1_5), new DLNADoc("M-DMS", DLNADoc.Version.V1_5)}, new DLNACaps(new String[]{"av-upload", "image-upload", "audio-upload"}));
            final ProtocolInfos protocols = new ProtocolInfos(new ProtocolInfo[0]);
            for (DLNAProfiles dlnaProfile : DLNAProfiles.values()) {
                if (dlnaProfile == DLNAProfiles.NONE) continue;
                try {
                    protocols.add((Object)new DLNAProtocolInfo(dlnaProfile));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LOGGER.info("UPnP: Hello, i'm " + identity.getUdn().getIdentifierString());
            LocalService cds = new AnnotationLocalServiceBinder().read(ContentDirectoryService.class);
            cds.setManager((ServiceManager)new DefaultServiceManager(cds, ContentDirectoryService.class));
            LocalService cms = new AnnotationLocalServiceBinder().read(ConnectionManagerService.class);
            cms.setManager((ServiceManager)new DefaultServiceManager<ConnectionManagerService>(cms, ConnectionManagerService.class){

                protected ConnectionManagerService createServiceInstance() throws Exception {
                    return new ConnectionManagerService(protocols, null);
                }
            });
            LocalService mss = new AnnotationLocalServiceBinder().read(MSMediaReceiverRegistrarService.class);
            mss.setManager((ServiceManager)new DefaultServiceManager(mss, MSMediaReceiverRegistrarService.class));
            Icon icon = null;
            try {
                icon = new Icon("image/png", 128, 128, 24, new File("tmm.png"));
            }
            catch (Exception e) {
                try {
                    icon = new Icon("image/png", 128, 128, 24, new File("AppBundler/tmm.png"));
                }
                catch (Exception e2) {
                    LOGGER.debug("Did not find device icon...");
                }
            }
            this.localDevice = new LocalDevice(identity, (DeviceType)type, details, new Icon[]{icon}, new LocalService[]{cds, cms, mss});
        }
        return this.localDevice;
    }

    public void sendPlayerSearchRequest() {
        this.createUpnpService();
        this.upnpService.getControlPoint().search((UpnpHeader)new UDADeviceTypeHeader((DeviceType)new UDADeviceType("MediaRenderer")));
    }

    public List<Device> getAvailablePlayers() {
        this.createUpnpService();
        ArrayList<Device> ret = new ArrayList<Device>();
        for (Device device : this.upnpService.getRegistry().getDevices()) {
            if (!device.getType().getType().equals("MediaRenderer")) continue;
            ret.add(device);
        }
        return ret;
    }

    public void setPlayer(Device device) {
        this.playerService = device.findService((ServiceId)new UDAServiceId("AVTransport"));
        if (this.playerService == null) {
            LOGGER.warn("Could not find AVTransportService on UPnP device {}", (Object)device.getDisplayString());
        }
    }

    public void playFile(MediaEntity me, MediaFile mf) {
        if (this.playerService == null) {
            LOGGER.debug("No UPnP player set - did you call setPlayer(Device) ?");
            return;
        }
        if (mf == null) {
            LOGGER.debug("parameters empty!");
            return;
        }
        String url = "";
        String meta = "NO METADATA";
        if (me != null) {
            try {
                DIDLContent didl = new DIDLContent();
                DIDLParser dip = new DIDLParser();
                if (me instanceof Movie) {
                    Movie movie = (Movie)me;
                    didl.addItem((Item)Metadata.getUpnpMovie(movie, true));
                } else if (me instanceof TvShowEpisode) {
                    TvShowEpisode episode = (TvShowEpisode)me;
                    didl.addItem((Item)Metadata.getUpnpTvShowEpisode(episode.getTvShow(), episode, true));
                }
                url = ((Res)((Item)didl.getItems().get(0)).getResources().get(0)).getValue();
                meta = dip.generate(didl);
            }
            catch (Exception e) {
                LOGGER.debug("Could not generate metadata / url");
                return;
            }
        }
        SetAVTransportURI setAVTransportURIAction = new SetAVTransportURI(this.playerService, url, meta){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.debug("Setting URL for player failed! " + defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)setAVTransportURIAction);
        Play playAction = new Play(this.playerService){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Playing via UPnP failed - '{}'", (Object)defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)playAction);
    }

    public void stopPlay() {
        if (this.playerService == null) {
            return;
        }
        Stop stopAction = new Stop(this.playerService){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Stopping UPnP playback failed - '{}'", (Object)defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)stopAction);
    }

    public String getDeviceDescriptorXML() {
        String xml = "";
        try {
            xml = this.upnpService.getConfiguration().getDeviceDescriptorBinderUDA10().generate((Device)this.localDevice, new RemoteClientInfo(), this.upnpService.getConfiguration().getNamespace());
        }
        catch (DescriptorBindingException e) {
            LOGGER.debug("Could not generate UPNP device descriptor", (Throwable)e);
        }
        return xml;
    }

    public void startWebServer() {
        try {
            if (this.webServer == null) {
                this.webServer = new WebServer(8009);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not start UPnP web server - '{}'", (Object)e.getMessage());
        }
    }

    public void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.closeAllConnections();
        }
    }

    public void startMediaServer() {
        this.createUpnpService();
        try {
            this.upnpService.getRegistry().addDevice(this.getDevice(), new DiscoveryOptions(true));
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | LocalServiceBindingException | ValidationException | RegistrationException e) {
            LOGGER.warn("Could not start UPnP MediaServer - '{}'", (Object)e.getMessage());
        }
    }

    public void stopMediaServer() {
        if (this.upnpService != null) {
            this.upnpService.getRegistry().removeAllLocalDevices();
        }
    }

    public void shutdown() {
        this.stopPlay();
        this.stopWebServer();
        this.stopMediaServer();
        if (this.upnpService != null) {
            try {
                this.upnpService.getRouter().shutdown();
            }
            catch (RouterException e) {
                LOGGER.debug("Could not shutdown the UPNP router.");
            }
            this.upnpService.shutdown();
        }
    }
}

