/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.button;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.fourthline.cling.model.meta.Device;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;

public abstract class UpnpPlayButton
extends JButton {
    public UpnpPlayButton() {
        this.setAction(new PlayAction());
    }

    public abstract MediaFile getMediaFile();

    public abstract MediaEntity getMediaEntity();

    private void playLocal() {
        MediaFile mf = this.getMediaFile();
        if (mf == null) {
            return;
        }
        try {
            TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
        }
        catch (Exception ex) {
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
        }
    }

    private void playViaUpnp(Device device) {
        Upnp instance = Upnp.getInstance();
        instance.setPlayer(device);
        instance.playFile(this.getMediaEntity(), this.getMediaFile());
    }

    private class PlayAction
    extends AbstractAction {
        private PlayAction() {
            this.putValue("SmallIcon", IconManager.PLAY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Settings.getInstance().isUpnpRemotePlay()) {
                UpnpPlayButton.this.playLocal();
            } else {
                List<Device> upnpDevices = Upnp.getInstance().getAvailablePlayers();
                if (upnpDevices.isEmpty()) {
                    UpnpPlayButton.this.playLocal();
                } else {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new DeviceAction("System player", null));
                    menu.add(new JSeparator());
                    for (Device device : upnpDevices) {
                        menu.add(new DeviceAction(device.getDetails().getFriendlyName(), device));
                    }
                    menu.show(UpnpPlayButton.this, 0, UpnpPlayButton.this.getBounds().height);
                }
            }
        }
    }

    private class DeviceAction
    extends AbstractAction {
        private Device device;

        private DeviceAction(String title, Device device) {
            this.putValue("Name", title);
            this.device = device;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.device == null) {
                UpnpPlayButton.this.playLocal();
            } else {
                UpnpPlayButton.this.playViaUpnp(this.device);
            }
        }
    }
}

